/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-02-03 14:41:30 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `da_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=429 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=27478 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=819038 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=34777 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_blc_filters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_blc_instances` (
  `instance_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `link_id` int(10) unsigned NOT NULL,
  `container_id` int(10) unsigned NOT NULL,
  `container_type` varchar(40) NOT NULL DEFAULT 'post',
  `link_text` text NOT NULL DEFAULT '',
  `parser_type` varchar(40) NOT NULL DEFAULT 'link',
  `container_field` varchar(250) NOT NULL DEFAULT '',
  `link_context` varchar(250) NOT NULL DEFAULT '',
  `raw_url` text NOT NULL,
  PRIMARY KEY (`instance_id`),
  KEY `link_id` (`link_id`),
  KEY `source_id` (`container_type`,`container_id`),
  KEY `parser_type` (`parser_type`)
) ENGINE=InnoDB AUTO_INCREMENT=20638 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_blc_links` (
  `link_id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `first_failure` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_check` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_success` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_check_attempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `check_count` int(4) unsigned NOT NULL DEFAULT 0,
  `final_url` text CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL,
  `redirect_count` smallint(5) unsigned NOT NULL DEFAULT 0,
  `log` text NOT NULL,
  `http_code` smallint(6) NOT NULL DEFAULT 0,
  `status_code` varchar(100) DEFAULT '',
  `status_text` varchar(250) DEFAULT '',
  `request_duration` float NOT NULL DEFAULT 0,
  `timeout` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `broken` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `warning` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `may_recheck` tinyint(1) NOT NULL DEFAULT 1,
  `being_checked` tinyint(1) NOT NULL DEFAULT 0,
  `result_hash` varchar(200) NOT NULL DEFAULT '',
  `false_positive` tinyint(1) NOT NULL DEFAULT 0,
  `dismissed` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`link_id`),
  KEY `url` (`url`(150)),
  KEY `final_url` (`final_url`(150)),
  KEY `http_code` (`http_code`),
  KEY `broken` (`broken`),
  KEY `last_check_attempt` (`last_check_attempt`),
  KEY `may_recheck` (`may_recheck`),
  KEY `check_count` (`check_count`)
) ENGINE=InnoDB AUTO_INCREMENT=838 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_blc_synch` (
  `container_id` int(20) unsigned NOT NULL,
  `container_type` varchar(40) NOT NULL,
  `synched` tinyint(2) unsigned NOT NULL,
  `last_synch` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`container_type`,`container_id`),
  KEY `synched` (`synched`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_cmplz_cookiebanners` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `banner_version` int(11) NOT NULL,
  `default` int(11) NOT NULL,
  `position` text NOT NULL,
  `checkbox_style` text NOT NULL,
  `use_logo` text NOT NULL,
  `logo_attachment_id` text NOT NULL,
  `close_button` text NOT NULL,
  `revoke` text NOT NULL,
  `manage_consent_options` text NOT NULL,
  `header` text NOT NULL,
  `dismiss` text NOT NULL,
  `save_preferences` text NOT NULL,
  `view_preferences` text NOT NULL,
  `category_functional` text NOT NULL,
  `category_all` text NOT NULL,
  `category_stats` text NOT NULL,
  `category_prefs` text NOT NULL,
  `accept` text NOT NULL,
  `message_optin` text NOT NULL,
  `use_categories` text NOT NULL,
  `disable_cookiebanner` int(11) NOT NULL,
  `banner_width` int(11) NOT NULL,
  `soft_cookiewall` int(11) NOT NULL,
  `dismiss_on_scroll` int(11) NOT NULL,
  `dismiss_on_timeout` int(11) NOT NULL,
  `dismiss_timeout` text NOT NULL,
  `accept_informational` text NOT NULL,
  `message_optout` text NOT NULL,
  `use_custom_cookie_css` text NOT NULL,
  `custom_css` text NOT NULL,
  `statistics` text NOT NULL,
  `functional_text` text NOT NULL,
  `statistics_text` text NOT NULL,
  `statistics_text_anonymous` text NOT NULL,
  `preferences_text` text NOT NULL,
  `marketing_text` text NOT NULL,
  `colorpalette_background` text NOT NULL,
  `colorpalette_text` text NOT NULL,
  `colorpalette_toggles` text NOT NULL,
  `colorpalette_border_radius` text NOT NULL,
  `border_width` text NOT NULL,
  `font_size` text NOT NULL,
  `colorpalette_button_accept` text NOT NULL,
  `colorpalette_button_deny` text NOT NULL,
  `colorpalette_button_settings` text NOT NULL,
  `buttons_border_radius` text NOT NULL,
  `animation` text NOT NULL,
  `use_box_shadow` int(11) NOT NULL,
  `header_footer_shadow` int(11) NOT NULL,
  `hide_preview` int(11) NOT NULL,
  `disable_width_correction` int(11) NOT NULL,
  `legal_documents` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_cmplz_cookies` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `slug` varchar(250) NOT NULL,
  `sync` int(11) NOT NULL,
  `ignored` int(11) NOT NULL,
  `retention` text NOT NULL,
  `type` text NOT NULL,
  `serviceID` int(11) NOT NULL,
  `cookieFunction` text NOT NULL,
  `collectedPersonalData` text NOT NULL,
  `purpose` text NOT NULL,
  `language` varchar(6) NOT NULL,
  `isTranslationFrom` int(11) NOT NULL,
  `isOwnDomainCookie` int(11) NOT NULL,
  `domain` text NOT NULL,
  `deleted` int(11) NOT NULL,
  `isMembersOnly` int(11) NOT NULL,
  `showOnPolicy` int(11) NOT NULL,
  `lastUpdatedDate` int(11) NOT NULL,
  `lastAddDate` int(11) NOT NULL,
  `firstAddDate` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_cmplz_dnsmpd` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `region` text NOT NULL,
  `global_optout` int(11) NOT NULL,
  `cross_context` int(11) NOT NULL,
  `limit_sensitive` int(11) NOT NULL,
  `request_date` int(11) NOT NULL,
  `resolved` int(11) NOT NULL,
  `request_for_access` int(11) NOT NULL,
  `right_to_be_forgotten` int(11) NOT NULL,
  `right_to_data_portability` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_cmplz_services` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `slug` varchar(250) NOT NULL,
  `serviceType` varchar(250) NOT NULL,
  `category` varchar(250) NOT NULL,
  `thirdParty` int(11) NOT NULL,
  `sharesData` int(11) NOT NULL,
  `secondParty` int(11) NOT NULL,
  `privacyStatementURL` varchar(250) NOT NULL,
  `language` varchar(6) NOT NULL,
  `isTranslationFrom` int(11) NOT NULL,
  `sync` int(11) NOT NULL,
  `lastUpdatedDate` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_dlm_api_keys` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `public_key` longtext DEFAULT NULL,
  `token` longtext DEFAULT NULL,
  `secret_key` longtext DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `attribute_name` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_dlm_cookiemeta` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `cookie_id` bigint(20) DEFAULT NULL,
  `meta_key` longtext DEFAULT NULL,
  `meta_data` longtext DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `attribute_name` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_dlm_cookies` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `hash` longtext DEFAULT NULL,
  `creation_date` datetime DEFAULT NULL,
  `expiration_date` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `attribute_name` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_dlm_downloads` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `download_id` bigint(20) NOT NULL,
  `download_count` bigint(20) NOT NULL,
  `download_versions` varchar(200) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `attribute_name` (`download_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_dlm_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(255) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `currency` varchar(5) NOT NULL,
  `hash` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_dlm_order_customer` (
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `address_1` varchar(255) DEFAULT NULL,
  `address_2` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `postcode` varchar(255) DEFAULT NULL,
  `country` varchar(5) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `order_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  CONSTRAINT `da_fk_order_customer_order` FOREIGN KEY (`order_id`) REFERENCES `da_dlm_order` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_dlm_order_item` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(10) unsigned NOT NULL,
  `label` varchar(255) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  `tax_class` varchar(255) DEFAULT NULL,
  `tax_total` int(11) DEFAULT NULL,
  `subtotal` int(11) DEFAULT NULL,
  `total` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `da_fk_order_item_order1` (`order_id`),
  CONSTRAINT `da_fk_order_item_order1` FOREIGN KEY (`order_id`) REFERENCES `da_dlm_order` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_dlm_order_transaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `amount` int(11) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `processor` varchar(255) DEFAULT NULL,
  `processor_nice_name` varchar(255) DEFAULT NULL,
  `processor_transaction_id` varchar(255) DEFAULT NULL,
  `processor_status` varchar(255) DEFAULT NULL,
  `order_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `da_fk_transaction_order1` (`order_id`),
  CONSTRAINT `da_fk_transaction_order1` FOREIGN KEY (`order_id`) REFERENCES `da_dlm_order` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_dlm_reports_log` (
  `date` date NOT NULL,
  `download_ids` longtext DEFAULT NULL,
  `revenue` longtext DEFAULT NULL,
  `refunds` longtext DEFAULT NULL,
  PRIMARY KEY (`date`),
  KEY `attribute_name` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_dlm_session` (
  `key` varchar(150) NOT NULL,
  `hash` varchar(150) NOT NULL,
  `expiry` datetime NOT NULL,
  `data` longtext NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_download_log` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_ip` varchar(200) NOT NULL,
  `uuid` varchar(200) NOT NULL,
  `user_agent` varchar(200) NOT NULL,
  `download_id` bigint(20) NOT NULL,
  `version_id` bigint(20) NOT NULL,
  `version` varchar(200) NOT NULL,
  `download_date` datetime DEFAULT NULL,
  `download_status` varchar(200) DEFAULT NULL,
  `download_status_message` varchar(200) DEFAULT NULL,
  `download_location` varchar(200) DEFAULT NULL,
  `download_category` longtext DEFAULT NULL,
  `meta_data` longtext DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `attribute_name` (`download_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_duplicator_activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `sub_type` varchar(100) NOT NULL,
  `severity` int(8) NOT NULL,
  `title` text NOT NULL,
  `data` longtext NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `progress` float NOT NULL DEFAULT 0,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `owner` varchar(60) NOT NULL DEFAULT '',
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `type` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`),
  KEY `archive_name` (`archive_name`),
  KEY `type_idx` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`),
  KEY `value_2` (`value_2`),
  KEY `value_3` (`value_3`),
  KEY `value_4` (`value_4`),
  KEY `value_5` (`value_5`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_hurrytimer_evergreen` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `countdown_id` bigint(20) unsigned NOT NULL,
  `client_ip_address` varchar(50) NOT NULL,
  `expired` tinyint(1) unsigned DEFAULT NULL,
  `client_expires_at` bigint(20) unsigned NOT NULL,
  `reset_token` varchar(20) DEFAULT NULL,
  `destroy_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=1202658 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2592870 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1191077 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_prevent_direct_access_free` (
  `ID` mediumint(9) NOT NULL AUTO_INCREMENT,
  `post_id` mediumint(9) NOT NULL,
  `time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `url` varchar(55) NOT NULL DEFAULT '',
  `is_prevented` tinyint(1) DEFAULT 1,
  `hits_count` mediumint(9) NOT NULL,
  `limit_downloads` mediumint(9) DEFAULT NULL,
  `expired_date` bigint(20) DEFAULT NULL,
  UNIQUE KEY `id` (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_redirection_404` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext NOT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `agent` varchar(255) DEFAULT NULL,
  `referrer` varchar(255) DEFAULT NULL,
  `http_code` int(11) unsigned NOT NULL DEFAULT 0,
  `request_method` varchar(10) DEFAULT NULL,
  `request_data` mediumtext DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `referrer` (`referrer`(191)),
  KEY `ip` (`ip`)
) ENGINE=InnoDB AUTO_INCREMENT=198171 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_redirection_groups` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `tracking` int(11) NOT NULL DEFAULT 1,
  `module_id` int(11) unsigned NOT NULL DEFAULT 0,
  `status` enum('enabled','disabled') NOT NULL DEFAULT 'enabled',
  `position` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `module_id` (`module_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_redirection_items` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `url` mediumtext NOT NULL,
  `match_url` varchar(2000) DEFAULT NULL,
  `match_data` text DEFAULT NULL,
  `regex` int(11) unsigned NOT NULL DEFAULT 0,
  `position` int(11) unsigned NOT NULL DEFAULT 0,
  `last_count` int(10) unsigned NOT NULL DEFAULT 0,
  `last_access` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `group_id` int(11) NOT NULL DEFAULT 0,
  `status` enum('enabled','disabled') NOT NULL DEFAULT 'enabled',
  `action_type` varchar(20) NOT NULL,
  `action_code` int(11) unsigned NOT NULL,
  `action_data` mediumtext DEFAULT NULL,
  `match_type` varchar(20) NOT NULL,
  `title` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `status` (`status`),
  KEY `regex` (`regex`),
  KEY `group_idpos` (`group_id`,`position`),
  KEY `group` (`group_id`),
  KEY `match_url` (`match_url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=732 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_redirection_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext NOT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `sent_to` mediumtext DEFAULT NULL,
  `agent` mediumtext DEFAULT NULL,
  `referrer` mediumtext DEFAULT NULL,
  `http_code` int(11) unsigned NOT NULL DEFAULT 0,
  `request_method` varchar(10) DEFAULT NULL,
  `request_data` mediumtext DEFAULT NULL,
  `redirect_by` varchar(50) DEFAULT NULL,
  `redirection_id` int(11) unsigned DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `redirection_id` (`redirection_id`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB AUTO_INCREMENT=111362 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_seopress_content_analysis` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `title` longtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `og_title` longtext DEFAULT NULL,
  `og_description` longtext DEFAULT NULL,
  `og_image` longtext DEFAULT NULL,
  `og_url` longtext DEFAULT NULL,
  `og_site_name` longtext DEFAULT NULL,
  `twitter_title` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_image_src` longtext DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `h1` longtext DEFAULT NULL,
  `h2` longtext DEFAULT NULL,
  `h3` longtext DEFAULT NULL,
  `images` longtext DEFAULT NULL,
  `meta_robots` longtext DEFAULT NULL,
  `meta_google` longtext DEFAULT NULL,
  `links_no_follow` longtext DEFAULT NULL,
  `outbound_links` longtext DEFAULT NULL,
  `internal_links` longtext DEFAULT NULL,
  `json_schemas` longtext DEFAULT NULL,
  `keywords` text DEFAULT NULL,
  `permalink` text DEFAULT NULL,
  `score` text DEFAULT NULL,
  `analysis_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_post_id` (`post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=512 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=512 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_umbrella_backup` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `count_attachments` int(11) DEFAULT NULL,
  `count_public_posts` int(11) DEFAULT NULL,
  `count_plugins` int(11) DEFAULT NULL,
  `wp_core_version` varchar(20) DEFAULT NULL,
  `config_database` longtext DEFAULT NULL,
  `config_file` longtext DEFAULT NULL,
  `title` varchar(50) DEFAULT NULL,
  `suffix` varchar(50) DEFAULT NULL,
  `is_scheduled` tinyint(4) DEFAULT NULL,
  `backupId` bigint(20) DEFAULT NULL,
  `incremental_date` varchar(50) DEFAULT NULL,
  `status` varchar(128) DEFAULT NULL,
  `finish_file` tinyint(4) DEFAULT NULL,
  `finish_database` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_umbrella_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `code` varchar(128) DEFAULT NULL,
  `message` longtext DEFAULT NULL,
  `backupId` bigint(20) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_umbrella_task_backup` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_schedule` datetime DEFAULT current_timestamp(),
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `jobId` bigint(20) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `status` varchar(128) DEFAULT NULL,
  `backupId` bigint(20) DEFAULT NULL,
  `log` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_wpfm_backup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `backup_name` text DEFAULT NULL,
  `backup_date` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_wpie_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` varchar(25) DEFAULT NULL,
  `opration` varchar(100) NOT NULL,
  `username` varchar(60) NOT NULL,
  `unique_id` varchar(100) NOT NULL,
  `opration_type` varchar(100) NOT NULL,
  `options` longtext DEFAULT NULL,
  `process_log` varchar(255) DEFAULT NULL,
  `process_lock` int(3) DEFAULT NULL,
  `create_date` datetime NOT NULL,
  `last_update_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` longtext DEFAULT NULL,
  `open_graph_image` longtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` mediumtext DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=1038 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `da_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `da_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`),
  KEY `url_index` (`url`),
  KEY `target_indexable_id_index` (`target_indexable_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3797 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `da_users` VALUES 
("1","Digitool44","$wp$2y$10$9lduF1GV4oVBWI1IoTscEeK1G6GG1.I/kTcNdwz3Ioa4HurMDkdWe","digitool44","support@agence-tool.fr","https://dualdiploma.org","2024-01-09 10:10:10","","0","Digitool44"),
("2","Communication ADD","$wp$2y$10$e43QfHeB415O0ZmINwgugOVHxKUuBOBCyZ5JO/pjW/m.jaKDvtEFW","communication-add","com@dualdiploma.org","","2024-05-17 09:33:25","","0","Ségolène Maillard"),
("3","Chantal FM.","$wp$2y$10$KOUjKhM9EATN4sw/7VghiOKVYanx9Lf4kribhpNWytb/jlZHxc8KW","chantal-fm","cfmartell@dualdiploma.org","","2024-05-17 09:34:43","","0","Chantal Firino Martell"),
("4","Elizabeth DM.","$wp$2y$10$XVYG.hGSFyztejJV/iNT/.Uo4ZputVaiHwJw5mQUtz27TmlOJKlRm","elizabeth-dm","edemontlivault@dualdiploma.org","","2024-05-17 09:36:42","","0","Elizabeth de Montlivault"),
("5","Melody","$wp$2y$10$oNqJPMBDv6MDHYWMKGSGB.99ksV81sKTBK4UGwZk/R73we9G0.2H6","melody","mbongrand@dualdiploma.org","","2024-08-22 13:01:16","","0","Melody Bongrand"),
("6","Np_digital","$wp$2y$10$fbun.opI/647DECCIUNvyuphL1xubPY68yDzEcsAQ28k58ygkyDa.","np_digital","npdigitalfrance@gmail.com","","2025-09-25 08:42:31","1758789751:$generic$uXSmaU_lvswgBXq0NFjVVewSvtPPmXviqda68Qiz","0","Np_digital"),
("7","Harold","$wp$2y$10$PU7exBM2ntJ6CX1GulamHOPFK.bbvZFUTQbMS1UCCI5xX.pacpRFK","harold","harold@informacyde.fr","","2025-10-07 13:08:02","","0","Harold");

INSERT IGNORE INTO `da_usermeta` VALUES 
("1","1","nickname","Digitool44"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","da_capabilities","a:8:{s:13:\"administrator\";b:1;s:15:\"wpie_new_export\";b:1;s:18:\"wpie_manage_export\";b:1;s:15:\"wpie_new_import\";b:1;s:18:\"wpie_manage_import\";b:1;s:13:\"wpie_settings\";b:1;s:15:\"wpie_extensions\";b:1;s:18:\"wpie_add_shortcode\";b:1;}"),
("13","1","da_user_level","10"),
("14","1","dismissed_wp_pointers","theme_editor_notice"),
("15","1","show_welcome_panel","0"),
("17","1","da_dashboard_quick_press_last_post_id","1182304"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:12:\"193.248.44.0\";}"),
("19","1","da_user-settings","libraryContent=browse&posts_list_mode=list&urlbutton=none"),
("20","1","da_user-settings-time","1715934916"),
("21","1","da_persisted_preferences","a:4:{s:14:\"core/edit-post\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2024-06-21T15:09:00.592Z\";s:4:\"core\";a:2:{s:10:\"openPanels\";a:10:{i:0;s:11:\"post-status\";i:1;s:33:\"taxonomy-panel-type_etablissement\";i:2;s:14:\"featured-image\";i:3;s:20:\"taxonomy-panel-ville\";i:4;s:24:\"yoast-seo/document-panel\";i:5;s:34:\"taxonomy-panel-wp_pattern_category\";i:6;s:19:\"taxonomy-panel-type\";i:7;s:23:\"taxonomy-panel-academie\";i:8;s:19:\"taxonomy-panel-pays\";i:9;s:15:\"page-attributes\";}s:10:\"editorMode\";s:6:\"visual\";}s:17:\"core/block-editor\";a:1:{s:25:\"linkControlSettingsDrawer\";b:1;}}"),
("22","1","closedpostboxes_page","a:0:{}"),
("23","1","metaboxhidden_page","a:0:{}"),
("24","1","managenav-menuscolumnshidden","a:3:{i:0;s:15:\"title-attribute\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";}"),
("25","1","metaboxhidden_nav-menus","a:0:{}"),
("26","1","nav_menu_recently_edited","278"),
("27","1","closedpostboxes_nav-menus","a:0:{}"),
("28","1","edit_page_per_page","50"),
("29","1","meta-box-order_page","a:4:{s:6:\"normal\";s:38:\"seopress_content_analysis,seopress_cpt\";s:8:\"advanced\";s:0:\"\";s:15:\"acf_after_title\";s:0:\"\";s:4:\"side\";s:0:\"\";}"),
("30","1","edit_partenaire_per_page","200"),
("32","1","closedpostboxes_partenaire","a:0:{}"),
("33","1","metaboxhidden_partenaire","a:0:{}"),
("34","1","meta-box-order_partenaire","a:4:{s:6:\"normal\";s:34:\"acf-group_65d76e58acc4b,wpseo_meta\";s:8:\"advanced\";s:0:\"\";s:4:\"side\";s:0:\"\";s:15:\"acf_after_title\";s:0:\"\";}"),
("35","1","manageedit-postcolumnshidden","a:4:{i:0;s:4:\"tags\";i:1;s:11:\"wpseo-title\";i:2;s:14:\"wpseo-metadesc\";i:3;s:13:\"wpseo-focuskw\";}"),
("36","1","edit_post_per_page","40"),
("37","1","_yoast_wpseo_introductions","a:2:{s:42:\"ai-generate-titles-and-descriptions-upsell\";a:2:{s:7:\"is_seen\";b:1;s:7:\"seen_on\";i:1760623442;}s:29:\"ai-brand-insights-post-launch\";a:2:{s:7:\"is_seen\";b:1;s:7:\"seen_on\";i:1761223103;}}"),
("38","1","_yoast_wpseo_profile_updated","1760623664"),
("39","1","wpseo_title",""),
("40","1","wpseo_metadesc",""),
("42","1","wpseo_content_analysis_disable",""),
("43","1","wpseo_keyword_analysis_disable",""),
("44","1","wpseo_inclusive_language_analysis_disable",""),
("55","1","edit_question_per_page","100"),
("57","1","manageedit-acf-taxonomycolumnshidden","a:1:{i:0;s:7:\"acf-key\";}"),
("58","1","acf_user_settings","a:1:{s:20:\"taxonomies-first-run\";b:1;}"),
("59","1","da_media_library_mode","grid"),
("60","1","edit_etablissement_per_page","500"),
("61","2","nickname","Communication ADD"),
("62","2","first_name","Ségolène"),
("63","2","last_name","Maillard"),
("64","2","description",""),
("65","2","rich_editing","true"),
("66","2","syntax_highlighting","true"),
("67","2","comment_shortcuts","false"),
("68","2","admin_color","fresh"),
("69","2","use_ssl","0"),
("70","2","show_admin_bar_front","true"),
("71","2","locale",""),
("72","2","da_capabilities","a:8:{s:13:\"administrator\";b:1;s:15:\"wpie_new_export\";b:1;s:18:\"wpie_manage_export\";b:1;s:15:\"wpie_new_import\";b:1;s:18:\"wpie_manage_import\";b:1;s:13:\"wpie_settings\";b:1;s:15:\"wpie_extensions\";b:1;s:18:\"wpie_add_shortcode\";b:1;}"),
("73","2","da_user_level","10"),
("74","2","_yoast_wpseo_profile_updated","1762546513"),
("75","2","dismissed_wp_pointers",""),
("76","3","nickname","Chantal FM."),
("77","3","first_name","Chantal"),
("78","3","last_name","Firino Martell"),
("79","3","description",""),
("80","3","rich_editing","true"),
("81","3","syntax_highlighting","true"),
("82","3","comment_shortcuts","false"),
("83","3","admin_color","fresh"),
("84","3","use_ssl","0"),
("85","3","show_admin_bar_front","false"),
("86","3","locale",""),
("87","3","da_capabilities","a:8:{s:13:\"administrator\";b:1;s:15:\"wpie_new_export\";b:1;s:18:\"wpie_manage_export\";b:1;s:15:\"wpie_new_import\";b:1;s:18:\"wpie_manage_import\";b:1;s:13:\"wpie_settings\";b:1;s:15:\"wpie_extensions\";b:1;s:18:\"wpie_add_shortcode\";b:1;}"),
("88","3","da_user_level","10"),
("89","3","_yoast_wpseo_profile_updated","1758698737"),
("90","3","dismissed_wp_pointers","theme_editor_notice,sp22_ad"),
("91","4","nickname","Elizabeth DM."),
("92","4","first_name","Elizabeth"),
("93","4","last_name","de Montlivault"),
("94","4","description",""),
("95","4","rich_editing","true"),
("96","4","syntax_highlighting","true"),
("97","4","comment_shortcuts","false"),
("98","4","admin_color","fresh"),
("99","4","use_ssl","0"),
("100","4","show_admin_bar_front","true"),
("101","4","locale",""),
("102","4","da_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("103","4","da_user_level","10"),
("104","4","_yoast_wpseo_profile_updated","1758698748"),
("105","4","dismissed_wp_pointers",""),
("107","2","da_dashboard_quick_press_last_post_id","1185589"),
("109","2","community-events-location","a:1:{s:2:\"ip\";s:13:\"149.232.193.0\";}"),
("110","2","da_persisted_preferences","a:4:{s:4:\"core\";a:7:{s:10:\"openPanels\";a:13:{i:0;s:11:\"post-status\";i:1;s:19:\"taxonomy-panel-type\";i:2;s:14:\"featured-image\";i:3;s:12:\"post-excerpt\";i:4;s:15:\"page-attributes\";i:5;s:44:\"taxonomy-panel-mywp-category-custom-patterns\";i:6;s:34:\"taxonomy-panel-wp_pattern_category\";i:7;s:23:\"taxonomy-panel-category\";i:8;s:19:\"taxonomy-panel-pays\";i:9;s:24:\"yoast-seo/document-panel\";i:10;s:23:\"taxonomy-panel-post_tag\";i:11;s:20:\"taxonomy-panel-ville\";i:12;s:23:\"taxonomy-panel-academie\";}s:15:\"distractionFree\";b:0;s:12:\"fixedToolbar\";b:0;s:16:\"hiddenBlockTypes\";a:0:{}s:10:\"editorMode\";s:6:\"visual\";s:26:\"isComplementaryAreaVisible\";b:0;s:11:\"pinnedItems\";a:2:{s:50:\"mywp-custom-patterns-settings/mywp-custom-patterns\";b:1;s:21:\"yoast-seo/seo-sidebar\";b:0;}}s:14:\"core/edit-post\";a:3:{s:12:\"welcomeGuide\";b:0;s:14:\"fullscreenMode\";b:0;s:23:\"metaBoxesMainOpenHeight\";i:24;}s:9:\"_modified\";s:24:\"2026-02-03T09:40:22.430Z\";s:17:\"core/block-editor\";a:1:{s:25:\"linkControlSettingsDrawer\";b:1;}}"),
("111","2","da_user-settings","libraryContent=browse&imgsize=&posts_list_mode=list&editor=html&mfold=o"),
("112","2","da_user-settings-time","1763653962"),
("115","3","da_dashboard_quick_press_last_post_id","918371"),
("117","3","community-events-location","a:1:{s:2:\"ip\";s:13:\"185.146.221.0\";}"),
("118","3","_yoast_wpseo_introductions","a:2:{s:42:\"ai-generate-titles-and-descriptions-upsell\";a:2:{s:7:\"is_seen\";b:1;s:7:\"seen_on\";i:1758698549;}s:25:\"ai-fix-assessments-upsell\";a:2:{s:7:\"is_seen\";b:1;s:7:\"seen_on\";i:1758698549;}}"),
("119","3","da_persisted_preferences","a:4:{s:4:\"core\";a:4:{s:10:\"openPanels\";a:5:{i:0;s:11:\"post-status\";i:1;s:24:\"yoast-seo/document-panel\";i:2;s:34:\"taxonomy-panel-wp_pattern_category\";i:3;s:23:\"taxonomy-panel-post_tag\";i:4;s:20:\"taxonomy-panel-ville\";}s:26:\"isComplementaryAreaVisible\";b:1;s:15:\"distractionFree\";b:0;s:12:\"fixedToolbar\";b:1;}s:14:\"core/edit-post\";a:2:{s:12:\"welcomeGuide\";b:0;s:23:\"metaBoxesMainOpenHeight\";i:310;}s:9:\"_modified\";s:24:\"2025-06-19T13:14:15.850Z\";s:17:\"core/block-editor\";a:1:{s:25:\"linkControlSettingsDrawer\";b:1;}}"),
("120","2","nav_menu_recently_edited","278"),
("121","2","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("122","2","metaboxhidden_nav-menus","a:9:{i:0;s:27:\"add-post-type-etablissement\";i:1;s:24:\"add-post-type-partenaire\";i:2;s:22:\"add-post-type-question\";i:3;s:12:\"add-post_tag\";i:4;s:22:\"add-type_etablissement\";i:5;s:8:\"add-pays\";i:6;s:9:\"add-ville\";i:7;s:12:\"add-academie\";i:8;s:8:\"add-type\";}"),
("123","2","_yoast_alerts_dismissed","a:1:{s:26:\"webinar-promo-notification\";b:1;}"),
("129","3","wpseo_metadesc",""),
("130","3","wpseo_title",""),
("131","3","wpseo_content_analysis_disable",""),
("132","3","wpseo_inclusive_language_analysis_disable",""),
("133","3","wpseo_keyword_analysis_disable",""),
("134","2","closedpostboxes_page","a:0:{}"),
("135","2","metaboxhidden_page","a:0:{}"),
("136","2","meta-box-order_page","a:4:{s:6:\"normal\";s:0:\"\";s:8:\"advanced\";s:34:\"acf-group_6603f1248e563,wpseo_meta\";s:4:\"side\";s:0:\"\";s:15:\"acf_after_title\";s:0:\"\";}"),
("137","3","da_user-settings","libraryContent=browse&posts_list_mode=list"),
("138","3","da_user-settings-time","1728398541"),
("140","2","da_googlesitekit_site_verification_file","09bc2bf99b275b29"),
("141","2","da_googlesitekit_access_token","iOSiykc9gEzAvezjscvYQDF4QW5mNnN3UThWUzRPbWxQeVZmckFXd0JFSmpSV2hrVFQyWG1NL3Evb2NJMmd5MnZRNFRVbTBNLzhLbEk0Q1FHVDdwbHhqd0JuWmV1bzd5TUZWd05vb2VrU3FMaE9Rc3p5WVEzZ2g3RVd1aWNOYlJaRE4zclFUWmJMVkRvWHlkNzRWQk5zeGpMTmladzkvOFR0ZlQrV1VEZ3JWVzdPdTZHbWE3NU0yNXI1R1BYUnQ0MlQ1TGZOK203a1BPMGVjOGtqWVl4L3hGQU9CeUVIeTdCSUtQcEJhTVhMSFdQS0JmQ24wNTF2TE9GZzRNRzA5VWVjZUdMazBKOUhIM2I0aUo5RVFLUmZ2NDI2L1VHTkRFSWFGVW5IY0lSWEMwck5ZVlg0N3ljTXNKK21jbS9ueEFlU2lZbEN1dVl4dkNJdGhWYTFmTER3b0VBbERZOTBNb1R3NWFqS3lVUDhya3BRamJSRlYwS2V5R0tKOExVNXdsVHdweHQzNFJSazV4QnJtZXNaTGJlc2xCUlNsdQ=="),
("142","2","da_googlesitekit_access_token_expires_in","3599"),
("143","2","da_googlesitekit_access_token_created_at","1746457139"),
("144","2","da_googlesitekit_refresh_token","hR4pJjzH4aSEhKqgConHaVIvNFpzSy90bmczU3ZYQURReDFQUWNaTFQ2N1hQRUZ4cXVRdUp5VUZybW10OXJOdTRJNkV3TldzM0loMHpPL3NiaWRLVC9hZEFRR1dYMDQ2UTVENFZCL1VSQWRkaFFKWllxbVU3b2laamcyV0NYdm5xTTRtVVRIb0RDazhuV2QrZy9BZjZsVERnblBTVlJPSTFBb3Y1dnluQW5TMmVqK0lCT3JIUUlKcGt3enZPT282a0VXWVYrQ3Jpdi9nUWN3b1BYYVBWMWYxQVBWZmF6NmsyUS9pWkVFNDBhUUJRQ0FHS2RqQjBXRlFDaE14M09ESFpoOGNpbkV2ZXdueXMxSVhKcldaakhkaXExdS9aSnMwRkNqL0JUM0VGZGE2RDFkQnRoNDZUc1pqV24zdEM0Y3ozbUp1VkxmVDlRcWNCekZEUytBSmp2amh0TEU9"),
("145","2","da_googlesitekit_auth_scopes","a:7:{i:0;s:50:\"https://www.googleapis.com/auth/analytics.readonly\";i:1;s:48:\"https://www.googleapis.com/auth/siteverification\";i:2;s:46:\"https://www.googleapis.com/auth/userinfo.email\";i:3;s:48:\"https://www.googleapis.com/auth/userinfo.profile\";i:4;s:42:\"https://www.googleapis.com/auth/webmasters\";i:5;s:6:\"openid\";i:6;s:51:\"https://www.googleapis.com/auth/tagmanager.readonly\";}"),
("146","2","da_googlesitekit_additional_auth_scopes","a:0:{}"),
("147","2","da_googlesitekit_profile","a:4:{s:5:\"email\";s:26:\"academica.france@gmail.com\";s:5:\"photo\";s:97:\"https://lh3.googleusercontent.com/a/ACg8ocKv45dNeENms6UDnYmBZo8eypR6xEwSCD5t9cqqvor5OceS3UYO=s100\";s:9:\"full_name\";s:16:\"Academica France\";s:12:\"last_updated\";i:1746432387;}"),
("148","2","da_googlesitekitpersistent_initial_version","1.150.0"),
("149","2","da_googlesitekit_site_verified_meta","verified"),
("150","2","da_googlesitekit_survey_timeouts","a:8:{s:18:\"view_ga4_dashboard\";i:1744205888;s:14:\"view_dashboard\";i:1739288359;s:18:\"view_kmw_setup_cta\";i:1725004508;s:19:\"view_como_setup_cta\";i:1724753026;s:8:\"__global\";i:1739244997;s:11:\"enable_como\";i:1724763222;s:8:\"view_kmw\";i:1739453804;s:24:\"view_kmw_setup_completed\";i:1739806759;}"),
("151","3","da_media_library_mode","list"),
("152","5","nickname","Melody"),
("153","5","first_name","Melody"),
("154","5","last_name","Bongrand"),
("155","5","description",""),
("156","5","rich_editing","true"),
("157","5","syntax_highlighting","true"),
("158","5","comment_shortcuts","false"),
("159","5","admin_color","fresh"),
("160","5","use_ssl","0"),
("161","5","show_admin_bar_front","true"),
("162","5","locale",""),
("163","5","da_capabilities","a:8:{s:13:\"administrator\";b:1;s:15:\"wpie_new_export\";b:1;s:18:\"wpie_manage_export\";b:1;s:15:\"wpie_new_import\";b:1;s:18:\"wpie_manage_import\";b:1;s:13:\"wpie_settings\";b:1;s:15:\"wpie_extensions\";b:1;s:18:\"wpie_add_shortcode\";b:1;}"),
("164","5","da_user_level","10"),
("165","5","dismissed_wp_pointers","sp22_ad"),
("166","5","_yoast_wpseo_profile_updated","1756991160"),
("167","5","dismissed_wp_pointers",""),
("168","5","wpseo_metadesc",""),
("169","5","wpseo_title",""),
("170","5","wpseo_content_analysis_disable",""),
("171","5","wpseo_inclusive_language_analysis_disable",""),
("172","5","wpseo_keyword_analysis_disable",""),
("174","5","da_dashboard_quick_press_last_post_id","1161440"),
("175","5","community-events-location","a:1:{s:2:\"ip\";s:12:\"88.191.158.0\";}"),
("176","5","da_persisted_preferences","a:4:{s:4:\"core\";a:2:{s:10:\"openPanels\";a:2:{i:0;s:11:\"post-status\";i:1;s:24:\"yoast-seo/document-panel\";}s:26:\"isComplementaryAreaVisible\";b:0;}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2024-08-27T15:24:47.668Z\";s:17:\"core/block-editor\";a:1:{s:25:\"linkControlSettingsDrawer\";b:1;}}"),
("177","2","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:123:\"blc_dashboard_widget,dashboard_site_health,dashboard_right_now,wpseo-wincher-dashboard-overview,duplicator_dashboard_widget\";s:4:\"side\";s:64:\"dashboard_quick_press,dashboard_primary,secupress-attacks-widget\";s:7:\"column3\";s:66:\"wpseo-dashboard-overview,nab-dashboard-overview,dashboard_activity\";s:7:\"column4\";s:0:\"\";}"),
("178","2","da_googlesitekit_survey_queue","a:1:{i:0;a:4:{s:7:\"session\";a:2:{s:10:\"session_id\";s:333:\"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzaWQiOiJYTGpzRnNqeEhkZVpOaTNDZDZacXFHLWFGOFpCb1FEYVpUdTdxS0JnM3ZqYy5hcHBzLnNpdGVraXQud2l0aGdvb2dsZS5jb20iLCJzdXIiOiJzaXdnX25vdF9hY3RpdmF0ZWRfc3VydmV5IiwidWlkIjoiMTY0OWQ5OGFjYTM1MWViNDcyNTRjNTY3ZDQ4M2Q4NzViZmQ4NmJlOWM3NWRlMTI2MGJjNjliYTdhYzRlNDVjNCJ9.MS2Na1zqAjdOmRrB4tVR3BxCWklQmLkfggz-c1GYjiM\";s:13:\"session_token\";s:24:\"8e1h9jgifffw3b8obg6je2k4\";}s:14:\"survey_payload\";a:3:{s:8:\"language\";s:5:\"en_US\";s:8:\"question\";a:3:{i:0;a:5:{s:16:\"question_ordinal\";i:1;s:13:\"question_text\";s:69:\"Have you tried the new Sign in with Google functionality in Site Kit?\";s:13:\"question_type\";s:13:\"single_select\";s:17:\"trigger_condition\";a:0:{}s:8:\"question\";a:1:{s:13:\"answer_choice\";a:2:{i:0;a:3:{s:14:\"answer_ordinal\";i:1;s:4:\"text\";s:3:\"Yes\";s:8:\"write_in\";b:0;}i:1;a:3:{s:14:\"answer_ordinal\";i:2;s:4:\"text\";s:2:\"No\";s:8:\"write_in\";b:0;}}}}i:1;a:5:{s:16:\"question_ordinal\";i:2;s:13:\"question_text\";s:68:\"What was your experience with the Sign in with Google functionality?\";s:13:\"question_type\";s:12:\"multi_select\";s:17:\"trigger_condition\";a:1:{i:0;a:2:{s:16:\"question_ordinal\";i:1;s:14:\"answer_ordinal\";a:1:{i:0;i:1;}}}s:8:\"question\";a:3:{s:13:\"answer_choice\";a:4:{i:0;a:3:{s:14:\"answer_ordinal\";i:1;s:4:\"text\";s:87:\"I tried it, but ultimately it’s not the right option for my site so disabled it again\";s:8:\"write_in\";b:0;}i:1;a:3:{s:14:\"answer_ordinal\";i:2;s:4:\"text\";s:51:\"I tried setting it up, but got an error in Site Kit\";s:8:\"write_in\";b:0;}i:2;a:3:{s:14:\"answer_ordinal\";i:3;s:4:\"text\";s:70:\"I tried setting it up, but got an error generating the Oauth Client ID\";s:8:\"write_in\";b:0;}i:3;a:3:{s:14:\"answer_ordinal\";i:4;s:4:\"text\";s:6:\"Other:\";s:8:\"write_in\";b:1;}}s:11:\"min_choices\";i:0;s:11:\"max_choices\";i:0;}}i:2;a:5:{s:16:\"question_ordinal\";i:3;s:13:\"question_text\";s:66:\"Why haven\'t you enabled the new Sign in with Google functionality?\";s:13:\"question_type\";s:12:\"multi_select\";s:17:\"trigger_condition\";a:1:{i:0;a:2:{s:16:\"question_ordinal\";i:1;s:14:\"answer_ordinal\";a:1:{i:0;i:2;}}}s:8:\"question\";a:3:{s:13:\"answer_choice\";a:4:{i:0;a:3:{s:14:\"answer_ordinal\";i:1;s:4:\"text\";s:78:\"I haven\'t noticed the message about this new feature on the Site Kit dashboard\";s:8:\"write_in\";b:0;}i:1;a:3:{s:14:\"answer_ordinal\";i:2;s:4:\"text\";s:91:\"I already have other ways for visitors to sign in on my site (e.g. Facebook, Apple sign-in)\";s:8:\"write_in\";b:0;}i:2;a:3:{s:14:\"answer_ordinal\";i:3;s:4:\"text\";s:66:\"I don\'t need my site visitors to sign in with their Google account\";s:8:\"write_in\";b:0;}i:3;a:3:{s:14:\"answer_ordinal\";i:4;s:4:\"text\";s:6:\"Other:\";s:8:\"write_in\";b:1;}}s:11:\"min_choices\";i:0;s:11:\"max_choices\";i:0;}}}s:10:\"completion\";a:1:{i:0;a:6:{s:18:\"completion_ordinal\";i:1;s:16:\"completion_title\";s:33:\"Thanks for sharing your thoughts!\";s:15:\"completion_text\";s:96:\"If you have more feedback about Sign in with Google, find us on our WordPress.org support forum.\";s:14:\"follow_up_text\";s:10:\"Let’s go\";s:13:\"follow_up_url\";s:65:\"https://wordpress.org/support/plugin/google-site-kit/#new-topic-0\";s:17:\"trigger_condition\";N;}}}s:26:\"no_available_survey_reason\";s:0:\"\";s:9:\"survey_id\";s:25:\"siwg_not_activated_survey\";}}"),
("179","2","da_googlesitekitpersistent_dismissed_prompts","a:1:{s:29:\"consent-mode-setup-cta-widget\";a:2:{s:7:\"expires\";i:0;s:5:\"count\";i:1;}}"),
("180","2","da_googlesitekit_user_input_settings","a:2:{s:13:\"postFrequency\";a:2:{s:5:\"scope\";s:4:\"user\";s:6:\"values\";a:1:{i:0;s:7:\"monthly\";}}s:5:\"goals\";a:2:{s:5:\"scope\";s:4:\"user\";s:6:\"values\";a:3:{i:0;s:16:\"growing_audience\";i:1;s:16:\"help_better_rank\";i:2;s:18:\"retaining_visitors\";}}}"),
("181","5","da_user-settings","libraryContent=browse"),
("182","5","da_user-settings-time","1724772740"),
("183","2","closedpostboxes_partenaire","a:0:{}"),
("184","2","metaboxhidden_partenaire","a:0:{}"),
("186","3","edit_page_per_page","50"),
("189","3","closedpostboxes_dashboard","a:7:{i:0;s:22:\"nab-dashboard-overview\";i:1;s:19:\"dashboard_right_now\";i:2;s:18:\"dashboard_activity\";i:3;s:24:\"wpseo-dashboard-overview\";i:4;s:32:\"wpseo-wincher-dashboard-overview\";i:5;s:21:\"dashboard_quick_press\";i:6;s:17:\"dashboard_primary\";}"),
("190","3","metaboxhidden_dashboard","a:0:{}"),
("192","2","_yoast_wpseo_introductions","a:1:{s:25:\"ai-fix-assessments-upsell\";a:2:{s:7:\"is_seen\";b:1;s:7:\"seen_on\";i:1758700373;}}"),
("203","2","manageedit-acf-post-typecolumnshidden","a:1:{i:0;s:7:\"acf-key\";}"),
("204","2","acf_user_settings","a:3:{s:19:\"post-type-first-run\";b:1;s:23:\"options-pages-first-run\";b:1;s:20:\"taxonomies-first-run\";b:1;}"),
("205","2","meta-box-order_partenaire","a:4:{s:6:\"normal\";s:0:\"\";s:8:\"advanced\";s:0:\"\";s:4:\"side\";s:23:\"acf-group_65d76e58acc4b\";s:15:\"acf_after_title\";s:0:\"\";}"),
("206","2","closedpostboxes_acf-field-group","a:0:{}"),
("207","2","metaboxhidden_acf-field-group","a:1:{i:0;s:7:\"slugdiv\";}"),
("208","2","manageedit-acf-ui-options-pagecolumnshidden","a:1:{i:0;s:7:\"acf-key\";}"),
("210","3","manageedit-acf-ui-options-pagecolumnshidden","a:1:{i:0;s:7:\"acf-key\";}"),
("211","3","acf_user_settings","a:2:{s:23:\"options-pages-first-run\";b:1;s:20:\"taxonomies-first-run\";b:1;}"),
("212","3","closedpostboxes_acf-ui-options-page","a:0:{}"),
("213","3","metaboxhidden_acf-ui-options-page","a:2:{i:0;s:21:\"acf-advanced-settings\";i:1;s:7:\"slugdiv\";}"),
("214","3","manageedit-acf-taxonomycolumnshidden","a:1:{i:0;s:7:\"acf-key\";}"),
("215","3","nav_menu_recently_edited","278"),
("216","3","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("217","3","metaboxhidden_nav-menus","a:10:{i:0;s:19:\"pll_lang_switch_box\";i:1;s:27:\"add-post-type-etablissement\";i:2;s:24:\"add-post-type-partenaire\";i:3;s:22:\"add-post-type-question\";i:4;s:12:\"add-post_tag\";i:5;s:22:\"add-type_etablissement\";i:6;s:8:\"add-pays\";i:7;s:9:\"add-ville\";i:8;s:12:\"add-academie\";i:9;s:8:\"add-type\";}"),
("222","2","wpseo_metadesc",""),
("223","2","wpseo_title",""),
("224","2","wpseo_content_analysis_disable",""),
("225","2","wpseo_keyword_analysis_disable",""),
("226","2","description_en",""),
("250","2","closedpostboxes_dashboard","a:0:{}"),
("251","2","metaboxhidden_dashboard","a:6:{i:0;s:32:\"wpseo-wincher-dashboard-overview\";i:1;s:21:\"dashboard_quick_press\";i:2;s:17:\"dashboard_primary\";i:3;s:24:\"wpseo-dashboard-overview\";i:4;s:22:\"nab-dashboard-overview\";i:5;s:27:\"duplicator_dashboard_widget\";}"),
("252","2","manageedit-acf-taxonomycolumnshidden","a:1:{i:0;s:7:\"acf-key\";}"),
("254","2","redirection_log_per_page","900"),
("255","2","edit_ville_per_page","200"),
("261","3","meta-box-order_dashboard","a:4:{s:6:\"normal\";s:162:\"nab-dashboard-overview,dashboard_site_health,dashboard_right_now,dashboard_activity,blc_dashboard_widget,wpseo-dashboard-overview,wpseo-wincher-dashboard-overview\";s:4:\"side\";s:39:\"dashboard_quick_press,dashboard_primary\";s:7:\"column3\";s:0:\"\";s:7:\"column4\";s:0:\"\";}"),
("262","3","meta-box-order_post","a:4:{s:6:\"normal\";s:34:\"acf-group_67e563eb283eb,wpseo_meta\";s:8:\"advanced\";s:0:\"\";s:4:\"side\";s:0:\"\";s:15:\"acf_after_title\";s:0:\"\";}"),
("263","5","closedpostboxes_page","a:1:{i:0;s:10:\"wpseo_meta\";}"),
("264","5","metaboxhidden_page","a:0:{}"),
("265","5","meta-box-order_page","a:4:{s:6:\"normal\";s:34:\"wpseo_meta,acf-group_6603f1248e563\";s:8:\"advanced\";s:0:\"\";s:15:\"acf_after_title\";s:0:\"\";s:4:\"side\";s:0:\"\";}"),
("269","2","da_googlesitekit_proxy_access_code","sitekit-EhIKB1Nlc3Npb24QgICA3aXopws"),
("271","1","session_tokens","a:13:{s:64:\"71c5bcc10f66050f93a563841af291bf869e7e52128d66d57ac91338d9bfc4e2\";a:4:{s:10:\"expiration\";i:1770282475;s:2:\"ip\";s:12:\"51.159.39.21\";s:2:\"ua\";s:4:\"node\";s:5:\"login\";i:1769072875;}s:64:\"139abf2b70860223eef2ae3d1ad401025dda2fbd2c7e7c7dc4b38697abc5cb62\";a:4:{s:10:\"expiration\";i:1770282475;s:2:\"ip\";s:12:\"51.159.39.21\";s:2:\"ua\";s:4:\"node\";s:5:\"login\";i:1769072875;}s:64:\"9ae029d487687e39fe95051b4a6d89a6f44aab652fa6fe764e482fb6ae68627f\";a:4:{s:10:\"expiration\";i:1770282476;s:2:\"ip\";s:14:\"193.248.44.173\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:148.0) Gecko/20100101 Firefox/148.0\";s:5:\"login\";i:1769072876;}s:64:\"3300de36d869b2e773d45573b17c29815a00a2690c40cc3ab231d9353ec9eaa4\";a:4:{s:10:\"expiration\";i:1770282476;s:2:\"ip\";s:14:\"193.248.44.173\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:148.0) Gecko/20100101 Firefox/148.0\";s:5:\"login\";i:1769072876;}s:64:\"a0674980c1e6f242cd0496f32cd57f752ec765d7474a4fac832a9722cdfc3778\";a:4:{s:10:\"expiration\";i:1770626910;s:2:\"ip\";s:12:\"51.159.39.21\";s:2:\"ua\";s:4:\"node\";s:5:\"login\";i:1769417310;}s:64:\"e2037459bb8bdb41995c0128681da101966b55b207a4fdf8987f06adc9ab37af\";a:4:{s:10:\"expiration\";i:1770626910;s:2:\"ip\";s:12:\"51.159.39.21\";s:2:\"ua\";s:4:\"node\";s:5:\"login\";i:1769417310;}s:64:\"84124c9b78a9909c9a320860fe2f52d6069306e785a5f68466805689d5e15989\";a:4:{s:10:\"expiration\";i:1770626910;s:2:\"ip\";s:14:\"193.248.44.173\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:148.0) Gecko/20100101 Firefox/148.0\";s:5:\"login\";i:1769417310;}s:64:\"e128c9a0f6854845b2416e55c5995ef00b7a94c0c7ef4ef8abe25b84febef755\";a:4:{s:10:\"expiration\";i:1770626910;s:2:\"ip\";s:14:\"193.248.44.173\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:148.0) Gecko/20100101 Firefox/148.0\";s:5:\"login\";i:1769417310;}s:64:\"55dc3facd894593053e233f0a88b75c72ec9b189cd224c8df89b9e9b2611f11f\";a:4:{s:10:\"expiration\";i:1771236489;s:2:\"ip\";s:12:\"51.159.39.21\";s:2:\"ua\";s:4:\"node\";s:5:\"login\";i:1770026889;}s:64:\"a30998a3b696f06f303e2e2eda8758e91fb50f8b69dc0c80b4de1077b6e0714d\";a:4:{s:10:\"expiration\";i:1771236489;s:2:\"ip\";s:12:\"51.159.39.21\";s:2:\"ua\";s:4:\"node\";s:5:\"login\";i:1770026889;}s:64:\"4af478ecec949f67dcbf131ceb43bce372b196589010ed1f1ce5d037518abb2b\";a:4:{s:10:\"expiration\";i:1771236489;s:2:\"ip\";s:14:\"193.248.44.173\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:148.0) Gecko/20100101 Firefox/148.0\";s:5:\"login\";i:1770026889;}s:64:\"26448da4ccf69947b3a50bcc48265728a91eff4066b1d34a2b57ac9cd5b522f3\";a:4:{s:10:\"expiration\";i:1771236489;s:2:\"ip\";s:14:\"193.248.44.173\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:148.0) Gecko/20100101 Firefox/148.0\";s:5:\"login\";i:1770026889;}s:64:\"b4cfd83dc611a8bf90267b7cbf6de93d908ea325215bb7e2a9f77f6ea6a0d698\";a:4:{s:10:\"expiration\";i:1770199691;s:2:\"ip\";s:14:\"193.248.44.173\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:148.0) Gecko/20100101 Firefox/148.0\";s:5:\"login\";i:1770026891;}}"),
("279","3","session_tokens","a:6:{s:64:\"9676904de136d0e93478b5710d19e78e2b0a441678d465767d4fce170eab551b\";a:4:{s:10:\"expiration\";i:1758871348;s:2:\"ip\";s:13:\"82.120.180.16\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36\";s:5:\"login\";i:1758698548;}s:64:\"96551ff2d13227e6d8bfecae7a7f5de096b15ffe085521d53a764ff38b77c1ca\";a:4:{s:10:\"expiration\";i:1758871483;s:2:\"ip\";s:13:\"82.120.180.16\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:144.0) Gecko/20100101 Firefox/144.0\";s:5:\"login\";i:1758698683;}s:64:\"874623eaa259073c689b76f93ccaf630d57b995f5be22f2f84d1ef1400a74ed2\";a:4:{s:10:\"expiration\";i:1758871726;s:2:\"ip\";s:13:\"82.120.180.16\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36\";s:5:\"login\";i:1758698926;}s:64:\"baf566d92f91c929716c89a8a634dbf23cbbdb07a0badaf8f508a5437b8943a4\";a:4:{s:10:\"expiration\";i:1758871743;s:2:\"ip\";s:13:\"82.120.180.16\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:144.0) Gecko/20100101 Firefox/144.0\";s:5:\"login\";i:1758698943;}s:64:\"b97ad70f85fd43e95101fb57fdd887727246f6f1850a58aa3d578f29c4446232\";a:4:{s:10:\"expiration\";i:1758871743;s:2:\"ip\";s:13:\"82.120.180.16\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:144.0) Gecko/20100101 Firefox/144.0\";s:5:\"login\";i:1758698943;}s:64:\"a7c322b60adb46fa7291a10c87aa2cd323d629a5655d73a9135af03076d4be15\";a:4:{s:10:\"expiration\";i:1759936171;s:2:\"ip\";s:15:\"185.146.221.138\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36\";s:5:\"login\";i:1758726571;}}"),
("280","2","session_tokens","a:12:{s:64:\"fe32600a5e6547b5ffa854b0e6addda0a188a3f07e51c27113618f3ec69b2121\";a:4:{s:10:\"expiration\";i:1770193802;s:2:\"ip\";s:14:\"149.232.193.44\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1768984202;}s:64:\"864ed629ca8d791f9bfcb73a1403c376fe431fdef2e6a462e680a2c2b7eb8f3b\";a:4:{s:10:\"expiration\";i:1770297044;s:2:\"ip\";s:14:\"149.232.193.44\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1769087444;}s:64:\"ac046f313176a223fefb3d27b632bf270ac2577c5bfeb1c67c8a7c1d1ab133e5\";a:4:{s:10:\"expiration\";i:1770200803;s:2:\"ip\";s:14:\"149.232.193.44\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1770028003;}s:64:\"cfd2cd2dbd6c2004b2e4d2160c2674452c969af7b516976e14dcce200f2f9f39\";a:4:{s:10:\"expiration\";i:1770210136;s:2:\"ip\";s:14:\"149.232.193.44\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1770037336;}s:64:\"354b97a1bac63c8dceaa377bd19fc04cec147886cd1d7cb7a8d2ddc340075e86\";a:4:{s:10:\"expiration\";i:1770213570;s:2:\"ip\";s:14:\"149.232.193.44\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1770040770;}s:64:\"ea728ce1f8b608103c62562059936991ca32d6dc9011a934ca628ee193103f80\";a:4:{s:10:\"expiration\";i:1770216073;s:2:\"ip\";s:14:\"149.232.193.44\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1770043273;}s:64:\"0dd8c8d8d651f48894cb55997e1c4a63879e0b35f28de0cf8e07be0447ea9b24\";a:4:{s:10:\"expiration\";i:1771270135;s:2:\"ip\";s:14:\"90.103.148.235\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1770060535;}s:64:\"388e8dcda27e61695dc1c0dff6bb6382f9af539c61c043338d02c6dc96d46d02\";a:4:{s:10:\"expiration\";i:1770281004;s:2:\"ip\";s:14:\"149.232.193.44\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1770108204;}s:64:\"56dfe7f6a68088cf79bc3516bad2b8b1bada7849ed4c56e29fd31753229fb428\";a:4:{s:10:\"expiration\";i:1771318403;s:2:\"ip\";s:14:\"149.232.193.44\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1770108803;}s:64:\"527ec8eba1444b885da128ec9938b963542485873448651632a3debbaec2be22\";a:4:{s:10:\"expiration\";i:1770283094;s:2:\"ip\";s:14:\"149.232.193.44\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1770110294;}s:64:\"ff23bc65d268ae619affbdf3d3196673c7e45b9b71969cd94895d31967609771\";a:4:{s:10:\"expiration\";i:1770284639;s:2:\"ip\";s:14:\"149.232.193.44\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1770111839;}s:64:\"8b07ab7875b3a26736764951c4205f63247df339497b02bdcf90f18b0b2029fe\";a:4:{s:10:\"expiration\";i:1770300617;s:2:\"ip\";s:14:\"149.232.193.44\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/144.0.0.0 Safari/537.36\";s:5:\"login\";i:1770127817;}}"),
("281","4","wpseo_content_analysis_disable",""),
("282","4","wpseo_keyword_analysis_disable",""),
("283","2","closedpostboxes_hurrytimer_countdown","a:1:{i:0;s:19:\"hurrytimer-settings\";}"),
("284","2","metaboxhidden_hurrytimer_countdown","a:0:{}"),
("290","5","session_tokens","a:1:{s:64:\"9342318c80340f3643e79719f7810adc352cde44b8530f005b4e3425a711b864\";a:4:{s:10:\"expiration\";i:1768382373;s:2:\"ip\";s:13:\"88.191.158.11\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36\";s:5:\"login\";i:1768209573;}}"),
("293","2","secupress-advanced-settings_admin-bar","1"),
("294","2","secupress-advanced-settings_expert-mode","1"),
("295","3","secupress-advanced-settings_admin-bar","1"),
("296","3","secupress-advanced-settings_expert-mode","1"),
("322","2","da_dismissed_secupress_notices","plugins_all_js_css,new-24"),
("334","3","da_dismissed_secupress_notices","new-23,new-23201"),
("337","5","secupress-advanced-settings_admin-bar","1"),
("338","5","secupress-advanced-settings_expert-mode","1"),
("343","3","da_googlesitekit_access_token","0gVNRROmw4Lo24EpofcQoStEQ1YwNSt5WXROTXdISy9xUGdHZ0VwRmVzbWpQNkhwVFMrZXNwWk1PS1dVZDNiMXpTRWZhWXpBZk5GVHhKaGFCZFEzMDJaUkhqNnA5b2hZbGtxOEIxVy9NdVBoVkhkdW1xaUtCVC9KN2F3UWFZMlVlZU1ZcHFUd2NCRksvYXYrRDF3b2RCcDNJMERzNGhyN2xDVTV5V2tuTlpQeThVZ2VkOE1wRUZDWU11Q2E3MDJSY1dMWUlBUVNsUTgxL0J3dU1ibE9yTkJmTWcwWmRCNzlBT3VNRXkwQ09OMEJSdWloYjhZSlhRWDR1dk9jRXBBcGdHT3I1NERUeHRtSG1vZmNlWUpEc3NsV20xQXNBdG0zWVNiZmVVMW10dU1SQkVwTVBQakMrZ3o0NW9UTk9lUmRkQmJBS1Q0QzVMU0IrYjZpeEY2RmFscTdNdWxnUjdQbWhET0ZjU3V4RnBZVDNSS2FuNUhJOXMxRk1ZQThMbGprcnFKaGRxcGJud2tIV01hd2lOWHpxdkpjYWRSZ2x5WFZ3M2VBY1NRTVBDOUVRR3I2TE5reHM1UzVJU3U0SnkyVnFRPT0="),
("344","3","da_googlesitekit_access_token_expires_in","3599"),
("345","3","da_googlesitekit_access_token_created_at","1758726870"),
("346","3","da_googlesitekit_refresh_token","8XXiQhfTRbMemz/bHoCfH3NIcG5pYjFVS29NRUsxbGhiQ01lQTZXcmNwTnlBcERaMWdoVHFXNTljWmtwRDE4cVMrNnpuM25JODdHUFh3eWtqUDZBczY2c2hzSUVtd1pmZEZ3cDd3cXVMYTJld3RaOXhGOEkzY2NMVVdoYS82d0RGZkgzNTNIdDdoRW1BUlp3d095QVJ4Q0g5UEhjQ202V0RLbCtpZGo0OWNlNUtidWpGWVBsMGNtS1BpMGxNSXJ5N1YxQUZZNnlKbS9mMU1PUlJLR3hKak9HYmdRbUFyY3pHcTZtZEtxUnRaM29hdTlsaE9VN0tYeG9JbUdINzUrMzU0TjRac0VQYVNOOC9XZXF2ZlAwaW9NRXMrcCsxejlJV3dYTlExSnB6emlMMXhkUFlCZnNqN2ppdVJlMlVCRnk1VGwyL0phR2dleWZDNVNTZW4xNmVNUHVValE9"),
("347","3","da_googlesitekit_auth_scopes","a:7:{i:0;s:50:\"https://www.googleapis.com/auth/analytics.readonly\";i:1;s:48:\"https://www.googleapis.com/auth/siteverification\";i:2;s:42:\"https://www.googleapis.com/auth/webmasters\";i:3;s:48:\"https://www.googleapis.com/auth/userinfo.profile\";i:4;s:51:\"https://www.googleapis.com/auth/tagmanager.readonly\";i:5;s:6:\"openid\";i:6;s:46:\"https://www.googleapis.com/auth/userinfo.email\";}"),
("348","3","da_googlesitekit_additional_auth_scopes","a:1:{i:0;s:46:\"https://www.googleapis.com/auth/analytics.edit\";}"),
("349","3","da_googlesitekit_profile","a:4:{s:5:\"email\";s:26:\"academica.france@gmail.com\";s:5:\"photo\";s:97:\"https://lh3.googleusercontent.com/a/ACg8ocKv45dNeENms6UDnYmBZo8eypR6xEwSCD5t9cqqvor5OceS3UYO=s100\";s:9:\"full_name\";s:16:\"Academica France\";s:12:\"last_updated\";i:1758726870;}"),
("350","3","da_googlesitekitpersistent_initial_version","1.162.0"),
("351","3","da_googlesitekit_site_verified_meta","verified"),
("352","3","da_googlesitekit_survey_timeouts","a:4:{s:8:\"view_kmw\";i:1759331579;s:14:\"view_dashboard\";i:1758813273;s:18:\"view_ads_setup_cta\";i:1758813294;s:18:\"view_ga4_dashboard\";i:1758813480;}"),
("353","3","da_googlesitekitpersistent_dismissed_items","a:1:{s:15:\"auto-update-cta\";i:1758727386;}"),
("354","3","da_googlesitekitpersistent_dismissed_tours","a:1:{i:0;s:16:\"sharedKeyMetrics\";}"),
("357","3","da_googlesitekit_audience_settings","a:3:{s:19:\"configuredAudiences\";a:2:{i:0;s:42:\"properties/294222352/audiences/12203815689\";i:1;s:42:\"properties/294222352/audiences/12203811809\";}s:34:\"isAudienceSegmentationWidgetHidden\";b:0;s:15:\"didSetAudiences\";b:1;}"),
("358","3","da_googlesitekitpersistent_expirable_items","a:3:{s:72:\"widget-area-expirable-new-badge-mainDashboardTrafficAudienceSegmentation\";i:1761146090;s:87:\"audience-selection-panel-expirable-new-badge-properties/294222352/audiences/12203815689\";i:1758726892;s:87:\"audience-selection-panel-expirable-new-badge-properties/294222352/audiences/12203811809\";i:1758726892;}"),
("359","3","da_googlesitekitpersistent_dismissed_prompts","a:1:{s:44:\"audience_segmentation_setup_cta-notification\";a:2:{s:7:\"expires\";i:0;s:5:\"count\";i:1;}}"),
("361","5","_yoast_wpseo_introductions","a:0:{}"),
("364","6","nickname","Np_digital"),
("365","6","first_name",""),
("366","6","last_name",""),
("367","6","description",""),
("368","6","rich_editing","true"),
("369","6","syntax_highlighting","true"),
("370","6","comment_shortcuts","false"),
("371","6","admin_color","fresh"),
("372","6","use_ssl","0"),
("373","6","show_admin_bar_front","true"),
("374","6","locale",""),
("375","6","da_capabilities","a:1:{s:7:\"lecteur\";b:1;}"),
("376","6","da_user_level","0"),
("377","6","dismissed_wp_pointers","sp22_ad"),
("378","6","_yoast_wpseo_profile_updated","1758789751"),
("379","6","dismissed_wp_pointers",""),
("381","7","nickname","Harold"),
("382","7","first_name",""),
("383","7","last_name",""),
("384","7","description",""),
("385","7","rich_editing","true"),
("386","7","syntax_highlighting","true"),
("387","7","comment_shortcuts","false"),
("388","7","admin_color","fresh"),
("389","7","use_ssl","0"),
("390","7","show_admin_bar_front","true"),
("391","7","locale",""),
("392","7","da_capabilities","a:1:{s:7:\"lecteur\";b:1;}"),
("393","7","da_user_level","0"),
("394","7","dismissed_wp_pointers","sp22_ad"),
("395","7","_yoast_wpseo_profile_updated","1759842482"),
("396","7","dismissed_wp_pointers",""),
("397","7","session_tokens","a:1:{s:64:\"127cfef244ea2fd65d1702a1b2630fd4d8d4d050d3379be0dcd9e5c8fad8cfe5\";a:4:{s:10:\"expiration\";i:1760022009;s:2:\"ip\";s:14:\"193.160.89.243\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36\";s:5:\"login\";i:1759849209;}}"),
("398","7","secupress-advanced-settings_admin-bar","1"),
("399","7","secupress-advanced-settings_expert-mode","1"),
("400","7","_yoast_wpseo_introductions","a:0:{}"),
("401","7","community-events-location","a:1:{s:2:\"ip\";s:12:\"193.160.89.0\";}"),
("402","6","_secupress_passwordspraying","G3fIUCHQWUF*RHkX2t609BPX"),
("403","6","_secupress_passwordspraying","G3fIUCHQWUF*RHkX2t609BPX"),
("404","6","_secupress_passwordspraying","G3fIUCHQWUF*RHkX2t609BPX"),
("405","1","secupress-advanced-settings_admin-bar","1"),
("406","1","secupress-advanced-settings_expert-mode","1"),
("419","2","closedpostboxes_toplevel_page_dd-countdown-top-bar","a:0:{}"),
("420","2","metaboxhidden_toplevel_page_dd-countdown-top-bar","a:0:{}"),
("422","1","wpseo_seen_llm_txt_opt_in_notification","1");

INSERT IGNORE INTO `da_actionscheduler_actions` VALUES 
("15947","action_scheduler/migration_hook","failed","2024-05-07 08:33:35","2024-05-07 10:33:35","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715070815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715070815;}","2","1","2024-05-07 08:34:12","2024-05-07 10:34:12","0",NULL,"10"),
("16458","action_scheduler/migration_hook","failed","2024-05-07 13:50:23","2024-05-07 15:50:23","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715089823;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715089823;}","2","1","2024-05-07 13:50:41","2024-05-07 15:50:41","0",NULL,"10"),
("27290","rocket_preload_job_preload_url","failed","2024-06-05 08:59:29","2024-06-05 08:59:29","[\"https:\\/\\/dualdiploma.org\\/ville\\/laval\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27291","rocket_preload_job_preload_url","failed","2024-06-05 08:59:29","2024-06-05 08:59:29","[\"https:\\/\\/dualdiploma.org\\/ville\\/le-mans\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27292","rocket_preload_job_preload_url","failed","2024-06-05 08:59:29","2024-06-05 08:59:29","[\"https:\\/\\/dualdiploma.org\\/ville\\/le-raincy\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27293","rocket_preload_job_preload_url","failed","2024-06-05 08:59:29","2024-06-05 08:59:29","[\"https:\\/\\/dualdiploma.org\\/ville\\/les-sables-dolonne\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27294","rocket_preload_job_preload_url","failed","2024-06-05 08:59:29","2024-06-05 08:59:29","[\"https:\\/\\/dualdiploma.org\\/ville\\/libourne\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27295","rocket_preload_job_preload_url","failed","2024-06-05 08:59:29","2024-06-05 08:59:29","[\"https:\\/\\/dualdiploma.org\\/ville\\/lille\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27296","rocket_preload_job_preload_url","failed","2024-06-05 08:59:29","2024-06-05 08:59:29","[\"https:\\/\\/dualdiploma.org\\/ville\\/limoges\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27297","rocket_preload_job_preload_url","failed","2024-06-05 08:59:29","2024-06-05 08:59:29","[\"https:\\/\\/dualdiploma.org\\/ville\\/limonest\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27298","rocket_preload_job_preload_url","failed","2024-06-05 08:59:29","2024-06-05 08:59:29","[\"https:\\/\\/dualdiploma.org\\/ville\\/loches\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27299","rocket_preload_job_preload_url","failed","2024-06-05 08:59:29","2024-06-05 08:59:29","[\"https:\\/\\/dualdiploma.org\\/ville\\/longuenesse\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27300","rocket_preload_job_preload_url","failed","2024-06-05 08:59:29","2024-06-05 08:59:29","[\"https:\\/\\/dualdiploma.org\\/ville\\/lorient\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27301","rocket_preload_job_preload_url","failed","2024-06-05 08:59:29","2024-06-05 08:59:29","[\"https:\\/\\/dualdiploma.org\\/ville\\/lyon\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27302","rocket_preload_job_check_finished","failed","2024-06-05 09:00:30","2024-06-05 11:00:30","[1717577970]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1717578030;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1717578030;}","1","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27324","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/bruz\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27325","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/caen\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27326","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/cahors\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27327","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/calais\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27328","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/cannes\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27329","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/carcassonne\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27330","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/challans\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27331","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/chambery\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27332","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/charleville-mezieres\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27333","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/charlieu\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27334","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/chartres\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27335","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/chatenay-malabry\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27336","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/chaville\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27337","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/cherbourg-en-cotentin\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27338","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/cholet\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27339","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/clermont-lherault\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27340","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/clermont-ferrand\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27341","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/cognac\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27342","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/colmar\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27343","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/courbevoie\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27344","rocket_saas_job_check_status","failed","2024-06-05 09:01:02","2024-06-05 09:01:02","[\"https:\\/\\/dualdiploma.org\\/ville\\/cuise-la-motte\",false,\"rucss\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","3","1","2024-07-10 11:24:35","2024-07-10 13:24:35","0",NULL,"10"),
("27424","rocket_preload_job_check_finished","failed","2024-07-10 11:43:57","2024-07-10 13:43:57","[1720611777]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1720611837;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1720611837;}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27433","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/differences-et-complementarites-des-pedagogies-francaise-et-americaine\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27434","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/une-ceremonie-de-remise-des-diplomes-dans-le-respect-des-traditions\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27435","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/interview-de-christine-mariotti-cheffe-detablissement-de-saint-coeur-a-beaune\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27436","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/temoignage-pedagogie-dual-diploma-academica\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27437","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/option-digital-photography\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27438","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/elective-digital-photography\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27439","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/4-reasons-to-integrate-the-dual-diploma-academica-into-your-schools-educational-pathway\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27440","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/differences-and-complementarities-of-french-and-american-pedagogies\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27441","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/testimony-pedagogy-dual-diploma-academica\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27442","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/life-management-skills-leading-a-healthy-and-constructive-lifestyle\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27443","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/life-management-skills-mener-un-style-de-vie-sain-et-constructif\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27444","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/preparez-vous-pour-luniversite-avec-college-entrance-exam-prep\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27445","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/get-ready-for-college-with-college-entrance-exam-prep\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27446","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/dans-la-mecanique-de-lelective-concepts-of-engineering-technology\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27447","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/criminologie-decouvrez-les-dessous-des-experts\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27448","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/lire-en-anglais-pour-parfaire-son-niveau\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27449","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/a-la-decouverte-de-lelective-psychology\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27450","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/ceremonie-graduation-2022-academica-dual-diploma\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27451","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/interview-anne-n-promotion-2022-etudiante-a-esmod\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27452","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/academica-laureat-presidential-eaward-biden\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27453","rocket_preload_job_preload_url","failed","2024-07-10 11:43:03","2024-07-10 11:43:03","[\"https:\\/\\/dualdiploma.org\\/enseignement-catholique-academica-au-congres-mondial-de-l-oiec\"]","O:28:\"ActionScheduler_NullSchedule\":0:{}","1","1","2024-07-10 11:44:21","2024-07-10 13:44:21","0",NULL,"10"),
("27463","action_scheduler/migration_hook","failed","2025-05-25 16:27:41","2025-05-25 18:27:41","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1748190461;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1748190461;}","2","1","2025-05-25 16:27:41","2025-05-25 18:27:41","0",NULL,"10"),
("27469","action_scheduler/migration_hook","failed","2025-07-01 09:08:19","2025-07-01 11:08:19","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1751360899;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1751360899;}","2","1","2025-07-01 09:08:25","2025-07-01 11:08:25","0",NULL,"10"),
("27472","action_scheduler/migration_hook","failed","2025-09-24 07:28:01","2025-09-24 09:28:01","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758698881;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758698881;}","2","1","2025-09-24 07:28:08","2025-09-24 09:28:08","0",NULL,"10");

INSERT IGNORE INTO `da_actionscheduler_claims` VALUES 
("2031","2024-06-05 08:42:29");

INSERT IGNORE INTO `da_actionscheduler_groups` VALUES 
("1","rocket-preload"),
("2","action-scheduler-migration"),
("3","rocket-rucss");

INSERT IGNORE INTO `da_actionscheduler_logs` VALUES 
("92","15947","action created","2024-05-07 08:32:35","2024-05-07 10:32:35"),
("186","15947","action started via WP Cron","2024-05-07 08:34:12","2024-05-07 10:34:12"),
("187","15947","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-05-07 08:34:12","2024-05-07 10:34:12"),
("1647","16458","action created","2024-05-07 13:49:23","2024-05-07 15:49:23"),
("1752","16458","action started via WP Cron","2024-05-07 13:50:41","2024-05-07 15:50:41"),
("1753","16458","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-05-07 13:50:41","2024-05-07 15:50:41"),
("34102","27290","action created","2024-06-05 08:59:29","2024-06-05 10:59:29"),
("34103","27291","action created","2024-06-05 08:59:29","2024-06-05 10:59:29"),
("34104","27292","action created","2024-06-05 08:59:29","2024-06-05 10:59:29"),
("34105","27293","action created","2024-06-05 08:59:29","2024-06-05 10:59:29"),
("34106","27294","action created","2024-06-05 08:59:29","2024-06-05 10:59:29"),
("34107","27295","action created","2024-06-05 08:59:29","2024-06-05 10:59:29"),
("34108","27296","action created","2024-06-05 08:59:29","2024-06-05 10:59:29"),
("34109","27297","action created","2024-06-05 08:59:29","2024-06-05 10:59:29"),
("34110","27298","action created","2024-06-05 08:59:29","2024-06-05 10:59:29"),
("34111","27299","action created","2024-06-05 08:59:29","2024-06-05 10:59:29"),
("34112","27300","action created","2024-06-05 08:59:29","2024-06-05 10:59:29"),
("34113","27301","action created","2024-06-05 08:59:29","2024-06-05 10:59:29"),
("34124","27302","action created","2024-06-05 08:59:30","2024-06-05 10:59:30"),
("34284","27324","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34285","27325","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34286","27326","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34287","27327","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34288","27328","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34289","27329","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34290","27330","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34291","27331","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34292","27332","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34293","27333","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34294","27334","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34295","27335","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34296","27336","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34297","27337","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34298","27338","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34299","27339","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34300","27340","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34301","27341","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34302","27342","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34303","27343","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34304","27344","action created","2024-06-05 09:01:02","2024-06-05 11:01:02"),
("34311","27290","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34312","27290","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34313","27291","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34314","27291","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34315","27292","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34316","27292","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34317","27293","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34318","27293","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34319","27294","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34320","27294","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34321","27295","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34322","27295","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34323","27296","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34324","27296","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34325","27297","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34326","27297","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34327","27298","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34328","27298","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34329","27299","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34330","27299","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34331","27300","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34332","27300","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34333","27301","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34334","27301","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34335","27302","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34336","27302","action failed via Async Request: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34337","27324","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34338","27324","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34339","27325","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34340","27325","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34341","27326","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34342","27326","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34343","27327","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34344","27327","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34345","27328","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34346","27328","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34347","27329","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34348","27329","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34349","27330","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34350","27330","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34351","27331","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34352","27331","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34353","27332","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34354","27332","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34355","27333","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34356","27333","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34357","27334","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34358","27334","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34359","27335","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34360","27335","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34361","27336","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34362","27336","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34363","27337","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34364","27337","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34365","27338","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34366","27338","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34367","27339","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34368","27339","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34369","27340","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34370","27340","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34371","27341","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34372","27341","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34373","27342","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34374","27342","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34375","27343","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34376","27343","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34377","27344","action started via Async Request","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34378","27344","action failed via Async Request: Scheduled action for rocket_saas_job_check_status will not be executed as no callbacks are registered.","2024-07-10 11:24:35","2024-07-10 13:24:35"),
("34578","27424","action created","2024-07-10 11:42:57","2024-07-10 13:42:57"),
("34593","27433","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34594","27434","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34595","27435","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34596","27436","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34597","27437","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34598","27438","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34599","27439","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34600","27440","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34601","27441","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34602","27442","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34603","27443","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34604","27444","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34605","27445","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34606","27446","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34607","27447","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34608","27448","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34609","27449","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34610","27450","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34611","27451","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34612","27452","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34613","27453","action created","2024-07-10 11:43:03","2024-07-10 13:43:03"),
("34662","27433","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34663","27433","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34664","27434","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34665","27434","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34666","27435","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34667","27435","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34668","27436","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34669","27436","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34670","27437","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34671","27437","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34672","27438","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34673","27438","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34674","27439","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34675","27439","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34676","27440","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34677","27440","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34678","27441","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34679","27441","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34680","27442","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34681","27442","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34682","27443","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34683","27443","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34684","27444","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34685","27444","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34686","27445","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34687","27445","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34688","27446","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34689","27446","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34690","27447","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34691","27447","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34692","27448","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34693","27448","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34694","27449","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34695","27449","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34696","27450","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34697","27450","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34698","27451","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34699","27451","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34700","27452","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34701","27452","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34702","27453","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34703","27453","action failed via Async Request: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34704","27424","action started via Async Request","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34705","27424","action failed via Async Request: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.","2024-07-10 11:44:21","2024-07-10 13:44:21"),
("34732","27463","action created","2025-05-25 16:26:41","2025-05-25 18:26:41"),
("34733","27463","action started via WP Cron","2025-05-25 16:27:41","2025-05-25 18:27:41"),
("34734","27463","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2025-05-25 16:27:41","2025-05-25 18:27:41"),
("34750","27469","action created","2025-07-01 09:07:19","2025-07-01 11:07:19"),
("34751","27469","action started via Async Request","2025-07-01 09:08:25","2025-07-01 11:08:25"),
("34752","27469","action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2025-07-01 09:08:25","2025-07-01 11:08:25"),
("34759","27472","action created","2025-09-24 07:27:01","2025-09-24 09:27:01"),
("34760","27472","action started via WP Cron","2025-09-24 07:28:08","2025-09-24 09:28:08"),
("34761","27472","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2025-09-24 07:28:08","2025-09-24 09:28:08");

INSERT IGNORE INTO `da_blc_instances` VALUES 
("165","28","14223","page","n\'hésitez pas à nous contacter","link","post_content","","https://dualdiploma.org/contact/"),
("214","134","14292","page","Toolin","link","post_content","","https://toolin.fr"),
("215","135","14292","page","l’Agence Tool","link","post_content","","https://agencetool.fr"),
("536","23","10717","post","Dans le cadre d\'Academica Dual Diploma<span>™</span>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("537","314","10717","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/02/daniel-schludi-7jl7ndhard8-unsplash-scaled-1.webp"),
("538","315","10717","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/02/gulfer-ergin-luguctvlk1q-unsplash-scaled-1.webp"),
("3670","281","8898","post","documentation page.","link","post_content","","https://dualdiploma.org/documentation/"),
("3671","282","8898","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/photography.webp"),
("3672","283","8898","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/aperture.webp"),
("3673","284","8898","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/shutter-speed.webp"),
("3674","285","8898","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/xmib27c74cb7ab171ae4fcf2c7aeed6c_259427471.webp"),
("3675","286","8898","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/hnmm7b43b1e6544f02e9cdc6771e8109_435927403.webp"),
("3676","287","8898","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/extrait-cours-digital-photography.webp"),
("3677","288","8898","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/extrait-cours-digital-photography-2.webp"),
("5026","136","17206","page","","link","post_content","","https://archives.dualdiploma.org/fichier/fichier-2/"),
("5027","136","17206","page","","link","post_content","","https://archives.dualdiploma.org/fichier/fichier-2/"),
("5241","551","16371","post","offrent de nombreux avantages aux élèves","link","post_content","","https://www.education.gouv.fr/reussir-au-lycee/l-abibac-6638?Cookies=true"),
("5242","23","16371","post","en immersion digitale dans une High School américaine","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("5243","419","16371","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/06/parlement-800x418.png"),
("5715","88","4357","post","digital courses","link","post_content","","https://dualdiploma.org/"),
("5716","88","4357","post","American teachers","link","post_content","","https://dualdiploma.org/"),
("5717","217","4357","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/01/Skyline-Manhattan-e1581597333651.webp"),
("5718","218","4357","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/01/crowdfunding-image.webp"),
("5719","262","10040","post","<span style=\"text-decoration: underline;\">the Dual Diploma Academica program</span>","link","post_content","","https://dualdiploma.org"),
("5720","292","10040","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/10/brett-jordan-d44kht8ex14-unsplash-copie-scaled-1.webp"),
("5721","293","10040","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/10/life-management-skills.webp"),
("5722","294","10040","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/10/brendan-church-pkef6tt3c08-unsplash-scaled-1.webp"),
("8021","88","166654","post","<strong>Academica Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("8022","540","166654","post","<strong>double diplôme</strong>","link","post_content","","https://dualdiploma.org/blog/le-bac-en-europe-doubles-diplomes-et-diversite-des-parcours/"),
("8023","23","166654","post","<strong>Academica Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("8024","23","166654","post","<strong>Academica Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("8025","540","166654","post","<strong>double diplôme</strong>","link","post_content","","https://dualdiploma.org/blog/le-bac-en-europe-doubles-diplomes-et-diversite-des-parcours/"),
("8026","88","166654","post","<strong>High School Diploma américain</strong>","link","post_content","","https://dualdiploma.org/"),
("8027","541","166654","post","nombreux élèves","link","post_content","","https://dualdiploma.org/blog/temoignage-pedagogie-dual-diploma-academica/"),
("8028","88","166654","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("8029","549","166654","post","professeur américain","link","post_content","","https://dualdiploma.org/blog/enseignement-a-distance-les-professeurs-academica-partagent-leurs-expertises-et-outils/"),
("8030","543","166654","post","expériences et cultures","link","post_content","","https://dualdiploma.org/blog/les-clubs-du-dual-diploma-des-experiences-dapprentissage-enrichissantes-et-diversifiees/"),
("8031","88","166654","post","<strong>Academica Dual Diploma™</strong>","link","post_content","","https://dualdiploma.org/"),
("8032","434","166654","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/11/diplomes-de-la-ceremonie-de-graduation-800x533.webp"),
("8033","435","166654","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/11/eleve-du-dual-diploma-lors-de-la-remise-de-diplome-2024-800x533.webp"),
("9290","511","356573","post","Sommet pour l\'Action sur l\'Intelligence Artificielle","link","post_content","","https://www.elysee.fr/sommet-pour-l-action-sur-l-ia"),
("9291","512","356573","post"," <strong>EdTech France</strong>","link","post_content","","https://edtechfrance.fr/"),
("9292","445","356573","post","Dual Diploma program","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#programme"),
("9293","445","356573","post","cours clés","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#programme"),
("9294","553","356573","post","Lia Seirotti","link","post_content","","https://ais.academica.org/lia-seirotti/"),
("9295","445","356573","post","Dual Diploma program","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#programme"),
("9296","514","356573","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/Design-sans-titre-21.png"),
("9297","552","356573","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/Lia-Seirotti.jpeg"),
("9298","522","356573","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/Design-sans-titre-23.png"),
("9299","591","393250","post","Academica International Studies","link","post_content","","https://ais.academica.org/?_gl=1%2Avgonlw%2A_up%2AMQ..%2A_ga%2AMjAzNzU4MzU2LjE3NDE5NTk4NTQ.%2A_ga_RNTF8F9BXT%2AMTc0MTk1OTg1My4xLjEuMTc0MTk2MjMzOC4wLjAuMA..%2A_ga_B8LVJ0X6ST%2AMTc0MTk1OTg1My4xLjEuMTc0MTk2MjMzOC4wLjAuMA.."),
("9300","592","393250","post","Student of the Month","link","post_content","","https://ais.academica.org/student-recognition/?_gl=1%2Aa2p4jk%2A_up%2AMQ..%2A_ga%2AMjAzODgzNjgzOC4xNzQxOTYyMzc4%2A_ga_B8LVJ0X6ST%2AMTc0MTk2MjM3Ny4xLjAuMTc0MTk2MjM3Ny4wLjAuMA..%2A_ga_RNTF8F9BXT%2AMTc0MTk2MjM3Ny4xLjAuMTc0MTk2MjM3Ny4wLjAuMA.."),
("9301","23","393250","post","le programme du double diplôme","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("9302","66","393250","post","Assistez à notre webinaire","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("9303","593","393250","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/Francillette-Cedric-Photo-e1736540765914-800x804.jpg"),
("9304","594","393250","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/IMG_0015.jpeg"),
("9305","595","393250","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/Cours-visio-800x803.png"),
("9306","596","393250","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/Logo-Dual-Diploma-Transparent-1-800x272.png"),
("9307","557","400322","post","SNCEEL","link","post_content","","https://www.snceel.fr/en-2025-tous-a-la-villette/"),
("9308","48","400322","post","300 partenaires","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("9309","23","400322","post","<strong>le programme Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("9310","558","400322","post","l’Institution Robin","link","post_content","","https://institution-robin.com/"),
("9311","559","400322","post","Jérémy Torresan","link","post_content","","https://www.linkedin.com/in/j%C3%A9r%C3%A9my-torresan-9a93b0265/overlay/about-this-profile/"),
("9312","481","400322","post","<strong>Assistez à notre webinaire</strong>","link","post_content","","https://dualdiploma.org/inscription-webinaire-partenaire/"),
("9313","560","400322","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/1741973581197-2-800x600.jpg"),
("9314","561","400322","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/POST-SIGNATURE-LINKEDIN-800x600.png"),
("9315","9","473541","post","Academica International Studies","link","post_content","","https://ais.academica.org/"),
("9316","597","473541","post","Lou Becker","link","post_content","","https://www.instagram.com/lou_cinematic/"),
("9317","23","473541","post","<strong>Dual Diploma Program™</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("9318","598","473541","post","Can you hear the music ?","link","post_content","","https://www.youtube.com/watch?v=qn53lNoB4n8"),
("9319","23","473541","post","Clubs","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("9320","66","473541","post","J\'assiste au webinaire","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("9321","599","473541","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/Capture-decran-2025-04-14-141705-1.png"),
("9322","600","473541","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/Winner-colegia-Film-Festival-800x1000.png"),
("9323","24","17242","post","représentants d\'Academica USA","link","post_content","","https://dualdiploma.org/le-groupe-academica/"),
("9324","46","17242","post","deux de nos professeures américaines","link","post_content","","https://dualdiploma.org/les-professeurs-americains/"),
("9325","420","17242","post","Retrouvez le Yearbook de la promotion 2024 ici.","link","post_content","","https://www.academicaseniors.com/"),
("9326","421","17242","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-204-scaled.webp"),
("9327","422","17242","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-234-800x533.webp"),
("9328","423","17242","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-260-800x533.webp"),
("9329","424","17242","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/alissa-longo-et-yvette-mendez-teachers-800x450.webp"),
("9330","425","17242","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/martine-roussel-et-celine-ouziel-800x450.webp"),
("9331","426","17242","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-338-800x533.webp"),
("9332","427","17242","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/10/240704-Academica-Reportage-376-scaled.webp"),
("9333","428","17242","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-458-800x533.webp"),
("9334","429","17242","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-558-scaled.webp"),
("9335","2","183925","post","<strong>Dual Diploma Program</strong>","link","post_content","","https://dualdiploma.org/le-programme/"),
("9336","88","183925","post","<strong>Academica Dual Diploma</strong>,","link","post_content","","https://dualdiploma.org/"),
("9337","88","183925","post","<strong>Academica Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("9338","46","183925","post","<strong>professeurs américains</strong>","link","post_content","","https://dualdiploma.org/les-professeurs-americains/"),
("9339","437","183925","post","<strong>Parcoursup</strong>","link","post_content","","https://authentification.parcoursup.fr/Authentification/connexionGestion"),
("9340","88","183925","post","<strong>College Counselling</strong>","link","post_content","","https://dualdiploma.org/"),
("9341","438","183925","post","<strong>Université de Bocconi</strong>.","link","post_content","","https://www.unibocconi.it/en"),
("9342","439","183925","post","<strong>Polytechnique</strong>","link","post_content","","https://www.polytechnique.edu/"),
("9343","440","183925","post","<strong>high school diploma américain</strong>","link","post_content","","https://dualdiploma.org/?s=high+school+diploma+am%C3%A9ricain"),
("9344","441","183925","post","<strong>Columbia</strong>","link","post_content","","https://www.columbia.edu/"),
("9345","442","183925","post","<strong>Dauphine</strong>","link","post_content","","https://dauphine.psl.eu/"),
("9346","443","183925","post","<strong>HEC Montréal</strong>","link","post_content","","https://www.hec.ca/"),
("9347","539","183925","post","<strong>school américaine</strong>","link","post_content","","https://dualdiploma.org/blog/le-club-model-un-du-dual-diploma/"),
("9348","91","183925","post","<strong>Academica Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/alumni/"),
("9349","57","183925","post","<strong>pédagogie</strong>","link","post_content","","https://dualdiploma.org/linnovation-pedagogique/"),
("9350","46","183925","post","<strong>professeurs américains</strong>","link","post_content","","https://dualdiploma.org/les-professeurs-americains/"),
("9351","445","183925","post"," programme","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#programme"),
("9352","46","183925","post","<strong><em>professeurs américains</em></strong>","link","post_content","","https://dualdiploma.org/les-professeurs-americains/"),
("9353","538","183925","post","<strong>Academica Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/blog/a-partnership-of-excellence-academica-international-studies-and-the-international-office-of-catholic-education-redefine-international-education/"),
("9354","447","183925","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/12/ceremonie-de-remise-de-diplome-2024-du-bac-americain-800x533.webp"),
("9355","448","183925","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/12/lancer-de-diplome-du-bac-americain-800x533.webp"),
("9356","535","215421","post","<strong>Academica Dual Diploma™</strong>","link","post_content","","https://dualdiploma.org/blog/remise-des-diplomes-2024-une-ceremonie-a-lamericaine-pour-lobtention-du-high-school-diploma/"),
("9357","445","215421","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#programme"),
("9358","9","215421","post","<strong>Academica International Studies</strong>","link","post_content","","https://ais.academica.org/"),
("9359","87","215421","post","<strong>grandes écoles</strong>","link","post_content","","https://dualdiploma.org/valorisation-post-bac/"),
("9360","537","215421","post","<strong>professeurs américains</strong>","link","post_content","","https://dualdiploma.org/blog/differences-et-complementarites-des-pedagogies-francaise-et-americaine/"),
("9361","537","215421","post","<strong>système éducatif français</strong>.","link","post_content","","https://dualdiploma.org/blog/differences-et-complementarites-des-pedagogies-francaise-et-americaine/"),
("9362","543","215421","post","clubs","link","post_content","","https://dualdiploma.org/blog/les-clubs-du-dual-diploma-des-experiences-dapprentissage-enrichissantes-et-diversifiees/"),
("9363","445","215421","post","<strong>programme Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#programme"),
("9364","536","215421","post","<strong>universités européennes</strong>","link","post_content","","https://dualdiploma.org/blog/obtenir-le-bac-americain-us-high-school-diploma-depuis-la-france-grace-au-digital/"),
("9365","534","215421","post","<strong>High School</strong>","link","post_content","","https://dualdiploma.org/blog/double-bac-francais-americain-quels-benefices/"),
("9366","532","215421","post","<em>compétences académiques</em>","link","post_content","","https://dualdiploma.org/blog/les-atouts-du-bilinguisme-dans-la-vie-active-des-jeunes-diplomes/"),
("9367","538","215421","post","<strong>Academica International Studies</strong>","link","post_content","","https://dualdiploma.org/blog/a-partnership-of-excellence-academica-international-studies-and-the-international-office-of-catholic-education-redefine-international-education/"),
("9368","66","215421","post","Inscrivez-vous à notre prochain webinaire pour plus d\'informations.","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("9369","465","215421","post","","image","post_content","","https://lh7-rt.googleusercontent.com/docsz/AD_4nXdizm2XaNYfb2olszDXo80iTgg4abP3w6O2PlicFae1o1FZkM5WKoRblj0VMVbfZ79kgpe-Ub1x_FP-iYaDtLOOdoKXjdRcRlGRDpIgPiQbKWlNE-dHcamupSy_knunnkkr-cRpcg?key=wRJohDMQHvGbsSGkYOpEFt5Y"),
("9370","466","215421","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/12/lancer-de-diplome-du-bac-americain-600x400.webp"),
("9371","467","215421","post","","image","post_content","","https://lh7-rt.googleusercontent.com/docsz/AD_4nXd_HkBhbD6T5GPezHtoA97xgj6LGYR6JvAR9aIW1KvTfUZKlWpSVWGfDaHOEIe97PLjqdH_38g8QJylhT-M01k7A-MEuC-_hYMZZbkMmkgJCfO-OINtXPsR7rqN0IQWMHwGF2fNCA?key=wRJohDMQHvGbsSGkYOpEFt5Y"),
("9372","468","215421","post","","image","post_content","","https://lh7-rt.googleusercontent.com/docsz/AD_4nXdM1QwNYpcfAliFBKDqZg3_qJpsvBwzwRoxY5yrTZLYlL0zV8HK0pmHLn-02_agrBw0Xdh3-xwgzVws3aKW0Gmq5QS0Uyl8Yv72xq8zepjICiwlTVqjGss8-xrJH8z9cHXNot-bIQ?key=wRJohDMQHvGbsSGkYOpEFt5Y"),
("9373","470","245251","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#diplome"),
("9374","48","245251","post","<strong>High Schools américaines</strong>","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("9375","46","245251","post","<strong>professeurs américains</strong>","link","post_content","","https://dualdiploma.org/les-professeurs-americains/"),
("9376","542","245251","post","<strong>High School Diploma</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma"),
("9377","46","245251","post","<strong>professeurs américains</strong>","link","post_content","","https://dualdiploma.org/les-professeurs-americains/"),
("9378","470","245251","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#diplome"),
("9379","48","245251","post"," <strong>universités américaines</strong>","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("9380","88","245251","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("9381","540","245251","post","<strong>High School Diploma </strong>","link","post_content","","https://dualdiploma.org/blog/le-bac-en-europe-doubles-diplomes-et-diversite-des-parcours/"),
("9382","445","245251","post","<strong>double cursus</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#programme"),
("9383","443","245251","post","HEC Montréal","link","post_content","","https://www.hec.ca/"),
("9384","487","245251","post","Sciences Po Paris ","link","post_content","","https://www.sciencespo.fr/fr/"),
("9385","88","245251","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("9386","471","245251","post","","image","post_content","","https://lh7-rt.googleusercontent.com/docsz/AD_4nXdZ4K63e7iqeas3gmt-TUYRLOVRtNt7Aud_CUCTvAKX281lVqr-tlcztPsxfMG9hmVO-hOhuo5pra6ITTudvQPYx9Mbj3JNLGZiPNaC2cCziFt2YvV90tWy5EPTNzvbBELAAa4q2g?key=wZ6-Sxrxu8Z_oSrUBApvQzv3"),
("9387","88","286805","post","<strong>Academica Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("9388","533","286805","post","<strong>universités américaines</strong>","link","post_content","","https://dualdiploma.org/blog/preparez-vous-pour-luniversite-avec-college-entrance-exam-prep/"),
("9389","533","286805","post","<strong>univers</strong>","link","post_content","","https://dualdiploma.org/blog/preparez-vous-pour-luniversite-avec-college-entrance-exam-prep/"),
("9390","533","286805","post","i","link","post_content","","https://dualdiploma.org/blog/preparez-vous-pour-luniversite-avec-college-entrance-exam-prep/"),
("9391","533","286805","post","<strong>tés américaines</strong>","link","post_content","","https://dualdiploma.org/blog/preparez-vous-pour-luniversite-avec-college-entrance-exam-prep/"),
("9392","533","286805","post","<strong>universitaire américain</strong>","link","post_content","","https://dualdiploma.org/blog/preparez-vous-pour-luniversite-avec-college-entrance-exam-prep/"),
("9393","88","286805","post","<strong>Dual Diploma,</strong>","link","post_content","","https://dualdiploma.org/"),
("9394","88","286805","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("9395","88","286805","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("9396","483","286805","post","<strong>College Entrance Exam Prep</strong>","link","post_content","","https://dualdiploma.org/?s=College+Entrance+Exam+Prep"),
("9397","533","286805","post","<strong>universités américaines</strong> ","link","post_content","","https://dualdiploma.org/blog/preparez-vous-pour-luniversite-avec-college-entrance-exam-prep/"),
("9398","533","286805","post"," <strong>universités américaines</strong>","link","post_content","","https://dualdiploma.org/blog/preparez-vous-pour-luniversite-avec-college-entrance-exam-prep/"),
("9399","88","286805","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("9400","23","286805","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("9401","484","286805","post","Georgetown University","link","post_content","","https://www.georgetown.edu/"),
("9402","485","286805","post","Brown University","link","post_content","","https://www.brown.edu/"),
("9403","88","286805","post","<strong>Academica Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("9404","23","286805","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("9405","66","286805","post","Inscrivez-vous dès maintenant pour découvrir comment le Dual Diploma peut transformer votre avenir","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("9406","486","286805","post","","image","post_content","","https://lh7-rt.googleusercontent.com/docsz/AD_4nXdXwKTtrlLNxBsWYBNky-LpEmihJPRchWYp13bGjPaAUacWcNRo2NFh63Px_RRuKojjIW1DEqX8JmX2NMe8vsw4spOUYNahP0Mco5zA7mkgsZldNOj_KM3NqGSIc7fsZcyoY2XAkQ?key=fIu53lRuP0tc_GV7aNkHiUk0"),
("9407","470","287466","post","Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#diplome"),
("9408","493","287466","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/01/young-asia-businesswoman-using-laptop-talk-colleague-about-plan-video-call-meeting-while-work-from-home-living-room-1-scaled.jpg"),
("9409","494","287466","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/01/Design-sans-titre-15.png"),
("9410","494","287466","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/01/Design-sans-titre-15.png"),
("9411","494","287466","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/01/Design-sans-titre-15.png"),
("9412","494","287466","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/01/Design-sans-titre-15.png"),
("9413","494","287466","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/01/Design-sans-titre-15.png"),
("9414","507","287466","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/01/Design-sans-titre-15-1.png"),
("9415","390","13378","post","International Office of Catholic Education","link","post_content","","http://oiecinternational.com/fr/"),
("9416","546","13378","post","AIS’s participation in the OIEC World Congress in Marseille last December","link","post_content","","https://dualdiploma.org/blog/enseignement-catholique-academica-au-congres-mondial-de-l-oiec/"),
("9417","40","13378","post","earn a recognized and accredited American digital high school diploma, the High School Diploma","link","post_content","","https://dualdiploma.org/comment-ca-marche/"),
("9418","90","13378","post","Be partner","link","post_content","","https://dualdiploma.org/devenir-partenaire/"),
("9419","337","13378","post","In 2022, Academica was honored with the prestigious Presidential E Award","link","post_content","","https://dualdiploma.org/academica-laureat-presidential-eaward-biden/"),
("9420","392","13378","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-et-herve-lecomte-signature-du-partenariat-entre-academica-international-studies-et-loiec-scaled-1.webp"),
("9421","393","13378","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/09/logo-oiec.webp"),
("9422","394","13378","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/09/partenariat-ais-et-oiec-logos-unesco-united-nations-counsil-of-europe.webp"),
("9423","395","13378","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/09/partenariat-ais-et-oiec-presidential-e-award.webp"),
("9424","396","13378","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-herve-lecomte-elizabeth-de-montlivault-chantal-firino-martell-scaled-1.webp"),
("9425","397","13378","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-et-herve-lecomte-en-compagnie-de-lequipe-francaise-dacademica-international-studies-scaled-1.webp"),
("9426","543","16334","post","différents clubs du Dual Diploma Program","link","post_content","","https://dualdiploma.org/blog/les-clubs-du-dual-diploma-des-experiences-dapprentissage-enrichissantes-et-diversifiees/"),
("9427","413","16334","post","https://www.un.org/en/mun","link","post_content","","https://www.un.org/en/mun"),
("9428","414","16334","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/mlk-800x1778.png"),
("9429","415","16334","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/stem-800x1778.png"),
("9430","416","16334","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/hr-800x1778.png"),
("9431","417","16334","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/sdg-800x1778.png"),
("9432","337","12311","post","lauréat du Presidential E Award décerné par le Président des Etats-Unis Joe Biden pour notre Excellence dans l’éducation","link","post_content","","https://dualdiploma.org/academica-laureat-presidential-eaward-biden/"),
("9433","547","12311","post","Lacordaire, école marseillaise","link","post_content","","https://www.lacordaire.com/le-lycee/filieres-et-options-au-lycee-lacordaire/#toggle-id-9"),
("9434","340","12311","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/01/academica-oiec-nouveau-logo.webp"),
("9435","341","12311","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/01/eleves-participant-au-congres-de-loiec.webp"),
("9436","342","12311","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/01/1674816306469-1-modifie.webp"),
("9437","343","12311","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.17.20.webp"),
("9438","344","12311","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/01/1674743743751-scaled-1.webp"),
("9439","345","12311","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/01/1674743743336-modifie-1.webp"),
("9440","346","12311","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/01/img-20221203-wa0011.webp"),
("9441","347","12311","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.17.20-2.webp"),
("9442","348","12311","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/01/eleve-academica-lors-du-congres-modifie.webp"),
("9443","349","12311","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.14.10.webp"),
("9444","350","12311","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/01/2693075621683966844.webp"),
("9445","23","13211","post","Dual Diploma Program","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("9446","365","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-academica_ceremonie-dome-de-paris-2023-scaled-1.webp"),
("9447","366","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-dome-de-paris-graduation-2023-scaled-1.webp"),
("9448","367","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/20230707-academica_ceremonie-128-benjaminbocquet-scaled-1.webp"),
("9449","368","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/livret-et-echarpe-1-scaled.webp"),
("9450","369","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/antonin.webp"),
("9451","370","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/20230707-academica_ceremonie-113-benjaminbocquet-scaled-1.webp"),
("9452","371","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/equipe-de-direction-americaine-academica-dual-diploma-scaled-1.webp"),
("9453","372","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/equipe-americaine-academica-scaled-1.webp"),
("9454","373","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/20230707-Academia_Ceremonie-GIF-001.gif"),
("9455","374","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/dji_0901-400x284-1.webp"),
("9456","375","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/img_0301-400x284-1.webp"),
("9457","376","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/academica-dome-de-paris-academica_ceremonie-dual-diploma-graduation-2023-400x284-1.webp"),
("9458","377","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/img_0394-400x284-1.webp"),
("9459","378","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/img_0350-400x284-1.webp"),
("9460","379","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/debut-ceremonie-graduation-2023-400x284-1.webp"),
("9461","380","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/drapeau-americain-ceremonie-graduation-2023-400x284-1.webp"),
("9462","381","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/graduation-academica_ceremonie-dualdiploma-2023-400x284-1.webp"),
("9463","382","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/academica_ceremonie-dual-diploma-graduation-2023-400x284-1.webp"),
("9464","383","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-sur-scene-academica-dual-diploma-400x284-1.webp"),
("9465","384","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-graduation-dual-diploma-2023-400x284-1.webp"),
("9466","385","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-diplomes-academica_ceremonie-dual-diploma-2023-400x284-1.webp"),
("9467","386","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/lancer-de-diplomes-academica_ceremonie-dual-diploma-2023.webp"),
("9468","387","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/academica-france-academica_ceremonie-dual-diploma-2023-400x284-1.webp"),
("9469","388","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/livret-400x284-1.webp"),
("9470","389","13211","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/diplomes-dualdiploma-graduation-2023-400x284-1.webp"),
("9471","390","13289","post","L\'Office International de l\'Enseignement Catholique","link","post_content","","http://oiecinternational.com/fr/"),
("9472","546","13289","post","a participation d’AIS au Congrès Mondial de l’OIEC à Marseille","link","post_content","","https://dualdiploma.org/blog/enseignement-catholique-academica-au-congres-mondial-de-l-oiec/"),
("9473","40","13289","post","un diplôme de fin d\'études secondaires américain en digital, le High School Diploma","link","post_content","","https://dualdiploma.org/comment-ca-marche/"),
("9474","90","13289","post","Devenir partenaire","link","post_content","","https://dualdiploma.org/devenir-partenaire/"),
("9475","337","13289","post","En 2022, Academica a été honorée du prestigieux Presidential E Award","link","post_content","","https://dualdiploma.org/academica-laureat-presidential-eaward-biden/"),
("9476","392","13289","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-et-herve-lecomte-signature-du-partenariat-entre-academica-international-studies-et-loiec-scaled-1.webp"),
("9477","393","13289","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/09/logo-oiec.webp"),
("9478","394","13289","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/09/partenariat-ais-et-oiec-logos-unesco-united-nations-counsil-of-europe.webp"),
("9479","395","13289","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/09/partenariat-ais-et-oiec-presidential-e-award.webp"),
("9480","396","13289","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-herve-lecomte-elizabeth-de-montlivault-chantal-firino-martell-scaled-1.webp"),
("9481","397","13289","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-et-herve-lecomte-en-compagnie-de-lequipe-francaise-dacademica-international-studies-scaled-1.webp"),
("9482","545","13710","post","cérémonie de graduation 2023","link","post_content","","https://dualdiploma.org/blog/ceremonie-de-graduation-2023-dacademica-dual-diploma/"),
("9483","544","13710","post","le Dual Diploma Times","link","post_content","","https://dualdiploma.org/blog/le-dual-diploma-times-donner-une-voix-a-nos-eleves-avec-le-journalisme/"),
("9484","400","13710","post","Nous vous invitons à consulter le dernier numéro ici","link","post_content","","https://ais.academica.org/ais2021B/wp-content/uploads/2023/05/Spring-2023-DDTimes.pdf"),
("9485","401","13710","post","@DDCookingandBakingClub","link","post_content","","https://www.instagram.com/ddcookingandbakingclub/"),
("9486","402","13710","post","@DualDiplomaBookClub","link","post_content","","https://www.instagram.com/dualdiplomabookclub/"),
("9487","403","13710","post","@DualDiploma-ArtSociety","link","post_content","","https://www.instagram.com/dualdiploma_artsociety/"),
("9488","404","13710","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/12/social-media-club_.webp"),
("9489","405","13710","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/12/dd-times-1.webp"),
("9490","406","13710","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/12/cooking-club_.webp"),
("9491","407","13710","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/12/book-club_.webp"),
("9492","408","13710","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/12/edutainment_.webp"),
("9493","409","13710","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/12/united-nations.webp"),
("9494","410","13710","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/12/art-club_.webp"),
("9495","2","14085","post","Rendez-vous la page du programme détaillé pour plus d\'informations sur les autres électives","link","post_content","","https://dualdiploma.org/le-programme/"),
("9496","411","14085","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/elective-public-speaking-and-journalism-800x256.webp"),
("9497","9","11394","post","Academica","link","post_content","","https://ais.academica.org/"),
("9498","23","11394","post","Dans le cadre d’Academica Dual Diploma™, vous devrez participer à des content based live sessions","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("9499","316","11394","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/05/bret-kavanaugh-_af0_qah4k4-unsplash-scaled-1.webp"),
("9500","317","11394","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/05/morgan-harper-nichols-omxprcahxre-unsplash-scaled-1.webp"),
("9501","40","11555","post","<strong><u>(en savoir plus sur le double diplôme).</u></strong>","link","post_content","","https://dualdiploma.org/comment-ca-marche/"),
("9502","318","11555","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/08/202207088610568246464570212_polarr_1-scaled-1.webp"),
("9503","319","11555","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/08/img_2794-scaled-1.webp"),
("9504","320","11555","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/08/img_2711-scaled-1.webp"),
("9505","321","11555","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/08/img_2587-scaled-1.webp"),
("9506","322","11555","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/08/img_3410-scaled-1.webp"),
("9507","323","11555","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/08/img_2478-400x284-1.webp"),
("9508","324","11555","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/08/img_2823-400x284-1.webp"),
("9509","325","11555","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/08/img_2760-400x284-1.webp"),
("9510","326","11555","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/08/img_3550-400x284-1.webp"),
("9511","327","11555","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/08/h7a4856-400x284-1.webp"),
("9512","328","11555","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/08/img_2542-400x284-1.webp"),
("9513","329","11555","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/08/h7a4747-400x284-1.webp"),
("9514","330","11555","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/08/img_2298-400x284-1.webp"),
("9515","48","11624","post"," ","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("9516","48","11624","post","l\'établissement Saint Louis à Lorient","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("9517","40","11624","post","<span style=\"text-decoration: underline;\">ici</span>","link","post_content","","https://dualdiploma.org/comment-ca-marche/"),
("9518","332","11624","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/09/anne-1.webp"),
("9519","333","11624","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2022/09/anne-2-scaled-1.webp"),
("9524","351","12819","post","en France pour Parcoursup","link","post_content","","https://www.parcoursup.fr/"),
("9525","23","12819","post","<strong>35 000 élèves de Academica International Studies répartis dans le monde</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("9526","352","12819","post","le site américain du Dual Diploma","link","post_content","","https://ais.academica.org/dual-diploma-times"),
("9527","353","12819","post","ici","link","post_content","","https://ais.academica.org/ais2021B/wp-content/uploads/2023/01/Diploma-Times-Winter-2022-Edition-Final-1-1.pdf"),
("9528","354","12819","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/04/novembre.webp"),
("9529","355","12819","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/04/novembre-2.webp"),
("9530","356","12819","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/04/musicals-1.webp"),
("9531","357","12819","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/04/musicals-2.webp"),
("9532","358","12819","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/04/europe.webp"),
("9533","359","12819","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/04/europe-2.webp"),
("9534","360","12819","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/04/double-standard.webp"),
("9535","361","12819","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/04/double-standard-2.webp"),
("9536","362","12819","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/04/world-cup.webp"),
("9537","363","12819","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/04/world-cup-2.webp"),
("9538","364","13139","post","Fondateur de l\'ONG internationale Ouishare","link","post_content","","https://fr.ouishare.net/"),
("9539","24","13139","post","L\'équipe américaine d\'Academica était également présente","link","post_content","","https://dualdiploma.org/le-groupe-academica/"),
("9540","365","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-academica_ceremonie-dome-de-paris-2023-scaled-1.webp"),
("9541","366","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-dome-de-paris-graduation-2023-scaled-1.webp"),
("9542","367","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/20230707-academica_ceremonie-128-benjaminbocquet-scaled-1.webp"),
("9543","368","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/livret-et-echarpe-1-scaled.webp"),
("9544","369","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/antonin.webp"),
("9545","370","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/20230707-academica_ceremonie-113-benjaminbocquet-scaled-1.webp"),
("9546","371","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/equipe-de-direction-americaine-academica-dual-diploma-scaled-1.webp"),
("9547","372","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/equipe-americaine-academica-scaled-1.webp"),
("9548","373","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/20230707-Academia_Ceremonie-GIF-001.gif"),
("9549","374","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/dji_0901-400x284-1.webp"),
("9550","375","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/img_0301-400x284-1.webp"),
("9551","376","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/academica-dome-de-paris-academica_ceremonie-dual-diploma-graduation-2023-400x284-1.webp"),
("9552","377","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/img_0394-400x284-1.webp"),
("9553","378","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/img_0350-400x284-1.webp"),
("9554","379","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/debut-ceremonie-graduation-2023-400x284-1.webp"),
("9555","380","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/drapeau-americain-ceremonie-graduation-2023-400x284-1.webp"),
("9556","381","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/graduation-academica_ceremonie-dualdiploma-2023-400x284-1.webp"),
("9557","382","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/academica_ceremonie-dual-diploma-graduation-2023-400x284-1.webp"),
("9558","383","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-sur-scene-academica-dual-diploma-400x284-1.webp"),
("9559","384","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-graduation-dual-diploma-2023-400x284-1.webp"),
("9560","385","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-diplomes-academica_ceremonie-dual-diploma-2023-400x284-1.webp"),
("9561","386","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/lancer-de-diplomes-academica_ceremonie-dual-diploma-2023.webp"),
("9562","387","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/academica-france-academica_ceremonie-dual-diploma-2023-400x284-1.webp"),
("9563","388","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/livret-400x284-1.webp"),
("9564","389","13139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/08/diplomes-dualdiploma-graduation-2023-400x284-1.webp"),
("9565","278","8839","post","click here","link","post_content","","https://www.aisvirtual.com/ourpages/auto/2016/2/25/72758904/Dual%20Diploma%20Times%20Issue%2013th%20Edition.pdf?rnd=1609939582000"),
("9566","279","8839","post","<span style=\"text-decoration: underline;\">this link</span>","link","post_content","","https://www.aisvirtual.com/apps/pages/index.jsp?uREC_ID=300445&type=d"),
("9567","40","10413","post","Academica Dual Diploma<span>™</span>","link","post_content","","https://dualdiploma.org/comment-ca-marche/"),
("9568","296","10413","post","<span style=\"text-decoration: underline;\">S\'inscrire</span>","link","post_content","","https://www.collegeboard.org/"),
("9569","297","10413","post","<span style=\"text-decoration: underline;\">En savoir +</span>","link","post_content","","https://prepexpert.com/sat-time-breakdown-with-breaks/"),
("9570","298","10413","post","<span style=\"text-decoration: underline;\">S\'inscrire</span>","link","post_content","","https://www.act.org/"),
("9571","299","10413","post","<span style=\"text-decoration: underline;\">En savoir +</span>","link","post_content","","https://www.princetonreview.com/college-advice/how-long-is-the-act#:~:text=The%20ACT%20is%203%20hours,over%204%20hours%20with%20breaks"),
("9572","300","10413","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/clayton-robbins-ihqb-c8c7bc-unsplash-scaled-1-800x533.webp"),
("9573","301","10413","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/10/brett-jordan-kuemuodzepy-unsplash.webp"),
("9574","88","10437","post","Dual Diploma Academica","link","post_content","","https://dualdiploma.org/"),
("9575","296","10437","post","<span style=\"text-decoration: underline;\">Apply</span>","link","post_content","","https://www.collegeboard.org/"),
("9576","297","10437","post","<span style=\"text-decoration: underline;\">Get more information</span>","link","post_content","","https://prepexpert.com/sat-time-breakdown-with-breaks/"),
("9577","298","10437","post","<span style=\"text-decoration: underline;\">Apply</span>","link","post_content","","https://www.act.org/"),
("9578","299","10437","post","<span style=\"text-decoration: underline;\">Get more information</span>","link","post_content","","https://www.princetonreview.com/college-advice/how-long-is-the-act#:~:text=The%20ACT%20is%203%20hours,over%204%20hours%20with%20breaks"),
("9579","300","10437","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/clayton-robbins-ihqb-c8c7bc-unsplash-scaled-1-800x533.webp"),
("9580","301","10437","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/10/brett-jordan-kuemuodzepy-unsplash.webp"),
("9581","2","10505","post","<u>le programme</u>","link","post_content","","https://dualdiploma.org/le-programme/"),
("9582","303","10505","post","nombreux métiers liés à ce domaine","link","post_content","","https://concours-advance.fr/admission-post-bac/metiers-apres-ecole-ingenieur/"),
("9583","2","10505","post","<u>programme</u>.","link","post_content","","https://dualdiploma.org/le-programme/"),
("9584","304","10505","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-1.webp"),
("9585","305","10505","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-2.webp"),
("9586","306","10505","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-3.webp"),
("9587","307","10505","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-4.webp"),
("9588","308","10505","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-5.webp"),
("9589","309","10505","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/11/1.webp"),
("9590","310","10505","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/11/3.webp"),
("9591","311","10505","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/11/4.webp"),
("9592","9","10702","post","Academica","link","post_content","","https://ais.academica.org/"),
("9593","2","10702","post","<span style=\"text-decoration: underline;\">cours</span>&nbsp;","link","post_content","","https://dualdiploma.org/le-programme/"),
("9594","312","10702","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/fingerprint-257037_1280-800x796.png"),
("9595","313","10702","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/cours-crime.webp"),
("9596","277","5342","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/11/photo-christine-mariotti-scaled-1.webp"),
("9597","278","7371","post","cliquez ici","link","post_content","","https://www.aisvirtual.com/ourpages/auto/2016/2/25/72758904/Dual%20Diploma%20Times%20Issue%2013th%20Edition.pdf?rnd=1609939582000"),
("9598","279","7371","post","<span style=\"text-decoration: underline;\">en suivant ce lien</span>","link","post_content","","https://www.aisvirtual.com/apps/pages/index.jsp?uREC_ID=300445&type=d"),
("9599","280","7371","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/03/elias.webp"),
("9600","187","7463","post","notre page de documentation.","link","post_content","","https://dualdiploma.org/documentation/"),
("9601","282","7463","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/photography.webp"),
("9602","283","7463","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/aperture.webp"),
("9603","284","7463","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/shutter-speed.webp"),
("9604","285","7463","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/xmib27c74cb7ab171ae4fcf2c7aeed6c_259427471.webp"),
("9605","286","7463","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/hnmm7b43b1e6544f02e9cdc6771e8109_435927403.webp"),
("9606","287","7463","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/extrait-cours-digital-photography.webp"),
("9607","288","7463","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/04/extrait-cours-digital-photography-2.webp"),
("9608","232","8775","post","CNESCO Report on Modern Foreign Languages.","link","post_content","","https://www.cnesco.fr/fr/langues-vivantes/recommandations/"),
("9609","550","8775","post","<span style=\"font-weight: 400;\">Dual Diploma Academica</span>","link","post_content","","https://dualdiploma.org/blog/decouvrir-le-dual-diploma-academica-bac-francais-us-high-school-diploma/"),
("9610","8","8775","post","Discover the Dual Diploma Academica program team.","link","post_content","","https://dualdiploma.org/academica-france/"),
("9611","237","8775","post","<span style=\"font-weight: 400;\">Lycée Stanislas Cannes</span>","link","post_content","","https://www.stanislas-cannes.com/"),
("9612","234","8775","post","<span style=\"font-weight: 400;\">Saint Joseph de Tivoli in Bordeaux</span>","link","post_content","","https://dualdiploma.org/etablissement-partenaire/#partenaires"),
("9613","238","8775","post","<span style=\"font-weight: 400;\">Lasalle Maravillas</span>","link","post_content","","https://lasallemaravillas.com/"),
("9614","48","8775","post","<span style=\"font-weight: 400;\">Become an Academica Dual Diploma partner school&nbsp;</span>","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("9615","550","8794","post","Dual Diploma Academica ","link","post_content","","https://dualdiploma.org/blog/decouvrir-le-dual-diploma-academica-bac-francais-us-high-school-diploma/"),
("9616","267","8794","post","homework","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#temps-de-travail-et-calendrier"),
("9617","239","8794","post"," US ","link","post_content","","https://dualdiploma.org/decrocher-le-us-high-school-diploma-depuis-la-france-grace-au-digital/"),
("9618","239","8794","post","High School Diploma","link","post_content","","https://dualdiploma.org/decrocher-le-us-high-school-diploma-depuis-la-france-grace-au-digital/"),
("9619","228","8794","post","<strong>US </strong>","link","post_content","","https://dualdiploma.org/le-groupe-academica/#le-high-school-diploma"),
("9620","228","8794","post","<strong>High School Diploma</strong>","link","post_content","","https://dualdiploma.org/le-groupe-academica/#le-high-school-diploma"),
("9621","532","8794","post","Discover the advantages of bilingualism for young graduates","link","post_content","","https://dualdiploma.org/blog/les-atouts-du-bilinguisme-dans-la-vie-active-des-jeunes-diplomes/"),
("9622","268","8794","post","Flipped Learning Network","link","post_content","","https://www.panopto.com/blog/what-is-a-flipped-classroom/"),
("9623","24","8794","post","<strong>Academ</strong>","link","post_content","","https://dualdiploma.org/le-groupe-academica/"),
("9624","24","8794","post","<strong>ica International Studies</strong>","link","post_content","","https://dualdiploma.org/le-groupe-academica/"),
("9625","213","8794","post","American teachers","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#professeurs-americains"),
("9626","88","8794","post","Academica","link","post_content","","https://dualdiploma.org/"),
("9627","549","8794","post","online teaching","link","post_content","","https://dualdiploma.org/blog/enseignement-a-distance-les-professeurs-academica-partagent-leurs-expertises-et-outils/"),
("9628","260","8794","post","Discover the testimonials of Academica students and teachers","link","post_content","","https://dualdiploma.org/temoignages/"),
("9629","289","8794","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/05/dual_diploma_high-bac-american-flag.webp"),
("9630","270","8794","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/06/dual-diploma-academica-france-us-flag.webp"),
("9631","290","8794","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/06/shutterstock_179296106.webp"),
("9632","40","10003","post","<span style=\"text-decoration: underline;\"><strong>le programme Academica Dual Diploma™</strong></span>","link","post_content","","https://dualdiploma.org/comment-ca-marche/"),
("9633","292","10003","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/10/brett-jordan-d44kht8ex14-unsplash-copie-scaled-1.webp"),
("9634","293","10003","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/10/life-management-skills.webp"),
("9635","294","10003","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2021/10/brendan-church-pkef6tt3c08-unsplash-scaled-1.webp"),
("9636","550","5139","post","cursus Dual Diploma Academica","link","post_content","","https://dualdiploma.org/blog/decouvrir-le-dual-diploma-academica-bac-francais-us-high-school-diploma/"),
("9637","549","5139","post","professeurs américains","link","post_content","","https://dualdiploma.org/blog/enseignement-a-distance-les-professeurs-academica-partagent-leurs-expertises-et-outils/"),
("9638","213","5139","post","professeurs américains","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#professeurs-americains"),
("9639","235","5139","post","professeur référent français","link","post_content","","https://dualdiploma.org/etablissement-partenaire/#coordinateur"),
("9640","550","5139","post","Dual Diploma Academica","link","post_content","","https://dualdiploma.org/blog/decouvrir-le-dual-diploma-academica-bac-francais-us-high-school-diploma/"),
("9641","88","5139","post","Academica","link","post_content","","https://dualdiploma.org/"),
("9642","260","5139","post","Madame Kaiser, Program director au lycée Paul Claudel d’Hulst à Paris","link","post_content","","https://dualdiploma.org/temoignages/"),
("9643","261","5139","post","<strong>si une </strong><strong>famille expatriée</strong><strong> doit déménager, leur enfant pourra continuer son cursus avec Academica en candidat libre</strong>.","link","post_content","","https://dualdiploma.org/eleve/#suivre-en-candidat-libre"),
("9644","549","5139","post","Enseignement à distance : les professeurs Academica partagent leurs expertises et outils","link","post_content","","https://dualdiploma.org/blog/enseignement-a-distance-les-professeurs-academica-partagent-leurs-expertises-et-outils/"),
("9645","262","5139","post","Academica International Studies","link","post_content","","https://dualdiploma.org"),
("9646","260","5139","post","Découvrez l’ensemble des témoignages de nos professeurs référents.","link","post_content","","https://dualdiploma.org/temoignages/"),
("9647","532","5139","post","bilinguisme","link","post_content","","https://dualdiploma.org/blog/les-atouts-du-bilinguisme-dans-la-vie-active-des-jeunes-diplomes/"),
("9648","66","5139","post","inscrivez-vous à nos réunions d’informations web","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("9649","260","5139","post","Découvrez les témoignages Academica élèves et enseignants","link","post_content","","https://dualdiploma.org/temoignages/"),
("9650","260","5139","post","Témoignages de parents","link","post_content","","https://dualdiploma.org/temoignages/"),
("9651","264","5139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/06/shutterstock_716924311.webp"),
("9652","265","5139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/06/ave-studentsatwork-e1591349771898.webp"),
("9653","266","5139","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/06/ave-lifemanagement.webp"),
("9654","550","5181","post","Dual Diploma Academica","link","post_content","","https://dualdiploma.org/blog/decouvrir-le-dual-diploma-academica-bac-francais-us-high-school-diploma/"),
("9655","267","5181","post","travail à la maison","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#temps-de-travail-et-calendrier"),
("9656","239","5181","post","US ","link","post_content","","https://dualdiploma.org/decrocher-le-us-high-school-diploma-depuis-la-france-grace-au-digital/"),
("9657","239","5181","post","High School Diploma","link","post_content","","https://dualdiploma.org/decrocher-le-us-high-school-diploma-depuis-la-france-grace-au-digital/"),
("9658","228","5181","post","<strong>US </strong>","link","post_content","","https://dualdiploma.org/le-groupe-academica/#le-high-school-diploma"),
("9659","228","5181","post","<strong>High School Diploma</strong>","link","post_content","","https://dualdiploma.org/le-groupe-academica/#le-high-school-diploma"),
("9660","532","5181","post","Découvrez les atouts du bilinguisme pour les jeunes diplômés","link","post_content","","https://dualdiploma.org/blog/les-atouts-du-bilinguisme-dans-la-vie-active-des-jeunes-diplomes/"),
("9661","268","5181","post","Flipped Learning Network","link","post_content","","https://www.panopto.com/blog/what-is-a-flipped-classroom/"),
("9662","24","5181","post","<strong>Academ</strong>","link","post_content","","https://dualdiploma.org/le-groupe-academica/"),
("9663","24","5181","post","<strong>ica International Studies</strong>","link","post_content","","https://dualdiploma.org/le-groupe-academica/"),
("9664","213","5181","post","professeurs","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#professeurs-americains"),
("9665","213","5181","post","américains","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#professeurs-americains"),
("9666","88","5181","post","Academica","link","post_content","","https://dualdiploma.org/"),
("9667","549","5181","post","enseignement en ligne","link","post_content","","https://dualdiploma.org/blog/enseignement-a-distance-les-professeurs-academica-partagent-leurs-expertises-et-outils/"),
("9668","260","5181","post","Découvrez les témoignages d","link","post_content","","https://dualdiploma.org/temoignages/"),
("9669","260","5181","post","’","link","post_content","","https://dualdiploma.org/temoignages/"),
("9670","260","5181","post","élèves et enseignants Academica","link","post_content","","https://dualdiploma.org/temoignages/"),
("9671","269","5181","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/06/20230707-academica_ceremonie-191-2-benjaminbocquet-copy1-scaled-1.webp"),
("9672","270","5181","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/06/dual-diploma-academica-france-us-flag.webp"),
("9673","271","5181","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/06/drapeau-americain-ceremonie-graduation-2023-scaled-1.webp"),
("9674","239","5251","post","high school diploma","link","post_content","","https://dualdiploma.org/decrocher-le-us-high-school-diploma-depuis-la-france-grace-au-digital/"),
("9675","88","5251","post","Dual Diploma en France","link","post_content","","https://dualdiploma.org/"),
("9676","214","5251","post","établissements scolaires partenaires en France","link","post_content","","https://dualdiploma.org/nos-etablissements-partenaires#partenaires"),
("9677","272","5251","post","Academica International Studies france virtual graduation 2020","link","post_content","","https://www.youtube.com/watch?v=9W3MI2Qd1UY"),
("9678","273","5251","post","diplômes Academica","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#graduation"),
("9679","119","5251","post","<span style=\"font-weight: 400;\">Comment inscrire votre enfant au programme Dual Diploma Academica ?</span>","link","post_content","","https://dualdiploma.org/eleve/"),
("9680","556","5251","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/07/shutterstock_174215792-scaled-1.webp"),
("9681","434","5251","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/11/diplomes-de-la-ceremonie-de-graduation-800x533.webp"),
("9682","426","5251","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-338-800x533.webp"),
("9683","550","4701","post","<span style=\"font-weight: 400;\">Dual Diploma Academica</span>","link","post_content","","https://dualdiploma.org/blog/decouvrir-le-dual-diploma-academica-bac-francais-us-high-school-diploma/"),
("9684","228","4701","post","<span style=\"font-weight: 400;\">US High School Diploma</span>","link","post_content","","https://dualdiploma.org/le-groupe-academica/#le-high-school-diploma"),
("9685","88","4701","post","<span style=\"font-weight: 400;\">Academica International Studies</span>","link","post_content","","https://dualdiploma.org/"),
("9686","212","4701","post","<span style=\"font-weight: 400;\">Découvrez le déroulement du programme Dual Diploma</span>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#quoi-pour-qui-comment"),
("9687","213","4701","post","<span style=\"font-weight: 400;\">professeurs américains</span>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#professeurs-americains"),
("9688","66","4701","post","<span style=\"font-weight: 400;\">inscrire à nos webinaires</span>","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("9689","88","4701","post","<span style=\"font-weight: 400;\">double diplôme</span>","link","post_content","","https://dualdiploma.org/"),
("9690","119","4701","post","<span style=\"font-weight: 400;\">Comment inscrire votre enfant au programme Dual Diploma</span>","link","post_content","","https://dualdiploma.org/eleve/"),
("9705","88","4813","post","Academica International Studies","link","post_content","","https://dualdiploma.org/"),
("9706","8","4813","post","l\'équipe Academica","link","post_content","","https://dualdiploma.org/academica-france/"),
("9707","213","4813","post","enseignants américains de Academica","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#professeurs-americains"),
("9708","24","4813","post","Academica","link","post_content","","https://dualdiploma.org/le-groupe-academica/"),
("9709","555","4813","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/04/webinaire-classe-virtuelle.webp"),
("9710","555","4813","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/04/webinaire-classe-virtuelle.webp"),
("9718","609","3542","post","bilinguisme","link","post_content","","https://dualdiploma.org/blog/tag/classe-virtuelle/"),
("9719","88","3542","post","Dual Diploma Academica","link","post_content","","https://dualdiploma.org/"),
("9720","88","3542","post","Dual Diploma Academica","link","post_content","","https://dualdiploma.org/"),
("9721","88","3542","post","Dual Diploma Academica","link","post_content","","https://dualdiploma.org/"),
("9722","216","3542","post","cours en digital","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#plan-detudes"),
("9723","213","3542","post","professeurs américains","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#professeurs-americains"),
("9724","217","3542","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/01/Skyline-Manhattan-e1581597333651.webp"),
("9725","218","3542","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2020/01/crowdfunding-image.webp"),
("9726","88","4053","post","American teachers","link","post_content","","https://dualdiploma.org/"),
("9727","88","4053","post","their school","link","post_content","","https://dualdiploma.org/"),
("9728","262","4053","post","DualDiploma.org","link","post_content","","https://dualdiploma.org"),
("9729","48","4053","post","Discover our partnering schools","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("9737","231","4714","post","établissements partenaires","link","post_content","","https://dualdiploma.org/etablissement-partenaire/#devenir-partenaire"),
("9738","232","4714","post","Rapport CNESCO sur les Langues vivantes étrangères","link","post_content","","https://www.cnesco.fr/fr/langues-vivantes/recommandations/"),
("9739","213","4714","post","<span style=\"font-weight: 400;\">professeurs américains</span>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#professeurs-americains"),
("9740","550","4714","post","<span style=\"font-weight: 400;\">Dual Diploma Academica</span>","link","post_content","","https://dualdiploma.org/blog/decouvrir-le-dual-diploma-academica-bac-francais-us-high-school-diploma/"),
("9741","48","4714","post","<span style=\"font-weight: 400;\">600 établissements partenaires</span>","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("9742","23","4714","post","<span style=\"font-weight: 400;\">High School américaine</span>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("9743","233","4714","post","<span style=\"font-weight: 400;\">immersion dans une culture étrangère</span>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#les-benefices"),
("9744","234","4714","post","<span style=\"font-weight: 400;\">36 établissements français</span>","link","post_content","","https://dualdiploma.org/etablissement-partenaire/#partenaires"),
("9745","235","4714","post","<span style=\"font-weight: 400;\">professeur référent nommé Program</span>","link","post_content","","https://dualdiploma.org/etablissement-partenaire/#coordinateur"),
("9746","8","4714","post","Découvrez l’équipe du programme Dual Diploma Academica","link","post_content","","https://dualdiploma.org/academica-france/"),
("9747","237","4714","post","<span style=\"font-weight: 400;\">Lycée Stanislas Cannes</span>","link","post_content","","https://www.stanislas-cannes.com/"),
("9748","234","4714","post","<span style=\"font-weight: 400;\">Saint Joseph de Tivoli à Bordeaux</span>","link","post_content","","https://dualdiploma.org/etablissement-partenaire/#partenaires"),
("9749","238","4714","post","<span style=\"font-weight: 400;\">Lasalle Maravillas</span>","link","post_content","","https://lasallemaravillas.com/"),
("9750","48","4714","post","<span style=\"font-weight: 400;\">Devenez un établissement partenaire du double diplôme Dual Diploma Academica</span>","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("9751","23","3449","post","d’étudier comme aux USA. ","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("9752","212","3449","post","Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#quoi-pour-qui-comment"),
("9753","88","3449","post","Découvrez les conditions d’admission au High School Diploma depuis la France","link","post_content","","https://dualdiploma.org/"),
("9754","213","3449","post","professeurs américains","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#professeurs-americains"),
("9755","214","3449","post","établissement scolaire","link","post_content","","https://dualdiploma.org/nos-etablissements-partenaires#partenaires"),
("9756","88","3449","post","Dual Diploma.org","link","post_content","","https://dualdiploma.org/"),
("9757","48","3449","post","Découvrez les établissements partenaires","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("9944","119","820309","post","<strong>étudiants étrangers</strong>","link","post_content","","https://dualdiploma.org/eleve/"),
("9945","632","820309","post","SEVP","link","post_content","","https://www.ice.gov/sevis"),
("9946","633","820309","post","<strong>ambassade des États-Unis</strong>","link","post_content","","https://fr.usembassy.gov/fr/visas-fr/"),
("9947","24","820309","post","<strong>programme Academica Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/le-groupe-academica/"),
("9948","28","820309","post","<strong>Dual Diploma d’Academica</strong>","link","post_content","","https://dualdiploma.org/contact/"),
("9949","2","820309","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/le-programme/"),
("9950","636","820309","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/09/unnamed.jpg"),
("9951","634","820309","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/08/image-800x533.jpeg"),
("9952","635","820309","post","","image","post_content","","https://lh7-rt.googleusercontent.com/docsz/AD_4nXe3Rvc8j4mOSOWZWQAEWCE4gANFKKtKmTWtPPqOKdRmCTI-Uly8gY5VBsRXvK9Ya6KCCxFqyGjgKbSSx1Xr1_VRwePs42-7FB4qBOcP0LOlTHP2QvFRJkm5kwGbLllaXA0B842A?key=PWhMsYmAQYQ2m49QYM8tHHiz"),
("10047","28","820321","post","Academica Dual Diploma","link","post_content","","https://dualdiploma.org/contact/"),
("10048","470","820321","post","<strong>High School Diploma</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#diplome"),
("10049","66","820321","post","<strong>diplôme américain</strong>","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("10050","647","820321","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/09/ARTICLE-LINKEDIN-CV-1-800x800.png"),
("10051","642","820321","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/08/image-1-800x533.jpeg"),
("10052","643","820321","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/08/image-2-800x533.jpeg"),
("10053","644","820321","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/09/AD_4nXdKWNp58_k1nYFL-YKNm4EYl8VmqQTJbyQYyhveBo8Ug3Wyc7wFJvvXFEbEI-9SzIW14EGIxXq_ngwb9QcgyH9VbaJQPXU4Lik2UwlGpM6wJaOGQOdfJfvpCXH-rznezzb021oHqQ.jpg"),
("10054","645","820321","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/09/AD_4nXfGObTYW6eH_fXPIjAl7m_P40c4NG4g9fCzx9DRESGpV0pPqYwk9vHg2-LI2xP_DfKMfXQLtPJhowuNyGpVk0JfyWou3_gSfr0H-bNepn5FbygRoD7qUHuxXRIDtVP3NR6u0cyPIw.png"),
("10055","646","820321","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/08/image-3-800x434.jpeg"),
("10146","334","12219","post","décerner le E Award à <strong>Academica International Studies (AIS)</strong>","link","post_content","","https://www.commerce.gov/news/blog/2022/07/secretary-gina-raimondo-presents-presidential-awards-export-excellence-us"),
("10147","23","12219","post","permet aux lycéens étrangers d\'obtenir un diplôme d\'études secondaires accrédité par les Etats-Unis","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("10148","335","12219","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/01/e-award-gina-raimondo-et-gina-lalicata.webp"),
("10149","336","12219","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2023/01/cropped_mi_john_f_kennedy_crest_white_house_getty.webp"),
("10158","649","820233","post","J\'accède au quizz","link","post_content","","https://dualdiploma.org/irregular-verbs-trainer/"),
("10159","40","820233","post","Dual Diploma","link","post_content","","https://dualdiploma.org/comment-ca-marche/"),
("10160","56","820233","post","méthode adaptée","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#experience"),
("10161","28","820233","post","programme Dual Diploma","link","post_content","","https://dualdiploma.org/contact/"),
("10162","88","820233","post","Je découvre le Dual Diploma","link","post_content","","https://dualdiploma.org/"),
("10163","650","820233","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/08/image-800x533.png"),
("10164","651","820233","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/08/image-1-800x533.png"),
("10384","656","916405","post","<strong>Réseau mlfmonde</strong>","link","post_content","","https://www.mlfmonde.org/"),
("10385","88","916405","post","Academica Dual Diploma","link","post_content","","https://dualdiploma.org/"),
("10386","23","916405","post","double Diplôme franco-américain","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("10387","657","916405","post","Découvrir le Réseau mlfmonde","link","post_content","","https://www.mlfmonde.org"),
("10388","262","916405","post","En savoir plus sur le Dual Diploma","link","post_content","","https://dualdiploma.org"),
("10389","658","916405","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/09/IMG_4358-800x504.jpg"),
("10390","659","916405","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/09/IMG_2051-800x448.jpg"),
("10391","660","916405","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/09/Dual-Diploma-4-800x1200.png"),
("10483","2","820022","post","<strong>programme Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/le-programme/"),
("10484","187","820022","post","<strong>test de niveau d’anglais</strong>","link","post_content","","https://dualdiploma.org/documentation/"),
("10485","187","820022","post","<strong>test d’admission en anglais</strong>","link","post_content","","https://dualdiploma.org/documentation/"),
("10486","2","820022","post"," <strong>Anglais &amp; Art de la Langue</strong>","link","post_content","","https://dualdiploma.org/le-programme/"),
("10487","2","820022","post","<strong>Anglais I</strong>","link","post_content","","https://dualdiploma.org/le-programme/"),
("10488","2","820022","post","<strong>Anglais III</strong>","link","post_content","","https://dualdiploma.org/le-programme/"),
("10489","2","820022","post","<strong>Anglais V</strong>","link","post_content","","https://dualdiploma.org/le-programme/"),
("10490","187","820022","post","<strong>test de niveau d’anglais</strong>","link","post_content","","https://dualdiploma.org/documentation/"),
("10491","2","820022","post","<strong>Anglais &amp; Art de la Langue</strong>","link","post_content","","https://dualdiploma.org/le-programme/"),
("10492","2","820022","post","<strong>Anglais I à Anglais V</strong>","link","post_content","","https://dualdiploma.org/le-programme/"),
("10493","88","820022","post","<strong>programme Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("10494","2","820022","post"," <strong>test anglais niveau</strong>","link","post_content","","https://dualdiploma.org/le-programme/"),
("10495","662","820022","post","<strong>Cadre européen commun de référence pour les langues </strong>","link","post_content","","https://www.service-public.fr/particuliers/vosdroits/F34739"),
("10496","662","820022","post","<strong>niveau A1</strong>","link","post_content","","https://www.service-public.fr/particuliers/vosdroits/F34739"),
("10497","2","820022","post","<strong>Anglais I à Anglais V</strong>","link","post_content","","https://dualdiploma.org/le-programme/"),
("10498","663","820022","post","<strong>TOEFL</strong>","link","post_content","","https://www.etsglobal.org/mq/fr/test-type-family/test-toefl-ibt"),
("10499","664","820022","post","<strong>IELTS</strong>","link","post_content","","https://ielts.org/"),
("10500","665","820022","post","<strong>TOEIC</strong>","link","post_content","","https://www.etsglobal.org/fr/fr"),
("10501","88","820022","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("10502","666","820022","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/image-800x541.png"),
("10503","667","820022","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/08/cheerful-young-graphic-designer-lady-using-digital-graphic-tablet-while-working-late-modern-office-night-asia-professional-female-using-laptop-computer-retoucher-sitting-living-room-home-800x450.jpg"),
("10504","668","820022","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/image-1-800x534.png"),
("11915","683","995256","post","<em>Times Higher Education World University Ranking</em> (THE).","link","post_content","","https://www.timeshighereducation.com/world-university-rankings/latest/world-ranking"),
("11916","88","995256","post","<strong>Academica Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("11917","684","995256","post","méthodologie officielle du THE 2026","link","post_content","","https://www.timeshighereducation.com/world-university-rankings/methodology"),
("11918","685","995256","post","<strong>University of Oxford</strong>","link","post_content","","https://www.ox.ac.uk/"),
("11919","686","995256","post","<strong>Massachusetts Institute of Technology (MIT)</strong>","link","post_content","","https://www.mit.edu/"),
("11920","687","995256","post","<strong>Princeton</strong>","link","post_content","","https://www.princeton.edu/"),
("11921","688","995256","post","<strong>Cambridge</strong>","link","post_content","","https://www.cam.ac.uk/"),
("11922","689","995256","post","<strong>Harvard</strong>","link","post_content","","https://www.harvard.edu/"),
("11923","690","995256","post","<strong>Stanford</strong>","link","post_content","","https://www.stanford.edu/"),
("11924","686","995256","post","<strong>MIT</strong>","link","post_content","","https://www.mit.edu/"),
("11925","685","995256","post","<strong>Oxford</strong>","link","post_content","","https://www.ox.ac.uk/"),
("11926","686","995256","post","<strong>MIT</strong>","link","post_content","","https://www.mit.edu/"),
("11927","687","995256","post","<strong>Princeton</strong>","link","post_content","","https://www.princeton.edu/"),
("11928","688","995256","post","<strong>Cambridge</strong>","link","post_content","","https://www.cam.ac.uk/"),
("11929","691","995256","post","<strong>Tsinghua University</strong>","link","post_content","","https://www.tsinghua.edu.cn/en/"),
("11930","692","995256","post","<strong>recherche d’une qualité exceptionnelle</strong> (97,7 / 100)","link","post_content","","https://www.timeshighereducation.com/world-university-rankings/university-oxford"),
("11931","693","995256","post","<strong>PSL (Paris Sciences et Lettres)</strong>","link","post_content","","https://psl.eu/"),
("11932","694","995256","post","48ᵉ","link","post_content","","https://www.timeshighereducation.com/world-university-rankings/paris-sciences-et-lettres-psl-research-university-paris"),
("11933","695","995256","post","<strong>Institut Polytechnique de Paris</strong>","link","post_content","","https://www.ip-paris.fr/"),
("11934","696","995256","post","68<sup>e</sup>","link","post_content","","https://www.timeshighereducation.com/world-university-rankings/institut-polytechnique-de-paris"),
("11935","697","995256","post","<strong>Université Paris-Saclay</strong>","link","post_content","","https://www.universite-paris-saclay.fr/"),
("11936","698","995256","post","68ᵉ","link","post_content","","https://www.timeshighereducation.com/world-university-rankings/universite-paris-saclay"),
("11937","699","995256","post","<strong>Sorbonne Université</strong>","link","post_content","","https://www.sorbonne-universite.fr/"),
("11938","700","995256","post","76ᵉ","link","post_content","","https://www.timeshighereducation.com/world-university-rankings/sorbonne-university"),
("11939","701","995256","post","cla","link","post_content","","https://www.timeshighereducation.com/press-releases/world-university-rankings-2026-out-now"),
("11940","701","995256","post","ssement THE 2026","link","post_content","","https://www.timeshighereducation.com/press-releases/world-university-rankings-2026-out-now"),
("11941","714","995256","post","3ᵉ place ex aequo","link","post_content","","https://www.timeshighereducation.com/world-university-rankings/princeton-university"),
("11942","715","995256","post","5ᵉ","link","post_content","","https://www.timeshighereducation.com/world-university-rankings/harvard-university"),
("11943","716","995256","post","20ᵉ","link","post_content","","https://www.timeshighereducation.com/world-university-rankings/columbia-university"),
("11944","702","995256","post","<strong>coût élevé des études</strong> américaines","link","post_content","","https://www.securemyscholarship.com/blog/cost-of-studying-in-the-us"),
("11945","703","995256","post","communiqué officiel de THE","link","post_content","","https://www.timeshighereducation.com/press-releases/world-university-rankings-2026-out-now?"),
("11946","704","995256","post","<strong>42 % des universités américaines</strong>","link","post_content","","https://www.timeshighereducation.com/news/us-universities-international-recruitment-back-reverse?"),
("11947","691","995256","post","Tsinghua University (12ᵉ)","link","post_content","","https://www.tsinghua.edu.cn/en/"),
("11948","705","995256","post","Peking University (13ᵉ)","link","post_content","","https://english.pku.edu.cn/"),
("11949","706","995256","post","National University of Singapore (17ᵉ)","link","post_content","","https://nus.edu.sg/"),
("11950","707","995256","post","<em>Times Higher Education (THE)</em>","link","post_content","","https://www.timeshighereducation.com/world-university-rankings/latest/world-ranking?"),
("11951","708","995256","post","<em>QS World University Rankings</em>","link","post_content","","https://www.topuniversities.com/world-university-rankings"),
("11952","709","995256","post","<em>Shanghai Ranking</em>","link","post_content","","https://www.shanghairanking.com/rankings"),
("11953","717","995256","post","Erasmus","link","post_content","","https://info.erasmusplus.fr/"),
("11954","262","995256","post","Je découvre le Dual Diploma","link","post_content","","https://dualdiploma.org"),
("11955","684","995256","post","Times Higher Education – World University Rankings 2026: Methodology Explained","link","post_content","","https://www.timeshighereducation.com/world-university-rankings/methodology"),
("11956","683","995256","post","Times Higher Education – World University Rankings 2026: Full Results","link","post_content","","https://www.timeshighereducation.com/world-university-rankings/latest/world-ranking"),
("11957","701","995256","post","Times Higher Education – Press Release: World University Rankings 2026 Out Now","link","post_content","","https://www.timeshighereducation.com/press-releases/world-university-rankings-2026-out-now"),
("11958","711","995256","post","Times Higher Education – US Universities’ International Recruitment Back in Reverse","link","post_content","","https://www.timeshighereducation.com/news/us-universities-international-recruitment-back-reverse"),
("11959","702","995256","post","SecureMyScholarship – The Cost of Studying in the US","link","post_content","","https://www.securemyscholarship.com/blog/cost-of-studying-in-the-us"),
("11960","708","995256","post","QS World University Rankings 2025 – Official Ranking","link","post_content","","https://www.topuniversities.com/world-university-rankings"),
("11961","709","995256","post","Shanghai Ranking (ARWU) 2025 – Global Ranking of Academic Subjects","link","post_content","","https://www.shanghairanking.com/rankings"),
("11962","713","995256","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/image-2-800x450.png"),
("11963","712","995256","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/image-3-800x837.png"),
("11964","23","709010","post"," programme Academica Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("11965","9","709010","post","Academica International Studies","link","post_content","","https://ais.academica.org/"),
("11966","622","709010","post"," Lycée Notre-Dame De La Merci à Montpellier","link","post_content","","https://www.lamerci.com/"),
("11967","623","709010","post","Turning of the Tassel","link","post_content","","https://www.graduationsource.com/blog/why-we-turn-tassel#:~:text=Why%20Do%20We%20Turn%20The,confirming%20your%20newfound%20graduate%20status."),
("11968","624","709010","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09937-800x450.jpg"),
("11969","625","709010","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09610-800x450.jpg"),
("11970","626","709010","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/07/DSC00229-800x450.jpg"),
("11971","627","709010","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09692-800x450.jpg"),
("11972","628","709010","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09891-1-800x450.jpg"),
("11973","629","709010","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09794-800x450.jpg"),
("11974","630","709010","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09828-800x450.jpg"),
("11975","631","709010","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09848-800x450.jpg"),
("11976","9","512025","post","Academica International Studies","link","post_content","","https://ais.academica.org/"),
("11977","23","512025","post","<strong>Dual Diploma Program™</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("11978","23","512025","post","High School Diploma américain","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("13961","23","1078370","post","<strong>Academica Dual Diploma™</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("13962","768","1078370","post","<strong>curriculum vitae</strong>","link","post_content","","https://dualdiploma.org/blog/competitif-international-importance-cv-anglais/"),
("13963","88","1078370","post","<strong>Academica Dual Diploma™</strong>","link","post_content","","https://dualdiploma.org/"),
("13964","66","1078370","post","Je m’inscris au webinaire","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("13965","48","1078370","post"," <strong>Vérifiez ici</strong>","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("13966","769","1078370","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/image-2-800x533.jpeg"),
("13967","770","1078370","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/image-3-800x566.jpeg"),
("13968","771","1078567","post","<strong>système scolaire américain</strong>","link","post_content","","https://dualdiploma.org/blog/comment-le-bac-americain-prepare-les-eleves-aux-etudes-internationales/"),
("13969","537","1078567","post","<strong>pédagogie</strong>","link","post_content","","https://dualdiploma.org/blog/differences-et-complementarites-des-pedagogies-francaise-et-americaine/"),
("13970","772","1078567","post","<strong>élève du programme Academica Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/blog/student-of-the-month-academica-dual-diploma-2025/"),
("13971","470","1078567","post","<strong>High School Diploma</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#diplome"),
("13972","88","1078567","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/"),
("13973","48","1078567","post","<strong>Vérifiez ici</strong>","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("13974","773","1078567","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/image-4-800x534.jpeg"),
("13975","774","1078567","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/image-5-800x534.jpeg"),
("13976","775","1078567","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/image-6-800x456.jpeg"),
("14096","23","14132","page","Découvrez le Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("14097","24","14132","page","Academica aux USA et dans le monde","link","post_content","","https://dualdiploma.org/le-groupe-academica/"),
("14098","9","14132","page","Academica International Studies","link","post_content","","https://ais.academica.org/"),
("14099","56","14132","page","groupes, activités collectives avec les live sessions, activités parascolaires (guest speaker, clubs) intégrées à la vie scolaire","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#experience"),
("14100","26","14132","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-innovation-mockup.webp"),
("14101","27","14132","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-innovation-mockup2.webp"),
("14159","601","14153","page","Prenez rendez-vous","link","post_content","","https://dualdiploma.zohobookings.eu/#/91739000003279130"),
("14160","23","14153","page","programme Academica Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("14161","23","14153","page","Le Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("14162","56","14153","page","Cérémonie de graduation","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#experience"),
("14163","57","14153","page","pédagogie digitale","link","post_content","","https://dualdiploma.org/linnovation-pedagogique/"),
("14164","2","14153","page","Le programme","link","post_content","","https://dualdiploma.org/le-programme/"),
("14165","57","14153","page","Pédagogie différenciée et inversée","link","post_content","","https://dualdiploma.org/linnovation-pedagogique/"),
("14166","9","14153","page","Academica International Studies","link","post_content","","https://ais.academica.org/"),
("14167","46","14153","page","professeurs américains","link","post_content","","https://dualdiploma.org/les-professeurs-americains/"),
("14168","58","14153","page","program director","link","post_content","","https://dualdiploma.org/le-professeur-referent-program-director/"),
("14169","28","14153","page","Contactez-nous","link","post_content","","https://dualdiploma.org/contact/"),
("14170","601","14153","page","Prenez rendez-vous","link","post_content","","https://dualdiploma.zohobookings.eu/#/91739000003279130"),
("14171","526","14153","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/17-1.png"),
("14172","523","14153","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/8.png"),
("14173","524","14153","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/11.png"),
("14174","54","14153","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-cursus.webp"),
("14175","525","14153","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/14.png"),
("14176","63","14153","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-professeur.webp"),
("14177","22","14153","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-partenariats.webp"),
("14178","64","14153","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/06/temoignage-ce.png"),
("14179","66","14155","page","Assister au webinaire","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("14180","68","14155","page","Pour plus de détails","link","post_content","","https://dualdiploma.org/le-programme/#art-history"),
("14181","69","14155","page","Pour plus de détails","link","post_content","","https://dualdiploma.org/le-programme/#computer-science"),
("14182","70","14155","page","Pour plus de détails","link","post_content","","https://dualdiploma.org/le-programme/#computer-scienceprinciples"),
("14183","71","14155","page","Pour plus de détails","link","post_content","","https://dualdiploma.org/le-programme/#environmental-science"),
("14184","72","14155","page","Pour plus de détails","link","post_content","","https://dualdiploma.org/le-programme/#european-history"),
("14185","73","14155","page","Pour plus de détails","link","post_content","","https://dualdiploma.org/le-programme/#english-composition"),
("14186","74","14155","page","Pour plus de détails","link","post_content","","https://dualdiploma.org/le-programme/#entrepreneurship"),
("14187","75","14155","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-2.webp"),
("14188","76","14155","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-3.webp"),
("14189","41","14155","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-programme-mockup.webp"),
("14190","24","14156","page","Découvrez le groupe Academica","link","post_content","","https://dualdiploma.org/le-groupe-academica/"),
("14191","77","14156","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-4.webp"),
("14192","78","14156","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-USA.svg"),
("14193","79","14156","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-bilingue.svg"),
("14194","80","14156","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-scolaire.svg"),
("14195","81","14156","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-maturite.svg"),
("14196","82","14156","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/dual-diploma-Gina-Lalicata.png"),
("14197","520","14156","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/accueil-2.png"),
("14198","527","14156","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/16-1.png"),
("14199","24","14157","page","Découvrez le groupe Academica","link","post_content","","https://dualdiploma.org/le-groupe-academica/"),
("14200","23","14157","page","Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("14201","48","14157","page","établissements partenaire","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("14202","23","14157","page","Academica Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("14203","23","14157","page","Academica Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("14204","46","14157","page","la communauté éducative américaine","link","post_content","","https://dualdiploma.org/les-professeurs-americains/"),
("14205","85","14157","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-devenir_partenaire-VA.png"),
("14425","23","1143748","post","<strong>Dual Diploma</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("14426","23","1143748","post","<strong>cours américains</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("14427","56","1143748","post","<strong>culture américaine</strong>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/#experience"),
("14428","776","1143748","post","En savoir plus sur le programme Academica Dual Diploma™","link","post_content","","https://dualdiploma.org?utm_source=chatgpt.com"),
("14429","48","1143748","post"," <strong>Vérifiez ici</strong>","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("14430","777","1143748","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/image-800x533.jpeg"),
("14431","778","1143748","post","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/image-1-800x533.png"),
("14435","40","14149","page","Au programme du Dual Diploma","link","post_content","","https://dualdiploma.org/comment-ca-marche/"),
("14436","9","14149","page","Academica International Studies (AIS)","link","post_content","","https://ais.academica.org/"),
("14437","41","14149","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-programme-mockup.webp"),
("17651","66","15636","page","Je m\'inscris au webinaire de présentation","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("17652","136","17161","page","","link","post_content","","https://archives.dualdiploma.org/fichier/fichier-2/"),
("17653","637","17161","page","Master calendar 2025-2026","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/09/Master-Calendar-Dual-Diploma-2025-2026.pdf"),
("17654","638","17161","page","Kit du Program Director 2025-2026","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/09/Kit-Program-Director_25-26_compressed.pdf"),
("17655","639","17161","page","Program Director Handbook 2025-2026","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/09/AIS-Program-Director-Handbook-2025-2026.pdf"),
("17656","652","17161","page","Mémo de rentrée 2025-2026","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/09/Memo-de-rentree-Program-Director-25-26.pdf"),
("17657","640","17161","page","Formulaire de désistement (drop)","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/09/Formulaire-de-desistement-2025-2026.pdf"),
("17658","820","17161","page","Formulaire de changement d\'établissement (transfert)","link","post_content","","https://dualdiploma.org/wp-content/uploads/2026/01/Lien-Formulaire-Transfert.pdf"),
("17659","143","17161","page","Demande de Transcript/Certificat d\'inscription","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/10/Demande-de-Transcript-ou-de-Certificat-dinscription.pdf"),
("17660","678","17161","page","Attestaton à joindre  au Transcript (pour les Terminales)","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/AIS-Dual-Diploma-Program-Certficate-of-Participation-2026.pdf"),
("17661","673","17161","page","Guide AVE SIS - Colegia","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/Tuto-AVE-SIS-Colegia_Program-director_25-26.pdf"),
("17662","672","17161","page","Informations Plagiat et \"Academic Integrity Policies\"","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/Informations-Plagiat-et-Academic-Integrity-Policies.pdf"),
("17663","680","17161","page","Calendrier et consignes pour le dépôt des bulletins","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/Collecte_bulletins_Academica_2025-10-20.pdf"),
("17664","654","17161","page","Enregistrement du Webinaire de rentrée 2025","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/09/Lien-Webinaire-de-rentree-25-26-USA.pdf"),
("17665","147","17161","page","Présentation du Webinaire de rentrée 2025","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/08/Comment-classer-automatiquement-vos-emails.pdf"),
("17666","136","17161","page","","link","post_content","","https://archives.dualdiploma.org/fichier/fichier-2/"),
("17667","147","17161","page","Guide pour classer vos emails automatiquement","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/08/Comment-classer-automatiquement-vos-emails.pdf"),
("17668","674","17161","page","Master Calendar JUMPSTART 25-26","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/AIS-Dual-Diploma-Master-Calendar-2025-26-Jumpstart.pdf"),
("17669","152","17161","page","Comprendre le programme Jumpstart","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/10/Comprendre-le-programme-Jumpstart.pdf"),
("17670","675","17161","page","Programme Jumpstart 25-26","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/Programme-Jumpstart-2025-26.pdf"),
("17671","676","17161","page","Présentation complète du programme Jumpstart 25-26","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/Dual-Diploma-Academica-2025-26-Jumpstart-EP.pdf"),
("17672","677","17161","page","Mémo rentrée Jumpstart 25-26 pour les parents AVANT le test","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/FAQ-de-rentree-PARENTS-Jumpstart-Avant-le-Test-25-26.pdf"),
("17673","473","17161","page","Mémo rentrée Jumpstart 24-25 pour les parents APRES le test","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/01/FAQ-de-rentree-Jumpstart-24-25-Parents-Apres-le-Test.pdf"),
("17674","681","17161","page","Candidatures au Competitive College Club (CCC) 2025-26","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/Informations-Competitive-College-Club-CCC-2025-26-1.pdf"),
("17675","682","17161","page","Informations pour les candidatures aux USA","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/Etudier-aux-Etats-Unis_25-26.pdf"),
("17676","499","17161","page","Electives avancées 2025-26","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/Advanced-Electives-for-2025-26.pdf"),
("17677","157","17161","page","Affichettes QR codes","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/08/Affichettes-plaquette-video.pdf"),
("17678","136","17161","page","","link","post_content","","https://archives.dualdiploma.org/fichier/fichier-2/"),
("17679","158","17161","page","Note sur le passage des élèves en «&nbsp;Inactive&nbsp;» dans Maestro","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/08/23.Note-sur-le-statut-Inactive-des-eleves-en-fin-dannee-sur-Maestro.pdf"),
("17740","66","1145544","page","Je m\'inscris au webinaire de présentation","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("17878","66","14271","page","Assister au webinaire","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("18017","824","14231","page","Conseils pour<br>le test","link","post_content","","https://dualdiploma.org/wp-content/uploads/2026/01/Conseils-pour-le-test-dadmission.pdf"),
("18018","822","14231","page","Calendrier","link","post_content","","https://dualdiploma.org/wp-content/uploads/2026/01/Calendrier-Dual-Diploma-Program-FR-1.pdf"),
("18019","611","14231","page","Cursus des<br>cours","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/05/Cursus-Cours-2025-2026.pdf"),
("18020","612","14231","page","Course<br>catalogue (EN)","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/05/AIS-Dual-Diploma-Course-Catalog-2025-2026_AP.pdf"),
("18021","826","14231","page","Electives (FR)","link","post_content","","https://dualdiploma.org/wp-content/uploads/2026/01/Electives-FR.pdf"),
("18022","827","14231","page","<strong>Electives (EN)</strong>","link","post_content","","https://dualdiploma.org/wp-content/uploads/2026/01/Elective-EN.pdf"),
("18023","830","14231","page","Manuel<br>Parents-Elèves","link","post_content","","https://dualdiploma.org/wp-content/uploads/2026/01/StudentParentHandbook-2026-2027-Dual-Diploma-EN.pdf"),
("18024","830","14231","page","Students-Parents<br>Handbook (EN)","link","post_content","","https://dualdiploma.org/wp-content/uploads/2026/01/StudentParentHandbook-2026-2027-Dual-Diploma-EN.pdf"),
("18025","88","14231","page","Academica Dual Diploma™","link","post_content","","https://dualdiploma.org/"),
("18026","116","14231","page","consulter notre FAQ","link","post_content","","https://dualdiploma.org/foire-aux-questions/"),
("18027","28","14231","page","nous contacter","link","post_content","","https://dualdiploma.org/contact/"),
("18028","28","14231","page","Contactez-nous","link","post_content","","https://dualdiploma.org/contact/"),
("18029","4","14231","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA.webp"),
("19851","48","17262","page","Etablissements partenaires","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("19852","88","17262","page","https://dualdiploma.org/","link","post_content","","https://dualdiploma.org/"),
("19853","832","17262","page","Planifier un échange","link","post_content","","https://dualdiploma.zohobookings.eu/#/91739000004281086"),
("19854","737","17262","page","Vidéo de présentation du programme","link","post_content","","#video"),
("19855","738","17262","page","Logos","link","post_content","","#logos"),
("19856","739","17262","page","Charte graphique","link","post_content","","#couleurs-officielles"),
("19857","740","17262","page","Brochure","link","post_content","","#brochure-journees-portes-ouvertes"),
("19858","748","17262","page","Flyer","link","post_content","","#flyer-dual-diploma"),
("19859","741","17262","page","Affichettes portes ouvertes","link","post_content","","#affichette-portes-ouvertes"),
("19860","744","17262","page","Visuels site internet","link","post_content","","#visuels-site-internet"),
("19861","745","17262","page","Visuels réseaux sociaux","link","post_content","","#visuels-reseaux-sociaux"),
("19862","825","17262","page","Visuels webinaire de présentation aux familles","link","post_content","","https://visuels-de-presentation-aux-familles"),
("19863","746","17262","page","Visuels de présentation aux familles","link","post_content","","#visuels-de-presentation-aux-familles"),
("19864","742","17262","page","Contenu pour votre site internet","link","post_content","","#contenu-pour-votre-site-internet"),
("19865","743","17262","page","Liens utiles","link","post_content","","#liens-utiles"),
("19866","747","17262","page","Liste de hashtags","link","post_content","","#liste-de-hashtags"),
("19867","174","17262","page","Accéder à notre chaîne YouTube","link","post_content","","https://www.youtube.com/@DualDiploma"),
("19868","175","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Logo-Dual-Diploma-Transparent-1-2.png"),
("19869","569","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/Logo-Dual-Diploma-2-1.png"),
("19870","568","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/dd-logo-carre-vert.png"),
("19871","570","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/dd-logo-carre-blanc.png"),
("19872","734","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/Icone-DD-blanc-scaled.png"),
("19873","735","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/American-High-School-Authorized.png"),
("19874","779","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Brochure-familles-Dual-Diploma.pdf"),
("19875","614","17262","page","Canva","link","post_content","","https://www.canva.com/fr_fr/free/"),
("19876","608","17262","page","<strong>com@dualdiploma.org</strong>","link","post_content","","mailto:com@dualdiploma.org"),
("19877","615","17262","page","Accéder au template Canva","link","post_content","","https://www.canva.com/design/DAGp3sTX-HA/6LVutxSXMKeBLgZi9eaDgg/view?utm_content=DAGp3sTX-HA&utm_campaign=designshare&utm_medium=link&utm_source=publishsharelink&mode=preview"),
("19878","806","17262","page","Télécharger le flyer (sans personnalisation)","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Flyer-Familles.pdf"),
("19879","781","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Affiches-QR-Code.pdf"),
("19880","783","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-3-edited.png"),
("19881","784","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-7.png"),
("19882","785","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-2.png"),
("19883","786","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-8.png"),
("19884","787","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-6.png"),
("19885","788","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-5.png"),
("19886","789","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-12.png"),
("19887","790","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-4.png"),
("19888","798","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-10.png"),
("19889","799","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-9.png"),
("19890","800","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-13.png"),
("19891","801","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-20-scaled.jpg"),
("19892","802","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-15.png"),
("19893","803","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-16.png"),
("19894","804","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-17.png"),
("19895","805","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-18.png"),
("19896","197","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/0.jpg"),
("19897","198","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Dual-Diploma.png"),
("19898","817","17262","page","Canva","link","post_content","","https://www.canva.com/fr_fr/free"),
("19899","608","17262","page","<strong>com@dualdiploma.org</strong>","link","post_content","","mailto:com@dualdiploma.org"),
("19900","602","17262","page","Accéder au template Canva","link","post_content","","https://www.canva.com/design/DAGmBI3Z_sg/OKGG7bddiBEK-St6BRfFog/view?utm_content=DAGmBI3Z_sg&utm_campaign=designshare&utm_medium=link&utm_source=publishsharelink&mode=preview"),
("19901","199","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-3.jpg"),
("19902","200","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-2.jpg"),
("19903","201","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-1.jpg"),
("19904","202","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-5.jpg"),
("19905","203","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-4.jpg"),
("19906","204","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-3.jpg"),
("19907","205","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3.jpg"),
("19908","206","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-6.jpg"),
("19909","207","17262","page","Télécharger","link","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-7.jpg"),
("19910","819","17262","page","«&nbsp;Electives&nbsp;»","link","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Decouvrir-les-Electives.pdf"),
("19911","88","17262","page","Site Academica Dual Diploma™","link","post_content","","https://dualdiploma.org/"),
("19912","187","17262","page","Documents à télécharger","link","post_content","","https://dualdiploma.org/documentation/"),
("19913","116","17262","page","FAQ","link","post_content","","https://dualdiploma.org/foire-aux-questions/"),
("19914","9","17262","page","Site Academica International Studies (AIS)","link","post_content","","https://ais.academica.org/"),
("19915","763","17262","page","Instagram <a href=\"https://dualdiploma.org/\" target=\"_blank\" rel=\"noreferrer noopener\">Academica Dual Diploma™","link","post_content","","https://www.instagram.com/ledualdiploma/"),
("19916","764","17262","page","Facebook <a href=\"https://dualdiploma.org/\" target=\"_blank\" rel=\"noreferrer noopener\">Academica Dual Diploma™","link","post_content","","https://www.facebook.com/ledualdiploma/"),
("19917","765","17262","page","LinkedIn <a href=\"https://dualdiploma.org/\" target=\"_blank\" rel=\"noreferrer noopener\">Academica Dual Diploma™","link","post_content","","https://www.linkedin.com/school/dualdiploma/"),
("19918","766","17262","page","TikTok <a href=\"https://dualdiploma.org/\" target=\"_blank\" rel=\"noreferrer noopener\">Academica Dual Diploma™","link","post_content","","https://www.tiktok.com/@dualdiploma"),
("19919","174","17262","page","YouTube <a href=\"https://dualdiploma.org/\" target=\"_blank\" rel=\"noreferrer noopener\">Academica Dual Diploma™","link","post_content","","https://www.youtube.com/@DualDiploma"),
("19920","86","17262","page","Groupe LinkedIn Alumni","link","post_content","","https://www.linkedin.com/groups/9096949/"),
("19921","767","17262","page","YouTube Academica","link","post_content","","https://www.youtube.com/@academica5312"),
("19922","91","17262","page","Page Alumni","link","post_content","","https://dualdiploma.org/alumni/"),
("19923","835","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Accompagnement-personnalise-Guide-de-communication.png"),
("19924","571","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/Logo-Dual-Diploma-1-1.png"),
("19925","569","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/Logo-Dual-Diploma-2-1.png"),
("19926","568","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/dd-logo-carre-vert.png"),
("19927","570","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/dd-logo-carre-blanc.png"),
("19928","734","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/Icone-DD-blanc-scaled.png"),
("19929","735","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/American-High-School-Authorized.png"),
("19930","210","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/ais-1.4.brand-colors-800x359.jpg"),
("19931","780","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Brochure-familles.png"),
("19932","815","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Flyer-familles.png"),
("19933","782","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Affichettes-qr-code-2.png"),
("19934","783","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-3-edited.png"),
("19935","791","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-7-edited-1.png"),
("19936","792","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-2-edited.png"),
("19937","793","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-8-edited.png"),
("19938","794","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-6-edited.png"),
("19939","795","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-5-edited.png"),
("19940","796","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-12-edited.png"),
("19941","797","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-4-edited.png"),
("19942","807","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-10-edited.png"),
("19943","808","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-9-edited.png"),
("19944","809","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-13-edited.png"),
("19945","810","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-20-edited-scaled.jpg"),
("19946","811","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-15-edited-1.png"),
("19947","812","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-16-edited.png"),
("19948","813","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-17-edited.png"),
("19949","814","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/12/Dual-Diploma-18-edited.png"),
("19950","197","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/0.jpg"),
("19951","198","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Dual-Diploma.png"),
("19952","607","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/05/Carrousel-instagram-p3-2.png"),
("19953","606","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/Carrousel-instagram-p11-1.png"),
("19954","199","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-3.jpg"),
("19955","200","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-2.jpg"),
("19956","201","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-1.jpg"),
("19957","202","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-5.jpg"),
("19958","203","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-4.jpg"),
("19959","204","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-3.jpg"),
("19960","205","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3.jpg"),
("19961","206","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-6.jpg"),
("19962","207","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-7.jpg"),
("19963","751","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/1.png"),
("19964","752","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/2.png"),
("19965","753","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/3.png"),
("19966","754","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/4.png"),
("19967","755","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/5.png"),
("19968","756","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/6.png"),
("19969","757","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/7.png"),
("19970","758","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/8.png"),
("19971","759","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/10.png"),
("19972","760","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/11.png"),
("19973","761","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/12-1.png"),
("19974","762","17262","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/13.png"),
("20008","66","14154","page","Assister au webinaire","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("20009","67","14154","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-1.webp"),
("20059","86","14158","page","Rester en contact","link","post_content","","https://www.linkedin.com/groups/9096949/"),
("20060","679","14158","page","Voir la cérémonie complète","link","post_content","","https://youtu.be/6v4azt3gRkM?si=8FuVZac-yC6F8O7e"),
("20061","23","14158","page","le Dual Diploma Program","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("20062","87","14158","page","Valorisation Post-Bac","link","post_content","","https://dualdiploma.org/valorisation-post-bac/"),
("20063","23","14158","page","Academica Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("20064","88","14158","page","Academica","link","post_content","","https://dualdiploma.org/"),
("20065","40","14158","page","les Live Sessions","link","post_content","","https://dualdiploma.org/comment-ca-marche/"),
("20066","23","14158","page","Le Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("20067","86","14158","page","Rejoindre le groupe des alumni","link","post_content","","https://www.linkedin.com/groups/9096949/"),
("20068","528","14158","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/18-1.png"),
("20069","4","14158","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA.webp"),
("20120","601","14159","page","Prenez rendez-vous","link","post_content","","https://dualdiploma.zohobookings.eu/#/91739000003279130"),
("20121","90","14159","page","Devenez partenaire","link","post_content","","https://dualdiploma.org/devenir-partenaire/"),
("20122","48","14159","page","Nos établissements partenaires","link","post_content","","https://dualdiploma.org/etablissement-partenaire/");

INSERT IGNORE INTO `da_blc_instances` VALUES 
("20123","91","14159","page","Que sont-ils devenus ?","link","post_content","","https://dualdiploma.org/alumni/"),
("20124","23","14159","page","Découvrez le Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("20125","48","14159","page","Découvrez la carte","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("20126","601","14159","page","Planifier un échange","link","post_content","","https://dualdiploma.zohobookings.eu/#/91739000003279130"),
("20127","92","14159","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-mockup_DualDiploma.webp"),
("20128","93","14159","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-VA.svg"),
("20129","94","14159","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-cursus.svg"),
("20130","95","14159","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-cible.webp"),
("20131","96","14159","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-programme.svg"),
("20132","97","14159","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-humain.svg"),
("20133","98","14159","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-diplome.webp"),
("20134","99","14159","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-etablissement_partenaires.webp"),
("20165","106","14161","page","Rejoins l\'aventure","link","post_content","","#rdv"),
("20166","23","14161","page","Avec le Dual Diploma, pas besoin de prendre l’avion, tu voyages directement de chez toi !","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("20167","107","14161","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-eleve-americain.webp"),
("20168","566","14161","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/23.jpg"),
("20169","54","14161","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-cursus.webp"),
("20385","66","14160","page","Assistez au Webinaire de présentation","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("20386","8","14160","page","Découvrez Academica France","link","post_content","","https://dualdiploma.org/academica-france/"),
("20387","23","14160","page","Découvrez le Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("20388","57","14160","page","Explorez nos innovations pédagogiques signées Academica","link","post_content","","https://dualdiploma.org/linnovation-pedagogique/"),
("20389","8","14160","page","l’équipe Academica","link","post_content","","https://dualdiploma.org/academica-france/"),
("20390","46","14160","page","un professeur aux USA","link","post_content","","https://dualdiploma.org/les-professeurs-americains/"),
("20391","23","14160","page","le cursus du Dual Diploma","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("20392","57","14160","page","Découvrez l’innovation pédagogique Academica","link","post_content","","https://dualdiploma.org/linnovation-pedagogique/"),
("20393","48","14160","page","<img src=\"https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-parent-map_etablissement-2-800x174.webp\" alt=\"\" class=\"wp-image-14656\"/>","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("20394","3","14160","page","Tarifs","link","post_content","","https://dualdiploma.org/comment-ca-marche/#frais"),
("20395","44","14160","page","Admisssions","link","post_content","","https://dualdiploma.org/comment-ca-marche/#inscription"),
("20396","98","14160","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-diplome.webp"),
("20397","565","14160","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/22.png"),
("20398","103","14160","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-parent-programme.webp"),
("20399","104","14160","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-parent-map_etablissement-2-800x174.webp"),
("20400","105","14160","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-parent-admission.webp"),
("20461","66","14254","page","Assistez au webinaire","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("20462","823","14254","page"," Inscrivez-vous","link","post_content","","https://creatorapp.zohopublic.eu/dualdiploma/academica/form-perma/Formulaire_d_Inscription/gjKBt8EypwxuQr7FSPbjrp3KfNbGDVk1vYWsN7JrtB5JH75GP5GTdt3h5tH43hSRJADZQXEvS6vY8JnC3GHr1PkDySesMVggMXpq"),
("20463","831","14254","page","Inscription","link","post_content","","https://dualdiploma.org/inscription-2026-2027/"),
("20464","44","14254","page","S\'inscrire","link","post_content","","/comment-ca-marche/#inscription"),
("20465","3","14254","page","Tarifs","link","post_content","","/comment-ca-marche/#frais"),
("20466","117","14254","page","<img src=\"https://dualdiploma.org/wp-content/uploads/2025/02/20.png\" alt=\"\" class=\"wp-image-357394 size-full\"/>","link","post_content","","https://dualdiploma.org/high-school-diploma/"),
("20467","23","14254","page","<img src=\"https://dualdiploma.org/wp-content/uploads/2024/03/DD-home-visuel-programme_dual-diploma.webp\" alt=\"\" class=\"wp-image-14320 size-full\"/>","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("20468","118","14254","page","<img src=\"https://dualdiploma.org/wp-content/uploads/2025/02/19.png\" alt=\"\" class=\"wp-image-357393 size-full\"/>","link","post_content","","https://dualdiploma.org/cours-a-la-carte/"),
("20469","56","14254","page","Découvrez la vie scolaire","link","post_content","","/academica-dual-diploma/#experience"),
("20470","57","14254","page","Découvrez notre pédagogie innovante","link","post_content","","https://dualdiploma.org/linnovation-pedagogique/"),
("20471","119","14254","page","Vous êtes un élève ?","link","post_content","","https://dualdiploma.org/eleve/"),
("20472","48","14254","page","Nos établissements partenaires","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("20473","87","14254","page","Que sont-ils devenus ?","link","post_content","","https://dualdiploma.org/valorisation-post-bac/"),
("20474","58","14254","page","Qui sont-ils ?","link","post_content","","https://dualdiploma.org/le-professeur-referent-program-director/"),
("20475","8","14254","page","Qui sommes-nous ?","link","post_content","","https://dualdiploma.org/academica-france/"),
("20476","48","14254","page","Établissements partenaires","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("20477","66","14254","page","Assistez au Webinaire <img class=\"wp-image-14501\" style=\"width: NaNpx;\" src=\"https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-webinaire_red.svg\" alt=\"\">","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("20478","23","14254","page","En savoir plus","link","post_content","","https://dualdiploma.org/academica-dual-diploma/"),
("20479","121","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/Academica-Dual-Diploma-High-School.webp"),
("20480","529","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/20.png"),
("20481","123","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-home-visuel-programme_dual-diploma.webp"),
("20482","530","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/19.png"),
("20483","719","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/accueil-6-2.png"),
("20484","519","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/Images-site-internet.png"),
("20485","527","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/16-1.png"),
("20486","720","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/accueil-5-1.png"),
("20487","721","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/11/accueil-7-1.png"),
("20488","127","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-etablissement.svg"),
("20489","128","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-eleves.svg"),
("20490","564","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/03/accueil-4-1.png"),
("20491","521","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/02/logo_academica-dual-diploma-blanc.png"),
("20492","130","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-diplome.svg"),
("20493","131","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-professeurs-1.svg"),
("20494","132","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/Le-double-diplome-du-bac-americain-en-immersion-virtuelle-2.png"),
("20495","133","14254","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-webinaire_red.svg"),
("20528","24","14133","page","Découvrez le groupe Academica","link","post_content","","https://dualdiploma.org/le-groupe-academica/"),
("20529","28","14133","page","Rejoignez-nous !","link","post_content","","https://dualdiploma.org/contact/"),
("20530","590","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/Site-Page-equipe-1.png"),
("20531","573","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-005-e1744360456826.jpg"),
("20532","574","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-015-e1744360591735.jpg"),
("20533","575","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-012-e1744360625182.jpg"),
("20534","576","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-025-e1744360809551.jpg"),
("20535","577","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-009-1-e1744361908394.jpg"),
("20536","578","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-002-e1744362093608.jpg"),
("20537","579","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-006-e1744362331153.jpg"),
("20538","580","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-007-e1744362432503.jpg"),
("20539","670","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/Louis-Vieville-2-4.png"),
("20540","582","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-011-e1744360992225.jpg"),
("20541","583","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-010-e1744362857518.jpg"),
("20542","584","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-013-e1744362919450.jpg"),
("20543","585","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-001-e1744363047157.jpg"),
("20544","586","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-019-e1744363101232.jpg"),
("20545","587","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-020-e1744363432714.jpg"),
("20546","588","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-014-e1744363568759.jpg"),
("20547","671","14133","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2025/10/AGUIRAR-Imane-2-2.png"),
("20548","8","14131","page","Découvrez l’équipe française","link","post_content","","https://dualdiploma.org/academica-france/"),
("20549","9","14131","page","Tout savoir sur Academica","link","post_content","","https://ais.academica.org/"),
("20550","8","14131","page","Découvrez l’équipe française !","link","post_content","","https://dualdiploma.org/academica-france/"),
("20551","10","14131","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-devenir_partenaire-VA-1.png"),
("20552","11","14131","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme-1.webp"),
("20553","12","14131","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/visuel-le-groupe-academica.png"),
("20554","13","14131","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-florida.webp"),
("20555","14","14131","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-fulbright.webp"),
("20556","15","14131","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-aefe.webp"),
("20557","16","14131","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-AP.webp"),
("20558","17","14131","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-cognia.webp"),
("20559","18","14131","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-US.webp"),
("20560","19","14131","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-USA.webp"),
("20561","20","14131","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-florida2.webp"),
("20562","21","14131","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-resident_e.webp"),
("20563","22","14131","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-partenariats.webp"),
("20573","66","14126","page","Assistez au Webinaire","link","post_content","","https://dualdiploma.org/webinaire-eleve-individuel/"),
("20574","2","14126","page","Découvrir le programme détaillé","link","post_content","","https://dualdiploma.org/le-programme/"),
("20575","3","14126","page","Tarif","link","post_content","","/comment-ca-marche/#frais"),
("20576","3","14126","page","Tarif","link","post_content","","/comment-ca-marche/#frais"),
("20577","3","14126","page","Tarif","link","post_content","","/comment-ca-marche/#frais"),
("20578","4","14126","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA.webp"),
("20579","5","14126","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme.webp"),
("20580","6","14126","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme2.webp"),
("20581","7","14126","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme3.webp"),
("20624","42","14150","page","Assistez au webinaire","link","post_content","","#rdv"),
("20625","837","14150","page","Comment ça marche ? ","link","post_content","","#commentcamarche"),
("20626","44","14150","page","Les admissions","link","post_content","","#inscription"),
("20627","3","14150","page","Les tarifs","link","post_content","","#frais"),
("20628","45","14150","page","Questions fréquentes","link","post_content","","#faq"),
("20629","46","14150","page","Ils sont disponibles tous les jours","link","post_content","","https://dualdiploma.org/les-professeurs-americains/"),
("20630","497","14150","page","Inscrivez-vous","link","post_content","","https://creatorapp.zohopublic.eu/dualdiploma/inscription-webinaire/form-perma/Formulaire_d_Inscription/bEnsq9ZCzuSW4PE74SEwOUa11hj3aYegDPJGbxngq5U0VmfNsKH52wDyxpO5qnG0OjhSwDWGz3rvxVnTNXDEU1BZpkqts0RWtmng"),
("20631","48","14150","page","Contactez votre établissement","link","post_content","","https://dualdiploma.org/etablissement-partenaire/"),
("20632","49","14150","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-test-de-niveau-et-validation-de-l_inscription.webp"),
("20633","50","14150","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-echanges-reguliers-en-anglais.webp"),
("20634","51","14150","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-les-live-sessions.webp"),
("20635","52","14150","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-cours-de-renfort-en-anglais.webp"),
("20636","53","14150","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-echanges-quotidiens-avec-les-professeurs.webp"),
("20637","54","14150","page","","image","post_content","","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-cursus.webp");

INSERT IGNORE INTO `da_blc_links` VALUES 
("2","https://dualdiploma.org/le-programme/","0000-00-00 00:00:00","2026-02-01 04:51:13","2026-02-01 04:51:13","2026-02-01 04:51:13","0","https://dualdiploma.org/le-programme/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:51:19 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14149&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14149&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /le-programme/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.245194","0","0","0","1","0","200|0|0|https://dualdiploma.org/le-programme/","0","0"),
("3","https://dualdiploma.org/comment-ca-marche/#frais","0000-00-00 00:00:00","2026-02-01 04:52:59","2026-02-01 04:52:59","2026-02-01 04:52:59","0","https://dualdiploma.org/comment-ca-marche/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:53:04 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14150&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14150&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /comment-ca-marche/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.243975","0","0","0","1","0","200|0|0|https://dualdiploma.org/comment-ca-marche/","0","0"),
("4","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA.webp","0000-00-00 00:00:00","2026-02-01 04:51:44","2026-02-01 04:51:44","2026-02-01 04:51:44","0","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:51:48 GMT\r\ncontent-type: image/webp\r\ncontent-length: 24234\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-5eaa&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.04017","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA.webp","0","0"),
("5","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme.webp","0000-00-00 00:00:00","2026-02-01 04:48:24","2026-02-01 04:48:24","2026-02-01 04:48:24","0","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:48:25 GMT\r\ncontent-type: image/webp\r\ncontent-length: 22438\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-57a6&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/DD-visuel-parent-programme.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.034142","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme.webp","0","0"),
("6","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme2.webp","0000-00-00 00:00:00","2026-02-01 04:48:39","2026-02-01 04:48:39","2026-02-01 04:48:39","0","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme2.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:48:44 GMT\r\ncontent-type: image/webp\r\ncontent-length: 23412\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-5b74&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/DD-visuel-parent-programme2.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.05203","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme2.webp","0","0"),
("7","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme3.webp","0000-00-00 00:00:00","2026-02-01 04:54:34","2026-02-01 04:54:34","2026-02-01 04:54:34","0","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme3.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:54:38 GMT\r\ncontent-type: image/webp\r\ncontent-length: 46268\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-b4bc&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/DD-visuel-parent-programme3.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.034552","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme3.webp","0","0"),
("8","https://dualdiploma.org/academica-france/","0000-00-00 00:00:00","2026-02-01 04:53:44","2026-02-01 04:53:44","2026-02-01 04:53:44","0","https://dualdiploma.org/academica-france/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:53:49 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14133&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14133&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /academica-france/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.27319","0","0","0","1","0","200|0|0|https://dualdiploma.org/academica-france/","0","0"),
("9","https://ais.academica.org/","0000-00-00 00:00:00","2026-02-01 04:54:24","2026-02-01 04:54:24","2026-02-01 04:54:24","0","https://ais.academica.org/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Sun, 01 Feb 2026 04:54:24 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nserver: cloudflare\r\nreport-to: {&quot;group&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https://a.nel.cloudflare.com/report/v4?s=xfh6xN%2BMPjHX6a3OPC5vAkjSDGGpGh9jgDcNXyele%2B9Pf9uW4vSGjso%2B%2FWmV6zdbu4vSwHW6Y6izYesxXLF3mBJVkEkiuswo3UbPqzdhADSexsVXF4rI80Lr8%2B9g&quot;}]}\r\nlast-modified: Thu, 29 Jan 2026 19:07:54 GMT\r\nvary: Accept-Encoding\r\nnel: {&quot;report_to&quot;:&quot;cf-nel&quot;,&quot;success_fraction&quot;:0.0,&quot;max_age&quot;:604800}\r\ncache-control: max-age=0, no-cache, no-store, must-revalidate\r\npragma: no-cache\r\nexpires: Mon, 29 Oct 1923 20:30:00 GMT\r\nstrict-transport-security: max-age=15768000; includeSubDomains\r\nx-powered-by: PleskLin\r\ncf-cache-status: DYNAMIC\r\ncontent-encoding: br\r\ncf-ray: 9c6ed9c2d810d373-CDG\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: ais.academica.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.396145","0","0","0","1","0","200|0|0|https://ais.academica.org/","0","0"),
("10","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-devenir_partenaire-VA-1.png","0000-00-00 00:00:00","2026-02-01 04:52:39","2026-02-01 04:52:39","2026-02-01 04:52:39","0","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-devenir_partenaire-VA-1.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:52:44 GMT\r\ncontent-type: image/png\r\ncontent-length: 267625\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-41569&quot;\r\nexpires: Tue, 03 Mar 2026 04:52:44 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/DD-visuel-devenir_partenaire-VA-1.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038834","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-devenir_partenaire-VA-1.png","0","0"),
("11","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme-1.webp","0000-00-00 00:00:00","2026-02-01 04:49:24","2026-02-01 04:49:24","2026-02-01 04:49:24","0","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:49:29 GMT\r\ncontent-type: image/webp\r\ncontent-length: 22460\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-57bc&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/DD-visuel-parent-programme-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038919","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-parent-programme-1.webp","0","0"),
("12","https://dualdiploma.org/wp-content/uploads/2024/05/visuel-le-groupe-academica.png","0000-00-00 00:00:00","2026-02-01 04:54:30","2026-02-01 04:54:30","2026-02-01 04:54:30","0","https://dualdiploma.org/wp-content/uploads/2024/05/visuel-le-groupe-academica.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:54:34 GMT\r\ncontent-type: image/png\r\ncontent-length: 338352\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-529b0&quot;\r\nexpires: Tue, 03 Mar 2026 04:54:34 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/visuel-le-groupe-academica.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038049","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/visuel-le-groupe-academica.png","0","0"),
("13","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-florida.webp","0000-00-00 00:00:00","2026-02-01 04:48:25","2026-02-01 04:48:25","2026-02-01 04:48:25","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-florida.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:48:27 GMT\r\ncontent-type: image/webp\r\ncontent-length: 4732\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-127c&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-accreditations-florida.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.028021","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-florida.webp","0","0"),
("14","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-fulbright.webp","0000-00-00 00:00:00","2026-02-01 04:54:19","2026-02-01 04:54:19","2026-02-01 04:54:19","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-fulbright.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:54:24 GMT\r\ncontent-type: image/webp\r\ncontent-length: 3064\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-bf8&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-accreditations-fulbright.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.042558","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-fulbright.webp","0","0"),
("15","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-aefe.webp","0000-00-00 00:00:00","2026-02-01 04:52:44","2026-02-01 04:52:44","2026-02-01 04:52:44","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-aefe.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:52:48 GMT\r\ncontent-type: image/webp\r\ncontent-length: 1402\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-57a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-accreditations-aefe.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.028768","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-aefe.webp","0","0"),
("16","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-AP.webp","0000-00-00 00:00:00","2026-02-01 04:48:53","2026-02-01 04:48:53","2026-02-01 04:48:53","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-AP.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:48:58 GMT\r\ncontent-type: image/webp\r\ncontent-length: 1374\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-55e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-accreditations-AP.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.052291","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-AP.webp","0","0"),
("17","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-cognia.webp","0000-00-00 00:00:00","2026-02-01 04:52:04","2026-02-01 04:52:04","2026-02-01 04:52:04","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-cognia.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:52:08 GMT\r\ncontent-type: image/webp\r\ncontent-length: 2840\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-b18&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-accreditations-cognia.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.033585","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-cognia.webp","0","0"),
("18","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-US.webp","0000-00-00 00:00:00","2026-02-01 04:55:04","2026-02-01 04:55:04","2026-02-01 04:55:04","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-US.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:55:08 GMT\r\ncontent-type: image/webp\r\ncontent-length: 4792\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-12b8&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-accreditations-US.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.060172","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-US.webp","0","0"),
("19","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-USA.webp","0000-00-00 00:00:00","2026-02-01 04:51:24","2026-02-01 04:51:24","2026-02-01 04:51:24","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-USA.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:51:28 GMT\r\ncontent-type: image/webp\r\ncontent-length: 2998\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-bb6&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-accreditations-USA.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.022825","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-USA.webp","0","0"),
("20","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-florida2.webp","0000-00-00 00:00:00","2026-02-01 04:54:48","2026-02-01 04:54:48","2026-02-01 04:54:48","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-florida2.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:54:53 GMT\r\ncontent-type: image/webp\r\ncontent-length: 5150\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-141e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-accreditations-florida2.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.042825","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-florida2.webp","0","0"),
("21","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-resident_e.webp","0000-00-00 00:00:00","2026-02-01 04:49:54","2026-02-01 04:49:54","2026-02-01 04:49:54","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-resident_e.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:49:59 GMT\r\ncontent-type: image/webp\r\ncontent-length: 2876\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-b3c&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-accreditations-resident_e.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.143393","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-accreditations-resident_e.webp","0","0"),
("22","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-partenariats.webp","0000-00-00 00:00:00","2026-02-01 04:53:49","2026-02-01 04:53:49","2026-02-01 04:53:49","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-partenariats.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:53:54 GMT\r\ncontent-type: image/webp\r\ncontent-length: 13396\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-3454&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-partenariats.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.045192","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-partenariats.webp","0","0"),
("23","https://dualdiploma.org/academica-dual-diploma/","0000-00-00 00:00:00","2026-02-01 04:49:39","2026-02-01 04:49:39","2026-02-01 04:49:39","0","https://dualdiploma.org/academica-dual-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:49:44 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14126&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14126&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /academica-dual-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.433268","0","0","0","1","0","200|0|0|https://dualdiploma.org/academica-dual-diploma/","0","0"),
("24","https://dualdiploma.org/le-groupe-academica/","0000-00-00 00:00:00","2026-02-01 04:49:03","2026-02-01 04:49:03","2026-02-01 04:49:03","0","https://dualdiploma.org/le-groupe-academica/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:49:09 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14131&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14131&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /le-groupe-academica/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.233833","0","0","0","1","0","200|0|0|https://dualdiploma.org/le-groupe-academica/","0","0"),
("26","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-innovation-mockup.webp","0000-00-00 00:00:00","2026-02-01 04:51:09","2026-02-01 04:51:09","2026-02-01 04:51:09","0","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-innovation-mockup.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:51:13 GMT\r\ncontent-type: image/webp\r\ncontent-length: 16956\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-423c&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/DD-visuel-innovation-mockup.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.028966","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-innovation-mockup.webp","0","0"),
("27","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-innovation-mockup2.webp","0000-00-00 00:00:00","2026-02-01 04:50:04","2026-02-01 04:50:04","2026-02-01 04:50:04","0","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-innovation-mockup2.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:50:08 GMT\r\ncontent-type: image/webp\r\ncontent-length: 23806\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-5cfe&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/DD-visuel-innovation-mockup2.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.043668","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-innovation-mockup2.webp","0","0"),
("28","https://dualdiploma.org/contact/","0000-00-00 00:00:00","2026-02-01 04:50:23","2026-02-01 04:50:23","2026-02-01 04:50:23","0","https://dualdiploma.org/contact/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:50:29 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14269&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14269&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /contact/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.209801","0","0","0","1","0","200|0|0|https://dualdiploma.org/contact/","0","0"),
("40","https://dualdiploma.org/comment-ca-marche/","0000-00-00 00:00:00","2026-02-01 04:54:03","2026-02-01 04:54:03","2026-02-01 04:54:03","0","https://dualdiploma.org/comment-ca-marche/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:54:09 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14150&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14150&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /comment-ca-marche/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.277076","0","0","0","1","0","200|0|0|https://dualdiploma.org/comment-ca-marche/","0","0"),
("41","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-programme-mockup.webp","0000-00-00 00:00:00","2026-02-01 04:52:18","2026-02-01 04:52:18","2026-02-01 04:52:18","0","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-programme-mockup.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:52:23 GMT\r\ncontent-type: image/webp\r\ncontent-length: 20266\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-4f2a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/DD-visuel-programme-mockup.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.037232","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-programme-mockup.webp","0","0"),
("42","https://dualdiploma.org/comment-ca-marche/#rdv","0000-00-00 00:00:00","2026-02-01 04:50:54","2026-02-01 04:50:54","2026-02-01 04:50:54","0","https://dualdiploma.org/comment-ca-marche/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:50:59 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14150&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14150&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /comment-ca-marche/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.207922","0","0","0","1","0","200|0|0|https://dualdiploma.org/comment-ca-marche/","0","0"),
("44","https://dualdiploma.org/comment-ca-marche/#inscription","0000-00-00 00:00:00","2026-02-01 04:51:48","2026-02-01 04:51:48","2026-02-01 04:51:48","0","https://dualdiploma.org/comment-ca-marche/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:51:54 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14150&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14150&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /comment-ca-marche/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.260062","0","0","0","1","0","200|0|0|https://dualdiploma.org/comment-ca-marche/","0","0"),
("45","https://dualdiploma.org/comment-ca-marche/#faq","0000-00-00 00:00:00","2026-02-01 04:49:18","2026-02-01 04:49:18","2026-02-01 04:49:18","0","https://dualdiploma.org/comment-ca-marche/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:49:24 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14150&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14150&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /comment-ca-marche/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.525685","0","0","0","1","0","200|0|0|https://dualdiploma.org/comment-ca-marche/","0","0"),
("46","https://dualdiploma.org/les-professeurs-americains/","0000-00-00 00:00:00","2026-02-01 04:53:04","2026-02-01 04:53:04","2026-02-01 04:53:04","0","https://dualdiploma.org/les-professeurs-americains/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:53:09 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14156&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14156&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /les-professeurs-americains/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.214138","0","0","0","1","0","200|0|0|https://dualdiploma.org/les-professeurs-americains/","0","0"),
("48","https://dualdiploma.org/etablissement-partenaire/","0000-00-00 00:00:00","2026-02-01 04:50:59","2026-02-01 04:50:59","2026-02-01 04:50:59","0","https://dualdiploma.org/etablissement-partenaire/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:51:04 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14152&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14152&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /etablissement-partenaire/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.241191","0","0","0","1","0","200|0|0|https://dualdiploma.org/etablissement-partenaire/","0","0"),
("49","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-test-de-niveau-et-validation-de-l_inscription.webp","0000-00-00 00:00:00","2026-02-01 04:52:08","2026-02-01 04:52:08","2026-02-01 04:52:08","0","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-test-de-niveau-et-validation-de-l_inscription.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:52:13 GMT\r\ncontent-type: image/webp\r\ncontent-length: 174374\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-2a926&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/DD-visuel-test-de-niveau-et-validation-de-l_inscription.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024655","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-test-de-niveau-et-validation-de-l_inscription.webp","0","0"),
("50","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-echanges-reguliers-en-anglais.webp","0000-00-00 00:00:00","2026-02-01 04:48:23","2026-02-01 04:48:23","2026-02-01 04:48:23","0","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-echanges-reguliers-en-anglais.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:48:24 GMT\r\ncontent-type: image/webp\r\ncontent-length: 159494\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-26f06&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/DD-visuel-echanges-reguliers-en-anglais.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.138335","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-echanges-reguliers-en-anglais.webp","0","0"),
("51","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-les-live-sessions.webp","0000-00-00 00:00:00","2026-02-01 04:50:19","2026-02-01 04:50:19","2026-02-01 04:50:19","0","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-les-live-sessions.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:50:23 GMT\r\ncontent-type: image/webp\r\ncontent-length: 175428\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-2ad44&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/DD-visuel-les-live-sessions.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038815","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-les-live-sessions.webp","0","0"),
("52","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-cours-de-renfort-en-anglais.webp","0000-00-00 00:00:00","2026-02-01 04:49:09","2026-02-01 04:49:09","2026-02-01 04:49:09","0","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-cours-de-renfort-en-anglais.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:49:14 GMT\r\ncontent-type: image/webp\r\ncontent-length: 15724\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-3d6c&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/DD-visuel-cours-de-renfort-en-anglais.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.022105","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-cours-de-renfort-en-anglais.webp","0","0"),
("53","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-echanges-quotidiens-avec-les-professeurs.webp","0000-00-00 00:00:00","2026-02-01 04:51:19","2026-02-01 04:51:19","2026-02-01 04:51:19","0","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-echanges-quotidiens-avec-les-professeurs.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:51:24 GMT\r\ncontent-type: image/webp\r\ncontent-length: 17058\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-42a2&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/DD-visuel-echanges-quotidiens-avec-les-professeurs.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.023581","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-echanges-quotidiens-avec-les-professeurs.webp","0","0"),
("54","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-cursus.webp","0000-00-00 00:00:00","2026-02-01 04:49:29","2026-02-01 04:49:29","2026-02-01 04:49:29","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-cursus.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:49:33 GMT\r\ncontent-type: image/webp\r\ncontent-length: 16976\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-4250&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-cursus.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.035059","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-cursus.webp","0","0"),
("56","https://dualdiploma.org/academica-dual-diploma/#experience","0000-00-00 00:00:00","2026-02-01 05:09:01","2026-02-01 05:09:01","2026-02-01 05:09:01","0","https://dualdiploma.org/academica-dual-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:09:06 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14126&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14126&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /academica-dual-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.239586","0","0","0","1","0","200|0|0|https://dualdiploma.org/academica-dual-diploma/","0","0"),
("57","https://dualdiploma.org/linnovation-pedagogique/","0000-00-00 00:00:00","2026-02-01 05:09:33","2026-02-01 05:09:33","2026-02-01 05:09:33","0","https://dualdiploma.org/linnovation-pedagogique/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:09:38 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14132&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14132&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /linnovation-pedagogique/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.218249","0","0","0","1","0","200|0|0|https://dualdiploma.org/linnovation-pedagogique/","0","0"),
("58","https://dualdiploma.org/le-professeur-referent-program-director/","0000-00-00 00:00:00","2026-02-01 04:48:34","2026-02-01 04:48:34","2026-02-01 04:48:34","0","https://dualdiploma.org/le-professeur-referent-program-director/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:48:39 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14157&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14157&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /le-professeur-referent-program-director/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.249494","0","0","0","1","0","200|0|0|https://dualdiploma.org/le-professeur-referent-program-director/","0","0"),
("63","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-professeur.webp","0000-00-00 00:00:00","2026-02-01 04:48:27","2026-02-01 04:48:27","2026-02-01 04:48:27","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-professeur.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:48:29 GMT\r\ncontent-type: image/webp\r\ncontent-length: 5496\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-1578&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-professeur.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.041053","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-devenir_partenaire-professeur.webp","0","0"),
("64","https://dualdiploma.org/wp-content/uploads/2024/06/temoignage-ce.png","0000-00-00 00:00:00","2026-02-01 04:49:59","2026-02-01 04:49:59","2026-02-01 04:49:59","0","https://dualdiploma.org/wp-content/uploads/2024/06/temoignage-ce.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:50:04 GMT\r\ncontent-type: image/png\r\ncontent-length: 19843\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-4d83&quot;\r\nexpires: Tue, 03 Mar 2026 04:50:04 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/06/temoignage-ce.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020324","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/06/temoignage-ce.png","0","0"),
("66","https://dualdiploma.org/webinaire-eleve-individuel/","0000-00-00 00:00:00","2026-02-01 04:51:34","2026-02-01 04:51:34","2026-02-01 04:51:34","0","https://dualdiploma.org/webinaire-eleve-individuel/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:51:39 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14265&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14265&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /webinaire-eleve-individuel/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.213413","0","0","0","1","0","200|0|0|https://dualdiploma.org/webinaire-eleve-individuel/","0","0"),
("67","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-1.webp","0000-00-00 00:00:00","2026-02-01 04:49:14","2026-02-01 04:49:14","2026-02-01 04:49:14","0","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:49:18 GMT\r\ncontent-type: image/webp\r\ncontent-length: 15040\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-3ac0&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.033433","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-1.webp","0","0"),
("68","https://dualdiploma.org/le-programme/#art-history","0000-00-00 00:00:00","2026-02-01 04:50:49","2026-02-01 04:50:49","2026-02-01 04:50:49","0","https://dualdiploma.org/le-programme/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:50:54 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14149&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14149&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /le-programme/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.296439","0","0","0","1","0","200|0|0|https://dualdiploma.org/le-programme/","0","0"),
("69","https://dualdiploma.org/le-programme/#computer-science","0000-00-00 00:00:00","2026-02-01 04:50:08","2026-02-01 04:50:08","2026-02-01 04:50:08","0","https://dualdiploma.org/le-programme/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:50:14 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14149&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14149&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /le-programme/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.252215","0","0","0","1","0","200|0|0|https://dualdiploma.org/le-programme/","0","0"),
("70","https://dualdiploma.org/le-programme/#computer-scienceprinciples","0000-00-00 00:00:00","2026-02-01 04:49:33","2026-02-01 04:49:33","2026-02-01 04:49:33","0","https://dualdiploma.org/le-programme/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:49:39 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14149&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14149&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /le-programme/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.275835","0","0","0","1","0","200|0|0|https://dualdiploma.org/le-programme/","0","0"),
("71","https://dualdiploma.org/le-programme/#environmental-science","0000-00-00 00:00:00","2026-02-01 04:53:24","2026-02-01 04:53:24","2026-02-01 04:53:24","0","https://dualdiploma.org/le-programme/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:53:29 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14149&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14149&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /le-programme/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.271096","0","0","0","1","0","200|0|0|https://dualdiploma.org/le-programme/","0","0"),
("72","https://dualdiploma.org/le-programme/#european-history","0000-00-00 00:00:00","2026-02-01 04:51:28","2026-02-01 04:51:28","2026-02-01 04:51:28","0","https://dualdiploma.org/le-programme/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:51:34 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14149&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14149&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /le-programme/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.201834","0","0","0","1","0","200|0|0|https://dualdiploma.org/le-programme/","0","0"),
("73","https://dualdiploma.org/le-programme/#english-composition","0000-00-00 00:00:00","2026-02-01 04:49:49","2026-02-01 04:49:49","2026-02-01 04:49:49","0","https://dualdiploma.org/le-programme/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:49:54 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14149&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14149&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /le-programme/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.249573","0","0","0","1","0","200|0|0|https://dualdiploma.org/le-programme/","0","0"),
("74","https://dualdiploma.org/le-programme/#entrepreneurship","0000-00-00 00:00:00","2026-02-01 04:54:24","2026-02-01 04:54:24","2026-02-01 04:54:24","0","https://dualdiploma.org/le-programme/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:54:29 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14149&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14149&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /le-programme/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.280996","0","0","0","1","0","200|0|0|https://dualdiploma.org/le-programme/","0","0"),
("75","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-2.webp","0000-00-00 00:00:00","2026-02-01 04:53:58","2026-02-01 04:53:58","2026-02-01 04:53:58","0","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-2.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:54:03 GMT\r\ncontent-type: image/webp\r\ncontent-length: 27428\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-6b24&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-2.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.041668","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-2.webp","0","0"),
("76","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-3.webp","0000-00-00 00:00:00","2026-02-01 04:48:58","2026-02-01 04:48:58","2026-02-01 04:48:58","0","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-3.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:49:03 GMT\r\ncontent-type: image/webp\r\ncontent-length: 20556\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-504c&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-3.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.037949","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-3.webp","0","0"),
("77","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-4.webp","0000-00-00 00:00:00","2026-02-01 04:50:29","2026-02-01 04:50:29","2026-02-01 04:50:29","0","https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-4.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:50:34 GMT\r\ncontent-type: image/webp\r\ncontent-length: 20332\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-4f6c&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-4.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.041339","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/DD-visuel-devenir_partenaire-VA-4.webp","0","0"),
("78","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-USA.svg","0000-00-00 00:00:00","2026-02-01 04:54:43","2026-02-01 04:54:43","2026-02-01 04:54:43","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-USA.svg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:54:48 GMT\r\ncontent-type: image/svg+xml\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\nvary: Accept-Encoding\r\netag: W/&quot;668e6db9-1c48&quot;\r\nexpires: Mon, 01 Feb 2027 04:54:48 GMT\r\ncache-control: max-age=31536000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-picto-USA.svg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.026608","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-USA.svg","0","0"),
("79","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-bilingue.svg","0000-00-00 00:00:00","2026-02-01 04:51:59","2026-02-01 04:51:59","2026-02-01 04:51:59","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-bilingue.svg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:52:04 GMT\r\ncontent-type: image/svg+xml\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\nvary: Accept-Encoding\r\netag: W/&quot;668e6db9-a91&quot;\r\nexpires: Mon, 01 Feb 2027 04:52:04 GMT\r\ncache-control: max-age=31536000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-picto-bilingue.svg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.034225","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-bilingue.svg","0","0"),
("80","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-scolaire.svg","0000-00-00 00:00:00","2026-02-01 04:50:34","2026-02-01 04:50:34","2026-02-01 04:50:34","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-scolaire.svg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:50:38 GMT\r\ncontent-type: image/svg+xml\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\nvary: Accept-Encoding\r\netag: W/&quot;668e6db9-f27&quot;\r\nexpires: Mon, 01 Feb 2027 04:50:38 GMT\r\ncache-control: max-age=31536000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-picto-scolaire.svg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.033196","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-scolaire.svg","0","0"),
("81","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-maturite.svg","0000-00-00 00:00:00","2026-02-01 04:53:54","2026-02-01 04:53:54","2026-02-01 04:53:54","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-maturite.svg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:53:58 GMT\r\ncontent-type: image/svg+xml\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\nvary: Accept-Encoding\r\netag: W/&quot;668e6db9-1ddf&quot;\r\nexpires: Mon, 01 Feb 2027 04:53:58 GMT\r\ncache-control: max-age=31536000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-picto-maturite.svg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.045939","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-maturite.svg","0","0"),
("82","https://dualdiploma.org/wp-content/uploads/2024/05/dual-diploma-Gina-Lalicata.png","0000-00-00 00:00:00","2026-02-01 04:52:13","2026-02-01 04:52:13","2026-02-01 04:52:13","0","https://dualdiploma.org/wp-content/uploads/2024/05/dual-diploma-Gina-Lalicata.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:52:18 GMT\r\ncontent-type: image/png\r\ncontent-length: 83336\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-14588&quot;\r\nexpires: Tue, 03 Mar 2026 04:52:18 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/dual-diploma-Gina-Lalicata.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.040699","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/dual-diploma-Gina-Lalicata.png","0","0"),
("85","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-devenir_partenaire-VA.png","0000-00-00 00:00:00","2026-02-01 04:53:39","2026-02-01 04:53:39","2026-02-01 04:53:39","0","https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-devenir_partenaire-VA.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:53:44 GMT\r\ncontent-type: image/png\r\ncontent-length: 221686\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-361f6&quot;\r\nexpires: Tue, 03 Mar 2026 04:53:44 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/DD-visuel-devenir_partenaire-VA.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.035294","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/DD-visuel-devenir_partenaire-VA.png","0","0"),
("86","https://www.linkedin.com/groups/9096949/","0000-00-00 00:00:00","2026-02-01 04:54:29","2026-02-01 04:54:29","2026-02-01 04:54:29","0","https://www.linkedin.com/groups/9096949/","1","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 302 ===\n\nResponse headers\n================\nHTTP/2 302 \r\ndate: Sun, 01 Feb 2026 04:54:30 GMT\r\ncontent-length: 0\r\nlocation: https://www.linkedin.com/uas/login?session_redirect=https%3A%2F%2Fwww.linkedin.com%2Fgroups%2F9096949%2F\r\nx-fs-uuid: 000649bc006b0658c2c3c3757580f8e6\r\nstrict-transport-security: max-age=31536000\r\nx-content-type-options: nosniff\r\nx-frame-options: sameorigin\r\ncontent-security-policy: default-src &#039;none&#039;; base-uri &#039;self&#039;; form-action &#039;self&#039; *.qualtrics.com; connect-src &#039;self&#039; wss: blob: *.linkedin.com *.microsoft.com *.lynda.com dpm.demdex.net/id lnkd.demdex.net *.licdn.com linkedin.sc.omtrdc.net/b/ss/ *.skype.com *.skype.net *.office.com *.trouter.io *.qualtrics.com *.agora.io:* *.sd-rtn.com:* www.google.com google.com adservice.google.com pagead2.googlesyndication.com td.doubleclick.net www.googletagmanager.com www.googleadservices.com ad.doubleclick.net googleads.g.doubleclick.net; img-src data: blob: *; font-src data: *; frame-src &#039;self&#039; blob: *.doubleclick.net www.slideshare.net radar.cedexis.com *.linkedin.com *.licdn.com cdn.embedly.com lichat.azurewebsites.net www.youtube.com www.youtube-nocookie.com www.facebook.com player.vimeo.com embed.ted.com livestream.com embed.gettyimages.com w.soundcloud.com www.lynda.com *.megaphone.fm *.omny.fm *.sounder.fm msit.powerbi.com app.powerbi.com linkedin.github.io www.linkedin-event.com lnkd.demdex.net www.paypal.com *.qualtrics.com flo.uri.sh *.fls.doubleclick.net www.googletagmanager.com td.doubleclick.net; worker-src &#039;self&#039; blob: static.licdn.com static-exp1.licdn.com static-exp2.licdn.com static-exp3.licdn.com; style-src &#039;unsafe-inline&#039; static.licdn.com static-exp1.licdn.com static-exp2.licdn.com static-exp3.licdn.com s.c.lnkd.licdn.com static-src.linkedin.com static-lcdn.licdn.com www.linkedin.com/sc/ www.linkedin.com/scds/ qprod.www.linkedin.com/sc/; script-src &#039;report-sample&#039; &#039;sha256-6gLjSWp3GRKZCUFvRX5aGHtECD1wVRgJOJp7r0ZQjV0=&#039; &#039;sha256-3woF8BZ54TeXM+czaH3aXoaJsVpiamuAKFsXDykAR/Q=&#039; static.licdn.com static-exp1.licdn.com static-exp2.licdn.com static-exp3.licdn.com s.c.lnkd.licdn.com static-src.linkedin.com www.linkedin.com/voyager/service-worker-push.js platform.linkedin.com/js/analytics.js platform-akam.linkedin.com/js/analytics.js platform-ecst.linkedin.com/js/analytics.js platform-azur.linkedin.com/js/analytics.js static-lcdn.licdn.com www.linkedin.com/sc/ www.linkedin.com/scds/ qprod.www.linkedin.com/sc/ www.linkedin.com/sw.js www.linkedin.com/voyager/abp-detection.js piwik.corp.linkedin.com/piwik/piwik.js platform.linkedin.com/litms/utag/ platform-akam.linkedin.com/litms/utag/ platform-ecst.linkedin.com/litms/utag/ platform-azur.linkedin.com/litms/utag/ platform.linkedin.com/litms/vendor/ platform-akam.linkedin.com/litms/vendor/ platform-ecst.linkedin.com/litms/vendor/ platform-azur.linkedin.com/litms/vendor/ snap.licdn.com/li.lms-analytics/ www.googletagmanager.com/gtag/js www.googleadservices.com/pagead/ www.google.com/pagead/ googleads.g.doubleclick.net/pagead/ adservice.google.com/pagead/ pagead2.googlesyndication.com/pagead/ www.googletagmanager.com/gtag/destination; media-src blob: *; manifest-src &#039;self&#039;; frame-ancestors &#039;self&#039; *.www.linkedin.com:* *.prod.linkedin.com\r\nx-li-fabric: prod-ltx1\r\npragma: no-cache\r\nexpires: Thu, 01 Jan 1970 00:00:00 GMT\r\ncache-control: no-cache, no-store, no-transform\r\nx-li-pop: cf-prod-ltx1-x\r\nx-li-proto: http/2\r\nx-li-uuid: AAZJvABrBljCw8N1dYD45g==\r\nset-cookie: JSESSIONID=ajax:3711187659199845190; Domain=.www.linkedin.com; Path=/; Secure; SameSite=None\r\ncf-cache-status: DYNAMIC\r\nset-cookie: lang=v=2&amp;lang=en-us; Domain=linkedin.com; Path=/; Secure; SameSite=None\r\nset-cookie: bcookie=&quot;v=2&amp;9b8f6024-7317-48d5-82f0-fd32d325915e&quot;; Domain=.linkedin.com; Expires=Mon, 01-Feb-2027 04:54:29 GMT; Path=/; Secure; SameSite=None\r\nset-cookie: bscookie=&quot;v=1&amp;202602010454295043ce10-4945-407d-8320-b1ce4e532d97AQG9o6yF7BL7GrWHTZMwAy2NDWYOYdS2&quot;; Domain=.www.linkedin.com; Expires=Mon, 01-Feb-2027 04:54:29 GMT; Path=/; HttpOnly; Secure; SameSite=None\r\nset-cookie: li_gc=MTswOzE3Njk5MjE2Njk7MjswMjF2VsS81rKwd6xNvU6P1vtWxAapkUQR4zW6nCe6Il5nkQ==; Domain=.linkedin.com; Expires=Fri, 31 Jul 2026 04:54:29 GMT; Path=/; Secure; SameSite=None\r\nset-cookie: lidc=&quot;b=TGST05:s=T:r=T:a=T:p=T:g=3438:u=1:x=1:i=1769921669:t=1770008069:v=2:sig=AQF3L5-pyG2ydd5XYMFPturR7HydrqRH&quot;; Expires=Mon, 02 Feb 2026 04:54:29 GMT; domain=.linkedin.com; Path=/; SameSite=None; Secure\r\nset-cookie: __cf_bm=aj4zRpfv.rwF4AjCgNYBxMJEVJDFxJx4.qGh7gaYNAQ-1769921670-1.0.1.1-Ba2ae5Jshp_ZZWOhRAjsO6l7tD_m89LIqoI.Hg6wxicaIQp6Kb204YN8PPsgWF_4tsvkPtWR4YYYMvHOyMJkeySCjsG62pwJssj6AnKP16s; path=/; expires=Sun, 01-Feb-26 05:24:30 GMT; domain=.linkedin.com; HttpOnly; Secure; SameSite=None\r\nserver: cloudflare\r\ncf-ray: 9c6ed9e4ccb37ad7-CDG\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nHEAD /groups/9096949/ HTTP/2\r\nHost: www.linkedin.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","302","","","0.246962","0","0","0","1","0","302|0|0|https://www.linkedin.com/groups/9096949/","0","0"),
("87","https://dualdiploma.org/valorisation-post-bac/","0000-00-00 00:00:00","2026-02-01 04:54:53","2026-02-01 04:54:53","2026-02-01 04:54:53","0","https://dualdiploma.org/valorisation-post-bac/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:54:59 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14151&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14151&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /valorisation-post-bac/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.239314","0","0","0","1","0","200|0|0|https://dualdiploma.org/valorisation-post-bac/","0","0"),
("88","https://dualdiploma.org/","0000-00-00 00:00:00","2026-02-01 04:50:39","2026-02-01 04:50:39","2026-02-01 04:50:39","0","https://dualdiploma.org/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:50:44 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14254&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.286393","0","0","0","1","0","200|0|0|https://dualdiploma.org/","0","0"),
("90","https://dualdiploma.org/devenir-partenaire/","0000-00-00 00:00:00","2026-02-01 04:54:09","2026-02-01 04:54:09","2026-02-01 04:54:09","0","https://dualdiploma.org/devenir-partenaire/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:54:14 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14153&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14153&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /devenir-partenaire/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.261292","0","0","0","1","0","200|0|0|https://dualdiploma.org/devenir-partenaire/","0","0"),
("91","https://dualdiploma.org/alumni/","0000-00-00 00:00:00","2026-02-01 04:53:18","2026-02-01 04:53:18","2026-02-01 04:53:18","0","https://dualdiploma.org/alumni/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:53:24 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14158&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14158&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /alumni/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.214938","0","0","0","1","0","200|0|0|https://dualdiploma.org/alumni/","0","0"),
("92","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-mockup_DualDiploma.webp","0000-00-00 00:00:00","2026-02-01 05:08:46","2026-02-01 05:08:46","2026-02-01 05:08:46","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-mockup_DualDiploma.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:08:51 GMT\r\ncontent-type: image/webp\r\ncontent-length: 20432\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-4fd0&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-visuel-pro-mockup_DualDiploma.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.028827","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-mockup_DualDiploma.webp","0","0"),
("93","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-VA.svg","0000-00-00 00:00:00","2026-02-01 04:51:04","2026-02-01 04:51:04","2026-02-01 04:51:04","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-VA.svg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:51:09 GMT\r\ncontent-type: image/svg+xml\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\nvary: Accept-Encoding\r\netag: W/&quot;668e6db9-1774&quot;\r\nexpires: Mon, 01 Feb 2027 04:51:09 GMT\r\ncache-control: max-age=31536000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-picto-VA.svg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.023644","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-VA.svg","0","0"),
("94","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-cursus.svg","0000-00-00 00:00:00","2026-02-01 05:10:06","2026-02-01 05:10:06","2026-02-01 05:10:06","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-cursus.svg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:10:11 GMT\r\ncontent-type: image/svg+xml\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\nvary: Accept-Encoding\r\netag: W/&quot;668e6db9-1717&quot;\r\nexpires: Mon, 01 Feb 2027 05:10:11 GMT\r\ncache-control: max-age=31536000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-picto-cursus.svg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020104","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-cursus.svg","0","0"),
("95","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-cible.webp","0000-00-00 00:00:00","2026-02-01 04:50:44","2026-02-01 04:50:44","2026-02-01 04:50:44","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-cible.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:50:49 GMT\r\ncontent-type: image/webp\r\ncontent-length: 13118\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-333e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-visuel-pro-cible.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.028984","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-cible.webp","0","0"),
("96","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-programme.svg","0000-00-00 00:00:00","2026-02-01 04:53:09","2026-02-01 04:53:09","2026-02-01 04:53:09","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-programme.svg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:53:14 GMT\r\ncontent-type: image/svg+xml\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\nvary: Accept-Encoding\r\netag: W/&quot;668e6db9-14f0&quot;\r\nexpires: Mon, 01 Feb 2027 04:53:14 GMT\r\ncache-control: max-age=31536000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-picto-programme.svg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02443","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-programme.svg","0","0"),
("97","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-humain.svg","0000-00-00 00:00:00","2026-02-01 04:53:29","2026-02-01 04:53:29","2026-02-01 04:53:29","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-humain.svg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:53:34 GMT\r\ncontent-type: image/svg+xml\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\nvary: Accept-Encoding\r\netag: W/&quot;668e6db9-11e3&quot;\r\nexpires: Mon, 01 Feb 2027 04:53:34 GMT\r\ncache-control: max-age=31536000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-picto-humain.svg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020855","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-humain.svg","0","0"),
("98","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-diplome.webp","0000-00-00 00:00:00","2026-02-01 04:51:39","2026-02-01 04:51:39","2026-02-01 04:51:39","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-diplome.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:51:44 GMT\r\ncontent-type: image/webp\r\ncontent-length: 23696\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-5c90&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-visuel-pro-diplome.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.019428","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-diplome.webp","0","0"),
("99","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-etablissement_partenaires.webp","0000-00-00 00:00:00","2026-02-01 04:50:14","2026-02-01 04:50:14","2026-02-01 04:50:14","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-etablissement_partenaires.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:50:19 GMT\r\ncontent-type: image/webp\r\ncontent-length: 30608\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-7790&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-visuel-pro-etablissement_partenaires.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.021696","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-pro-etablissement_partenaires.webp","0","0"),
("103","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-parent-programme.webp","0000-00-00 00:00:00","2026-02-01 04:52:28","2026-02-01 04:52:28","2026-02-01 04:52:28","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-parent-programme.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:52:33 GMT\r\ncontent-type: image/webp\r\ncontent-length: 24894\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-613e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-visuel-parent-programme.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038587","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-parent-programme.webp","0","0"),
("104","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-parent-map_etablissement-2-800x174.webp","0000-00-00 00:00:00","2026-02-01 05:08:56","2026-02-01 05:08:56","2026-02-01 05:08:56","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-parent-map_etablissement-2-800x174.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:09:01 GMT\r\ncontent-type: image/webp\r\ncontent-length: 60790\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-ed76&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-visuel-parent-map_etablissement-2-800x174.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024151","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-parent-map_etablissement-2-800x174.webp","0","0"),
("105","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-parent-admission.webp","0000-00-00 00:00:00","2026-02-01 04:49:44","2026-02-01 04:49:44","2026-02-01 04:49:44","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-parent-admission.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:49:49 GMT\r\ncontent-type: image/webp\r\ncontent-length: 8558\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-216e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-visuel-parent-admission.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.153296","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-parent-admission.webp","0","0"),
("106","https://dualdiploma.org/eleve/#rdv","0000-00-00 00:00:00","2026-02-01 04:52:33","2026-02-01 04:52:33","2026-02-01 04:52:33","0","https://dualdiploma.org/eleve/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:52:39 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14161&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14161&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /eleve/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.281231","0","0","0","1","0","200|0|0|https://dualdiploma.org/eleve/","0","0"),
("107","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-eleve-americain.webp","0000-00-00 00:00:00","2026-02-01 05:09:46","2026-02-01 05:09:46","2026-02-01 05:09:46","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-eleve-americain.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:09:51 GMT\r\ncontent-type: image/webp\r\ncontent-length: 7210\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-1c2a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-visuel-eleve-americain.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02566","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-visuel-eleve-americain.webp","0","0"),
("116","https://dualdiploma.org/foire-aux-questions/","0000-00-00 00:00:00","2026-02-01 04:48:29","2026-02-01 04:48:29","2026-02-01 04:48:29","0","https://dualdiploma.org/foire-aux-questions/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:48:34 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14223&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14223&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /foire-aux-questions/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.247612","0","0","0","1","0","200|0|0|https://dualdiploma.org/foire-aux-questions/","0","0"),
("117","https://dualdiploma.org/high-school-diploma/","0000-00-00 00:00:00","2026-02-01 05:09:56","2026-02-01 05:09:56","2026-02-01 05:09:56","0","https://dualdiploma.org/high-school-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:10:01 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14154&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14154&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /high-school-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.338575","0","0","0","1","0","200|0|0|https://dualdiploma.org/high-school-diploma/","0","0"),
("118","https://dualdiploma.org/cours-a-la-carte/","0000-00-00 00:00:00","2026-02-01 04:53:34","2026-02-01 04:53:34","2026-02-01 04:53:34","0","https://dualdiploma.org/cours-a-la-carte/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:53:39 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14155&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14155&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /cours-a-la-carte/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.253846","0","0","0","1","0","200|0|0|https://dualdiploma.org/cours-a-la-carte/","0","0"),
("119","https://dualdiploma.org/eleve/","0000-00-00 00:00:00","2026-02-01 04:51:54","2026-02-01 04:51:54","2026-02-01 04:51:54","0","https://dualdiploma.org/eleve/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:51:59 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14161&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14161&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /eleve/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.266278","0","0","0","1","0","200|0|0|https://dualdiploma.org/eleve/","0","0"),
("121","https://dualdiploma.org/wp-content/uploads/2024/05/Academica-Dual-Diploma-High-School.webp","0000-00-00 00:00:00","2026-02-01 04:52:48","2026-02-01 04:52:48","2026-02-01 04:52:48","0","https://dualdiploma.org/wp-content/uploads/2024/05/Academica-Dual-Diploma-High-School.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:52:53 GMT\r\ncontent-type: image/webp\r\ncontent-length: 96944\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-17ab0&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/Academica-Dual-Diploma-High-School.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024887","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/Academica-Dual-Diploma-High-School.webp","0","0"),
("123","https://dualdiploma.org/wp-content/uploads/2024/03/DD-home-visuel-programme_dual-diploma.webp","0000-00-00 00:00:00","2026-02-01 05:08:40","2026-02-01 05:08:40","2026-02-01 05:08:40","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-home-visuel-programme_dual-diploma.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:08:42 GMT\r\ncontent-type: image/webp\r\ncontent-length: 4198\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-1066&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-home-visuel-programme_dual-diploma.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.142058","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-home-visuel-programme_dual-diploma.webp","0","0"),
("127","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-etablissement.svg","0000-00-00 00:00:00","2026-02-01 05:08:36","2026-02-01 05:08:36","2026-02-01 05:08:36","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-etablissement.svg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:08:38 GMT\r\ncontent-type: image/svg+xml\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\nvary: Accept-Encoding\r\netag: W/&quot;668e6db9-1639&quot;\r\nexpires: Mon, 01 Feb 2027 05:08:38 GMT\r\ncache-control: max-age=31536000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-picto-etablissement.svg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038179","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-etablissement.svg","0","0"),
("128","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-eleves.svg","0000-00-00 00:00:00","2026-02-01 05:09:11","2026-02-01 05:09:11","2026-02-01 05:09:11","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-eleves.svg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:09:16 GMT\r\ncontent-type: image/svg+xml\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\nvary: Accept-Encoding\r\netag: W/&quot;668e6db9-155e&quot;\r\nexpires: Mon, 01 Feb 2027 05:09:16 GMT\r\ncache-control: max-age=31536000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-picto-eleves.svg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02669","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-eleves.svg","0","0"),
("130","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-diplome.svg","0000-00-00 00:00:00","2026-02-01 04:54:59","2026-02-01 04:54:59","2026-02-01 04:54:59","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-diplome.svg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:55:04 GMT\r\ncontent-type: image/svg+xml\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\nvary: Accept-Encoding\r\netag: W/&quot;668e6db9-dcc&quot;\r\nexpires: Mon, 01 Feb 2027 04:55:04 GMT\r\ncache-control: max-age=31536000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-picto-diplome.svg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.028625","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-diplome.svg","0","0"),
("131","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-professeurs-1.svg","0000-00-00 00:00:00","2026-02-01 05:08:38","2026-02-01 05:08:38","2026-02-01 05:08:38","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-professeurs-1.svg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:08:40 GMT\r\ncontent-type: image/svg+xml\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\nvary: Accept-Encoding\r\netag: W/&quot;668e6db9-1536&quot;\r\nexpires: Mon, 01 Feb 2027 05:08:40 GMT\r\ncache-control: max-age=31536000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-picto-professeurs-1.svg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.136053","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-professeurs-1.svg","0","0"),
("132","https://dualdiploma.org/wp-content/uploads/2024/05/Le-double-diplome-du-bac-americain-en-immersion-virtuelle-2.png","0000-00-00 00:00:00","2026-02-01 05:10:11","2026-02-01 05:10:11","2026-02-01 05:10:11","0","https://dualdiploma.org/wp-content/uploads/2024/05/Le-double-diplome-du-bac-americain-en-immersion-virtuelle-2.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:10:16 GMT\r\ncontent-type: image/png\r\ncontent-length: 16736\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-4160&quot;\r\nexpires: Tue, 03 Mar 2026 05:10:16 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/Le-double-diplome-du-bac-americain-en-immersion-virtuelle-2.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.040951","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/Le-double-diplome-du-bac-americain-en-immersion-virtuelle-2.png","0","0"),
("133","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-webinaire_red.svg","0000-00-00 00:00:00","2026-02-01 04:54:38","2026-02-01 04:54:38","2026-02-01 04:54:38","0","https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-webinaire_red.svg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:54:43 GMT\r\ncontent-type: image/svg+xml\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\nvary: Accept-Encoding\r\netag: W/&quot;668e6db9-2dd&quot;\r\nexpires: Mon, 01 Feb 2027 04:54:43 GMT\r\ncache-control: max-age=31536000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/03/DD-picto-webinaire_red.svg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02869","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/03/DD-picto-webinaire_red.svg","0","0"),
("134","https://toolin.fr","0000-00-00 00:00:00","2026-02-01 07:03:36","2026-02-01 07:03:36","2026-02-01 07:03:36","0","https://toolin.fr/","1","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 301 ===\n\nResponse headers\n================\nHTTP/2 301 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:03:36 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nlocation: https://www.toolin.fr/\r\nx-redirect-by: WordPress\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: toolin.fr\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","301","","","0.270985","0","0","0","1","0","301|0|0|https://toolin.fr/","0","0"),
("135","https://agencetool.fr","0000-00-00 00:00:00","2026-02-01 05:09:56","2026-02-01 05:09:56","2026-02-01 05:09:56","0","https://agencetool.fr/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/1.1 200 OK\r\nDate: Sun, 01 Feb 2026 05:09:56 GMT\r\nServer: Apache/2.4.66 (Debian)\r\nLast-Modified: Sat, 31 Jan 2026 23:36:02 GMT\r\nVary: Accept-Encoding\r\nConnection: close\r\nContent-Type: text/html; charset=UTF-8\r\n\r\nRequest headers\n================\nHEAD / HTTP/1.1\r\nHost: agencetool.fr\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://dualdiploma.org\r\nConnection: close\r\n\r\n\nLe lien est valide.","200","","","0.047868","0","0","0","1","0","200|0|0|https://agencetool.fr/","0","0");

INSERT IGNORE INTO `da_blc_links` VALUES 
("136","https://archives.dualdiploma.org/fichier/fichier-2/","0000-00-00 00:00:00","2026-02-01 05:09:31","2026-02-01 05:09:31","2026-02-01 05:09:31","0","https://archives.dualdiploma.org/fichier/fichier-2/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:09:33 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://archives.dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://archives.dualdiploma.org/wp-json/wp/v2/fichier/9761&gt;; rel=&quot;alternate&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://archives.dualdiploma.org/?p=9761&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /fichier/fichier-2/ HTTP/2\r\nHost: archives.dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","2.22788","0","0","0","1","0","200|0|0|https://archives.dualdiploma.org/fichier/fichier-2/","0","0"),
("143","https://dualdiploma.org/wp-content/uploads/2024/10/Demande-de-Transcript-ou-de-Certificat-dinscription.pdf","0000-00-00 00:00:00","2026-02-01 04:53:14","2026-02-01 04:53:14","2026-02-01 04:53:14","0","https://dualdiploma.org/wp-content/uploads/2024/10/Demande-de-Transcript-ou-de-Certificat-dinscription.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:53:18 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 142811\r\nlast-modified: Wed, 02 Oct 2024 15:24:12 GMT\r\netag: &quot;66fd659c-22ddb&quot;\r\nexpires: Tue, 03 Mar 2026 04:53:18 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/10/Demande-de-Transcript-ou-de-Certificat-dinscription.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.027063","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/10/Demande-de-Transcript-ou-de-Certificat-dinscription.pdf","0","0"),
("147","https://dualdiploma.org/wp-content/uploads/2024/08/Comment-classer-automatiquement-vos-emails.pdf","0000-00-00 00:00:00","2026-02-01 05:09:26","2026-02-01 05:09:26","2026-02-01 05:09:26","0","https://dualdiploma.org/wp-content/uploads/2024/08/Comment-classer-automatiquement-vos-emails.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:09:31 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 1094316\r\nlast-modified: Thu, 22 Aug 2024 13:01:35 GMT\r\netag: &quot;66c736af-10b2ac&quot;\r\nexpires: Tue, 03 Mar 2026 05:09:31 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/08/Comment-classer-automatiquement-vos-emails.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.037529","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/08/Comment-classer-automatiquement-vos-emails.pdf","0","0"),
("152","https://dualdiploma.org/wp-content/uploads/2024/10/Comprendre-le-programme-Jumpstart.pdf","0000-00-00 00:00:00","2026-02-01 05:09:21","2026-02-01 05:09:21","2026-02-01 05:09:21","0","https://dualdiploma.org/wp-content/uploads/2024/10/Comprendre-le-programme-Jumpstart.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:09:26 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 115084\r\nlast-modified: Thu, 10 Oct 2024 08:00:05 GMT\r\netag: &quot;67078985-1c18c&quot;\r\nexpires: Tue, 03 Mar 2026 05:09:26 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/10/Comprendre-le-programme-Jumpstart.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.026874","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/10/Comprendre-le-programme-Jumpstart.pdf","0","0"),
("157","https://dualdiploma.org/wp-content/uploads/2024/08/Affichettes-plaquette-video.pdf","0000-00-00 00:00:00","2026-02-01 05:09:51","2026-02-01 05:09:51","2026-02-01 05:09:51","0","https://dualdiploma.org/wp-content/uploads/2024/08/Affichettes-plaquette-video.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:09:56 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 601743\r\nlast-modified: Thu, 22 Aug 2024 13:15:12 GMT\r\netag: &quot;66c739e0-92e8f&quot;\r\nexpires: Tue, 03 Mar 2026 05:09:56 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/08/Affichettes-plaquette-video.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.14995","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/08/Affichettes-plaquette-video.pdf","0","0"),
("158","https://dualdiploma.org/wp-content/uploads/2024/08/23.Note-sur-le-statut-Inactive-des-eleves-en-fin-dannee-sur-Maestro.pdf","0000-00-00 00:00:00","2026-02-01 05:09:41","2026-02-01 05:09:41","2026-02-01 05:09:41","0","https://dualdiploma.org/wp-content/uploads/2024/08/23.Note-sur-le-statut-Inactive-des-eleves-en-fin-dannee-sur-Maestro.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:09:46 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 111645\r\nlast-modified: Thu, 22 Aug 2024 13:15:13 GMT\r\netag: &quot;66c739e1-1b41d&quot;\r\nexpires: Tue, 03 Mar 2026 05:09:46 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/08/23.Note-sur-le-statut-Inactive-des-eleves-en-fin-dannee-sur-Maestro.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.028407","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/08/23.Note-sur-le-statut-Inactive-des-eleves-en-fin-dannee-sur-Maestro.pdf","0","0"),
("174","https://www.youtube.com/@DualDiploma","0000-00-00 00:00:00","2026-02-01 05:09:06","2026-02-01 05:09:06","2026-02-01 05:09:06","0","https://www.youtube.com/@DualDiploma","1","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 302 ===\n\nResponse headers\n================\nHTTP/2 302 \r\ncontent-type: application/binary\r\nx-content-type-options: nosniff\r\ncache-control: no-cache, no-store, max-age=0, must-revalidate\r\npragma: no-cache\r\nexpires: Mon, 01 Jan 1990 00:00:00 GMT\r\ndate: Sun, 01 Feb 2026 05:09:06 GMT\r\nlocation: https://consent.youtube.com/m?continue=https%3A%2F%2Fwww.youtube.com%2F%40DualDiploma%3Fcbrd%3D1&amp;gl=FR&amp;m=0&amp;pc=yt&amp;cm=2&amp;hl=fr&amp;src=1\r\ncontent-length: 0\r\np3p: CP=&quot;This is not a P3P policy! See http://support.google.com/accounts/answer/151657?hl=fr for more info.&quot;\r\nstrict-transport-security: max-age=31536000\r\nx-frame-options: SAMEORIGIN\r\naccept-ch: Sec-CH-Viewport-Width, Sec-CH-DPR, Device-Memory\r\nvary: Sec-CH-Viewport-Width, Sec-CH-DPR, Device-Memory\r\norigin-trial: AmhMBR6zCLzDDxpW+HfpP67BqwIknWnyMOXOQGfzYswFmJe+fgaI6XZgAzcxOrzNtP7hEDsOo1jdjFnVr2IdxQ4AAAB4eyJvcmlnaW4iOiJodHRwczovL3lvdXR1YmUuY29tOjQ0MyIsImZlYXR1cmUiOiJXZWJWaWV3WFJlcXVlc3RlZFdpdGhEZXByZWNhdGlvbiIsImV4cGlyeSI6MTc1ODA2NzE5OSwiaXNTdWJkb21haW4iOnRydWV9\r\norigin-trial: AiDEBptUfVeO93q48VdVMe/ubupazdAl8AaHP+NBzdnW8quUcHdzJUyGSfrmtpKJu7EOvwRp9ug2rEo3XU+WMAMAAAB2eyJvcmlnaW4iOiJodHRwczovL3lvdXR1YmUuY29tOjQ0MyIsImZlYXR1cmUiOiJEZXZpY2VCb3VuZFNlc3Npb25DcmVkZW50aWFsczIiLCJleHBpcnkiOjE3NzQzMTA0MDAsImlzU3ViZG9tYWluIjp0cnVlfQ==\r\npermissions-policy: ch-ua-arch=*, ch-ua-bitness=*, ch-ua-full-version=*, ch-ua-full-version-list=*, ch-ua-model=*, ch-ua-wow64=*, ch-ua-form-factors=*, ch-ua-platform=*, ch-ua-platform-version=*\r\ncontent-security-policy-report-only: report-uri https://csp.withgoogle.com/csp/youtube_main/strict;base-uri &#039;self&#039;;object-src &#039;none&#039;;script-src &#039;report-sample&#039; &#039;nonce-kcuL74s6gw9qXQNPRWTG7Q&#039; &#039;unsafe-inline&#039; &#039;strict-dynamic&#039; https: http: &#039;unsafe-eval&#039;\r\nreport-to: {&quot;group&quot;:&quot;youtube_main&quot;,&quot;max_age&quot;:2592000,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https://csp.withgoogle.com/csp/report-to/youtube_main&quot;}]}\r\ncross-origin-opener-policy: same-origin-allow-popups; report-to=&quot;youtube_main&quot;\r\ncontent-security-policy: require-trusted-types-for &#039;script&#039;\r\nserver: ESF\r\nx-xss-protection: 0\r\nset-cookie: SOCS=CAAaBgiAr_rLBg; Domain=.youtube.com; Expires=Wed, 03-Mar-2027 05:09:06 GMT; Path=/; Secure; SameSite=lax\r\nset-cookie: __Secure-YENID=13.YTE=j7ZgD6GTHHwtulj1-7owDGmkqTZbWRDT-DKDL83Vfr5HDHuPHXWz3X02e3-NGOy57m_aaI5JJBgdzOA5Kl8MECmsTBTNJCBx2uATfWXHd01Gnkw_CG6Qwq3Y2FCgff-r-Q_6nniI-nNFTFyM6VEVbXqKZLo69IcqGjNyg_zJv8v00kBZD0oScW4iAw3w7wxwcR1jjflSjThpD3K0mff-YsPY45nZTERcXZLrdAAzkHmRVicriw4aDXzNL79NSFUxKPomPbzeTF_V1WqpLRm1zgwTbwB2DYZL0Ov5wbSWj_z9wKkHYWG6JQwTF0X5DdHdio-YpGJVN2FDVBefsx-ECQ; expires=Wed, 03-Mar-2027 05:09:06 GMT; path=/; domain=.youtube.com; Secure; HttpOnly; SameSite=lax\r\nset-cookie: YSC=E6wzsRVv6mk; Domain=.youtube.com; Path=/; Secure; HttpOnly; SameSite=none\r\nset-cookie: __Secure-YEC=CgsxLUdVdE5GQTJCSSjyv_vLBjInCgJGUhIhEh0SGwsMDg8QERITFBUWFxgZGhscHR4fICEiIyQlJiBkYuACCt0CMTMuWVRFPWo3WmdENkdUSEh3dHVsajEtN293REdta3FUWmJXUkRULURLREw4M1ZmcjVIREh1UEhYV3ozWDAyZTMtTkdPeTU3bV9hYUk1SkpCZ2R6T0E1S2w4TUVDbXNUQlROSkNCeDJ1QVRmV1hIZDAxR25rd19DRzZRd3EzWTJGQ2dmZi1yLVFfNm5uaUktbk5GVEZ5TTZWRVZiWHFLWkxvNjlJY3FHak55Z196SnY4djAwa0JaRDBvU2NXNGlBdzN3N3d4d2NSMWpqZmxTalRocEQzSzBtZmYtWXNQWTQ1blpURVJjWFpMcmRBQXprSG1SVmljcml3NGFEWHpOTDc5TlNGVXhLUG9tUGJ6ZVRGX1YxV3FwTFJtMXpnd1Rid0IyRFlaTDBPdjV3YlNXal96OXdLa0hZV0c2SlF3VEYwWDVEZEhkaW8tWXBHSlZOMkZEVkJlZnN4LUVDUQ%3D%3D; Domain=.youtube.com; Expires=Wed, 03-Mar-2027 05:09:05 GMT; Path=/; Secure; HttpOnly; SameSite=lax\r\nset-cookie: VISITOR_PRIVACY_METADATA=CgJGUhIhEh0SGwsMDg8QERITFBUWFxgZGhscHR4fICEiIyQlJiBk; Domain=.youtube.com; Expires=Wed, 03-Mar-2027 05:09:06 GMT; Path=/; Secure; HttpOnly; SameSite=none\r\nset-cookie: VISITOR_INFO1_LIVE=; Domain=.youtube.com; Expires=Mon, 08-May-2023 05:09:06 GMT; Path=/; Secure; HttpOnly; SameSite=none\r\nalt-svc: h3=&quot;:443&quot;; ma=2592000,h3-29=&quot;:443&quot;; ma=2592000\r\n\r\nRequest headers\n================\nHEAD /@DualDiploma HTTP/2\r\nHost: www.youtube.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","302","","","0.09357","0","0","0","1","0","302|0|0|https://www.youtube.com/@DualDiploma","0","0"),
("175","https://dualdiploma.org/wp-content/uploads/2024/09/Logo-Dual-Diploma-Transparent-1-2.png","0000-00-00 00:00:00","2026-02-01 05:09:38","2026-02-01 05:09:38","2026-02-01 05:09:38","0","https://dualdiploma.org/wp-content/uploads/2024/09/Logo-Dual-Diploma-Transparent-1-2.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:09:41 GMT\r\ncontent-type: image/png\r\ncontent-length: 56222\r\nlast-modified: Wed, 04 Sep 2024 08:46:23 GMT\r\netag: &quot;66d81e5f-db9e&quot;\r\nexpires: Tue, 03 Mar 2026 05:09:41 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/Logo-Dual-Diploma-Transparent-1-2.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.035812","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/Logo-Dual-Diploma-Transparent-1-2.png","0","0"),
("187","https://dualdiploma.org/documentation/","0000-00-00 00:00:00","2026-02-01 05:09:06","2026-02-01 05:09:06","2026-02-01 05:09:06","0","https://dualdiploma.org/documentation/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:09:11 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14231&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14231&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /documentation/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.248358","0","0","0","1","0","200|0|0|https://dualdiploma.org/documentation/","0","0"),
("197","https://dualdiploma.org/wp-content/uploads/2024/09/0.jpg","0000-00-00 00:00:00","2026-02-01 06:00:14","2026-02-01 06:00:14","2026-02-01 06:00:14","0","https://dualdiploma.org/wp-content/uploads/2024/09/0.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:00:19 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 125881\r\nlast-modified: Wed, 04 Sep 2024 10:44:43 GMT\r\netag: &quot;66d83a1b-1ebb9&quot;\r\nexpires: Tue, 03 Mar 2026 06:00:19 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/0.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.030645","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/0.jpg","0","0"),
("198","https://dualdiploma.org/wp-content/uploads/2024/09/Dual-Diploma.png","0000-00-00 00:00:00","2026-02-01 05:59:09","2026-02-01 05:59:09","2026-02-01 05:59:09","0","https://dualdiploma.org/wp-content/uploads/2024/09/Dual-Diploma.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:59:09 GMT\r\ncontent-type: image/png\r\ncontent-length: 251684\r\nlast-modified: Wed, 04 Sep 2024 10:46:13 GMT\r\netag: &quot;66d83a75-3d724&quot;\r\nexpires: Tue, 03 Mar 2026 05:59:09 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/Dual-Diploma.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02627","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/Dual-Diploma.png","0","0"),
("199","https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-3.jpg","0000-00-00 00:00:00","2026-02-01 06:05:09","2026-02-01 06:05:09","2026-02-01 06:05:09","0","https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-3.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:05:14 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 83707\r\nlast-modified: Wed, 04 Sep 2024 12:16:52 GMT\r\netag: &quot;66d84fb4-146fb&quot;\r\nexpires: Tue, 03 Mar 2026 06:05:14 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/kit-com-3.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.027904","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-3.jpg","0","0"),
("200","https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-2.jpg","0000-00-00 00:00:00","2026-02-01 06:00:09","2026-02-01 06:00:09","2026-02-01 06:00:09","0","https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-2.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:00:14 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 68259\r\nlast-modified: Wed, 04 Sep 2024 12:16:49 GMT\r\netag: &quot;66d84fb1-10aa3&quot;\r\nexpires: Tue, 03 Mar 2026 06:00:14 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/kit-com-2.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.027772","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-2.jpg","0","0"),
("201","https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-1.jpg","0000-00-00 00:00:00","2026-02-01 04:52:23","2026-02-01 04:52:23","2026-02-01 04:52:23","0","https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-1.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:52:28 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 109587\r\nlast-modified: Wed, 04 Sep 2024 12:16:53 GMT\r\netag: &quot;66d84fb5-1ac13&quot;\r\nexpires: Tue, 03 Mar 2026 04:52:28 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/kit-com-1.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.047777","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/kit-com-1.jpg","0","0"),
("202","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-5.jpg","0000-00-00 00:00:00","2026-02-01 06:03:24","2026-02-01 06:03:24","2026-02-01 06:03:24","0","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-5.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:03:29 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 108490\r\nlast-modified: Wed, 04 Sep 2024 12:22:13 GMT\r\netag: &quot;66d850f5-1a7ca&quot;\r\nexpires: Tue, 03 Mar 2026 06:03:29 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/Style-1-3-5.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024396","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-5.jpg","0","0"),
("203","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-4.jpg","0000-00-00 00:00:00","2026-02-01 05:10:01","2026-02-01 05:10:01","2026-02-01 05:10:01","0","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-4.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:10:06 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 118775\r\nlast-modified: Wed, 04 Sep 2024 12:22:30 GMT\r\netag: &quot;66d85106-1cff7&quot;\r\nexpires: Tue, 03 Mar 2026 05:10:06 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/Style-1-3-4.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.139086","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-4.jpg","0","0"),
("204","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-3.jpg","0000-00-00 00:00:00","2026-02-01 05:59:19","2026-02-01 05:59:19","2026-02-01 05:59:19","0","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-3.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:59:24 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 130601\r\nlast-modified: Wed, 04 Sep 2024 12:23:01 GMT\r\netag: &quot;66d85125-1fe29&quot;\r\nexpires: Tue, 03 Mar 2026 05:59:24 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/Style-1-3-3.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.034441","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-3.jpg","0","0"),
("205","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3.jpg","0000-00-00 00:00:00","2026-02-01 05:08:51","2026-02-01 05:08:51","2026-02-01 05:08:51","0","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:08:56 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 153208\r\nlast-modified: Wed, 04 Sep 2024 12:23:30 GMT\r\netag: &quot;66d85142-25678&quot;\r\nexpires: Tue, 03 Mar 2026 05:08:56 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/Style-1-3.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.021233","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3.jpg","0","0"),
("206","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-6.jpg","0000-00-00 00:00:00","2026-02-01 04:48:48","2026-02-01 04:48:48","2026-02-01 04:48:48","0","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-6.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:48:53 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 123084\r\nlast-modified: Wed, 04 Sep 2024 12:24:10 GMT\r\netag: &quot;66d8516a-1e0cc&quot;\r\nexpires: Tue, 03 Mar 2026 04:48:53 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/Style-1-3-6.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.031518","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-6.jpg","0","0"),
("207","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-7.jpg","0000-00-00 00:00:00","2026-02-01 05:09:16","2026-02-01 05:09:16","2026-02-01 05:09:16","0","https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-7.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:09:21 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 173155\r\nlast-modified: Wed, 04 Sep 2024 12:25:21 GMT\r\netag: &quot;66d851b1-2a463&quot;\r\nexpires: Tue, 03 Mar 2026 05:09:21 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/Style-1-3-7.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.034716","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/Style-1-3-7.jpg","0","0"),
("210","https://dualdiploma.org/wp-content/uploads/2024/09/ais-1.4.brand-colors-800x359.jpg","0000-00-00 00:00:00","2026-02-01 06:02:39","2026-02-01 06:02:39","2026-02-01 06:02:39","0","https://dualdiploma.org/wp-content/uploads/2024/09/ais-1.4.brand-colors-800x359.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:02:44 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 19336\r\nlast-modified: Wed, 04 Sep 2024 09:27:08 GMT\r\netag: &quot;66d827ec-4b88&quot;\r\nexpires: Tue, 03 Mar 2026 06:02:44 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/ais-1.4.brand-colors-800x359.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.032864","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/ais-1.4.brand-colors-800x359.jpg","0","0"),
("212","https://dualdiploma.org/academica-dual-diploma/#quoi-pour-qui-comment","0000-00-00 00:00:00","2026-02-01 04:54:14","2026-02-01 04:54:14","2026-02-01 04:54:14","0","https://dualdiploma.org/academica-dual-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:54:19 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14126&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14126&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /academica-dual-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.302463","0","0","0","1","0","200|0|0|https://dualdiploma.org/academica-dual-diploma/","0","0"),
("213","https://dualdiploma.org/academica-dual-diploma/#professeurs-americains","0000-00-00 00:00:00","2026-02-01 05:08:36","2026-02-01 05:08:36","2026-02-01 05:08:36","0","https://dualdiploma.org/academica-dual-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:08:36 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14126&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14126&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /academica-dual-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.191552","0","0","0","1","0","200|0|0|https://dualdiploma.org/academica-dual-diploma/","0","0"),
("214","https://dualdiploma.org/nos-etablissements-partenaires#partenaires","0000-00-00 00:00:00","2026-02-01 06:02:24","2026-02-01 06:02:24","2026-02-01 06:02:24","0","https://dualdiploma.org/nos-etablissements-partenaires","1","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 301 ===\n\nResponse headers\n================\nHTTP/2 301 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:02:30 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nexpires: Sun, 01 Feb 2026 07:02:30 GMT\r\ncache-control: max-age=3600\r\nx-redirect-by: redirection\r\nlocation: /etablissement-partenaire/\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\n\r\nRequest headers\n================\nHEAD /nos-etablissements-partenaires HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","301","","","0.21258","0","0","0","1","0","301|0|0|https://dualdiploma.org/nos-etablissements-partenaires","0","0"),
("216","https://dualdiploma.org/academica-dual-diploma/#plan-detudes","0000-00-00 00:00:00","2026-02-01 05:59:29","2026-02-01 05:59:29","2026-02-01 05:59:29","0","https://dualdiploma.org/academica-dual-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:59:34 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14126&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14126&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /academica-dual-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.286338","0","0","0","1","0","200|0|0|https://dualdiploma.org/academica-dual-diploma/","0","0"),
("217","https://dualdiploma.org/wp-content/uploads/2020/01/Skyline-Manhattan-e1581597333651.webp","0000-00-00 00:00:00","2026-02-01 06:04:24","2026-02-01 06:04:24","2026-02-01 06:04:24","0","https://dualdiploma.org/wp-content/uploads/2020/01/Skyline-Manhattan-e1581597333651.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:04:29 GMT\r\ncontent-type: image/webp\r\ncontent-length: 86600\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-15248&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2020/01/Skyline-Manhattan-e1581597333651.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.043796","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2020/01/Skyline-Manhattan-e1581597333651.webp","0","0"),
("218","https://dualdiploma.org/wp-content/uploads/2020/01/crowdfunding-image.webp","0000-00-00 00:00:00","2026-02-01 06:05:39","2026-02-01 06:05:39","2026-02-01 06:05:39","0","https://dualdiploma.org/wp-content/uploads/2020/01/crowdfunding-image.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:05:44 GMT\r\ncontent-type: image/webp\r\ncontent-length: 98084\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-17f24&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2020/01/crowdfunding-image.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.025056","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2020/01/crowdfunding-image.webp","0","0"),
("228","https://dualdiploma.org/le-groupe-academica/#le-high-school-diploma","0000-00-00 00:00:00","2026-02-01 05:08:42","2026-02-01 05:08:42","2026-02-01 05:08:42","0","https://dualdiploma.org/le-groupe-academica/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:08:46 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14131&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14131&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /le-groupe-academica/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.211257","0","0","0","1","0","200|0|0|https://dualdiploma.org/le-groupe-academica/","0","0"),
("231","https://dualdiploma.org/etablissement-partenaire/#devenir-partenaire","0000-00-00 00:00:00","2026-02-01 06:01:04","2026-02-01 06:01:04","2026-02-01 06:01:04","0","https://dualdiploma.org/etablissement-partenaire/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:01:09 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14152&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14152&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /etablissement-partenaire/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.257816","0","0","0","1","0","200|0|0|https://dualdiploma.org/etablissement-partenaire/","0","0"),
("232","https://www.cnesco.fr/fr/langues-vivantes/recommandations/","0000-00-00 00:00:00","2026-02-01 06:05:19","2026-02-01 06:05:19","2026-02-01 06:05:19","0","https://www.cnesco.fr/fr/langues-vivantes/recommandations/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:05:20 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nset-cookie: pll_language=fr; expires=Mon, 01-Feb-2027 06:05:20 GMT; Max-Age=31536000; path=/; HTTPOnly; Secure; secure; SameSite=Lax\r\nx-content-type-options: nosniff\r\nstrict-transport-security: max-age=31536000; includeSubDomains; preload\r\nreferrer-policy: origin-when-cross-origin\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /fr/langues-vivantes/recommandations/ HTTP/2\r\nHost: www.cnesco.fr\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.253855","0","0","0","1","0","200|0|0|https://www.cnesco.fr/fr/langues-vivantes/recommandations/","0","0"),
("233","https://dualdiploma.org/academica-dual-diploma/#les-benefices","0000-00-00 00:00:00","2026-02-01 06:00:44","2026-02-01 06:00:44","2026-02-01 06:00:44","0","https://dualdiploma.org/academica-dual-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:00:49 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14126&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14126&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /academica-dual-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.237035","0","0","0","1","0","200|0|0|https://dualdiploma.org/academica-dual-diploma/","0","0"),
("234","https://dualdiploma.org/etablissement-partenaire/#partenaires","0000-00-00 00:00:00","2026-02-01 05:59:13","2026-02-01 05:59:13","2026-02-01 05:59:13","0","https://dualdiploma.org/etablissement-partenaire/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:59:15 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14152&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14152&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /etablissement-partenaire/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.368758","0","0","0","1","0","200|0|0|https://dualdiploma.org/etablissement-partenaire/","0","0"),
("235","https://dualdiploma.org/etablissement-partenaire/#coordinateur","0000-00-00 00:00:00","2026-02-01 06:04:49","2026-02-01 06:04:49","2026-02-01 06:04:49","0","https://dualdiploma.org/etablissement-partenaire/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:04:54 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14152&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14152&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /etablissement-partenaire/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.21388","0","0","0","1","0","200|0|0|https://dualdiploma.org/etablissement-partenaire/","0","0"),
("237","https://www.stanislas-cannes.com/","0000-00-00 00:00:00","2026-02-01 07:01:11","2026-02-01 07:01:11","2026-02-01 07:01:11","0","https://www.stanislas-cannes.com/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Sun, 01 Feb 2026 07:01:18 GMT\r\ncontent-type: text/html; charset=utf-8\r\nserver: cloudflare\r\nvary: Accept-Encoding\r\nset-cookie: 2c524d0906110e7db082956d716c72b5=aataskj3a79cbmb41hul5s0c0j; path=/; secure; HttpOnly\r\np3p: CP=&quot;NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM&quot;\r\nexpires: Wed, 17 Aug 2005 00:00:00 GMT\r\nlast-modified: Sun, 01 Feb 2026 07:01:18 GMT\r\ncache-control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0\r\npragma: no-cache\r\nx-frame-options: SAMEORIGIN\r\nx-xss-protection: 1; mode=block\r\nx-content-type-options: nosniff\r\nreferrer-policy: no-referrer-when-downgrade\r\ncontent-security-policy: default-src * data: &#039;unsafe-eval&#039; &#039;unsafe-inline&#039;\r\nstrict-transport-security: max-age=31536000; includeSubDomains; preload\r\nnel: {&quot;report_to&quot;:&quot;cf-nel&quot;,&quot;success_fraction&quot;:0.0,&quot;max_age&quot;:604800}\r\ncf-cache-status: DYNAMIC\r\nreport-to: {&quot;group&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https://a.nel.cloudflare.com/report/v4?s=0M%2FECwy8tyeVvwjvBBSuRqXvaE3DAAmdyYQ2MOykiEph33P4fRHQf20h5fngsdbomdnMmGxYdbceI4qcBLzSZzzp3TXmbHtGbRI2Fc%2F17wqfVk4zU65%2BwfXmz4fby0FLuldT6w%3D%3D&quot;}]}\r\ncontent-encoding: br\r\ncf-ray: 9c6f9379692b2a32-CDG\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: www.stanislas-cannes.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","7.1141","0","0","0","1","0","200|0|0|https://www.stanislas-cannes.com/","0","0"),
("238","https://lasallemaravillas.com/","0000-00-00 00:00:00","2026-02-01 06:05:20","2026-02-01 06:05:20","2026-02-01 06:05:20","0","https://lasallemaravillas.com/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:05:23 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nx-powered-by: PHP/8.1.34\r\nlink: &lt;https://lasallemaravillas.com/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;, &lt;https://lasallemaravillas.com/wp-json/wp/v2/pages/48314&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;, &lt;https://lasallemaravillas.com/&gt;; rel=shortlink\r\nset-cookie: pll_language=es; expires=Mon, 01-Feb-2027 06:05:23 GMT; Max-Age=31536000; path=/; secure; SameSite=Lax\r\nstrict-transport-security: max-age=15768000; includeSubDomains\r\nx-powered-by: PleskLin\r\ncontent-encoding: br\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: lasallemaravillas.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","3.08079","0","0","0","1","0","200|0|0|https://lasallemaravillas.com/","0","0"),
("239","https://dualdiploma.org/decrocher-le-us-high-school-diploma-depuis-la-france-grace-au-digital/","0000-00-00 00:00:00","2026-02-01 05:59:24","2026-02-01 05:59:24","2026-02-01 05:59:24","0","https://dualdiploma.org/decrocher-le-us-high-school-diploma-depuis-la-france-grace-au-digital/","1","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 301 ===\n\nResponse headers\n================\nHTTP/2 301 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:59:29 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nexpires: Sun, 01 Feb 2026 06:59:29 GMT\r\ncache-control: max-age=3600\r\nx-redirect-by: redirection\r\nlocation: /obtenir-le-bac-americain-us-high-school-diploma-depuis-la-france-grace-au-digital/\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\n\r\nRequest headers\n================\nHEAD /decrocher-le-us-high-school-diploma-depuis-la-france-grace-au-digital/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","301","","","0.247433","0","0","0","1","0","301|0|0|https://dualdiploma.org/decrocher-le-us-high-school-diploma-depuis-la-france-grace-au-digital/","0","0"),
("260","https://dualdiploma.org/temoignages/","0000-00-00 00:00:00","2026-02-01 05:59:59","2026-02-01 05:59:59","2026-02-01 05:59:59","0","https://dualdiploma.org/temoignages/","1","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 301 ===\n\nResponse headers\n================\nHTTP/2 301 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:00:04 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nexpires: Sun, 01 Feb 2026 07:00:04 GMT\r\ncache-control: max-age=3600\r\nx-redirect-by: redirection\r\nlocation: /\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\n\r\nRequest headers\n================\nHEAD /temoignages/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","301","","","0.196342","0","0","0","1","0","301|0|0|https://dualdiploma.org/temoignages/","0","0"),
("261","https://dualdiploma.org/eleve/#suivre-en-candidat-libre","0000-00-00 00:00:00","2026-02-01 06:04:44","2026-02-01 06:04:44","2026-02-01 06:04:44","0","https://dualdiploma.org/eleve/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:04:49 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14161&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14161&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /eleve/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.356157","0","0","0","1","0","200|0|0|https://dualdiploma.org/eleve/","0","0"),
("262","https://dualdiploma.org","0000-00-00 00:00:00","2026-02-01 06:02:59","2026-02-01 06:02:59","2026-02-01 06:02:59","0","https://dualdiploma.org/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:03:04 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14254&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.210166","0","0","0","1","0","200|0|0|https://dualdiploma.org/","0","0"),
("264","https://dualdiploma.org/wp-content/uploads/2020/06/shutterstock_716924311.webp","0000-00-00 00:00:00","2026-02-01 05:59:39","2026-02-01 05:59:39","2026-02-01 05:59:39","0","https://dualdiploma.org/wp-content/uploads/2020/06/shutterstock_716924311.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:59:44 GMT\r\ncontent-type: image/webp\r\ncontent-length: 46224\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-b490&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2020/06/shutterstock_716924311.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.042188","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2020/06/shutterstock_716924311.webp","0","0"),
("265","https://dualdiploma.org/wp-content/uploads/2020/06/ave-studentsatwork-e1591349771898.webp","0000-00-00 00:00:00","2026-02-01 06:00:34","2026-02-01 06:00:34","2026-02-01 06:00:34","0","https://dualdiploma.org/wp-content/uploads/2020/06/ave-studentsatwork-e1591349771898.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:00:39 GMT\r\ncontent-type: image/webp\r\ncontent-length: 50186\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-c40a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2020/06/ave-studentsatwork-e1591349771898.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.023184","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2020/06/ave-studentsatwork-e1591349771898.webp","0","0"),
("266","https://dualdiploma.org/wp-content/uploads/2020/06/ave-lifemanagement.webp","0000-00-00 00:00:00","2026-02-01 06:04:59","2026-02-01 06:04:59","2026-02-01 06:04:59","0","https://dualdiploma.org/wp-content/uploads/2020/06/ave-lifemanagement.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:05:04 GMT\r\ncontent-type: image/webp\r\ncontent-length: 73954\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-120e2&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2020/06/ave-lifemanagement.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.025143","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2020/06/ave-lifemanagement.webp","0","0"),
("267","https://dualdiploma.org/academica-dual-diploma/#temps-de-travail-et-calendrier","0000-00-00 00:00:00","2026-02-01 06:01:44","2026-02-01 06:01:44","2026-02-01 06:01:44","0","https://dualdiploma.org/academica-dual-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:01:49 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14126&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14126&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /academica-dual-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.38319","0","0","0","1","0","200|0|0|https://dualdiploma.org/academica-dual-diploma/","0","0"),
("268","https://www.panopto.com/blog/what-is-a-flipped-classroom/","0000-00-00 00:00:00","2026-02-01 05:59:54","2026-02-01 05:59:54","2026-02-01 05:59:54","0","https://www.panopto.com/blog/what-is-a-flipped-classroom/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Sun, 01 Feb 2026 05:59:54 GMT\r\ncontent-type: text/html; charset=UTF-8\r\ncontent-encoding: br\r\nvary: Accept-Encoding\r\nvary: Accept-Encoding\r\nvary: Accept-Encoding\r\nvary: Accept-Encoding,Cookie\r\ncf-edge-cache: cache,platform=wordpress\r\nlink: &lt;https://www.panopto.com/?p=845&gt;; rel=shortlink\r\nx-powered-by: WP Engine\r\nx-cacheable: SHORT\r\ncache-control: max-age=600, must-revalidate\r\nx-cache: HIT: 1\r\nx-cache-group: normal\r\nx-xss-protection: 1; mode=block\r\nx-content-type-options: nosniff\r\nreferrer-policy: no-referrer-when-downgrade\r\nstrict-transport-security: max-age=31536000; includeSubDomains; preload\r\ncontent-security-policy: upgrade-insecure-requests\r\nx-frame-options: ALLOW-FROM https://pro.panopto.com\r\ncf-cache-status: DYNAMIC\r\nset-cookie: __cf_bm=9c_ESGOiYpPjDnVfhtp5aUsQC9LdPYO8vU19o5V1kMA-1769925594-1.0.1.1-N22lvhkRK724.tX58KXoBxj3sd68IYNrdHWuG9Y5Qx_uaqAKCM.VsatetFzmt_Fhn8HHL1z2odDOCVt3gsbypfDnoIy5Bd9odmNLbcDTWwI; path=/; expires=Sun, 01-Feb-26 06:29:54 GMT; domain=.www.panopto.com; HttpOnly; Secure; SameSite=None\r\nserver: cloudflare\r\ncf-ray: 9c6f39b7af586056-CDG\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nHEAD /blog/what-is-a-flipped-classroom/ HTTP/2\r\nHost: www.panopto.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.234634","0","0","0","1","0","200|0|0|https://www.panopto.com/blog/what-is-a-flipped-classroom/","0","0"),
("269","https://dualdiploma.org/wp-content/uploads/2020/06/20230707-academica_ceremonie-191-2-benjaminbocquet-copy1-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 05:59:15","2026-02-01 05:59:15","2026-02-01 05:59:15","0","https://dualdiploma.org/wp-content/uploads/2020/06/20230707-academica_ceremonie-191-2-benjaminbocquet-copy1-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:59:19 GMT\r\ncontent-type: image/webp\r\ncontent-length: 935910\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-e47e6&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2020/06/20230707-academica_ceremonie-191-2-benjaminbocquet-copy1-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.148021","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2020/06/20230707-academica_ceremonie-191-2-benjaminbocquet-copy1-scaled-1.webp","0","0"),
("270","https://dualdiploma.org/wp-content/uploads/2020/06/dual-diploma-academica-france-us-flag.webp","0000-00-00 00:00:00","2026-02-01 06:03:19","2026-02-01 06:03:19","2026-02-01 06:03:19","0","https://dualdiploma.org/wp-content/uploads/2020/06/dual-diploma-academica-france-us-flag.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:03:24 GMT\r\ncontent-type: image/webp\r\ncontent-length: 31526\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-7b26&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2020/06/dual-diploma-academica-france-us-flag.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.022052","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2020/06/dual-diploma-academica-france-us-flag.webp","0","0"),
("271","https://dualdiploma.org/wp-content/uploads/2020/06/drapeau-americain-ceremonie-graduation-2023-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:58:46","2026-02-01 06:58:46","2026-02-01 06:58:46","0","https://dualdiploma.org/wp-content/uploads/2020/06/drapeau-americain-ceremonie-graduation-2023-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:58:48 GMT\r\ncontent-type: image/webp\r\ncontent-length: 164748\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-2838c&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2020/06/drapeau-americain-ceremonie-graduation-2023-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.026763","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2020/06/drapeau-americain-ceremonie-graduation-2023-scaled-1.webp","0","0"),
("272","https://www.youtube.com/watch?v=9W3MI2Qd1UY","0000-00-00 00:00:00","2026-02-02 23:48:30","2026-02-02 23:48:30","2026-02-02 23:48:30","0","https://www.youtube.com/watch?v=9W3MI2Qd1UY","0","<em>(Using YouTube API)</em>\n\n403 Forbidden\nUnknown YouTube API response received.\n---\nmessage: Method doesn&#039;t allow unregistered callers (callers without established identity). Please use API Key or other form of API consumer identity to call this API.\ndomain: global\nreason: forbidden\n\nLe lien est valide.","403","warning","forbidden","0.063192","0","0","0","1","0","youtube|403|0|0|-|-","1","0"),
("273","https://dualdiploma.org/academica-dual-diploma/#graduation","0000-00-00 00:00:00","2026-02-01 05:59:49","2026-02-01 05:59:49","2026-02-01 05:59:49","0","https://dualdiploma.org/academica-dual-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:59:54 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14126&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14126&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /academica-dual-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.23441","0","0","0","1","0","200|0|0|https://dualdiploma.org/academica-dual-diploma/","0","0"),
("277","https://dualdiploma.org/wp-content/uploads/2020/11/photo-christine-mariotti-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:00:54","2026-02-01 06:00:54","2026-02-01 06:00:54","0","https://dualdiploma.org/wp-content/uploads/2020/11/photo-christine-mariotti-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:00:59 GMT\r\ncontent-type: image/webp\r\ncontent-length: 341332\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-53554&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2020/11/photo-christine-mariotti-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.037875","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2020/11/photo-christine-mariotti-scaled-1.webp","0","0"),
("278","https://www.aisvirtual.com/ourpages/auto/2016/2/25/72758904/Dual%20Diploma%20Times%20Issue%2013th%20Edition.pdf?rnd=1609939582000","2026-01-26 10:38:31","2026-02-01 11:48:26","2026-01-23 10:38:30","2026-02-01 11:48:26","5","https://www.aisvirtual.com/ourpages/auto/2016/2/25/72758904/Dual%20Diploma%20Times%20Issue%2013th%20Edition.pdf?rnd=1609939582000","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 404 ===\n\nResponse headers\n================\nHTTP/1.1 404 Not Found\r\nContent-Type: text/html\r\nServer: Microsoft-IIS/8.5\r\nX-Powered-By: ASP.NET\r\nX-Powered-By: ARR/3.0\r\nDate: Sun, 01 Feb 2026 11:48:26 GMT\r\nConnection: close\r\nContent-Length: 1245\r\n\r\nRequest headers\n================\nGET /ourpages/auto/2016/2/25/72758904/Dual%20Diploma%20Times%20Issue%2013th%20Edition.pdf?rnd=1609939582000 HTTP/1.1\r\nHost: www.aisvirtual.com\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://dualdiploma.org\r\nConnection: close\r\nRange: bytes=0-2048\r\n\r\nResponse HTML\n================\n&lt;!DOCTYPE html PUBLIC &quot;-//W3C//DTD XHTML 1.0 Strict//EN&quot; &quot;http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd&quot;&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;\r\n&lt;head&gt;\r\n&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=iso-8859-1&quot;/&gt;\r\n&lt;title&gt;404 - File or directory not found.&lt;/title&gt;\r\n&lt;style type=&quot;text/css&quot;&gt;\r\n&lt;!--\r\nbody{margin:0;font-size:.7em;font-family:Verdana, Arial, Helvetica, sans-serif;background:#EEEEEE;}\r\nfieldset{padding:0 15px 10px 15px;} \r\nh1{font-size:2.4em;margin:0;color:#FFF;}\r\nh2{font-size:1.7em;margin:0;color:#CC0000;} \r\nh3{font-size:1.2em;margin:10px 0 0 0;color:#000000;} \r\n#header{width:96%;margin:0 0 0 0;padding:6px 2% 6px 2%;font-family:&quot;trebuchet MS&quot;, Verdana, sans-serif;color:#FFF;\r\nbackground-color:#555555;}\r\n#content{margin:0 0 0 2%;position:relative;}\r\n.content-container{background:#FFF;width:96%;margin-top:8px;padding:10px;position:relative;}\r\n--&gt;\r\n&lt;/style&gt;\r\n&lt;/head&gt;\r\n&lt;body&gt;\r\n&lt;div id=&quot;header&quot;&gt;&lt;h1&gt;Server Error&lt;/h1&gt;&lt;/div&gt;\r\n&lt;div id=&quot;content&quot;&gt;\r\n &lt;div class=&quot;content-container&quot;&gt;&lt;fieldset&gt;\r\n  &lt;h2&gt;404 - File or directory not found.&lt;/h2&gt;\r\n  &lt;h3&gt;The resource you are looking for might have been removed, had its name changed, or is temporarily unavailable.&lt;/h3&gt;\r\n &lt;/fieldset&gt;&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;/body&gt;\r\n&lt;/html&gt;\r\n\nLe lien est cassé.","404","","","0.506722","0","1","0","1","0","404|broken|0|https://www.aisvirtual.com/ourpages/auto/2016/2/25/72758904/Dual%20Diploma%20Times%20Issue%2013th%20Edition.pdf","0","0"),
("279","https://www.aisvirtual.com/apps/pages/index.jsp?uREC_ID=300445&type=d","2026-01-26 10:38:30","2026-02-01 11:48:25","2026-01-23 10:38:29","2026-02-01 11:48:25","5","https://www.aisvirtual.com/apps/pages/index.jsp?uREC_ID=300445&type=d","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 404 ===\n\nResponse headers\n================\nHTTP/1.1 404 Not Found\r\nContent-Type: text/html\r\nServer: Microsoft-IIS/8.5\r\nX-Powered-By: ASP.NET\r\nX-Powered-By: ARR/3.0\r\nDate: Sun, 01 Feb 2026 11:48:24 GMT\r\nConnection: close\r\nContent-Length: 1245\r\n\r\nRequest headers\n================\nGET /apps/pages/index.jsp?uREC_ID=300445&amp;type=d HTTP/1.1\r\nHost: www.aisvirtual.com\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://dualdiploma.org\r\nConnection: close\r\nRange: bytes=0-2048\r\n\r\nResponse HTML\n================\n&lt;!DOCTYPE html PUBLIC &quot;-//W3C//DTD XHTML 1.0 Strict//EN&quot; &quot;http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd&quot;&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;\r\n&lt;head&gt;\r\n&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=iso-8859-1&quot;/&gt;\r\n&lt;title&gt;404 - File or directory not found.&lt;/title&gt;\r\n&lt;style type=&quot;text/css&quot;&gt;\r\n&lt;!--\r\nbody{margin:0;font-size:.7em;font-family:Verdana, Arial, Helvetica, sans-serif;background:#EEEEEE;}\r\nfieldset{padding:0 15px 10px 15px;} \r\nh1{font-size:2.4em;margin:0;color:#FFF;}\r\nh2{font-size:1.7em;margin:0;color:#CC0000;} \r\nh3{font-size:1.2em;margin:10px 0 0 0;color:#000000;} \r\n#header{width:96%;margin:0 0 0 0;padding:6px 2% 6px 2%;font-family:&quot;trebuchet MS&quot;, Verdana, sans-serif;color:#FFF;\r\nbackground-color:#555555;}\r\n#content{margin:0 0 0 2%;position:relative;}\r\n.content-container{background:#FFF;width:96%;margin-top:8px;padding:10px;position:relative;}\r\n--&gt;\r\n&lt;/style&gt;\r\n&lt;/head&gt;\r\n&lt;body&gt;\r\n&lt;div id=&quot;header&quot;&gt;&lt;h1&gt;Server Error&lt;/h1&gt;&lt;/div&gt;\r\n&lt;div id=&quot;content&quot;&gt;\r\n &lt;div class=&quot;content-container&quot;&gt;&lt;fieldset&gt;\r\n  &lt;h2&gt;404 - File or directory not found.&lt;/h2&gt;\r\n  &lt;h3&gt;The resource you are looking for might have been removed, had its name changed, or is temporarily unavailable.&lt;/h3&gt;\r\n &lt;/fieldset&gt;&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;/body&gt;\r\n&lt;/html&gt;\r\n\nLe lien est cassé.","404","","","0.512285","0","1","0","1","0","404|broken|0|https://www.aisvirtual.com/apps/pages/index.jsp","0","0"),
("280","https://dualdiploma.org/wp-content/uploads/2021/03/elias.webp","0000-00-00 00:00:00","2026-02-01 06:59:31","2026-02-01 06:59:31","2026-02-01 06:59:31","0","https://dualdiploma.org/wp-content/uploads/2021/03/elias.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:59:36 GMT\r\ncontent-type: image/webp\r\ncontent-length: 57904\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-e230&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/03/elias.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.03619","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/03/elias.webp","0","0"),
("281","https://dualdiploma.org/documentation/","0000-00-00 00:00:00","2026-02-01 06:02:49","2026-02-01 06:02:49","2026-02-01 06:02:49","0","https://dualdiploma.org/documentation/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:02:54 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14231&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14231&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /documentation/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.320284","0","0","0","1","0","200|0|0|https://dualdiploma.org/documentation/","0","0"),
("282","https://dualdiploma.org/wp-content/uploads/2021/04/photography.webp","0000-00-00 00:00:00","2026-02-01 07:03:11","2026-02-01 07:03:11","2026-02-01 07:03:11","0","https://dualdiploma.org/wp-content/uploads/2021/04/photography.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:03:16 GMT\r\ncontent-type: image/webp\r\ncontent-length: 19582\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-4c7e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/04/photography.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.022313","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/04/photography.webp","0","0"),
("283","https://dualdiploma.org/wp-content/uploads/2021/04/aperture.webp","0000-00-00 00:00:00","2026-02-01 06:02:14","2026-02-01 06:02:14","2026-02-01 06:02:14","0","https://dualdiploma.org/wp-content/uploads/2021/04/aperture.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:02:19 GMT\r\ncontent-type: image/webp\r\ncontent-length: 18338\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-47a2&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/04/aperture.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020125","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/04/aperture.webp","0","0"),
("284","https://dualdiploma.org/wp-content/uploads/2021/04/shutter-speed.webp","0000-00-00 00:00:00","2026-02-01 07:02:16","2026-02-01 07:02:16","2026-02-01 07:02:16","0","https://dualdiploma.org/wp-content/uploads/2021/04/shutter-speed.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:02:21 GMT\r\ncontent-type: image/webp\r\ncontent-length: 30130\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-75b2&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/04/shutter-speed.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.025726","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/04/shutter-speed.webp","0","0"),
("285","https://dualdiploma.org/wp-content/uploads/2021/04/xmib27c74cb7ab171ae4fcf2c7aeed6c_259427471.webp","0000-00-00 00:00:00","2026-02-01 07:03:06","2026-02-01 07:03:06","2026-02-01 07:03:06","0","https://dualdiploma.org/wp-content/uploads/2021/04/xmib27c74cb7ab171ae4fcf2c7aeed6c_259427471.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:03:11 GMT\r\ncontent-type: image/webp\r\ncontent-length: 58992\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-e670&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/04/xmib27c74cb7ab171ae4fcf2c7aeed6c_259427471.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.033184","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/04/xmib27c74cb7ab171ae4fcf2c7aeed6c_259427471.webp","0","0"),
("286","https://dualdiploma.org/wp-content/uploads/2021/04/hnmm7b43b1e6544f02e9cdc6771e8109_435927403.webp","0000-00-00 00:00:00","2026-02-01 06:04:29","2026-02-01 06:04:29","2026-02-01 06:04:29","0","https://dualdiploma.org/wp-content/uploads/2021/04/hnmm7b43b1e6544f02e9cdc6771e8109_435927403.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:04:34 GMT\r\ncontent-type: image/webp\r\ncontent-length: 43358\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-a95e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/04/hnmm7b43b1e6544f02e9cdc6771e8109_435927403.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.044159","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/04/hnmm7b43b1e6544f02e9cdc6771e8109_435927403.webp","0","0"),
("287","https://dualdiploma.org/wp-content/uploads/2021/04/extrait-cours-digital-photography.webp","0000-00-00 00:00:00","2026-02-01 06:00:19","2026-02-01 06:00:19","2026-02-01 06:00:19","0","https://dualdiploma.org/wp-content/uploads/2021/04/extrait-cours-digital-photography.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:00:24 GMT\r\ncontent-type: image/webp\r\ncontent-length: 26290\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-66b2&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/04/extrait-cours-digital-photography.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.021501","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/04/extrait-cours-digital-photography.webp","0","0"),
("288","https://dualdiploma.org/wp-content/uploads/2021/04/extrait-cours-digital-photography-2.webp","0000-00-00 00:00:00","2026-02-01 07:00:01","2026-02-01 07:00:01","2026-02-01 07:00:01","0","https://dualdiploma.org/wp-content/uploads/2021/04/extrait-cours-digital-photography-2.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:00:06 GMT\r\ncontent-type: image/webp\r\ncontent-length: 24018\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-5dd2&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/04/extrait-cours-digital-photography-2.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024128","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/04/extrait-cours-digital-photography-2.webp","0","0"),
("289","https://dualdiploma.org/wp-content/uploads/2021/05/dual_diploma_high-bac-american-flag.webp","0000-00-00 00:00:00","2026-02-01 05:59:54","2026-02-01 05:59:54","2026-02-01 05:59:54","0","https://dualdiploma.org/wp-content/uploads/2021/05/dual_diploma_high-bac-american-flag.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:59:59 GMT\r\ncontent-type: image/webp\r\ncontent-length: 29706\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-740a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/05/dual_diploma_high-bac-american-flag.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038642","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/05/dual_diploma_high-bac-american-flag.webp","0","0"),
("290","https://dualdiploma.org/wp-content/uploads/2020/06/shutterstock_179296106.webp","0000-00-00 00:00:00","2026-02-01 06:01:39","2026-02-01 06:01:39","2026-02-01 06:01:39","0","https://dualdiploma.org/wp-content/uploads/2020/06/shutterstock_179296106.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:01:44 GMT\r\ncontent-type: image/webp\r\ncontent-length: 32158\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-7d9e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2020/06/shutterstock_179296106.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.023422","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2020/06/shutterstock_179296106.webp","0","0"),
("292","https://dualdiploma.org/wp-content/uploads/2021/10/brett-jordan-d44kht8ex14-unsplash-copie-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:01:19","2026-02-01 06:01:19","2026-02-01 06:01:19","0","https://dualdiploma.org/wp-content/uploads/2021/10/brett-jordan-d44kht8ex14-unsplash-copie-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:01:24 GMT\r\ncontent-type: image/webp\r\ncontent-length: 136900\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-216c4&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/10/brett-jordan-d44kht8ex14-unsplash-copie-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024817","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/10/brett-jordan-d44kht8ex14-unsplash-copie-scaled-1.webp","0","0"),
("293","https://dualdiploma.org/wp-content/uploads/2021/10/life-management-skills.webp","0000-00-00 00:00:00","2026-02-01 06:03:59","2026-02-01 06:03:59","2026-02-01 06:03:59","0","https://dualdiploma.org/wp-content/uploads/2021/10/life-management-skills.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:04:04 GMT\r\ncontent-type: image/webp\r\ncontent-length: 22748\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-58dc&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/10/life-management-skills.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.021036","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/10/life-management-skills.webp","0","0"),
("294","https://dualdiploma.org/wp-content/uploads/2021/10/brendan-church-pkef6tt3c08-unsplash-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:00:59","2026-02-01 06:00:59","2026-02-01 06:00:59","0","https://dualdiploma.org/wp-content/uploads/2021/10/brendan-church-pkef6tt3c08-unsplash-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:01:04 GMT\r\ncontent-type: image/webp\r\ncontent-length: 244862\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-3bc7e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/10/brendan-church-pkef6tt3c08-unsplash-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.01955","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/10/brendan-church-pkef6tt3c08-unsplash-scaled-1.webp","0","0"),
("296","https://www.collegeboard.org/","0000-00-00 00:00:00","2026-02-01 06:01:59","2026-02-01 06:01:59","2026-02-01 06:01:59","0","https://www.collegeboard.org/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ncontent-type: text/html; charset=UTF-8\r\ncontent-length: 8513\r\nx-drupal-dynamic-cache: UNCACHEABLE (poor cacheability)\r\ncontent-language: en\r\nx-content-type-options: nosniff\r\nx-generator: Drupal 10 (https://www.drupal.org)\r\ncontent-security-policy: default-src &#039;self&#039; *.collegeboard.org; connect-src &#039;self&#039; ws: *.collegeboard.org k625k2vrzvdo5g7ynbvtjejehi.appsync-api.us-east-1.amazonaws.com/graphql dgtkl2ep7natjmkbefhxflglie.appsync-api.us-east-1.amazonaws.com/graphql cdn.cookielaw.org geolocation.onetrust.com lambda.us-east-1.amazonaws.com bam.nr-data.net cdn.aimtell.io cognito-identity.us-east-1.amazonaws.com sts.us-east-1.amazonaws.com www.google.com privacyportal.onetrust.com apform.secure.force.com cdnm3.cdnservice.space/start5.json code.jquery.com api.trongrid.io/wallet/getnodeinfo dgtkl2ep7natjmkbefhxflglie.appsync-api.us-east-1.amazonaws.com dgtkl2ep7natjmkbefhxflglie.appsync-realtime-api.us-east-1.amazonaws.com analytics.aimtell.com sts.us-west-2.amazonaws.com cognito-identity.us-west-2.amazonaws.com d1ktxyteejjrbw.cloudfront.net full-apform.cs190.force.com yt3.ggpht.com collegeboard-full.my.salesforce.com i.ytimg.com cdn.ckeditor.com telemetry.wiris.net wiris-v7.hive-prod.collegeboard.org:80 wiris-v7.hive-nonprod.collegeboard.org:80 *.appcues.com *.appcues.net *.my.salesforce-sites.com ipapi.co 9frgh2i4b9.execute-api.us-east-1.amazonaws.com collegeboard--full.sandbox.my.salesforce-scrt.com collegeboard.my.salesforce-scrt.com signals.aimtell.com api.getambassador.com pagead2.googlesyndication.com *.googlevideo.com/videoplayback www.googleadservices.com google.com cs-chat.crmlms-prod.collegeboard.org; font-src &#039;self&#039; *.collegeboard.org themes.googleusercontent.com fonts.gstatic.com data: moz-extension: use.fontawesome.com static3.avast.com at.alicdn.com cdn.loom.com/assets/fonts/ wiris-v7.hive-prod.collegeboard.org:80 wiris-v7.hive-nonprod.collegeboard.org:80 cdnjs.cloudflare.com/ajax/libs/mathjax/3.2.2/es5/output/chtml/fonts/woff-v2/; frame-src &#039;self&#039; *.collegeboard.org service.force.com beacon.aimtell.com datacloudstat.com www.youtube.com ws-lmdc-app03.dhs.state.nj.us gateway.zscloud.net mozbar.moz.com *.id.opendns.com lsrelay-config-production.s3.amazonaws.com pg-sasscer-ckf04.pgcps.org static.deledao.com data: schools-blocked.s3-website-us-east-1.amazonaws.com calendly.com platform.twitter.com *.appcues.com credentialfinder.org apps.credentialengine.org *.webcasts.com td.doubleclick.net www.googletagmanager.com cb-zscaler-pages.s3.amazonaws.com us-east-1.quicksight.aws.amazon.com www.buzzsprout.com cdn.aimtell.com collegeboard--full.sandbox.my.site.com collegeboard.my.site.com; img-src &#039;self&#039; *.collegeboard.org data: www.google.com googleads.g.doubleclick.net www.googletagmanager.com www.google.co.jp www.google.ca www.google.co www.google.jo translate.google.com d10lpsik1i8c69.cloudfront.net *.appcues.com res.cloudinary.com twemoji.maxcdn.com cdn.cookielaw.org signals.aimtell.com pagead2.googlesyndication.com www.googleadservices.com google.com img.youtube.com i.ytimg.com; script-src &#039;self&#039; &#039;unsafe-inline&#039; &#039;unsafe-eval&#039; *.collegeboard.org cdnjs.cloudflare.com sdk.amazonaws.com cdn.cookielaw.org www.googletagmanager.com googleads.g.doubleclick.net www.googleadservices.com connect.facebook.net www.youtube.com *.salesforceliveagent.com service.force.com ajax.cloudflare.com js-agent.newrelic.com bam.nr-data.net d10lpsik1i8c69.cloudfront.net s3.amazonaws.com/cdn.aimtell.com/ www.google.com static.lightning.force.com *.my.salesforce.com *.my.salesforce-sites.com apform.secure.force.com www.pagespeed-mod.com cdn.ckeditor.com cdnjs.cloudflare.com/ajax/libs/cropper/4.0.0/cropper.min.js assets.calendly.com platform.twitter.com *.appcues.com cb-zscaler-pages.s3.amazonaws.com www.buzzsprout.com cdn.jsdelivr.net/npm/js-cookie@3.0.5/dist/js.cookie.min.js collegeboard--full.sandbox.my.site.com collegeboard.my.site.com cdn.aimtell.com client.rum.us-east-1.amazonaws.com/1.0.2/cwr.js cdn.jsdelivr.net/npm/@fingerprintjs/fingerprintjs@3.3.2/dist/fp.js pagead2.googlesyndication.com blue.mbsy.co https://athena.collegeboard.org/2.2.4/cbw-widgets.min.js https://atlas.collegeboard.org/apricot/prod/4.10.6/dx_profile.js https://atlas.collegeboard.org/apricot/prod/4.10.6/main.min.js https://bigfuture.collegeboard.org/widgets/v2/CollegeSearchAndSaveTypeahead.js https://cdn.jsdelivr.net/npm/html2canvas@1.3.2/dist/html2canvas.min.js https://cdn.jsdelivr.net/npm/js-cookie@3.0.5/dist/js.cookie.min.js https://cdnjs.cloudflare.com/ajax/libs/cropper/4.0.0/cropper.min.js https://cdnjs.cloudflare.com/ajax/libs/mathjax/3.2.2/es5/tex-mml-chtml.js https://github.com/mattfarina/farbtastic/blob/master/src/farbtastic.js; style-src &#039;self&#039; &#039;unsafe-inline&#039; *.collegeboard.org service.force.com translate.googleapis.com use.fontawesome.com apform.secure.force.com *.my.salesforce-sites.com d10lpsik1i8c69.cloudfront.net/css/reset.css fonts.googleapis.com cdn.ckeditor.com cdnjs.cloudflare.com/ajax/libs/cropper/4.0.0/cropper.min.css wiris-v7.hive-prod.collegeboard.org:80 wiris-v7.hive-nonprod.collegeboard.org:80 *.appcues.com fonts.google.com collegeboard--full.sandbox.my.site.com collegeboard.my.site.com cdn.cookielaw.org https://atlas.collegeboard.org/apricot/prod/4.10.6/athena.min.css https://atlas.collegeboard.org/apricot/prod/4.10.6/dx_ckeditor.min.css https://atlas.collegeboard.org/apricot/prod/4.10.6/dx_profile.css https://atlas.collegeboard.org/apricot/prod/4.10.6/illustrations.css https://atlas.collegeboard.org/apricot/prod/4.10.6/main.min.css https://atlas.collegeboard.org/apricot/prod/4.6.1/org.css https://cdnjs.cloudflare.com/ajax/libs/cropper/4.0.0/cropper.min.css; frame-ancestors &#039;self&#039; credentialfinder.org; report-uri https://endpoint5.collection.us2.sumologic.com/receiver/v1/http/ZaVnC4dhaV0RBARw3e7I1maofn0rkqtWoPBPNh0wBLdICmPwpVd0aV427YIAMoG3\r\nx-drupal-cache: MISS\r\nlast-modified: Fri, 23 Jan 2026 16:43:50 GMT\r\netag: &quot;1769186630-gzip&quot;\r\ncontent-encoding: gzip\r\nx-request-id: v-b1caa33e-f87a-11f0-9ed2-9789e1f4e0d7\r\nx-ah-environment: prod\r\nx-cache-hits: 24\r\nx-age: 29\r\naccept-ranges: bytes\r\ncache-control: public, max-age=2764800\r\nexpires: Thu, 05 Mar 2026 06:01:59 GMT\r\ndate: Sun, 01 Feb 2026 06:01:59 GMT\r\nvary: Accept-Encoding\r\nstrict-transport-security: max-age=31536000 ; includeSubDomains\r\nx-xss-protection: 1; mode=block\r\nx-frame-options: SAMEORIGIN\r\naccess-control-allow-origin: *\r\nset-cookie: _abck=1C77833D0DED8DAE152B5110C30FF9B8~-1~YAAQ4dhLF6m9fdmbAQAAEDfLFw+/4UzTTzCmkt/wGUJBz57bVUYG74WfmR0muBMzamSQYoNZ0H7SDZ5bkC4+wXkXP5HrPjJJ/Zwa9oLhJLJCgEwUC2EDLcxwplYOJCWqsRAqfAzG3dS/2SARNVcS4+WvXRTN/7nBfkuhj4dmn5GYJiiyM4+VAvJ3YE29BnEb7lEvxlKlpigXxqg83O8KWi8X4bL4mjNM1fIf1rie8I3I5sg9mJm1Ahj+qW7PJIHTjNMirFjurQtTQY643DYTXNSG8ZqGfMK2UPQD5mr6GO0QNkTJxEC0NKpdC/td8FrkB3z6AmHXNDbVLAZSn/EWvwdktTpCayq9DKBozmIMyQ59CFKnIapOn42KHlf68Vf6Dkg8ZMl9q2RI0LTRCDP75Wgn8sy0amJlNtTtbL1MGBSWww5WoswbVnp4u7OklA60kQmQMGhIy+EyDYI=~-1~-1~-1~-1~-1; Domain=.collegeboard.org; Path=/; Expires=Mon, 01 Feb 2027 06:01:59 GMT; Max-Age=31536000; Secure\r\nset-cookie: bm_sz=1FB1709E783D136E5CA9DCF581180337~YAAQ4dhLF6q9fdmbAQAAEDfLFx4oq/C6i3hs85oVfhOBZ69/HZV3PYi8zmpVVjTIR9/3Uaipmx5hCxMc8r8X/VkFiS23icT0l4cl18P+VnpvN6J5M4VagUtVZJUPGXBbzwk8wClbzL5UHw7dI5EIfs4vrJMljjpqk76z2zeqK5zbEYM1DT45sVs5iImC6fR4jITG8vtW9yRS72VxZTOhJIkCdNV0wORqm4fd8Ez3KnN0SjkJET5THZ7bivwmG6n6Li5Se7wEfaEfkscGazWyIBh8YRoSkHzk7rSVGAYSh+cgoE7Qb78QrleXH9Hqbd73Ltu9zdzbCRo3qIHqwLxfhyN7EGtfk7Ktrn/AYQW6ccPVVdJm7jtR0nXQo5c=~3228993~3225670; Domain=.collegeboard.org; Path=/; Expires=Sun, 01 Feb 2026 10:01:59 GMT; Max-Age=14400\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: www.collegeboard.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.07668","0","0","0","1","0","200|0|0|https://www.collegeboard.org/","0","0"),
("297","https://prepexpert.com/sat-time-breakdown-with-breaks/","0000-00-00 00:00:00","2026-02-01 07:03:01","2026-02-01 07:03:01","2026-02-01 07:03:01","0","https://prepexpert.com/sat-time-breakdown-with-breaks/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Sun, 01 Feb 2026 07:03:01 GMT\r\ncontent-type: text/html; charset=UTF-8\r\ncontent-encoding: br\r\nvary: Accept-Encoding\r\nvary: Accept-Encoding\r\nvary: Accept-Encoding\r\nvary: Accept-Encoding,Cookie\r\nexpires: Thu, 19 Nov 1981 08:52:00 GMT\r\nlink: &lt;https://prepexpert.com/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://prepexpert.com/wp-json/wp/v2/posts/81075&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://prepexpert.com/?p=81075&gt;; rel=shortlink\r\npragma: no-cache\r\nx-powered-by: WP Engine\r\nx-cacheable: SHORT\r\ncache-control: max-age=600, must-revalidate\r\nx-cache: HIT: 1\r\nx-cache-group: normal\r\ncf-cache-status: DYNAMIC\r\nset-cookie: __cf_bm=1u7qZefrA9r8f1gbgsmpelhIAi.qbNDCFnQJyIRjTYw-1769929381-1.0.1.1-QnhU4s65kMUpHxFfG54OAoNqkP0ukTXNt7IerJTZJeFtGGNCT.dgVSSLnqElhmHilc4iNkRf3B8IdjCM7U220SEkEOmxcLyQM29FLsPnrSE; path=/; expires=Sun, 01-Feb-26 07:33:01 GMT; domain=.prepexpert.com; HttpOnly; Secure; SameSite=None\r\nserver: cloudflare\r\ncf-ray: 9c6f9628e97fd7e7-CDG\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nHEAD /sat-time-breakdown-with-breaks/ HTTP/2\r\nHost: prepexpert.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.260955","0","0","0","1","0","200|0|0|https://prepexpert.com/sat-time-breakdown-with-breaks/","0","0"),
("298","https://www.act.org/","0000-00-00 00:00:00","2026-02-01 06:02:09","2026-02-01 06:02:09","2026-02-01 06:02:09","0","https://www.act.org/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/1.1 200 OK\r\nContent-Type: text/html;charset=utf-8\r\nContent-Length: 15015\r\nConnection: close\r\nDate: Sun, 01 Feb 2026 06:02:09 GMT\r\nAccess-Control-Expose-Headers: CloudFront-Viewer-Country\r\nServer: Apache\r\nX-Dispatcher: dispatcher2useast1-28483413\r\nX-Vhost: publish\r\nX-Content-Type-Options: nosniff\r\nLast-Modified: Fri, 30 Jan 2026 21:37:41 GMT\r\nAccept-Ranges: bytes\r\nContent-Encoding: gzip\r\nX-Frame-Options: SAMEORIGIN\r\nETag: &quot;176fd-649a1c8747a9b-gzip&quot;\r\nVary: Accept-Encoding,Origin\r\nX-Cache: Miss from cloudfront\r\nVia: 1.1 173e1f9e40c2df572d404097afea2570.cloudfront.net (CloudFront)\r\nX-Amz-Cf-Pop: FRA56-P15\r\nX-Amz-Cf-Id: Bl_hOhuoeSUEeAUYmR_jrOOSsmh0VN9Oq7wTYgjVk0QFE5EqdLHwZQ==\r\n\r\nRequest headers\n================\nHEAD / HTTP/1.1\r\nHost: www.act.org\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://dualdiploma.org\r\nConnection: close\r\n\r\n\nLe lien est valide.","200","","","0.251671","0","0","0","1","0","200|0|0|https://www.act.org/","0","0"),
("299","https://www.princetonreview.com/college-advice/how-long-is-the-act#:~:text=The%20ACT%20is%203%20hours,over%204%20hours%20with%20breaks","0000-00-00 00:00:00","2026-02-01 07:04:01","2026-02-01 07:04:01","2026-02-01 07:04:01","0","https://www.princetonreview.com/college-advice/how-long-is-the-act","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ncontent-type: text/html; charset=utf-8\r\ncache-control: private, max-age=7200\r\nserver: Microsoft-IIS/10.0\r\nx-aspnetmvc-version: 5.2\r\nx-aspnet-version: 4.0.30319\r\nx-powered-by: ASP.NET\r\nvary: Accept-Encoding\r\ncontent-encoding: gzip\r\ndate: Sun, 01 Feb 2026 07:04:01 GMT\r\ncontent-length: 58226\r\nstrict-transport-security: max-age=31536000 ; includeSubDomains\r\n\r\nRequest headers\n================\nHEAD /college-advice/how-long-is-the-act HTTP/2\r\nHost: www.princetonreview.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.094321","0","0","0","1","0","200|0|0|https://www.princetonreview.com/college-advice/how-long-is-the-act","0","0"),
("300","https://dualdiploma.org/wp-content/uploads/2024/04/clayton-robbins-ihqb-c8c7bc-unsplash-scaled-1-800x533.webp","0000-00-00 00:00:00","2026-02-01 06:00:39","2026-02-01 06:00:39","2026-02-01 06:00:39","0","https://dualdiploma.org/wp-content/uploads/2024/04/clayton-robbins-ihqb-c8c7bc-unsplash-scaled-1-800x533.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:00:44 GMT\r\ncontent-type: image/webp\r\ncontent-length: 19140\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-4ac4&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/clayton-robbins-ihqb-c8c7bc-unsplash-scaled-1-800x533.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.026171","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/clayton-robbins-ihqb-c8c7bc-unsplash-scaled-1-800x533.webp","0","0"),
("301","https://dualdiploma.org/wp-content/uploads/2021/10/brett-jordan-kuemuodzepy-unsplash.webp","0000-00-00 00:00:00","2026-02-01 07:03:56","2026-02-01 07:03:56","2026-02-01 07:03:56","0","https://dualdiploma.org/wp-content/uploads/2021/10/brett-jordan-kuemuodzepy-unsplash.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:04:01 GMT\r\ncontent-type: image/webp\r\ncontent-length: 234798\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-3952e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/10/brett-jordan-kuemuodzepy-unsplash.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.0416","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/10/brett-jordan-kuemuodzepy-unsplash.webp","0","0"),
("303","https://concours-advance.fr/admission-post-bac/metiers-apres-ecole-ingenieur/","0000-00-00 00:00:00","2026-02-01 07:01:01","2026-02-01 07:01:01","2026-02-01 07:01:01","0","https://concours-advance.fr/admission-post-bac/metiers-apres-ecole-ingenieur/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 308 ===\n\nResponse headers\n================\nHTTP/2 308 \r\ndate: Sun, 01 Feb 2026 07:01:02 GMT\r\ncontent-length: 18\r\nlocation: https://www.concours-advance.fr/admission-post-bac/metiers-apres-ecole-ingenieur/\r\npermissions-policy: ambient-light-sensor=(), autoplay=(&#039;self&#039;), accelerometer=(), battery=(), camera=(), display-capture=(&#039;self&#039;), document-domain=(), fullscreen=(), geolocation=(), magnetometer=(), microphone=(), picture-in-picture=(&#039;self&#039;), screen-wake-lock=(), usb=(&#039;self&#039;), wake-lock=(), web-share=(&#039;self&#039;)\r\nreferrer-policy: strict-origin-when-cross-origin\r\nx-content-type-options: nosniff\r\nx-frame-options: SAMEORIGIN\r\ncf-cache-status: DYNAMIC\r\nreport-to: {&quot;group&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https://a.nel.cloudflare.com/report/v4?s=OR4pJ%2BhvKfaCagKF%2B6ThN2XKLq4sXVgrYr2jMVtPIbfy7qCuz0dS%2F3SJbA6EdUZOVTd7CzQ9b1fxV1jp16%2Bnz8LbGycUbK0DQPCQic1C7%2FFz08uD2T7E2ARZO35fk2c%3D&quot;}]}\r\nnel: {&quot;report_to&quot;:&quot;cf-nel&quot;,&quot;success_fraction&quot;:0.0,&quot;max_age&quot;:604800}\r\nserver: cloudflare\r\ncf-ray: 9c6f93410d3ad151-CDG\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nHEAD /admission-post-bac/metiers-apres-ecole-ingenieur/ HTTP/2\r\nHost: concours-advance.fr\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","308","","","0.227702","0","0","0","1","0","308|0|0|https://concours-advance.fr/admission-post-bac/metiers-apres-ecole-ingenieur/","0","0"),
("304","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-1.webp","0000-00-00 00:00:00","2026-02-01 07:03:37","2026-02-01 07:03:37","2026-02-01 07:03:37","0","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:03:42 GMT\r\ncontent-type: image/webp\r\ncontent-length: 22012\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-55fc&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/11/ingenieur-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.030802","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-1.webp","0","0"),
("305","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-2.webp","0000-00-00 00:00:00","2026-02-01 06:59:26","2026-02-01 06:59:26","2026-02-01 06:59:26","0","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-2.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:59:31 GMT\r\ncontent-type: image/webp\r\ncontent-length: 16532\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-4094&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/11/ingenieur-2.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.031826","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-2.webp","0","0"),
("306","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-3.webp","0000-00-00 00:00:00","2026-02-01 06:58:46","2026-02-01 06:58:46","2026-02-01 06:58:46","0","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-3.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:58:46 GMT\r\ncontent-type: image/webp\r\ncontent-length: 73246\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-11e1e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/11/ingenieur-3.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038464","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-3.webp","0","0"),
("307","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-4.webp","0000-00-00 00:00:00","2026-02-01 07:00:31","2026-02-01 07:00:31","2026-02-01 07:00:31","0","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-4.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:00:36 GMT\r\ncontent-type: image/webp\r\ncontent-length: 12124\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-2f5c&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/11/ingenieur-4.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02224","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-4.webp","0","0"),
("308","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-5.webp","0000-00-00 00:00:00","2026-02-01 07:01:18","2026-02-01 07:01:18","2026-02-01 07:01:18","0","https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-5.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:01:23 GMT\r\ncontent-type: image/webp\r\ncontent-length: 54618\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-d55a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/11/ingenieur-5.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020031","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/11/ingenieur-5.webp","0","0"),
("309","https://dualdiploma.org/wp-content/uploads/2021/11/1.webp","0000-00-00 00:00:00","2026-02-01 05:59:09","2026-02-01 05:59:09","2026-02-01 05:59:09","0","https://dualdiploma.org/wp-content/uploads/2021/11/1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:59:11 GMT\r\ncontent-type: image/webp\r\ncontent-length: 29734\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-7426&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/11/1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.149114","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/11/1.webp","0","0"),
("310","https://dualdiploma.org/wp-content/uploads/2021/11/3.webp","0000-00-00 00:00:00","2026-02-01 06:59:41","2026-02-01 06:59:41","2026-02-01 06:59:41","0","https://dualdiploma.org/wp-content/uploads/2021/11/3.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:59:46 GMT\r\ncontent-type: image/webp\r\ncontent-length: 24664\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-6058&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/11/3.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02104","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/11/3.webp","0","0"),
("311","https://dualdiploma.org/wp-content/uploads/2021/11/4.webp","0000-00-00 00:00:00","2026-02-01 07:01:23","2026-02-01 07:01:23","2026-02-01 07:01:23","0","https://dualdiploma.org/wp-content/uploads/2021/11/4.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:01:25 GMT\r\ncontent-type: image/webp\r\ncontent-length: 115566\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-1c36e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2021/11/4.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.036508","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2021/11/4.webp","0","0"),
("312","https://dualdiploma.org/wp-content/uploads/2024/04/fingerprint-257037_1280-800x796.png","0000-00-00 00:00:00","2026-02-01 06:01:49","2026-02-01 06:01:49","2026-02-01 06:01:49","0","https://dualdiploma.org/wp-content/uploads/2024/04/fingerprint-257037_1280-800x796.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:01:54 GMT\r\ncontent-type: image/png\r\ncontent-length: 217227\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-3508b&quot;\r\nexpires: Tue, 03 Mar 2026 06:01:54 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/fingerprint-257037_1280-800x796.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038844","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/fingerprint-257037_1280-800x796.png","0","0"),
("313","https://dualdiploma.org/wp-content/uploads/2024/04/cours-crime.webp","0000-00-00 00:00:00","2026-02-01 06:02:34","2026-02-01 06:02:34","2026-02-01 06:02:34","0","https://dualdiploma.org/wp-content/uploads/2024/04/cours-crime.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:02:39 GMT\r\ncontent-type: image/webp\r\ncontent-length: 19424\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-4be0&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/cours-crime.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.026503","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/cours-crime.webp","0","0"),
("314","https://dualdiploma.org/wp-content/uploads/2022/02/daniel-schludi-7jl7ndhard8-unsplash-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 07:00:21","2026-02-01 07:00:21","2026-02-01 07:00:21","0","https://dualdiploma.org/wp-content/uploads/2022/02/daniel-schludi-7jl7ndhard8-unsplash-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:00:26 GMT\r\ncontent-type: image/webp\r\ncontent-length: 317730\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-4d922&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/02/daniel-schludi-7jl7ndhard8-unsplash-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038856","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/02/daniel-schludi-7jl7ndhard8-unsplash-scaled-1.webp","0","0"),
("315","https://dualdiploma.org/wp-content/uploads/2022/02/gulfer-ergin-luguctvlk1q-unsplash-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:03:34","2026-02-01 06:03:34","2026-02-01 06:03:34","0","https://dualdiploma.org/wp-content/uploads/2022/02/gulfer-ergin-luguctvlk1q-unsplash-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:03:39 GMT\r\ncontent-type: image/webp\r\ncontent-length: 216878\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-34f2e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/02/gulfer-ergin-luguctvlk1q-unsplash-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.033616","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/02/gulfer-ergin-luguctvlk1q-unsplash-scaled-1.webp","0","0"),
("316","https://dualdiploma.org/wp-content/uploads/2022/05/bret-kavanaugh-_af0_qah4k4-unsplash-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:03:44","2026-02-01 06:03:44","2026-02-01 06:03:44","0","https://dualdiploma.org/wp-content/uploads/2022/05/bret-kavanaugh-_af0_qah4k4-unsplash-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:03:49 GMT\r\ncontent-type: image/webp\r\ncontent-length: 144922\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-2361a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/05/bret-kavanaugh-_af0_qah4k4-unsplash-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.153313","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/05/bret-kavanaugh-_af0_qah4k4-unsplash-scaled-1.webp","0","0");

INSERT IGNORE INTO `da_blc_links` VALUES 
("317","https://dualdiploma.org/wp-content/uploads/2022/05/morgan-harper-nichols-omxprcahxre-unsplash-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:01:24","2026-02-01 06:01:24","2026-02-01 06:01:24","0","https://dualdiploma.org/wp-content/uploads/2022/05/morgan-harper-nichols-omxprcahxre-unsplash-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:01:29 GMT\r\ncontent-type: image/webp\r\ncontent-length: 184062\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-2cefe&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/05/morgan-harper-nichols-omxprcahxre-unsplash-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024908","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/05/morgan-harper-nichols-omxprcahxre-unsplash-scaled-1.webp","0","0"),
("318","https://dualdiploma.org/wp-content/uploads/2022/08/202207088610568246464570212_polarr_1-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 07:03:16","2026-02-01 07:03:16","2026-02-01 07:03:16","0","https://dualdiploma.org/wp-content/uploads/2022/08/202207088610568246464570212_polarr_1-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:03:21 GMT\r\ncontent-type: image/webp\r\ncontent-length: 152406\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-25356&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/08/202207088610568246464570212_polarr_1-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020389","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/08/202207088610568246464570212_polarr_1-scaled-1.webp","0","0"),
("319","https://dualdiploma.org/wp-content/uploads/2022/08/img_2794-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:04:19","2026-02-01 06:04:19","2026-02-01 06:04:19","0","https://dualdiploma.org/wp-content/uploads/2022/08/img_2794-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:04:24 GMT\r\ncontent-type: image/webp\r\ncontent-length: 174782\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-2aabe&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/08/img_2794-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.023303","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/08/img_2794-scaled-1.webp","0","0"),
("320","https://dualdiploma.org/wp-content/uploads/2022/08/img_2711-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 04:48:44","2026-02-01 04:48:44","2026-02-01 04:48:44","0","https://dualdiploma.org/wp-content/uploads/2022/08/img_2711-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 04:48:48 GMT\r\ncontent-type: image/webp\r\ncontent-length: 146622\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-23cbe&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/08/img_2711-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.027013","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/08/img_2711-scaled-1.webp","0","0"),
("321","https://dualdiploma.org/wp-content/uploads/2022/08/img_2587-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 07:02:26","2026-02-01 07:02:26","2026-02-01 07:02:26","0","https://dualdiploma.org/wp-content/uploads/2022/08/img_2587-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:02:31 GMT\r\ncontent-type: image/webp\r\ncontent-length: 138354\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-21c72&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/08/img_2587-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.034056","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/08/img_2587-scaled-1.webp","0","0"),
("322","https://dualdiploma.org/wp-content/uploads/2022/08/img_3410-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:00:24","2026-02-01 06:00:24","2026-02-01 06:00:24","0","https://dualdiploma.org/wp-content/uploads/2022/08/img_3410-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:00:29 GMT\r\ncontent-type: image/webp\r\ncontent-length: 89072\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-15bf0&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/08/img_3410-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.030768","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/08/img_3410-scaled-1.webp","0","0"),
("323","https://dualdiploma.org/wp-content/uploads/2022/08/img_2478-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 06:02:19","2026-02-01 06:02:19","2026-02-01 06:02:19","0","https://dualdiploma.org/wp-content/uploads/2022/08/img_2478-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:02:24 GMT\r\ncontent-type: image/webp\r\ncontent-length: 5498\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-157a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/08/img_2478-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.034215","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/08/img_2478-400x284-1.webp","0","0"),
("324","https://dualdiploma.org/wp-content/uploads/2022/08/img_2823-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 07:01:56","2026-02-01 07:01:56","2026-02-01 07:01:56","0","https://dualdiploma.org/wp-content/uploads/2022/08/img_2823-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:02:01 GMT\r\ncontent-type: image/webp\r\ncontent-length: 5470\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-155e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/08/img_2823-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02226","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/08/img_2823-400x284-1.webp","0","0"),
("325","https://dualdiploma.org/wp-content/uploads/2022/08/img_2760-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 06:05:14","2026-02-01 06:05:14","2026-02-01 06:05:14","0","https://dualdiploma.org/wp-content/uploads/2022/08/img_2760-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:05:19 GMT\r\ncontent-type: image/webp\r\ncontent-length: 15044\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-3ac4&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/08/img_2760-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.022969","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/08/img_2760-400x284-1.webp","0","0"),
("326","https://dualdiploma.org/wp-content/uploads/2022/08/img_3550-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 06:04:39","2026-02-01 06:04:39","2026-02-01 06:04:39","0","https://dualdiploma.org/wp-content/uploads/2022/08/img_3550-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:04:44 GMT\r\ncontent-type: image/webp\r\ncontent-length: 15464\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-3c68&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/08/img_3550-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.027509","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/08/img_3550-400x284-1.webp","0","0"),
("327","https://dualdiploma.org/wp-content/uploads/2022/08/h7a4856-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 06:01:34","2026-02-01 06:01:34","2026-02-01 06:01:34","0","https://dualdiploma.org/wp-content/uploads/2022/08/h7a4856-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:01:39 GMT\r\ncontent-type: image/webp\r\ncontent-length: 17690\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-451a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/08/h7a4856-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02213","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/08/h7a4856-400x284-1.webp","0","0"),
("328","https://dualdiploma.org/wp-content/uploads/2022/08/img_2542-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 06:04:54","2026-02-01 06:04:54","2026-02-01 06:04:54","0","https://dualdiploma.org/wp-content/uploads/2022/08/img_2542-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:04:59 GMT\r\ncontent-type: image/webp\r\ncontent-length: 26650\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-681a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/08/img_2542-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.03044","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/08/img_2542-400x284-1.webp","0","0"),
("329","https://dualdiploma.org/wp-content/uploads/2022/08/h7a4747-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 06:02:09","2026-02-01 06:02:09","2026-02-01 06:02:09","0","https://dualdiploma.org/wp-content/uploads/2022/08/h7a4747-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:02:14 GMT\r\ncontent-type: image/webp\r\ncontent-length: 11614\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-2d5e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/08/h7a4747-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.025536","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/08/h7a4747-400x284-1.webp","0","0"),
("330","https://dualdiploma.org/wp-content/uploads/2022/08/img_2298-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 07:02:31","2026-02-01 07:02:31","2026-02-01 07:02:31","0","https://dualdiploma.org/wp-content/uploads/2022/08/img_2298-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:02:36 GMT\r\ncontent-type: image/webp\r\ncontent-length: 21666\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-54a2&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/08/img_2298-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.033281","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/08/img_2298-400x284-1.webp","0","0"),
("332","https://dualdiploma.org/wp-content/uploads/2022/09/anne-1.webp","0000-00-00 00:00:00","2026-02-01 06:02:44","2026-02-01 06:02:44","2026-02-01 06:02:44","0","https://dualdiploma.org/wp-content/uploads/2022/09/anne-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:02:49 GMT\r\ncontent-type: image/webp\r\ncontent-length: 256226\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-3e8e2&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/09/anne-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.040944","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/09/anne-1.webp","0","0"),
("333","https://dualdiploma.org/wp-content/uploads/2022/09/anne-2-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:59:51","2026-02-01 06:59:51","2026-02-01 06:59:51","0","https://dualdiploma.org/wp-content/uploads/2022/09/anne-2-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:59:56 GMT\r\ncontent-type: image/webp\r\ncontent-length: 177632\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-2b5e0&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2022/09/anne-2-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.049547","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2022/09/anne-2-scaled-1.webp","0","0"),
("334","https://www.commerce.gov/news/blog/2022/07/secretary-gina-raimondo-presents-presidential-awards-export-excellence-us","2025-05-30 23:38:38","2026-02-01 08:28:25","2025-05-27 23:38:09","2026-02-01 08:28:25","85","https://www.commerce.gov/news/blog/2022/07/secretary-gina-raimondo-presents-presidential-awards-export-excellence-us","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 403 ===\n\nResponse headers\n================\nHTTP/2 403 \r\ndate: Sun, 01 Feb 2026 08:28:26 GMT\r\ncontent-type: text/html; charset=UTF-8\r\naccept-ch: Sec-CH-UA-Bitness, Sec-CH-UA-Arch, Sec-CH-UA-Full-Version, Sec-CH-UA-Mobile, Sec-CH-UA-Model, Sec-CH-UA-Platform-Version, Sec-CH-UA-Full-Version-List, Sec-CH-UA-Platform, Sec-CH-UA, UA-Bitness, UA-Arch, UA-Full-Version, UA-Mobile, UA-Model, UA-Platform-Version, UA-Platform, UA\r\ncf-mitigated: challenge\r\ncritical-ch: Sec-CH-UA-Bitness, Sec-CH-UA-Arch, Sec-CH-UA-Full-Version, Sec-CH-UA-Mobile, Sec-CH-UA-Model, Sec-CH-UA-Platform-Version, Sec-CH-UA-Full-Version-List, Sec-CH-UA-Platform, Sec-CH-UA, UA-Bitness, UA-Arch, UA-Full-Version, UA-Mobile, UA-Model, UA-Platform-Version, UA-Platform, UA\r\ncross-origin-embedder-policy: require-corp\r\ncross-origin-opener-policy: same-origin\r\ncross-origin-resource-policy: same-origin\r\norigin-agent-cluster: ?1\r\npermissions-policy: accelerometer=(),browsing-topics=(),camera=(),clipboard-read=(),clipboard-write=(),geolocation=(),gyroscope=(),hid=(),interest-cohort=(),magnetometer=(),microphone=(),payment=(),publickey-credentials-get=(),screen-wake-lock=(),serial=(),sync-xhr=(),usb=()\r\nreferrer-policy: same-origin\r\nserver-timing: chlray;desc=&quot;9c7013484f9f488c&quot;\r\nx-content-type-options: nosniff\r\nx-frame-options: SAMEORIGIN\r\ncache-control: private, max-age=0, no-store, no-cache, must-revalidate, post-check=0, pre-check=0\r\nexpires: Thu, 01 Jan 1970 00:00:01 GMT\r\nset-cookie: __cf_bm=DAstBceVlHTgGUN4kTNCONZlhrXuPkGE2dyS8Wl1ujw-1769934506-1.0.1.1-7bM_f1UlTJip4keQabA5ZKVEPvqle_YDrw67wtTC6OIux4o4nCLO2s5t8qkpgdCz_2J.jZDSsjwIiU8RHidsai8F0oMivCZ5aMJCftlrZ4s; path=/; expires=Sun, 01-Feb-26 08:58:26 GMT; domain=.commerce.gov; HttpOnly; Secure; SameSite=None\r\nvary: Accept-Encoding\r\nserver: cloudflare\r\ncf-ray: 9c7013484f9f488c-EWR\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nGET /news/blog/2022/07/secretary-gina-raimondo-presents-presidential-awards-export-excellence-us HTTP/2\r\nHost: www.commerce.gov\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\nrange: bytes=0-2048\r\n\r\nResponse HTML\n================\n&lt;!DOCTYPE html&gt;&lt;html lang=&quot;en-US&quot;&gt;&lt;head&gt;&lt;title&gt;Just a moment...&lt;/title&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=Edge&quot;&gt;&lt;meta name=&quot;robots&quot; content=&quot;noindex,nofollow&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style&gt;*{box-sizing:border-box;margin:0;padding:0}html{line-height:1.15;-webkit-text-size-adjust:100%;color:#313131;font-family:system-ui,-apple-system,BlinkMacSystemFont,&quot;Segoe UI&quot;,Roboto,&quot;Helvetica Neue&quot;,Arial,&quot;Noto Sans&quot;,sans-serif,&quot;Apple Color Emoji&quot;,&quot;Segoe UI Emoji&quot;,&quot;Segoe UI Symbol&quot;,&quot;Noto Color Emoji&quot;}body{display:flex;flex-direction:column;height:100vh;min-height:100vh}.main-content{margin:8rem auto;padding-left:1.5rem;max-width:60rem}@media (width &lt;= 720px){.main-content{margin-top:4rem}}.h2{line-height:2.25rem;font-size:1.5rem;font-weight:500}@media (width &lt;= 720px){.h2{line-height:1.5rem;font-size:1.25rem}}#challenge-error-text{background-image:url(&quot;data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIzMiIgaGVpZ2h0PSIzMiIgZmlsbD0ibm9uZSI+PHBhdGggZmlsbD0iI0IyMEYwMyIgZD0iTTE2IDNhMTMgMTMgMCAxIDAgMTMgMTNBMTMuMDE1IDEzLjAxNSAwIDAgMCAxNiAzbTAgMjRhMTEgMTEgMCAxIDEgMTEtMTEgMTEuMDEgMTEuMDEgMCAwIDEtMTEgMTEiLz48cGF0aCBmaWxsPSIjQjIwRjAzIiBkPSJNMTcuMDM4IDE4LjYxNUgxNC44N0wxNC41NjMgOS41aDIuNzgzem0tMS4wODQgMS40MjdxLjY2IDAgMS4wNTcuMzg4LjQwNy4zODkuNDA3Ljk5NCAwIC41OTYtLjQwNy45ODQtLjM5Ny4zOS0xLjA1Ny4zODktLjY1IDAtMS4wNTYtLjM4OS0uMzk4LS4zODktLjM5OC0uOTg0IDAtLjU5Ny4zOTgtLjk4NS40MDYtLjM5NyAxLjA1Ni0uMzk3Ii8+PC9zdmc+&quot;);background-repeat:no-repeat;background-size:contain;padding-left:34px}@media (prefers-color-scheme: dark){body{background-color:#222;color:#d9d9d9}}&lt;/style&gt;&lt;meta http-equiv=&quot;refresh&quot; content=&quot;360&quot;&gt;&lt;/head&gt;&lt;body&gt;&lt;div class=&quot;main-wrapper&quot; role=&quot;main&quot;&gt;&lt;div class=&quot;main-content&quot;&gt;&lt;noscript&gt;&lt;div class=&quot;h2&quot;&gt;&lt;span id=&quot;challenge-error-text&quot;&gt;Enable JavaScript and cookies to continue&lt;/span&gt;&lt;/div&gt;&lt;/noscript&gt;&lt;/div&gt;&lt;/div&gt;&lt;script&gt;(function(){window._cf_chl_opt = {cvId: &#039;3&#039;,cZone: &#039;www.commerce.gov&#039;\nLe lien est cassé.","403","","","0.362441","0","1","0","1","0","403|broken|0|https://www.commerce.gov/news/blog/2022/07/secretary-gina-raimondo-presents-presidential-awards-export-excellence-us","0","0"),
("335","https://dualdiploma.org/wp-content/uploads/2023/01/e-award-gina-raimondo-et-gina-lalicata.webp","0000-00-00 00:00:00","2026-02-01 06:05:23","2026-02-01 06:05:23","2026-02-01 06:05:23","0","https://dualdiploma.org/wp-content/uploads/2023/01/e-award-gina-raimondo-et-gina-lalicata.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:05:28 GMT\r\ncontent-type: image/webp\r\ncontent-length: 59220\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-e754&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/01/e-award-gina-raimondo-et-gina-lalicata.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.023243","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/01/e-award-gina-raimondo-et-gina-lalicata.webp","0","0"),
("336","https://dualdiploma.org/wp-content/uploads/2023/01/cropped_mi_john_f_kennedy_crest_white_house_getty.webp","0000-00-00 00:00:00","2026-02-01 06:58:52","2026-02-01 06:58:52","2026-02-01 06:58:52","0","https://dualdiploma.org/wp-content/uploads/2023/01/cropped_mi_john_f_kennedy_crest_white_house_getty.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:58:56 GMT\r\ncontent-type: image/webp\r\ncontent-length: 47550\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-b9be&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/01/cropped_mi_john_f_kennedy_crest_white_house_getty.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.039806","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/01/cropped_mi_john_f_kennedy_crest_white_house_getty.webp","0","0"),
("337","https://dualdiploma.org/academica-laureat-presidential-eaward-biden/","0000-00-00 00:00:00","2026-02-01 06:01:54","2026-02-01 06:01:54","2026-02-01 06:01:54","0","https://dualdiploma.org/academica-laureat-presidential-eaward-biden/","1","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 301 ===\n\nResponse headers\n================\nHTTP/2 301 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:01:59 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nlocation: https://dualdiploma.org/academica-laureat-presidential-e-award-biden/\r\nexpires: Sun, 01 Feb 2026 07:01:59 GMT\r\ncache-control: max-age=3600\r\nx-redirect-by: redirection\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\n\r\nRequest headers\n================\nHEAD /academica-laureat-presidential-eaward-biden/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","301","","","0.267695","0","0","0","1","0","301|0|0|https://dualdiploma.org/academica-laureat-presidential-eaward-biden/","0","0"),
("340","https://dualdiploma.org/wp-content/uploads/2023/01/academica-oiec-nouveau-logo.webp","0000-00-00 00:00:00","2026-02-01 07:03:31","2026-02-01 07:03:31","2026-02-01 07:03:31","0","https://dualdiploma.org/wp-content/uploads/2023/01/academica-oiec-nouveau-logo.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:03:36 GMT\r\ncontent-type: image/webp\r\ncontent-length: 19278\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-4b4e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/01/academica-oiec-nouveau-logo.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.040024","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/01/academica-oiec-nouveau-logo.webp","0","0"),
("341","https://dualdiploma.org/wp-content/uploads/2023/01/eleves-participant-au-congres-de-loiec.webp","0000-00-00 00:00:00","2026-02-01 06:59:36","2026-02-01 06:59:36","2026-02-01 06:59:36","0","https://dualdiploma.org/wp-content/uploads/2023/01/eleves-participant-au-congres-de-loiec.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:59:41 GMT\r\ncontent-type: image/webp\r\ncontent-length: 30964\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-78f4&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/01/eleves-participant-au-congres-de-loiec.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.053258","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/01/eleves-participant-au-congres-de-loiec.webp","0","0"),
("342","https://dualdiploma.org/wp-content/uploads/2023/01/1674816306469-1-modifie.webp","0000-00-00 00:00:00","2026-02-01 06:05:34","2026-02-01 06:05:34","2026-02-01 06:05:34","0","https://dualdiploma.org/wp-content/uploads/2023/01/1674816306469-1-modifie.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:05:39 GMT\r\ncontent-type: image/webp\r\ncontent-length: 91818\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-166aa&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/01/1674816306469-1-modifie.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.018932","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/01/1674816306469-1-modifie.webp","0","0"),
("343","https://dualdiploma.org/wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.17.20.webp","0000-00-00 00:00:00","2026-02-01 06:02:30","2026-02-01 06:02:30","2026-02-01 06:02:30","0","https://dualdiploma.org/wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.17.20.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:02:34 GMT\r\ncontent-type: image/webp\r\ncontent-length: 20682\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-50ca&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.17.20.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.039198","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.17.20.webp","0","0"),
("344","https://dualdiploma.org/wp-content/uploads/2023/01/1674743743751-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:00:49","2026-02-01 06:00:49","2026-02-01 06:00:49","0","https://dualdiploma.org/wp-content/uploads/2023/01/1674743743751-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:00:54 GMT\r\ncontent-type: image/webp\r\ncontent-length: 192494\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-2efee&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/01/1674743743751-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.036272","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/01/1674743743751-scaled-1.webp","0","0"),
("345","https://dualdiploma.org/wp-content/uploads/2023/01/1674743743336-modifie-1.webp","0000-00-00 00:00:00","2026-02-01 07:00:41","2026-02-01 07:00:41","2026-02-01 07:00:41","0","https://dualdiploma.org/wp-content/uploads/2023/01/1674743743336-modifie-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:00:46 GMT\r\ncontent-type: image/webp\r\ncontent-length: 174588\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-2a9fc&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/01/1674743743336-modifie-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.053147","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/01/1674743743336-modifie-1.webp","0","0"),
("346","https://dualdiploma.org/wp-content/uploads/2023/01/img-20221203-wa0011.webp","0000-00-00 00:00:00","2026-02-01 06:03:14","2026-02-01 06:03:14","2026-02-01 06:03:14","0","https://dualdiploma.org/wp-content/uploads/2023/01/img-20221203-wa0011.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:03:19 GMT\r\ncontent-type: image/webp\r\ncontent-length: 33126\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-8166&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/01/img-20221203-wa0011.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020584","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/01/img-20221203-wa0011.webp","0","0"),
("347","https://dualdiploma.org/wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.17.20-2.webp","0000-00-00 00:00:00","2026-02-01 07:00:46","2026-02-01 07:00:46","2026-02-01 07:00:46","0","https://dualdiploma.org/wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.17.20-2.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:00:51 GMT\r\ncontent-type: image/webp\r\ncontent-length: 16742\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-4166&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.17.20-2.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.023863","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.17.20-2.webp","0","0"),
("348","https://dualdiploma.org/wp-content/uploads/2023/01/eleve-academica-lors-du-congres-modifie.webp","0000-00-00 00:00:00","2026-02-01 06:05:44","2026-02-01 06:05:44","2026-02-01 06:05:44","0","https://dualdiploma.org/wp-content/uploads/2023/01/eleve-academica-lors-du-congres-modifie.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:05:49 GMT\r\ncontent-type: image/webp\r\ncontent-length: 12454\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-30a6&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/01/eleve-academica-lors-du-congres-modifie.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.045472","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/01/eleve-academica-lors-du-congres-modifie.webp","0","0"),
("349","https://dualdiploma.org/wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.14.10.webp","0000-00-00 00:00:00","2026-02-01 06:03:09","2026-02-01 06:03:09","2026-02-01 06:03:09","0","https://dualdiploma.org/wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.14.10.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:03:14 GMT\r\ncontent-type: image/webp\r\ncontent-length: 50436\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-c504&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.14.10.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.039733","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/01/whatsapp-image-2022-12-03-at-16.14.10.webp","0","0"),
("350","https://dualdiploma.org/wp-content/uploads/2023/01/2693075621683966844.webp","0000-00-00 00:00:00","2026-02-01 06:05:04","2026-02-01 06:05:04","2026-02-01 06:05:04","0","https://dualdiploma.org/wp-content/uploads/2023/01/2693075621683966844.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:05:09 GMT\r\ncontent-type: image/webp\r\ncontent-length: 20640\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-50a0&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/01/2693075621683966844.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.037406","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/01/2693075621683966844.webp","0","0"),
("351","https://www.parcoursup.fr/","0000-00-00 00:00:00","2026-02-01 07:03:21","2026-02-01 07:03:21","2026-02-01 07:03:21","0","https://www.parcoursup.fr/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/1.1 200 OK\r\nDate: Sun, 01 Feb 2026 07:03:22 GMT\r\nServer: Apache\r\nX-Content-Type-Options: nosniff\r\nContent-Security-Policy: default-src &#039;none&#039; ; img-src &#039;self&#039; *.parcoursup.fr *.parcoursup-nouvelle-caledonie.fr *.paybox.com ; media-src &#039;self&#039; *.parcoursup.fr *.parcoursup-nouvelle-caledonie.fr *.paybox.com ; script-src &#039;unsafe-hashes&#039; &#039;self&#039; *.parcoursup.fr *.parcoursup-nouvelle-caledonie.fr *.paybox.com &#039;sha256-sI5v5bWVC19T46mBXAQNfZL5g/VIjJO4pxHjTHBGRTo=&#039; &#039;sha256-bclIzK3SfP1ClS25sRLJ0l5THuIWcyKh/XRhHiIjoP8=&#039; &#039;sha256-U3q5KwDyUdJs6mZtsTFTCPoNZs6DKhq9G8ZvSKs+sqM=&#039; ; font-src &#039;self&#039; *.parcoursup.fr *.parcoursup-nouvelle-caledonie.fr *.paybox.com ; frame-ancestors &#039;self&#039; ; style-src-elem &#039;self&#039; &#039;sha256-UG3e5GMK0p75fYUzpG+gQ7w8C5Xiho/3IN1lN4MygSs=&#039; &#039;sha256-LCCG8b1oYMgCStLhXjw2+M/3LsNjoavZBaIwEMJ6Kdg=&#039; &#039;sha256-e1gMlZC9QqOMyeY/9Z/NZIBDrlArAo46JAbkLbBDm1Q=&#039; &#039;sha256-UrGjHcu2Sr3l23rKhEgVKMijbWMN2Pell/Dz/a4DGiw=&#039;; frame-src &#039;self&#039; ; style-src &#039;self&#039; &#039;sha256-lbk0T9Eqn9FZGhCh9MPwvsW4o8mfHGljEvl4Z7A1CXw=&#039; &#039;sha256-zq27PiVE3uKYaCuZd8TdzyuSD1F45+67IRQlUZDK41c=&#039; &#039;sha256-3DuTxsT+isLRFfaBwfLTvkqwl+5WCvVBwlXHNtnEjR8=&#039; &#039;sha256-naYrp5ciLxqh93qokH0dHua1L06ytZsEdfzisDnQ9mM=&#039; &#039;sha256-UG3e5GMK0p75fYUzpG+gQ7w8C5Xiho/3IN1lN4MygSs=&#039; &#039;sha256-LCCG8b1oYMgCStLhXjw2+M/3LsNjoavZBaIwEMJ6Kdg=&#039; &#039;sha256-e1gMlZC9QqOMyeY/9Z/NZIBDrlArAo46JAbkLbBDm1Q=&#039; &#039;sha256-UrGjHcu2Sr3l23rKhEgVKMijbWMN2Pell/Dz/a4DGiw=&#039;\r\nX-XSS-Protection: 1; mode=block\r\nX-Frame-Options: SAMEORIGIN\r\nReferrer-Policy: strict-origin-when-cross-origin\r\nPermissions-Policy: speaker=(self &quot;https://*.twitter.com&quot; &quot;https://*.dailymotion.com&quot; &quot;https://www.youtube-nocookie.com&quot;), autoplay=(self &quot;https://*.twitter.com&quot; &quot;https://*.dailymotion.com&quot; &quot;https://www.youtube-nocookie.com&quot;), fullscreen=(self &quot;https://*.twitter.com&quot; &quot;https://*.dailymotion.com&quot; &quot;https://www.youtube-nocookie.com&quot;), geolocation=(self), payment=(self &quot;https://*.paybox.com&quot;), accelerometer=(), ambient-light-sensor=(), battery=(), camera=(), display-capture=(), document-domain=(), encrypted-media=(), gyroscope=(), layout-animations=(), legacy-image-formats=(), magnetometer=(), microphone=(), midi=(), notifications=(), oversized-images=(), picture-in-picture=(), publickey-credentials-get=(), push=(), sync-xhr=(self), usb=(), vibrate=(), wake-lock=(), xr-spatial-tracking=()\r\nStrict-Transport-Security: max-age=31536000; includeSubDomains; preload\r\nLast-Modified: Tue, 19 Dec 2023 13:32:50 GMT\r\nETag: &quot;113c-60cdce7248798-gzip&quot;\r\nAccept-Ranges: bytes\r\nVary: Accept-Encoding\r\nContent-Encoding: gzip\r\nContent-Length: 126\r\nConnection: close\r\nContent-Type: text/html\r\n\r\nRequest headers\n================\nHEAD / HTTP/1.1\r\nHost: www.parcoursup.fr\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://dualdiploma.org\r\nConnection: close\r\n\r\n\nLe lien est valide.","200","","","0.089604","0","0","0","1","0","200|0|0|https://www.parcoursup.fr/","0","0"),
("352","https://ais.academica.org/dual-diploma-times","2026-01-23 06:30:38","2026-02-01 07:58:10","2026-01-20 06:30:32","2026-02-01 07:58:10","6","https://ais.academica.org/dual-diploma-times","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 404 ===\n\nResponse headers\n================\nHTTP/2 404 \r\ndate: Sun, 01 Feb 2026 07:58:12 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nserver: cloudflare\r\nx-powered-by: PHP/8.2.30\r\ncf-edge-cache: cache,platform=wordpress\r\nexpires: Wed, 11 Jan 1984 05:00:00 GMT\r\ncache-control: no-cache, must-revalidate, max-age=0, no-store, private\r\nlink: &lt;https://ais.academica.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nserver-timing: wp-before-template;dur=252.09\r\nstrict-transport-security: max-age=15768000; includeSubDomains\r\nreport-to: {&quot;group&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https://a.nel.cloudflare.com/report/v4?s=PDPY9dCy3zMol9%2FvXTeCZGWqiTgH4WcSVViBh0Rt8lD79KBYC1beEEZjmPQBUoZEe4pZLUw2BTFyQkBAfD17O39rSXQdFaaItiQB6lchkUWDWk6lDlWxBubAI7zQ&quot;}]}\r\ncf-cache-status: DYNAMIC\r\nvary: accept-encoding\r\nnel: {&quot;report_to&quot;:&quot;cf-nel&quot;,&quot;success_fraction&quot;:0.0,&quot;max_age&quot;:604800}\r\ncontent-encoding: br\r\ncf-ray: 9c6fe6f81c59d145-CDG\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nGET /dual-diploma-times HTTP/2\r\nHost: ais.academica.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\nrange: bytes=0-2048\r\n\r\nResponse HTML\n================\n&lt;!doctype html&gt;\n&lt;html lang=&quot;en-US&quot;&gt;\n&lt;head&gt;\n&lt;script type=&quot;text/javascript&quot;&gt;\nvar _iub = _iub || [];\n_iub.csConfiguration = {&quot;applyGdprForCH&quot;:false,&quot;askConsentAtCookiePolicyUpdate&quot;:true,&quot;countryDetection&quot;:true,&quot;enableFadp&quot;:true,&quot;enableLgpd&quot;:true,&quot;enableUspr&quot;:true,&quot;floatingPreferencesButtonDisplay&quot;:&quot;bottom-right&quot;,&quot;gdprAppliesGlobally&quot;:false,&quot;lang&quot;:&quot;en&quot;,&quot;lgpdAppliesGlobally&quot;:false,&quot;perPurposeConsent&quot;:true,&quot;siteId&quot;:3565730,&quot;whitelabel&quot;:false,&quot;cookiePolicyId&quot;:31348884, &quot;banner&quot;:{ &quot;acceptButtonDisplay&quot;:true,&quot;closeButtonDisplay&quot;:false,&quot;customizeButtonDisplay&quot;:true,&quot;explicitWithdrawal&quot;:true,&quot;listPurposes&quot;:true,&quot;position&quot;:&quot;float-top-center&quot;,&quot;rejectButtonDisplay&quot;:true,&quot;showTitle&quot;:false }};\n&lt;/script&gt;\n&lt;script type=&quot;text/javascript&quot; src=https://cs.iubenda.com/autoblocking/3565730.js&gt;&lt;/script&gt;\n&lt;script type=&quot;text/javascript&quot; src=&quot;//cdn.iubenda.com/cs/gpp/stub.js&quot;&gt;&lt;/script&gt;\n&lt;script type=&quot;text/javascript&quot; src=&quot;//cdn.iubenda.com/cs/iubenda_cs.js&quot; charset=&quot;UTF-8&quot; async&gt;&lt;/script&gt;\n    &lt;meta charset=&quot;UTF-8&quot;&gt;\n    &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1, maximum-scale=1&quot;&gt;\n    &lt;meta name=&quot;theme-color&quot; content=&quot;#004c42&quot; /&gt;\n    &lt;meta name=&quot;apple-mobile-web-app-capable&quot; content=&quot;yes&quot;&gt;\n    &lt;meta name=&quot;apple-mobile-web-app-status-bar-style&quot; content=&quot;black-translucent&quot;&gt;\n    &lt;link rel=&quot;profile&quot; href=&quot;https://gmpg.org/xfn/11&quot;&gt;\n    &lt;style&gt; /* header-css v.033 */\n:root { --w: #fff; --b: #000; --green: #004c42; --green-light: #b4cfca; --grey: #4d4d4d; --grey-light:#dadada; --scrollOpacity: 1; --scrollScale: 1; --scrollBrightness: 1; }\nhtml {scroll-behavior: smooth;}\nbody { opacity: .1; color: #595959; font-family: Helvetica, Arial, sans-serif; overflow-x: hidden; width: 100vw; transition: 1s all; }\nbody.domLoaded { opacity: 1; transition: 1s all; }\nh1, h2, h3, h4, h5, h6 { color: var(--green); font-weight: 100;padding: 0; }\nbody.home h1 { color: var(--w); font-weight: bolder; }\np {font-size: 1em;}\n.c-white { color:var(--w) }\n.c-black { color:var(--b) }\n.c-green { color:var(--green) }\n.button-green {background:var(--green);c\nLe lien est cassé.","404","","","0.895901","0","1","0","1","0","404|broken|0|https://ais.academica.org/dual-diploma-times","0","0"),
("353","https://ais.academica.org/ais2021B/wp-content/uploads/2023/01/Diploma-Times-Winter-2022-Edition-Final-1-1.pdf","0000-00-00 00:00:00","2026-02-01 06:02:24","2026-02-01 06:02:24","2026-02-01 06:02:24","0","https://ais.academica.org/ais2021B/wp-content/uploads/2023/01/Diploma-Times-Winter-2022-Edition-Final-1-1.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Sun, 01 Feb 2026 06:02:24 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 2202653\r\nserver: cloudflare\r\nlast-modified: Mon, 23 Jan 2023 21:45:50 GMT\r\ncache-control: max-age=14400\r\nexpires: max-age=A10368000, public\r\netag: &quot;63cf000e-219c1d&quot;\r\nstrict-transport-security: max-age=15768000; includeSubDomains\r\nx-powered-by: PleskLin\r\naccept-ranges: bytes\r\ncf-cache-status: MISS\r\nvary: accept-encoding\r\nreport-to: {&quot;group&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https://a.nel.cloudflare.com/report/v4?s=WdhLil%2FeBNh%2BQ932V1VHvlNmnMq7ZaoHvxGjQn1LYX9SkGMogS6sMxV3BoRj9cOUHrnNoBWYaRMRsoD1G5ouC%2BwN58ZqgrsCXH0gKnLJbAaJtsH7ix%2F3ARM746nj&quot;}]}\r\nnel: {&quot;report_to&quot;:&quot;cf-nel&quot;,&quot;success_fraction&quot;:0.0,&quot;max_age&quot;:604800}\r\ncf-ray: 9c6f3d5f79e94562-CDG\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nHEAD /ais2021B/wp-content/uploads/2023/01/Diploma-Times-Winter-2022-Edition-Final-1-1.pdf HTTP/2\r\nHost: ais.academica.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.487163","0","0","0","1","0","200|0|0|https://ais.academica.org/ais2021B/wp-content/uploads/2023/01/Diploma-Times-Winter-2022-Edition-Final-1-1.pdf","0","0"),
("354","https://dualdiploma.org/wp-content/uploads/2023/04/novembre.webp","0000-00-00 00:00:00","2026-02-01 07:02:56","2026-02-01 07:02:56","2026-02-01 07:02:56","0","https://dualdiploma.org/wp-content/uploads/2023/04/novembre.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:03:01 GMT\r\ncontent-type: image/webp\r\ncontent-length: 6468\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-1944&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/04/novembre.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024861","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/04/novembre.webp","0","0"),
("355","https://dualdiploma.org/wp-content/uploads/2023/04/novembre-2.webp","0000-00-00 00:00:00","2026-02-01 06:01:14","2026-02-01 06:01:14","2026-02-01 06:01:14","0","https://dualdiploma.org/wp-content/uploads/2023/04/novembre-2.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:01:19 GMT\r\ncontent-type: image/webp\r\ncontent-length: 8034\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-1f62&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/04/novembre-2.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024136","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/04/novembre-2.webp","0","0"),
("356","https://dualdiploma.org/wp-content/uploads/2023/04/musicals-1.webp","0000-00-00 00:00:00","2026-02-01 07:00:51","2026-02-01 07:00:51","2026-02-01 07:00:51","0","https://dualdiploma.org/wp-content/uploads/2023/04/musicals-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:00:56 GMT\r\ncontent-type: image/webp\r\ncontent-length: 9798\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-2646&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/04/musicals-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.019586","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/04/musicals-1.webp","0","0"),
("357","https://dualdiploma.org/wp-content/uploads/2023/04/musicals-2.webp","0000-00-00 00:00:00","2026-02-01 07:03:42","2026-02-01 07:03:42","2026-02-01 07:03:42","0","https://dualdiploma.org/wp-content/uploads/2023/04/musicals-2.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:03:46 GMT\r\ncontent-type: image/webp\r\ncontent-length: 12128\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-2f60&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/04/musicals-2.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.021972","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/04/musicals-2.webp","0","0"),
("358","https://dualdiploma.org/wp-content/uploads/2023/04/europe.webp","0000-00-00 00:00:00","2026-02-01 07:01:31","2026-02-01 07:01:31","2026-02-01 07:01:31","0","https://dualdiploma.org/wp-content/uploads/2023/04/europe.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:01:36 GMT\r\ncontent-type: image/webp\r\ncontent-length: 12084\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-2f34&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/04/europe.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020949","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/04/europe.webp","0","0"),
("359","https://dualdiploma.org/wp-content/uploads/2023/04/europe-2.webp","0000-00-00 00:00:00","2026-02-01 07:02:06","2026-02-01 07:02:06","2026-02-01 07:02:06","0","https://dualdiploma.org/wp-content/uploads/2023/04/europe-2.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:02:11 GMT\r\ncontent-type: image/webp\r\ncontent-length: 40986\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-a01a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/04/europe-2.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020416","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/04/europe-2.webp","0","0"),
("360","https://dualdiploma.org/wp-content/uploads/2023/04/double-standard.webp","0000-00-00 00:00:00","2026-02-01 07:03:46","2026-02-01 07:03:46","2026-02-01 07:03:46","0","https://dualdiploma.org/wp-content/uploads/2023/04/double-standard.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:03:51 GMT\r\ncontent-type: image/webp\r\ncontent-length: 16472\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-4058&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/04/double-standard.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.031155","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/04/double-standard.webp","0","0"),
("361","https://dualdiploma.org/wp-content/uploads/2023/04/double-standard-2.webp","0000-00-00 00:00:00","2026-02-01 07:02:41","2026-02-01 07:02:41","2026-02-01 07:02:41","0","https://dualdiploma.org/wp-content/uploads/2023/04/double-standard-2.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:02:46 GMT\r\ncontent-type: image/webp\r\ncontent-length: 6628\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-19e4&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/04/double-standard-2.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.025285","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/04/double-standard-2.webp","0","0"),
("362","https://dualdiploma.org/wp-content/uploads/2023/04/world-cup.webp","0000-00-00 00:00:00","2026-02-01 07:02:36","2026-02-01 07:02:36","2026-02-01 07:02:36","0","https://dualdiploma.org/wp-content/uploads/2023/04/world-cup.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:02:41 GMT\r\ncontent-type: image/webp\r\ncontent-length: 15554\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-3cc2&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/04/world-cup.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.022731","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/04/world-cup.webp","0","0"),
("363","https://dualdiploma.org/wp-content/uploads/2023/04/world-cup-2.webp","0000-00-00 00:00:00","2026-02-01 06:04:09","2026-02-01 06:04:09","2026-02-01 06:04:09","0","https://dualdiploma.org/wp-content/uploads/2023/04/world-cup-2.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:04:14 GMT\r\ncontent-type: image/webp\r\ncontent-length: 16700\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-413c&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/04/world-cup-2.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.034398","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/04/world-cup-2.webp","0","0"),
("364","https://fr.ouishare.net/","2026-01-11 06:02:55","2026-02-01 07:03:16","2026-01-08 05:54:02","2026-02-01 07:03:16","8","https://fr.ouishare.net/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 526 ===\n\nResponse headers\n================\nHTTP/2 526 \r\ndate: Sun, 01 Feb 2026 07:03:16 GMT\r\ncontent-type: text/plain; charset=UTF-8\r\ncontent-length: 15\r\nserver: cloudflare\r\ncf-ray: 9c6f9687ab2897c1-CDG\r\ncache-control: private, max-age=0, no-store, no-cache, must-revalidate, post-check=0, pre-check=0\r\ncontent-language: fr\r\nexpires: Thu, 01 Jan 1970 00:00:01 GMT\r\nlink: &lt;https://www.ouishare.net/&gt;; rel=&quot;alternate&quot;; hreflang=&quot;en&quot;, &lt;https://fr.ouishare.net/&gt;; rel=&quot;alternate&quot;; hreflang=&quot;fr&quot;, &lt;https://es.ouishare.net/&gt;; rel=&quot;alternate&quot;; hreflang=&quot;es&quot;\r\nreferrer-policy: same-origin\r\nweglot: id.9c6f9687ab2897c1, p.cf\r\nx-frame-options: SAMEORIGIN\r\nprocessed-by: Weglot\r\nweglot-translated: false\r\nvary: Accept-Encoding\r\n\r\nRequest headers\n================\nGET / HTTP/2\r\nHost: fr.ouishare.net\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\nrange: bytes=0-2048\r\n\r\nResponse HTML\n================\nerror code: 526\nLe lien est cassé.","526","","","0.142918","0","1","0","1","0","526|broken|0|https://fr.ouishare.net/","0","0"),
("365","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-academica_ceremonie-dome-de-paris-2023-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:59:11","2026-02-01 06:59:11","2026-02-01 06:59:11","0","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-academica_ceremonie-dome-de-paris-2023-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:59:16 GMT\r\ncontent-type: image/webp\r\ncontent-length: 508178\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-7c112&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/eleves-academica_ceremonie-dome-de-paris-2023-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.026003","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/eleves-academica_ceremonie-dome-de-paris-2023-scaled-1.webp","0","0"),
("366","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-dome-de-paris-graduation-2023-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:59:02","2026-02-01 06:59:02","2026-02-01 06:59:02","0","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-dome-de-paris-graduation-2023-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:59:06 GMT\r\ncontent-type: image/webp\r\ncontent-length: 698146\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-aa722&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/eleves-dome-de-paris-graduation-2023-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.05791","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/eleves-dome-de-paris-graduation-2023-scaled-1.webp","0","0"),
("367","https://dualdiploma.org/wp-content/uploads/2023/08/20230707-academica_ceremonie-128-benjaminbocquet-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 07:00:36","2026-02-01 07:00:36","2026-02-01 07:00:36","0","https://dualdiploma.org/wp-content/uploads/2023/08/20230707-academica_ceremonie-128-benjaminbocquet-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:00:41 GMT\r\ncontent-type: image/webp\r\ncontent-length: 103758\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-1954e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/20230707-academica_ceremonie-128-benjaminbocquet-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.029952","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/20230707-academica_ceremonie-128-benjaminbocquet-scaled-1.webp","0","0"),
("368","https://dualdiploma.org/wp-content/uploads/2023/08/livret-et-echarpe-1-scaled.webp","0000-00-00 00:00:00","2026-02-01 06:03:29","2026-02-01 06:03:29","2026-02-01 06:03:29","0","https://dualdiploma.org/wp-content/uploads/2023/08/livret-et-echarpe-1-scaled.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:03:34 GMT\r\ncontent-type: image/webp\r\ncontent-length: 142092\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-22b0c&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/livret-et-echarpe-1-scaled.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.03263","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/livret-et-echarpe-1-scaled.webp","0","0"),
("369","https://dualdiploma.org/wp-content/uploads/2023/08/antonin.webp","0000-00-00 00:00:00","2026-02-01 06:02:04","2026-02-01 06:02:04","2026-02-01 06:02:04","0","https://dualdiploma.org/wp-content/uploads/2023/08/antonin.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:02:09 GMT\r\ncontent-type: image/webp\r\ncontent-length: 14192\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-3770&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/antonin.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02677","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/antonin.webp","0","0"),
("370","https://dualdiploma.org/wp-content/uploads/2023/08/20230707-academica_ceremonie-113-benjaminbocquet-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:03:49","2026-02-01 06:03:49","2026-02-01 06:03:49","0","https://dualdiploma.org/wp-content/uploads/2023/08/20230707-academica_ceremonie-113-benjaminbocquet-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:03:54 GMT\r\ncontent-type: image/webp\r\ncontent-length: 358096\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-576d0&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/20230707-academica_ceremonie-113-benjaminbocquet-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038247","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/20230707-academica_ceremonie-113-benjaminbocquet-scaled-1.webp","0","0"),
("371","https://dualdiploma.org/wp-content/uploads/2023/08/equipe-de-direction-americaine-academica-dual-diploma-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:03:04","2026-02-01 06:03:04","2026-02-01 06:03:04","0","https://dualdiploma.org/wp-content/uploads/2023/08/equipe-de-direction-americaine-academica-dual-diploma-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:03:09 GMT\r\ncontent-type: image/webp\r\ncontent-length: 225810\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-37212&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/equipe-de-direction-americaine-academica-dual-diploma-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.039989","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/equipe-de-direction-americaine-academica-dual-diploma-scaled-1.webp","0","0"),
("372","https://dualdiploma.org/wp-content/uploads/2023/08/equipe-americaine-academica-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 06:59:21","2026-02-01 06:59:21","2026-02-01 06:59:21","0","https://dualdiploma.org/wp-content/uploads/2023/08/equipe-americaine-academica-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:59:26 GMT\r\ncontent-type: image/webp\r\ncontent-length: 163054\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-27cee&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/equipe-americaine-academica-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.05132","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/equipe-americaine-academica-scaled-1.webp","0","0"),
("373","https://dualdiploma.org/wp-content/uploads/2024/04/20230707-Academia_Ceremonie-GIF-001.gif","0000-00-00 00:00:00","2026-02-01 06:02:54","2026-02-01 06:02:54","2026-02-01 06:02:54","0","https://dualdiploma.org/wp-content/uploads/2024/04/20230707-Academia_Ceremonie-GIF-001.gif","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:02:59 GMT\r\ncontent-type: image/gif\r\ncontent-length: 10148366\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-9ada0e&quot;\r\nexpires: Tue, 03 Mar 2026 06:02:59 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/20230707-Academia_Ceremonie-GIF-001.gif HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.040412","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/20230707-Academia_Ceremonie-GIF-001.gif","0","0"),
("374","https://dualdiploma.org/wp-content/uploads/2023/08/dji_0901-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 05:59:34","2026-02-01 05:59:34","2026-02-01 05:59:34","0","https://dualdiploma.org/wp-content/uploads/2023/08/dji_0901-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:59:39 GMT\r\ncontent-type: image/webp\r\ncontent-length: 57462\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-e076&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/dji_0901-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.035759","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/dji_0901-400x284-1.webp","0","0"),
("375","https://dualdiploma.org/wp-content/uploads/2023/08/img_0301-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 06:59:06","2026-02-01 06:59:06","2026-02-01 06:59:06","0","https://dualdiploma.org/wp-content/uploads/2023/08/img_0301-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:59:11 GMT\r\ncontent-type: image/webp\r\ncontent-length: 45636\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-b244&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/img_0301-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.037812","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/img_0301-400x284-1.webp","0","0"),
("376","https://dualdiploma.org/wp-content/uploads/2023/08/academica-dome-de-paris-academica_ceremonie-dual-diploma-graduation-2023-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 06:58:50","2026-02-01 06:58:50","2026-02-01 06:58:50","0","https://dualdiploma.org/wp-content/uploads/2023/08/academica-dome-de-paris-academica_ceremonie-dual-diploma-graduation-2023-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:58:52 GMT\r\ncontent-type: image/webp\r\ncontent-length: 38606\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-96ce&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/academica-dome-de-paris-academica_ceremonie-dual-diploma-graduation-2023-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.048942","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/academica-dome-de-paris-academica_ceremonie-dual-diploma-graduation-2023-400x284-1.webp","0","0"),
("377","https://dualdiploma.org/wp-content/uploads/2023/08/img_0394-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 07:01:36","2026-02-01 07:01:36","2026-02-01 07:01:36","0","https://dualdiploma.org/wp-content/uploads/2023/08/img_0394-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:01:41 GMT\r\ncontent-type: image/webp\r\ncontent-length: 46532\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-b5c4&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/img_0394-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02667","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/img_0394-400x284-1.webp","0","0"),
("378","https://dualdiploma.org/wp-content/uploads/2023/08/img_0350-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 07:02:11","2026-02-01 07:02:11","2026-02-01 07:02:11","0","https://dualdiploma.org/wp-content/uploads/2023/08/img_0350-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:02:16 GMT\r\ncontent-type: image/webp\r\ncontent-length: 65998\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-101ce&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/img_0350-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.037016","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/img_0350-400x284-1.webp","0","0"),
("379","https://dualdiploma.org/wp-content/uploads/2023/08/debut-ceremonie-graduation-2023-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 07:00:16","2026-02-01 07:00:16","2026-02-01 07:00:16","0","https://dualdiploma.org/wp-content/uploads/2023/08/debut-ceremonie-graduation-2023-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:00:21 GMT\r\ncontent-type: image/webp\r\ncontent-length: 34402\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-8662&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/debut-ceremonie-graduation-2023-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.049026","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/debut-ceremonie-graduation-2023-400x284-1.webp","0","0"),
("380","https://dualdiploma.org/wp-content/uploads/2023/08/drapeau-americain-ceremonie-graduation-2023-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 06:01:59","2026-02-01 06:01:59","2026-02-01 06:01:59","0","https://dualdiploma.org/wp-content/uploads/2023/08/drapeau-americain-ceremonie-graduation-2023-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:02:04 GMT\r\ncontent-type: image/webp\r\ncontent-length: 31224\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-79f8&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/drapeau-americain-ceremonie-graduation-2023-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.025071","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/drapeau-americain-ceremonie-graduation-2023-400x284-1.webp","0","0"),
("381","https://dualdiploma.org/wp-content/uploads/2023/08/graduation-academica_ceremonie-dualdiploma-2023-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 06:59:46","2026-02-01 06:59:46","2026-02-01 06:59:46","0","https://dualdiploma.org/wp-content/uploads/2023/08/graduation-academica_ceremonie-dualdiploma-2023-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:59:51 GMT\r\ncontent-type: image/webp\r\ncontent-length: 39948\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-9c0c&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/graduation-academica_ceremonie-dualdiploma-2023-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024403","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/graduation-academica_ceremonie-dualdiploma-2023-400x284-1.webp","0","0"),
("382","https://dualdiploma.org/wp-content/uploads/2023/08/academica_ceremonie-dual-diploma-graduation-2023-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 05:59:11","2026-02-01 05:59:11","2026-02-01 05:59:11","0","https://dualdiploma.org/wp-content/uploads/2023/08/academica_ceremonie-dual-diploma-graduation-2023-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:59:13 GMT\r\ncontent-type: image/webp\r\ncontent-length: 43374\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-a96e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/academica_ceremonie-dual-diploma-graduation-2023-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02497","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/academica_ceremonie-dual-diploma-graduation-2023-400x284-1.webp","0","0"),
("383","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-sur-scene-academica-dual-diploma-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 06:58:57","2026-02-01 06:58:57","2026-02-01 06:58:57","0","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-sur-scene-academica-dual-diploma-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:59:02 GMT\r\ncontent-type: image/webp\r\ncontent-length: 45662\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-b25e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/eleves-sur-scene-academica-dual-diploma-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.021925","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/eleves-sur-scene-academica-dual-diploma-400x284-1.webp","0","0"),
("384","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-graduation-dual-diploma-2023-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 07:02:51","2026-02-01 07:02:51","2026-02-01 07:02:51","0","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-graduation-dual-diploma-2023-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:02:56 GMT\r\ncontent-type: image/webp\r\ncontent-length: 53296\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-d030&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/eleves-graduation-dual-diploma-2023-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.040717","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/eleves-graduation-dual-diploma-2023-400x284-1.webp","0","0"),
("385","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-diplomes-academica_ceremonie-dual-diploma-2023-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 06:05:49","2026-02-01 06:05:49","2026-02-01 06:05:49","0","https://dualdiploma.org/wp-content/uploads/2023/08/eleves-diplomes-academica_ceremonie-dual-diploma-2023-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:05:54 GMT\r\ncontent-type: image/webp\r\ncontent-length: 51706\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-c9fa&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/eleves-diplomes-academica_ceremonie-dual-diploma-2023-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.03647","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/eleves-diplomes-academica_ceremonie-dual-diploma-2023-400x284-1.webp","0","0"),
("386","https://dualdiploma.org/wp-content/uploads/2023/08/lancer-de-diplomes-academica_ceremonie-dual-diploma-2023.webp","0000-00-00 00:00:00","2026-02-01 06:00:29","2026-02-01 06:00:29","2026-02-01 06:00:29","0","https://dualdiploma.org/wp-content/uploads/2023/08/lancer-de-diplomes-academica_ceremonie-dual-diploma-2023.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:00:34 GMT\r\ncontent-type: image/webp\r\ncontent-length: 732704\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-b2e20&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/lancer-de-diplomes-academica_ceremonie-dual-diploma-2023.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.041125","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/lancer-de-diplomes-academica_ceremonie-dual-diploma-2023.webp","0","0"),
("387","https://dualdiploma.org/wp-content/uploads/2023/08/academica-france-academica_ceremonie-dual-diploma-2023-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 07:01:25","2026-02-01 07:01:25","2026-02-01 07:01:25","0","https://dualdiploma.org/wp-content/uploads/2023/08/academica-france-academica_ceremonie-dual-diploma-2023-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:01:27 GMT\r\ncontent-type: image/webp\r\ncontent-length: 50188\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-c40c&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/academica-france-academica_ceremonie-dual-diploma-2023-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.029653","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/academica-france-academica_ceremonie-dual-diploma-2023-400x284-1.webp","0","0"),
("388","https://dualdiploma.org/wp-content/uploads/2023/08/livret-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 07:03:01","2026-02-01 07:03:01","2026-02-01 07:03:01","0","https://dualdiploma.org/wp-content/uploads/2023/08/livret-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:03:06 GMT\r\ncontent-type: image/webp\r\ncontent-length: 28450\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-6f22&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/livret-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.033939","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/livret-400x284-1.webp","0","0"),
("389","https://dualdiploma.org/wp-content/uploads/2023/08/diplomes-dualdiploma-graduation-2023-400x284-1.webp","0000-00-00 00:00:00","2026-02-01 07:01:51","2026-02-01 07:01:51","2026-02-01 07:01:51","0","https://dualdiploma.org/wp-content/uploads/2023/08/diplomes-dualdiploma-graduation-2023-400x284-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:01:56 GMT\r\ncontent-type: image/webp\r\ncontent-length: 34576\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-8710&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/08/diplomes-dualdiploma-graduation-2023-400x284-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024262","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/08/diplomes-dualdiploma-graduation-2023-400x284-1.webp","0","0"),
("390","http://oiecinternational.com/fr/","0000-00-00 00:00:00","2026-02-01 06:58:56","2026-02-01 06:58:56","2026-02-01 06:58:56","0","http://oiecinternational.com/fr/","1","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 301 ===\n\nResponse headers\n================\nHTTP/1.1 301 Moved Permanently\r\ndate: Sun, 01 Feb 2026 06:58:57 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nserver: OVHcloud\r\nx-powered-by: PHP/7.4\r\nx-redirect-by: WordPress\r\nlocation: https://oiecinternational.com/fr/\r\ncache-control: max-age=2592000\r\nexpires: Tue, 03 Mar 2026 06:58:56 GMT\r\nvary: Accept-Encoding\r\ncontent-encoding: gzip\r\nx-iplb-request-id: 200141D0030402000000000000002DD5:BDD0_200141D0030100000000000000000030:0050_697EF9B0_3B42:1D88\r\nx-iplb-instance: 52335\r\nconnection: close\r\n\r\nRequest headers\n================\nHEAD /fr/ HTTP/1.1\r\nHost: oiecinternational.com\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://dualdiploma.org\r\nConnection: close\r\n\r\n\nLe lien est valide.","301","","","0.892774","0","0","0","1","0","301|0|0|http://oiecinternational.com/fr/","0","0"),
("392","https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-et-herve-lecomte-signature-du-partenariat-entre-academica-international-studies-et-loiec-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 07:02:01","2026-02-01 07:02:01","2026-02-01 07:02:01","0","https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-et-herve-lecomte-signature-du-partenariat-entre-academica-international-studies-et-loiec-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:02:06 GMT\r\ncontent-type: image/webp\r\ncontent-length: 159920\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-270b0&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/09/antonio-l.roca-et-herve-lecomte-signature-du-partenariat-entre-academica-international-studies-et-loiec-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.03883","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-et-herve-lecomte-signature-du-partenariat-entre-academica-international-studies-et-loiec-scaled-1.webp","0","0"),
("393","https://dualdiploma.org/wp-content/uploads/2023/09/logo-oiec.webp","0000-00-00 00:00:00","2026-02-01 06:04:34","2026-02-01 06:04:34","2026-02-01 06:04:34","0","https://dualdiploma.org/wp-content/uploads/2023/09/logo-oiec.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:04:39 GMT\r\ncontent-type: image/webp\r\ncontent-length: 17156\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-4304&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/09/logo-oiec.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.03751","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/09/logo-oiec.webp","0","0"),
("394","https://dualdiploma.org/wp-content/uploads/2023/09/partenariat-ais-et-oiec-logos-unesco-united-nations-counsil-of-europe.webp","0000-00-00 00:00:00","2026-02-01 07:01:02","2026-02-01 07:01:02","2026-02-01 07:01:02","0","https://dualdiploma.org/wp-content/uploads/2023/09/partenariat-ais-et-oiec-logos-unesco-united-nations-counsil-of-europe.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:01:07 GMT\r\ncontent-type: image/webp\r\ncontent-length: 26604\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-67ec&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/09/partenariat-ais-et-oiec-logos-unesco-united-nations-counsil-of-europe.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024292","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/09/partenariat-ais-et-oiec-logos-unesco-united-nations-counsil-of-europe.webp","0","0"),
("395","https://dualdiploma.org/wp-content/uploads/2023/09/partenariat-ais-et-oiec-presidential-e-award.webp","0000-00-00 00:00:00","2026-02-01 06:05:28","2026-02-01 06:05:28","2026-02-01 06:05:28","0","https://dualdiploma.org/wp-content/uploads/2023/09/partenariat-ais-et-oiec-presidential-e-award.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:05:30 GMT\r\ncontent-type: image/webp\r\ncontent-length: 50834\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-c692&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/09/partenariat-ais-et-oiec-presidential-e-award.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.032359","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/09/partenariat-ais-et-oiec-presidential-e-award.webp","0","0"),
("396","https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-herve-lecomte-elizabeth-de-montlivault-chantal-firino-martell-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 07:02:21","2026-02-01 07:02:21","2026-02-01 07:02:21","0","https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-herve-lecomte-elizabeth-de-montlivault-chantal-firino-martell-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:02:26 GMT\r\ncontent-type: image/webp\r\ncontent-length: 187486\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-2dc5e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/09/antonio-l.roca-herve-lecomte-elizabeth-de-montlivault-chantal-firino-martell-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.030943","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-herve-lecomte-elizabeth-de-montlivault-chantal-firino-martell-scaled-1.webp","0","0"),
("397","https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-et-herve-lecomte-en-compagnie-de-lequipe-francaise-dacademica-international-studies-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 07:03:26","2026-02-01 07:03:26","2026-02-01 07:03:26","0","https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-et-herve-lecomte-en-compagnie-de-lequipe-francaise-dacademica-international-studies-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:03:31 GMT\r\ncontent-type: image/webp\r\ncontent-length: 222940\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-366dc&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/09/antonio-l.roca-et-herve-lecomte-en-compagnie-de-lequipe-francaise-dacademica-international-studies-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038198","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/09/antonio-l.roca-et-herve-lecomte-en-compagnie-de-lequipe-francaise-dacademica-international-studies-scaled-1.webp","0","0"),
("400","https://ais.academica.org/ais2021B/wp-content/uploads/2023/05/Spring-2023-DDTimes.pdf","0000-00-00 00:00:00","2026-02-01 07:03:36","2026-02-01 07:03:36","2026-02-01 07:03:36","0","https://ais.academica.org/ais2021B/wp-content/uploads/2023/05/Spring-2023-DDTimes.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Sun, 01 Feb 2026 07:03:36 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 6686095\r\nserver: cloudflare\r\nlast-modified: Thu, 11 May 2023 16:47:40 GMT\r\ncache-control: max-age=14400\r\nexpires: max-age=A10368000, public\r\netag: &quot;645d1c2c-66058f&quot;\r\nstrict-transport-security: max-age=15768000; includeSubDomains\r\nx-powered-by: PleskLin\r\naccept-ranges: bytes\r\ncf-cache-status: MISS\r\nvary: accept-encoding\r\nreport-to: {&quot;group&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https://a.nel.cloudflare.com/report/v4?s=LTivlEFHTo1lwdO8nht3E%2BUrMxPR18Ph5jkDADIMlCzxFYq8OMOZPfxX8xgZ9b%2FYMiNR%2FRPrWrnCuKAumg1YuAoTTYCBW97Ml1NrORaiS12y5QFuAVC06BVclojQ&quot;}]}\r\nnel: {&quot;report_to&quot;:&quot;cf-nel&quot;,&quot;success_fraction&quot;:0.0,&quot;max_age&quot;:604800}\r\ncf-ray: 9c6f97056d1fff34-CDG\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nHEAD /ais2021B/wp-content/uploads/2023/05/Spring-2023-DDTimes.pdf HTTP/2\r\nHost: ais.academica.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.476979","0","0","0","1","0","200|0|0|https://ais.academica.org/ais2021B/wp-content/uploads/2023/05/Spring-2023-DDTimes.pdf","0","0"),
("401","https://www.instagram.com/ddcookingandbakingclub/","0000-00-00 00:00:00","2026-02-01 07:03:36","2026-02-01 07:03:36","2026-02-01 07:03:36","0","https://www.instagram.com/ddcookingandbakingclub/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nvary: Accept-Encoding\r\ncontent-encoding: br\r\nset-cookie: csrftoken=8jgUrrbpbDEKv1vkzfaJX8; expires=Mon, 08-Mar-2027 07:03:37 GMT; Max-Age=34560000; path=/; domain=.instagram.com; secure\r\naccept-ch-lifetime: 4838400\r\naccept-ch: viewport-width,dpr,Sec-CH-Prefers-Color-Scheme,Sec-CH-UA-Full-Version-List,Sec-CH-UA-Platform-Version,Sec-CH-UA-Model\r\nreporting-endpoints: coop_report=&quot;https://www.facebook.com/browser_reporting/coop/?minimize=0&quot;, default=&quot;https://www.instagram.com/error/ig_web_error_reports/?device_level=unknown&amp;brsid=7601788963470738946&amp;comet_app_key=7&amp;cpp=C3&amp;cv=1032755762&amp;st=1769929417355&quot;, permissions_policy=&quot;https://www.instagram.com/error/ig_web_error_reports/&quot;\r\nreport-to: {&quot;max_age&quot;:2592000,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/www.facebook.com\\/browser_reporting\\/coop\\/?minimize=0&quot;}],&quot;group&quot;:&quot;coop_report&quot;,&quot;include_subdomains&quot;:true}, {&quot;max_age&quot;:259200,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/www.instagram.com\\/error\\/ig_web_error_reports\\/?device_level=unknown&amp;brsid=7601788963470738946&amp;comet_app_key=7&amp;cpp=C3&amp;cv=1032755762&amp;st=1769929417355&quot;}]}, {&quot;max_age&quot;:21600,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/www.instagram.com\\/error\\/ig_web_error_reports\\/&quot;}],&quot;group&quot;:&quot;permissions_policy&quot;}\r\ncontent-security-policy-report-only: default-src *.facebook.com *.fbcdn.net *.instagram.com blob:;script-src *.instagram.com static.cdninstagram.com *.facebook.com *.fbcdn.net *.facebook.net 127.0.0.1:* &#039;nonce-VkHwcv8O&#039; blob: &#039;self&#039; https://*.google-analytics.com https://translate.google.com https://apis.google.com https://accounts.google.com &#039;report-sample&#039;;style-src *.instagram.com static.cdninstagram.com data: blob: &#039;unsafe-inline&#039; *.fbcdn.net *.facebook.com;connect-src *.instagram.com wss://edge-chat.instagram.com connect.facebook.net *.facebook.com facebook.com *.fbcdn.net *.facebook.net wss://*.facebook.com:* ws://localhost:* blob: *.cdninstagram.com wss://*.instagram.com:* &#039;self&#039; https://meta.privacy-gateway.cloudflare.com/relay;font-src *.instagram.com static.cdninstagram.com data: *.fbcdn.net *.intern.facebook.com *.facebook.com https://fonts.gstatic.com;img-src *.instagram.com *.facebook.com *.fbcdn.net data: *.cdninstagram.com *.whatsapp.net blob: *.fbsbx.com android-webview-video-poster: *.oculuscdn.com *.giphy.com *.tenor.co *.tenor.com www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk https://www.gstatic.com https://*.google-analytics.com;media-src *.facebook.com *.fbcdn.net *.instagram.com *.cdninstagram.com *.fbsbx.com data: blob: https://*.giphy.com *.tenor.co *.tenor.com;child-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;frame-src *.instagram.com *.facebook.com *.fbsbx.com fbsbx.com data: www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk;manifest-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;object-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;block-all-mixed-content;report-uri https://www.facebook.com/csp/reporting/?minimize=0;\r\ncontent-security-policy: default-src *.facebook.com *.fbcdn.net *.instagram.com blob:;script-src *.instagram.com static.cdninstagram.com *.facebook.com *.fbcdn.net *.facebook.net 127.0.0.1:* &#039;nonce-VkHwcv8O&#039; blob: &#039;self&#039; &#039;unsafe-eval&#039; https://*.google-analytics.com https://translate.google.com https://apis.google.com https://accounts.google.com;style-src *.instagram.com static.cdninstagram.com data: blob: &#039;unsafe-inline&#039; *.fbcdn.net *.facebook.com;connect-src *.instagram.com wss://edge-chat.instagram.com connect.facebook.net *.facebook.com facebook.com *.fbcdn.net *.facebook.net wss://*.facebook.com:* ws://localhost:* blob: *.cdninstagram.com wss://*.instagram.com:* &#039;self&#039; https://meta.privacy-gateway.cloudflare.com/relay;font-src *.instagram.com static.cdninstagram.com data: *.fbcdn.net *.intern.facebook.com *.facebook.com https://fonts.gstatic.com;img-src *.instagram.com *.facebook.com *.fbcdn.net data: *.cdninstagram.com *.whatsapp.net blob: *.fbsbx.com android-webview-video-poster: *.oculuscdn.com *.giphy.com *.tenor.co *.tenor.com www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk https://www.gstatic.com https://*.google-analytics.com;media-src *.facebook.com *.fbcdn.net *.instagram.com *.cdninstagram.com *.fbsbx.com data: blob: https://*.giphy.com *.tenor.co *.tenor.com;child-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;frame-src *.instagram.com *.facebook.com *.fbsbx.com fbsbx.com data: www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk;manifest-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;object-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;block-all-mixed-content;upgrade-insecure-requests;\r\nx-frame-options: DENY\r\ndocument-policy: force-load-at-top\r\ndocument-policy: include-js-call-stacks-in-crash-reports\r\npermissions-policy: accelerometer=(self), attribution-reporting=(), autoplay=(), bluetooth=(), camera=(self), ch-device-memory=(), ch-downlink=(), ch-dpr=(), ch-ect=(), ch-rtt=(), ch-save-data=(), ch-ua-arch=(), ch-ua-bitness=(), ch-viewport-height=(), ch-viewport-width=(), ch-width=(), clipboard-read=(), clipboard-write=(self), compute-pressure=(), display-capture=(self), encrypted-media=(), fullscreen=(self), gamepad=(), geolocation=(self), gyroscope=(self), hid=(), idle-detection=(), interest-cohort=(), keyboard-map=(), local-fonts=(), magnetometer=(), microphone=(self), midi=(), otp-credentials=(self), payment=(), picture-in-picture=(self), private-state-token-issuance=(), publickey-credentials-get=(), screen-wake-lock=(), serial=(), shared-storage=(), shared-storage-select-url=(), private-state-token-redemption=(), usb=(), unload=(self), window-management=(), xr-spatial-tracking=();report-to=&quot;permissions_policy&quot;\r\ncross-origin-resource-policy: same-origin\r\norigin-trial: ArDvqjFKr1fHThlSM8Kkp74sxlOCFTeqYJMXCGqCG/VJmcYlO/0UavmpqPDit2KppDf1THInNpwA36GmtgPOug8AAAB2eyJvcmlnaW4iOiJodHRwczovL3d3dy5pbnN0YWdyYW0uY29tOjQ0MyIsImZlYXR1cmUiOiJDcmFzaFJlcG9ydGluZ1N0b3JhZ2VBUEkiLCJleHBpcnkiOjE3NzY3Mjk2MDAsImlzU3ViZG9tYWluIjp0cnVlfQ==\r\ncross-origin-opener-policy: same-origin-allow-popups;report-to=&quot;coop_report&quot;\r\npragma: no-cache\r\ncache-control: private, no-cache, no-store, must-revalidate\r\nexpires: Sat, 01 Jan 2000 00:00:00 GMT\r\nx-content-type-options: nosniff\r\nx-xss-protection: 0\r\norigin-agent-cluster: ?1\r\nstrict-transport-security: max-age=31536000; preload; includeSubDomains\r\nx-stack: www\r\ncontent-type: text/html; charset=&quot;utf-8&quot;\r\nx-fb-debug: b5bQs1CX0YXFK9V4bpG6eH4iZZaI8wSpRtl1T+z770psTLCE2M2+adBR/iujAdlYIqN4mRoiqnOT/JWK6ekplg==\r\ndate: Sun, 01 Feb 2026 07:03:37 GMT\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\nx-fb-connection-quality: EXCELLENT; q=0.9, rtt=16, rtx=0, c=16, mss=1380, tbw=3852, tp=-1, tpl=-1, uplat=156, ullat=0\r\n\r\nRequest headers\n================\nHEAD /ddcookingandbakingclub/ HTTP/2\r\nHost: www.instagram.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.484415","0","0","0","1","0","200|0|0|https://www.instagram.com/ddcookingandbakingclub/","0","0"),
("402","https://www.instagram.com/dualdiplomabookclub/","0000-00-00 00:00:00","2026-02-01 07:01:01","2026-02-01 07:01:01","2026-02-01 07:01:01","0","https://www.instagram.com/dualdiplomabookclub/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nvary: Accept-Encoding\r\ncontent-encoding: br\r\nset-cookie: csrftoken=r_UFsEqL13aH6kPUKivxZl; expires=Mon, 08-Mar-2027 07:01:01 GMT; Max-Age=34560000; path=/; domain=.instagram.com; secure\r\naccept-ch-lifetime: 4838400\r\naccept-ch: viewport-width,dpr,Sec-CH-Prefers-Color-Scheme,Sec-CH-UA-Full-Version-List,Sec-CH-UA-Platform-Version,Sec-CH-UA-Model\r\nreporting-endpoints: coop_report=&quot;https://www.facebook.com/browser_reporting/coop/?minimize=0&quot;, default=&quot;https://www.instagram.com/error/ig_web_error_reports/?device_level=unknown&amp;brsid=7601788292977429128&amp;comet_app_key=7&amp;cpp=C3&amp;cv=1032755762&amp;st=1769929261784&quot;, permissions_policy=&quot;https://www.instagram.com/error/ig_web_error_reports/&quot;\r\nreport-to: {&quot;max_age&quot;:2592000,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/www.facebook.com\\/browser_reporting\\/coop\\/?minimize=0&quot;}],&quot;group&quot;:&quot;coop_report&quot;,&quot;include_subdomains&quot;:true}, {&quot;max_age&quot;:259200,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/www.instagram.com\\/error\\/ig_web_error_reports\\/?device_level=unknown&amp;brsid=7601788292977429128&amp;comet_app_key=7&amp;cpp=C3&amp;cv=1032755762&amp;st=1769929261784&quot;}]}, {&quot;max_age&quot;:21600,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/www.instagram.com\\/error\\/ig_web_error_reports\\/&quot;}],&quot;group&quot;:&quot;permissions_policy&quot;}\r\ncontent-security-policy-report-only: default-src *.facebook.com *.fbcdn.net *.instagram.com blob:;script-src *.instagram.com static.cdninstagram.com *.facebook.com *.fbcdn.net *.facebook.net 127.0.0.1:* &#039;nonce-cCvb4rCd&#039; blob: &#039;self&#039; https://*.google-analytics.com https://translate.google.com https://apis.google.com https://accounts.google.com &#039;report-sample&#039;;style-src *.instagram.com static.cdninstagram.com data: blob: &#039;unsafe-inline&#039; *.fbcdn.net *.facebook.com;connect-src *.instagram.com wss://edge-chat.instagram.com connect.facebook.net *.facebook.com facebook.com *.fbcdn.net *.facebook.net wss://*.facebook.com:* ws://localhost:* blob: *.cdninstagram.com wss://*.instagram.com:* &#039;self&#039; https://meta.privacy-gateway.cloudflare.com/relay;font-src *.instagram.com static.cdninstagram.com data: *.fbcdn.net *.intern.facebook.com *.facebook.com https://fonts.gstatic.com;img-src *.instagram.com *.facebook.com *.fbcdn.net data: *.cdninstagram.com *.whatsapp.net blob: *.fbsbx.com android-webview-video-poster: *.oculuscdn.com *.giphy.com *.tenor.co *.tenor.com www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk https://www.gstatic.com https://*.google-analytics.com;media-src *.facebook.com *.fbcdn.net *.instagram.com *.cdninstagram.com *.fbsbx.com data: blob: https://*.giphy.com *.tenor.co *.tenor.com;child-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;frame-src *.instagram.com *.facebook.com *.fbsbx.com fbsbx.com data: www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk;manifest-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;object-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;block-all-mixed-content;report-uri https://www.facebook.com/csp/reporting/?minimize=0;\r\ncontent-security-policy: default-src *.facebook.com *.fbcdn.net *.instagram.com blob:;script-src *.instagram.com static.cdninstagram.com *.facebook.com *.fbcdn.net *.facebook.net 127.0.0.1:* &#039;nonce-cCvb4rCd&#039; blob: &#039;self&#039; &#039;unsafe-eval&#039; https://*.google-analytics.com https://translate.google.com https://apis.google.com https://accounts.google.com;style-src *.instagram.com static.cdninstagram.com data: blob: &#039;unsafe-inline&#039; *.fbcdn.net *.facebook.com;connect-src *.instagram.com wss://edge-chat.instagram.com connect.facebook.net *.facebook.com facebook.com *.fbcdn.net *.facebook.net wss://*.facebook.com:* ws://localhost:* blob: *.cdninstagram.com wss://*.instagram.com:* &#039;self&#039; https://meta.privacy-gateway.cloudflare.com/relay;font-src *.instagram.com static.cdninstagram.com data: *.fbcdn.net *.intern.facebook.com *.facebook.com https://fonts.gstatic.com;img-src *.instagram.com *.facebook.com *.fbcdn.net data: *.cdninstagram.com *.whatsapp.net blob: *.fbsbx.com android-webview-video-poster: *.oculuscdn.com *.giphy.com *.tenor.co *.tenor.com www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk https://www.gstatic.com https://*.google-analytics.com;media-src *.facebook.com *.fbcdn.net *.instagram.com *.cdninstagram.com *.fbsbx.com data: blob: https://*.giphy.com *.tenor.co *.tenor.com;child-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;frame-src *.instagram.com *.facebook.com *.fbsbx.com fbsbx.com data: www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk;manifest-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;object-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;block-all-mixed-content;upgrade-insecure-requests;\r\nx-frame-options: DENY\r\ndocument-policy: force-load-at-top\r\ndocument-policy: include-js-call-stacks-in-crash-reports\r\npermissions-policy: accelerometer=(self), attribution-reporting=(), autoplay=(), bluetooth=(), camera=(self), ch-device-memory=(), ch-downlink=(), ch-dpr=(), ch-ect=(), ch-rtt=(), ch-save-data=(), ch-ua-arch=(), ch-ua-bitness=(), ch-viewport-height=(), ch-viewport-width=(), ch-width=(), clipboard-read=(), clipboard-write=(self), compute-pressure=(), display-capture=(self), encrypted-media=(), fullscreen=(self), gamepad=(), geolocation=(self), gyroscope=(self), hid=(), idle-detection=(), interest-cohort=(), keyboard-map=(), local-fonts=(), magnetometer=(), microphone=(self), midi=(), otp-credentials=(self), payment=(), picture-in-picture=(self), private-state-token-issuance=(), publickey-credentials-get=(), screen-wake-lock=(), serial=(), shared-storage=(), shared-storage-select-url=(), private-state-token-redemption=(), usb=(), unload=(self), window-management=(), xr-spatial-tracking=();report-to=&quot;permissions_policy&quot;\r\ncross-origin-resource-policy: same-origin\r\norigin-trial: ArDvqjFKr1fHThlSM8Kkp74sxlOCFTeqYJMXCGqCG/VJmcYlO/0UavmpqPDit2KppDf1THInNpwA36GmtgPOug8AAAB2eyJvcmlnaW4iOiJodHRwczovL3d3dy5pbnN0YWdyYW0uY29tOjQ0MyIsImZlYXR1cmUiOiJDcmFzaFJlcG9ydGluZ1N0b3JhZ2VBUEkiLCJleHBpcnkiOjE3NzY3Mjk2MDAsImlzU3ViZG9tYWluIjp0cnVlfQ==\r\ncross-origin-opener-policy: same-origin-allow-popups\r\npragma: no-cache\r\ncache-control: private, no-cache, no-store, must-revalidate\r\nexpires: Sat, 01 Jan 2000 00:00:00 GMT\r\nx-content-type-options: nosniff\r\nx-xss-protection: 0\r\norigin-agent-cluster: ?1\r\nstrict-transport-security: max-age=31536000; preload; includeSubDomains\r\nx-stack: www\r\ncontent-type: text/html; charset=&quot;utf-8&quot;\r\nx-fb-debug: kBYHmYzvsabUWDzhA1Hrh7bbBBtaRkP4+7Kxc9rTQ7pCX/DeZVgapHbV9C7RvBNyibILqsH6lguYjn8kuv15fw==\r\ndate: Sun, 01 Feb 2026 07:01:01 GMT\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\nx-fb-connection-quality: EXCELLENT; q=0.9, rtt=16, rtx=0, c=16, mss=1380, tbw=3852, tp=-1, tpl=-1, uplat=159, ullat=0\r\n\r\nRequest headers\n================\nHEAD /dualdiplomabookclub/ HTTP/2\r\nHost: www.instagram.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.6013","0","0","0","1","0","200|0|0|https://www.instagram.com/dualdiplomabookclub/","0","0");

INSERT IGNORE INTO `da_blc_links` VALUES 
("403","https://www.instagram.com/dualdiploma_artsociety/","0000-00-00 00:00:00","2026-02-01 07:03:21","2026-02-01 07:03:21","2026-02-01 07:03:21","0","https://www.instagram.com/dualdiploma_artsociety/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nvary: Accept-Encoding\r\ncontent-encoding: br\r\nset-cookie: csrftoken=s5QXjiLf1fbwRo_LlR1tcr; expires=Mon, 08-Mar-2027 07:03:21 GMT; Max-Age=34560000; path=/; domain=.instagram.com; secure\r\naccept-ch-lifetime: 4838400\r\naccept-ch: viewport-width,dpr,Sec-CH-Prefers-Color-Scheme,Sec-CH-UA-Full-Version-List,Sec-CH-UA-Platform-Version,Sec-CH-UA-Model\r\nreporting-endpoints: coop_report=&quot;https://www.facebook.com/browser_reporting/coop/?minimize=0&quot;, default=&quot;https://www.instagram.com/error/ig_web_error_reports/?device_level=unknown&amp;brsid=7601788894191692003&amp;comet_app_key=7&amp;cpp=C3&amp;cv=1032755762&amp;st=1769929401807&quot;, permissions_policy=&quot;https://www.instagram.com/error/ig_web_error_reports/&quot;\r\nreport-to: {&quot;max_age&quot;:2592000,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/www.facebook.com\\/browser_reporting\\/coop\\/?minimize=0&quot;}],&quot;group&quot;:&quot;coop_report&quot;,&quot;include_subdomains&quot;:true}, {&quot;max_age&quot;:259200,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/www.instagram.com\\/error\\/ig_web_error_reports\\/?device_level=unknown&amp;brsid=7601788894191692003&amp;comet_app_key=7&amp;cpp=C3&amp;cv=1032755762&amp;st=1769929401807&quot;}]}, {&quot;max_age&quot;:21600,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/www.instagram.com\\/error\\/ig_web_error_reports\\/&quot;}],&quot;group&quot;:&quot;permissions_policy&quot;}\r\ncontent-security-policy-report-only: default-src *.facebook.com *.fbcdn.net *.instagram.com blob:;script-src *.instagram.com static.cdninstagram.com *.facebook.com *.fbcdn.net *.facebook.net 127.0.0.1:* &#039;nonce-XCGrOjW8&#039; blob: &#039;self&#039; https://*.google-analytics.com https://translate.google.com https://apis.google.com https://accounts.google.com &#039;report-sample&#039;;style-src *.instagram.com static.cdninstagram.com data: blob: &#039;unsafe-inline&#039; *.fbcdn.net *.facebook.com;connect-src *.instagram.com wss://edge-chat.instagram.com connect.facebook.net *.facebook.com facebook.com *.fbcdn.net *.facebook.net wss://*.facebook.com:* ws://localhost:* blob: *.cdninstagram.com wss://*.instagram.com:* &#039;self&#039; https://meta.privacy-gateway.cloudflare.com/relay;font-src *.instagram.com static.cdninstagram.com data: *.fbcdn.net *.intern.facebook.com *.facebook.com https://fonts.gstatic.com;img-src *.instagram.com *.facebook.com *.fbcdn.net data: *.cdninstagram.com *.whatsapp.net blob: *.fbsbx.com android-webview-video-poster: *.oculuscdn.com *.giphy.com *.tenor.co *.tenor.com www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk https://www.gstatic.com https://*.google-analytics.com;media-src *.facebook.com *.fbcdn.net *.instagram.com *.cdninstagram.com *.fbsbx.com data: blob: https://*.giphy.com *.tenor.co *.tenor.com;child-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;frame-src *.instagram.com *.facebook.com *.fbsbx.com fbsbx.com data: www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk;manifest-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;object-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;block-all-mixed-content;report-uri https://www.facebook.com/csp/reporting/?minimize=0;\r\ncontent-security-policy: default-src *.facebook.com *.fbcdn.net *.instagram.com blob:;script-src *.instagram.com static.cdninstagram.com *.facebook.com *.fbcdn.net *.facebook.net 127.0.0.1:* &#039;nonce-XCGrOjW8&#039; blob: &#039;self&#039; &#039;unsafe-eval&#039; https://*.google-analytics.com https://translate.google.com https://apis.google.com https://accounts.google.com;style-src *.instagram.com static.cdninstagram.com data: blob: &#039;unsafe-inline&#039; *.fbcdn.net *.facebook.com;connect-src *.instagram.com wss://edge-chat.instagram.com connect.facebook.net *.facebook.com facebook.com *.fbcdn.net *.facebook.net wss://*.facebook.com:* ws://localhost:* blob: *.cdninstagram.com wss://*.instagram.com:* &#039;self&#039; https://meta.privacy-gateway.cloudflare.com/relay;font-src *.instagram.com static.cdninstagram.com data: *.fbcdn.net *.intern.facebook.com *.facebook.com https://fonts.gstatic.com;img-src *.instagram.com *.facebook.com *.fbcdn.net data: *.cdninstagram.com *.whatsapp.net blob: *.fbsbx.com android-webview-video-poster: *.oculuscdn.com *.giphy.com *.tenor.co *.tenor.com www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk https://www.gstatic.com https://*.google-analytics.com;media-src *.facebook.com *.fbcdn.net *.instagram.com *.cdninstagram.com *.fbsbx.com data: blob: https://*.giphy.com *.tenor.co *.tenor.com;child-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;frame-src *.instagram.com *.facebook.com *.fbsbx.com fbsbx.com data: www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk;manifest-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;object-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;block-all-mixed-content;upgrade-insecure-requests;\r\nx-frame-options: DENY\r\ndocument-policy: force-load-at-top\r\ndocument-policy: include-js-call-stacks-in-crash-reports\r\npermissions-policy: accelerometer=(self), attribution-reporting=(), autoplay=(), bluetooth=(), camera=(self), ch-device-memory=(), ch-downlink=(), ch-dpr=(), ch-ect=(), ch-rtt=(), ch-save-data=(), ch-ua-arch=(), ch-ua-bitness=(), ch-viewport-height=(), ch-viewport-width=(), ch-width=(), clipboard-read=(), clipboard-write=(self), compute-pressure=(), display-capture=(self), encrypted-media=(), fullscreen=(self), gamepad=(), geolocation=(self), gyroscope=(self), hid=(), idle-detection=(), interest-cohort=(), keyboard-map=(), local-fonts=(), magnetometer=(), microphone=(self), midi=(), otp-credentials=(self), payment=(), picture-in-picture=(self), private-state-token-issuance=(), publickey-credentials-get=(), screen-wake-lock=(), serial=(), shared-storage=(), shared-storage-select-url=(), private-state-token-redemption=(), usb=(), unload=(self), window-management=(), xr-spatial-tracking=();report-to=&quot;permissions_policy&quot;\r\ncross-origin-resource-policy: same-origin\r\norigin-trial: ArDvqjFKr1fHThlSM8Kkp74sxlOCFTeqYJMXCGqCG/VJmcYlO/0UavmpqPDit2KppDf1THInNpwA36GmtgPOug8AAAB2eyJvcmlnaW4iOiJodHRwczovL3d3dy5pbnN0YWdyYW0uY29tOjQ0MyIsImZlYXR1cmUiOiJDcmFzaFJlcG9ydGluZ1N0b3JhZ2VBUEkiLCJleHBpcnkiOjE3NzY3Mjk2MDAsImlzU3ViZG9tYWluIjp0cnVlfQ==\r\ncross-origin-opener-policy: same-origin-allow-popups\r\npragma: no-cache\r\ncache-control: private, no-cache, no-store, must-revalidate\r\nexpires: Sat, 01 Jan 2000 00:00:00 GMT\r\nx-content-type-options: nosniff\r\nx-xss-protection: 0\r\norigin-agent-cluster: ?1\r\nstrict-transport-security: max-age=31536000; preload; includeSubDomains\r\nx-stack: www\r\ncontent-type: text/html; charset=&quot;utf-8&quot;\r\nx-fb-debug: FVn5k3pFbI0moeSGFxOihvpKtoJSeFjG/l3Szfx7uARI2kYLJBn6l7cjoBgtDceBFebtEf1iOQZ+s0fWX3cFIQ==\r\ndate: Sun, 01 Feb 2026 07:03:21 GMT\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\nx-fb-connection-quality: EXCELLENT; q=0.9, rtt=16, rtx=0, c=16, mss=1380, tbw=3852, tp=-1, tpl=-1, uplat=153, ullat=0\r\n\r\nRequest headers\n================\nHEAD /dualdiploma_artsociety/ HTTP/2\r\nHost: www.instagram.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.401202","0","0","0","1","0","200|0|0|https://www.instagram.com/dualdiploma_artsociety/","0","0"),
("404","https://dualdiploma.org/wp-content/uploads/2023/12/social-media-club_.webp","0000-00-00 00:00:00","2026-02-01 07:00:56","2026-02-01 07:00:56","2026-02-01 07:00:56","0","https://dualdiploma.org/wp-content/uploads/2023/12/social-media-club_.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:01:01 GMT\r\ncontent-type: image/webp\r\ncontent-length: 72700\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-11bfc&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/12/social-media-club_.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.039085","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/12/social-media-club_.webp","0","0"),
("405","https://dualdiploma.org/wp-content/uploads/2023/12/dd-times-1.webp","0000-00-00 00:00:00","2026-02-01 06:04:04","2026-02-01 06:04:04","2026-02-01 06:04:04","0","https://dualdiploma.org/wp-content/uploads/2023/12/dd-times-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:04:09 GMT\r\ncontent-type: image/webp\r\ncontent-length: 23314\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-5b12&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/12/dd-times-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.035668","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/12/dd-times-1.webp","0","0"),
("406","https://dualdiploma.org/wp-content/uploads/2023/12/cooking-club_.webp","0000-00-00 00:00:00","2026-02-01 07:03:51","2026-02-01 07:03:51","2026-02-01 07:03:51","0","https://dualdiploma.org/wp-content/uploads/2023/12/cooking-club_.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:03:56 GMT\r\ncontent-type: image/webp\r\ncontent-length: 262398\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-400fe&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/12/cooking-club_.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.040016","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/12/cooking-club_.webp","0","0"),
("407","https://dualdiploma.org/wp-content/uploads/2023/12/book-club_.webp","0000-00-00 00:00:00","2026-02-01 06:05:30","2026-02-01 06:05:30","2026-02-01 06:05:30","0","https://dualdiploma.org/wp-content/uploads/2023/12/book-club_.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:05:34 GMT\r\ncontent-type: image/webp\r\ncontent-length: 99270\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-183c6&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/12/book-club_.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.021048","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/12/book-club_.webp","0","0"),
("408","https://dualdiploma.org/wp-content/uploads/2023/12/edutainment_.webp","0000-00-00 00:00:00","2026-02-01 06:01:09","2026-02-01 06:01:09","2026-02-01 06:01:09","0","https://dualdiploma.org/wp-content/uploads/2023/12/edutainment_.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:01:14 GMT\r\ncontent-type: image/webp\r\ncontent-length: 80202\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-1394a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/12/edutainment_.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.031854","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/12/edutainment_.webp","0","0"),
("409","https://dualdiploma.org/wp-content/uploads/2023/12/united-nations.webp","0000-00-00 00:00:00","2026-02-01 07:01:27","2026-02-01 07:01:27","2026-02-01 07:01:27","0","https://dualdiploma.org/wp-content/uploads/2023/12/united-nations.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:01:31 GMT\r\ncontent-type: image/webp\r\ncontent-length: 38074\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-94ba&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/12/united-nations.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.022574","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/12/united-nations.webp","0","0"),
("410","https://dualdiploma.org/wp-content/uploads/2023/12/art-club_.webp","0000-00-00 00:00:00","2026-02-01 07:03:22","2026-02-01 07:03:22","2026-02-01 07:03:22","0","https://dualdiploma.org/wp-content/uploads/2023/12/art-club_.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:03:26 GMT\r\ncontent-type: image/webp\r\ncontent-length: 116220\r\nlast-modified: Wed, 10 Jul 2024 11:17:12 GMT\r\netag: &quot;668e6db8-1c5fc&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2023/12/art-club_.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.019946","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2023/12/art-club_.webp","0","0"),
("411","https://dualdiploma.org/wp-content/uploads/2024/04/elective-public-speaking-and-journalism-800x256.webp","0000-00-00 00:00:00","2026-02-01 07:00:11","2026-02-01 07:00:11","2026-02-01 07:00:11","0","https://dualdiploma.org/wp-content/uploads/2024/04/elective-public-speaking-and-journalism-800x256.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:00:16 GMT\r\ncontent-type: image/webp\r\ncontent-length: 26026\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-65aa&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/04/elective-public-speaking-and-journalism-800x256.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024318","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/04/elective-public-speaking-and-journalism-800x256.webp","0","0"),
("413","https://www.un.org/en/mun","2025-12-19 22:18:42","2026-02-03 00:49:06","2025-12-16 22:18:17","2026-02-03 00:49:06","18","https://www.un.org/en/mun","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 403 ===\n\nResponse headers\n================\nHTTP/2 403 \r\nserver: CloudFront\r\ndate: Tue, 03 Feb 2026 00:49:06 GMT\r\ncontent-type: text/html\r\ncontent-length: 919\r\nx-cache: Error from cloudfront\r\nvia: 1.1 d7b95fc49388e3b88d8d8ce14a277aac.cloudfront.net (CloudFront)\r\nx-amz-cf-pop: FRA50-P2\r\nx-amz-cf-id: DUOnQ_MTuxneOpvIsFa-KjIbXOXZUYA6_tjLynwVOBDHTwBzDYB_XA==\r\nx-xss-protection: 1; mode=block\r\nx-frame-options: SAMEORIGIN\r\nreferrer-policy: strict-origin-when-cross-origin\r\ncontent-security-policy: frame-ancestors &#039;self&#039; https://*.un.org;\r\nx-content-type-options: nosniff\r\nstrict-transport-security: max-age=31536000\r\ncache-control: max-age=86400\r\n\r\nRequest headers\n================\nGET /en/mun HTTP/2\r\nHost: www.un.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\nrange: bytes=0-2048\r\n\r\nResponse HTML\n================\n&lt;!DOCTYPE HTML PUBLIC &quot;-//W3C//DTD HTML 4.01 Transitional//EN&quot; &quot;http://www.w3.org/TR/html4/loose.dtd&quot;&gt;\n&lt;HTML&gt;&lt;HEAD&gt;&lt;META HTTP-EQUIV=&quot;Content-Type&quot; CONTENT=&quot;text/html; charset=iso-8859-1&quot;&gt;\n&lt;TITLE&gt;ERROR: The request could not be satisfied&lt;/TITLE&gt;\n&lt;/HEAD&gt;&lt;BODY&gt;\n&lt;H1&gt;403 ERROR&lt;/H1&gt;\n&lt;H2&gt;The request could not be satisfied.&lt;/H2&gt;\n&lt;HR noshade size=&quot;1px&quot;&gt;\nRequest blocked.\nWe can&#039;t connect to the server for this app or website at this time. There might be too much traffic or a configuration error. Try again later, or contact the app or website owner.\n&lt;BR clear=&quot;all&quot;&gt;\nIf you provide content to customers through CloudFront, you can find steps to troubleshoot and help prevent this error by reviewing the CloudFront documentation.\n&lt;BR clear=&quot;all&quot;&gt;\n&lt;HR noshade size=&quot;1px&quot;&gt;\n&lt;PRE&gt;\nGenerated by cloudfront (CloudFront)\nRequest ID: DUOnQ_MTuxneOpvIsFa-KjIbXOXZUYA6_tjLynwVOBDHTwBzDYB_XA==\n&lt;/PRE&gt;\n&lt;ADDRESS&gt;\n&lt;/ADDRESS&gt;\n&lt;/BODY&gt;&lt;/HTML&gt;\nLe lien est cassé.","403","","","0.217552","0","1","0","1","0","403|broken|0|https://www.un.org/en/mun","0","0"),
("414","https://dualdiploma.org/wp-content/uploads/2024/05/mlk-800x1778.png","0000-00-00 00:00:00","2026-02-01 06:59:16","2026-02-01 06:59:16","2026-02-01 06:59:16","0","https://dualdiploma.org/wp-content/uploads/2024/05/mlk-800x1778.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:59:21 GMT\r\ncontent-type: image/png\r\ncontent-length: 732322\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-b2ca2&quot;\r\nexpires: Tue, 03 Mar 2026 06:59:21 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/mlk-800x1778.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.14668","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/mlk-800x1778.png","0","0"),
("415","https://dualdiploma.org/wp-content/uploads/2024/05/stem-800x1778.png","0000-00-00 00:00:00","2026-02-01 05:59:44","2026-02-01 05:59:44","2026-02-01 05:59:44","0","https://dualdiploma.org/wp-content/uploads/2024/05/stem-800x1778.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 05:59:49 GMT\r\ncontent-type: image/png\r\ncontent-length: 560980\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-88f54&quot;\r\nexpires: Tue, 03 Mar 2026 05:59:49 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/stem-800x1778.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.03862","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/stem-800x1778.png","0","0"),
("416","https://dualdiploma.org/wp-content/uploads/2024/05/hr-800x1778.png","0000-00-00 00:00:00","2026-02-01 07:02:46","2026-02-01 07:02:46","2026-02-01 07:02:46","0","https://dualdiploma.org/wp-content/uploads/2024/05/hr-800x1778.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:02:51 GMT\r\ncontent-type: image/png\r\ncontent-length: 508113\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-7c0d1&quot;\r\nexpires: Tue, 03 Mar 2026 07:02:51 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/hr-800x1778.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.031636","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/hr-800x1778.png","0","0"),
("417","https://dualdiploma.org/wp-content/uploads/2024/05/sdg-800x1778.png","0000-00-00 00:00:00","2026-02-01 07:01:46","2026-02-01 07:01:46","2026-02-01 07:01:46","0","https://dualdiploma.org/wp-content/uploads/2024/05/sdg-800x1778.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:01:51 GMT\r\ncontent-type: image/png\r\ncontent-length: 1106667\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-10e2eb&quot;\r\nexpires: Tue, 03 Mar 2026 07:01:51 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/05/sdg-800x1778.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02908","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/05/sdg-800x1778.png","0","0"),
("419","https://dualdiploma.org/wp-content/uploads/2024/06/parlement-800x418.png","0000-00-00 00:00:00","2026-02-01 06:00:04","2026-02-01 06:00:04","2026-02-01 06:00:04","0","https://dualdiploma.org/wp-content/uploads/2024/06/parlement-800x418.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:00:09 GMT\r\ncontent-type: image/png\r\ncontent-length: 585612\r\nlast-modified: Wed, 10 Jul 2024 11:17:13 GMT\r\netag: &quot;668e6db9-8ef8c&quot;\r\nexpires: Tue, 03 Mar 2026 06:00:09 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/06/parlement-800x418.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.021919","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/06/parlement-800x418.png","0","0"),
("420","https://www.academicaseniors.com/","0000-00-00 00:00:00","2026-02-01 07:03:22","2026-02-01 07:03:22","2026-02-01 07:03:22","0","https://www.academicaseniors.com/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\naccept-ranges: bytes\r\nage: 138195\r\ncontent-encoding: gzip\r\ncontent-type: text/html;charset=utf-8\r\ndate: Fri, 30 Jan 2026 15:49:20 GMT\r\netag: W/&quot;34a8ecd759243ef8db34722f90135c54--gzip&quot;\r\nexpires: Thu, 01 Jan 1970 00:00:00 GMT\r\nserver: Squarespace\r\nset-cookie: crumb=Bb0JvxelMLyoY2Y0NjFlOGI5YWNkNzk0OWQ0OWM3ODQyNTFlOGYx;Secure;Path=/\r\nstrict-transport-security: max-age=0\r\nvary: Accept-Encoding\r\nx-content-type-options: nosniff\r\nx-contextid: mTi4P58Y/le7UjHxA\r\ncontent-length: 53956\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: www.academicaseniors.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.082454","0","0","0","1","0","200|0|0|https://www.academicaseniors.com/","0","0"),
("421","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-204-scaled.webp","0000-00-00 00:00:00","2026-02-01 06:03:54","2026-02-01 06:03:54","2026-02-01 06:03:54","0","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-204-scaled.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:03:59 GMT\r\ncontent-type: image/webp\r\ncontent-length: 261218\r\nlast-modified: Mon, 30 Sep 2024 12:24:12 GMT\r\netag: &quot;66fa986c-3fc62&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/240704-Academica-Reportage-204-scaled.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.042043","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-204-scaled.webp","0","0"),
("422","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-234-800x533.webp","0000-00-00 00:00:00","2026-02-01 06:58:48","2026-02-01 06:58:48","2026-02-01 06:58:48","0","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-234-800x533.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:58:50 GMT\r\ncontent-type: image/webp\r\ncontent-length: 19590\r\nlast-modified: Mon, 02 Sep 2024 15:38:54 GMT\r\netag: &quot;66d5dc0e-4c86&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/240704-Academica-Reportage-234-800x533.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.136428","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-234-800x533.webp","0","0"),
("423","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-260-800x533.webp","0000-00-00 00:00:00","2026-02-01 06:04:14","2026-02-01 06:04:14","2026-02-01 06:04:14","0","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-260-800x533.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:04:19 GMT\r\ncontent-type: image/webp\r\ncontent-length: 18882\r\nlast-modified: Mon, 02 Sep 2024 15:40:48 GMT\r\netag: &quot;66d5dc80-49c2&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/240704-Academica-Reportage-260-800x533.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.045958","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-260-800x533.webp","0","0"),
("424","https://dualdiploma.org/wp-content/uploads/2024/09/alissa-longo-et-yvette-mendez-teachers-800x450.webp","0000-00-00 00:00:00","2026-02-01 06:59:56","2026-02-01 06:59:56","2026-02-01 06:59:56","0","https://dualdiploma.org/wp-content/uploads/2024/09/alissa-longo-et-yvette-mendez-teachers-800x450.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:00:01 GMT\r\ncontent-type: image/webp\r\ncontent-length: 285066\r\nlast-modified: Mon, 02 Sep 2024 15:49:33 GMT\r\netag: &quot;66d5de8d-4598a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/alissa-longo-et-yvette-mendez-teachers-800x450.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.028462","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/alissa-longo-et-yvette-mendez-teachers-800x450.webp","0","0"),
("425","https://dualdiploma.org/wp-content/uploads/2024/09/martine-roussel-et-celine-ouziel-800x450.webp","0000-00-00 00:00:00","2026-02-01 07:00:26","2026-02-01 07:00:26","2026-02-01 07:00:26","0","https://dualdiploma.org/wp-content/uploads/2024/09/martine-roussel-et-celine-ouziel-800x450.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:00:31 GMT\r\ncontent-type: image/webp\r\ncontent-length: 287924\r\nlast-modified: Mon, 02 Sep 2024 15:58:12 GMT\r\netag: &quot;66d5e094-464b4&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/martine-roussel-et-celine-ouziel-800x450.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.019387","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/martine-roussel-et-celine-ouziel-800x450.webp","0","0"),
("426","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-338-800x533.webp","0000-00-00 00:00:00","2026-02-01 06:03:39","2026-02-01 06:03:39","2026-02-01 06:03:39","0","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-338-800x533.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:03:44 GMT\r\ncontent-type: image/webp\r\ncontent-length: 19338\r\nlast-modified: Mon, 02 Sep 2024 16:01:21 GMT\r\netag: &quot;66d5e151-4b8a&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/240704-Academica-Reportage-338-800x533.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.041685","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-338-800x533.webp","0","0"),
("427","https://dualdiploma.org/wp-content/uploads/2024/10/240704-Academica-Reportage-376-scaled.webp","0000-00-00 00:00:00","2026-02-01 06:01:29","2026-02-01 06:01:29","2026-02-01 06:01:29","0","https://dualdiploma.org/wp-content/uploads/2024/10/240704-Academica-Reportage-376-scaled.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 06:01:34 GMT\r\ncontent-type: image/webp\r\ncontent-length: 341942\r\nlast-modified: Tue, 01 Oct 2024 15:27:43 GMT\r\netag: &quot;66fc14ef-537b6&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/10/240704-Academica-Reportage-376-scaled.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02327","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/10/240704-Academica-Reportage-376-scaled.webp","0","0"),
("428","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-458-800x533.webp","0000-00-00 00:00:00","2026-02-01 07:01:07","2026-02-01 07:01:07","2026-02-01 07:01:07","0","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-458-800x533.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:01:11 GMT\r\ncontent-type: image/webp\r\ncontent-length: 135758\r\nlast-modified: Mon, 02 Sep 2024 16:14:48 GMT\r\netag: &quot;66d5e478-2124e&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/240704-Academica-Reportage-458-800x533.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.040727","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-458-800x533.webp","0","0"),
("429","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-558-scaled.webp","0000-00-00 00:00:00","2026-02-01 07:01:41","2026-02-01 07:01:41","2026-02-01 07:01:41","0","https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-558-scaled.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:01:46 GMT\r\ncontent-type: image/webp\r\ncontent-length: 583792\r\nlast-modified: Mon, 30 Sep 2024 12:55:53 GMT\r\netag: &quot;66fa9fd9-8e870&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/09/240704-Academica-Reportage-558-scaled.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.023166","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/09/240704-Academica-Reportage-558-scaled.webp","0","0"),
("434","https://dualdiploma.org/wp-content/uploads/2024/11/diplomes-de-la-ceremonie-de-graduation-800x533.webp","0000-00-00 00:00:00","2026-02-01 21:38:57","2026-02-01 21:38:57","2026-02-01 21:38:57","0","https://dualdiploma.org/wp-content/uploads/2024/11/diplomes-de-la-ceremonie-de-graduation-800x533.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 21:39:02 GMT\r\ncontent-type: image/webp\r\ncontent-length: 40598\r\nlast-modified: Tue, 26 Nov 2024 16:17:23 GMT\r\netag: &quot;6745f493-9e96&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/11/diplomes-de-la-ceremonie-de-graduation-800x533.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.022249","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/11/diplomes-de-la-ceremonie-de-graduation-800x533.webp","0","0"),
("435","https://dualdiploma.org/wp-content/uploads/2024/11/eleve-du-dual-diploma-lors-de-la-remise-de-diplome-2024-800x533.webp","0000-00-00 00:00:00","2026-02-01 21:38:43","2026-02-01 21:38:43","2026-02-01 21:38:43","0","https://dualdiploma.org/wp-content/uploads/2024/11/eleve-du-dual-diploma-lors-de-la-remise-de-diplome-2024-800x533.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 21:38:47 GMT\r\ncontent-type: image/webp\r\ncontent-length: 32600\r\nlast-modified: Tue, 26 Nov 2024 16:22:28 GMT\r\netag: &quot;6745f5c4-7f58&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/11/eleve-du-dual-diploma-lors-de-la-remise-de-diplome-2024-800x533.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020715","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/11/eleve-du-dual-diploma-lors-de-la-remise-de-diplome-2024-800x533.webp","0","0"),
("437","https://authentification.parcoursup.fr/Authentification/connexionGestion","0000-00-00 00:00:00","2026-02-03 03:39:03","2026-02-03 03:39:03","2026-02-03 03:39:03","0","https://authentification.parcoursup.fr/Authentification/connexionGestion","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/1.1 200 \r\nResponse_Token: 2961699339F04D2A8A68EB19FFBB59AD\r\nX-Content-Type-Options: nosniff\r\nX-XSS-Protection: 0\r\nCache-Control: no-cache, no-store, max-age=0, must-revalidate\r\nPragma: no-cache\r\nExpires: 0\r\nContent-Type: text/html;charset=UTF-8\r\nContent-Language: fr-FR\r\nTransfer-Encoding: chunked\r\nDate: Tue, 03 Feb 2026 03:39:03 GMT\r\nConnection: close\r\nStrict-Transport-Security: max-age=16070400; includeSubDomains; preload\r\nSet-Cookie: JSESSIONID=A19B87B8DA885D8D632E4EEA40FD3C6F; Path=/Authentification; HttpOnly; Secure; SameSite=Lax\r\nContent-Security-Policy: default-src *.parcoursup.fr *.parcoursup-nouvelle-caledonie.fr *.twitter.com *.twimg.com *.dailymotion.com fonts.gstatic.com www.gstatic.com github.com www.youtube-nocookie.com &#039;unsafe-eval&#039; &#039;unsafe-inline&#039; &#039;self&#039;; img-src &#039;self&#039; *.parcoursup.fr *.parcoursup-nouvelle-caledonie.fr *.twitter.com *.twimg.com *.dailymotion.com *.paybox.com *.doubleclick.net img.youtube.com data:; connect-src &#039;self&#039; *.parcoursup.fr *.parcoursup-nouvelle-caledonie.fr; frame-ancestors &#039;self&#039; https://*.parcoursup.fr https://*.parcoursup-nouvelle-caledonie.fr\r\nReferrer-Policy: strict-origin-when-cross-origin\r\nPermissions-Policy: speaker=(self &quot;https://*.twitter.com&quot; &quot;https://*.dailymotion.com&quot; &quot;https://www.youtube-nocookie.com&quot;), autoplay=(self &quot;https://*.twitter.com&quot; &quot;https://*.dailymotion.com&quot; &quot;https://www.youtube-nocookie.com&quot;), fullscreen=(self &quot;https://*.twitter.com&quot; &quot;https://*.dailymotion.com&quot; &quot;https://www.youtube-nocookie.com&quot;), geolocation=(self), payment=(self &quot;https://*.paybox.com&quot;), accelerometer=(), ambient-light-sensor=(), battery=(), camera=(), display-capture=(), document-domain=(), encrypted-media=(), gyroscope=(), layout-animations=(), legacy-image-formats=(), magnetometer=(), microphone=(), midi=(), notifications=(), oversized-images=(), picture-in-picture=(), publickey-credentials-get=(), push=(), sync-xhr=(self), usb=(), vibrate=(), wake-lock=(), xr-spatial-tracking=()\r\n\r\nRequest headers\n================\nGET /Authentification/connexionGestion HTTP/1.1\r\nHost: authentification.parcoursup.fr\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://dualdiploma.org\r\nConnection: close\r\nRange: bytes=0-2048\r\n\r\n\nLe lien est valide.","200","","","0.111165","0","0","0","1","0","200|0|0|https://authentification.parcoursup.fr/Authentification/connexionGestion","0","0"),
("438","https://www.unibocconi.it/en","0000-00-00 00:00:00","2026-02-03 03:39:03","2026-02-03 03:39:03","2026-02-03 03:39:03","0","https://www.unibocconi.it/en","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: CloudFront\r\ncontent-type: text/html; charset=UTF-8\r\ndate: Tue, 03 Feb 2026 03:39:04 GMT\r\ncontent-encoding: gzip\r\ncache-control: max-age=60, public\r\ncontent-language: en\r\nx-content-type-options: nosniff\r\nx-frame-options: SAMEORIGIN\r\nexpires: Sun, 19 Nov 1978 05:00:00 GMT\r\nlast-modified: Mon, 02 Feb 2026 16:13:27 GMT\r\netag: W/&quot;1770048807&quot;\r\ncontent-security-policy-report-only: object-src &#039;none&#039;; script-src &#039;self&#039; &#039;unsafe-eval&#039; https://www.googletagmanager.com https://cdn.smooch.io/ https://cdn.siteimprove.net https://cdnjs.cloudflare.com https://static.addtoany.com https://unpkg.com https://widget.spreaker.com; script-src-attr &#039;self&#039;; script-src-elem &#039;self&#039; &#039;unsafe-inline&#039; https://www.googletagmanager.com https://www.unibocconi.it https://analytics.tiktok.com https://connect.facebook.net https://cdn.iubenda.com https://maps.googleapis.com https://static.addtoany.com https://eu.acsbapp.com https://cdn.smooch.io/ https://cse.google.com/ https://www.google.com/ https://cs.iubenda.com/ https://snap.licdn.com/ https://partner.googleadservices.com/ https://googleads.g.doubleclick.net/ https://unibocconi.zendesk.com/ https://library.unibocconi.it/ https://ep2.adtrafficquality.google/ https://static.hotjar.com https://script.hotjar.com https://cdn.siteimprove.net https://cdnjs.cloudflare.com https://unpkg.com https://widget.spreaker.com; style-src &#039;self&#039; &#039;unsafe-inline&#039; https://fonts.googleapis.com https://cdn.smooch.io/ https://cdnjs.cloudflare.com https://unpkg.com; style-src-attr &#039;self&#039; &#039;unsafe-inline&#039;; style-src-elem &#039;self&#039; &#039;unsafe-inline&#039; https://fonts.googleapis.com https://www.google.com https://cdn.smooch.io/ https://cdnjs.cloudflare.com https://unpkg.com; frame-ancestors &#039;self&#039;\r\ncontent-security-policy: object-src &#039;none&#039;; script-src &#039;self&#039; &#039;unsafe-eval&#039; https://www.googletagmanager.com https://cdn.smooch.io/ https://cdn.siteimprove.net https://cdnjs.cloudflare.com https://static.addtoany.com https://unpkg.com https://widget.spreaker.com; script-src-attr &#039;self&#039;; script-src-elem &#039;self&#039; &#039;unsafe-inline&#039; https://www.googletagmanager.com https://www.unibocconi.it https://analytics.tiktok.com https://connect.facebook.net https://cdn.iubenda.com https://maps.googleapis.com https://static.addtoany.com https://eu.acsbapp.com https://cdn.smooch.io/ https://cse.google.com/ https://www.google.com/ https://cs.iubenda.com/ https://snap.licdn.com/ https://partner.googleadservices.com/ https://googleads.g.doubleclick.net/ https://unibocconi.zendesk.com/ https://library.unibocconi.it/ https://ep2.adtrafficquality.google/ https://static.hotjar.com https://script.hotjar.com https://cdn.siteimprove.net https://cdnjs.cloudflare.com https://unpkg.com https://widget.spreaker.com; style-src &#039;self&#039; &#039;unsafe-inline&#039; https://fonts.googleapis.com https://cdn.smooch.io/ https://cdnjs.cloudflare.com https://unpkg.com; style-src-attr &#039;self&#039; &#039;unsafe-inline&#039;; style-src-elem &#039;self&#039; &#039;unsafe-inline&#039; https://fonts.googleapis.com https://www.google.com/ https://cdn.smooch.io/ https://cdnjs.cloudflare.com https://unpkg.com; frame-ancestors &#039;self&#039;\r\naccess-control-allow-origin: https://storybook.unibocconi.it\r\naccess-control-allow-credentials: true\r\nstrict-transport-security: max-age=63072000; includeSubDomains; preload\r\nvary: Accept-Encoding\r\nx-cache: Miss from cloudfront\r\nvia: 1.1 a5aef96cbff4e6d0b6f6c37b4a0dc1e2.cloudfront.net (CloudFront)\r\nx-amz-cf-pop: CDG52-P6\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\nx-amz-cf-id: KBZd2Da6kiGs8mOElz1W9H-HzigWLsJl9HibtrIUnSBVKIpqHIC0_A==\r\nx-xss-protection: 1; mode=block\r\nreferrer-policy: no-referrer-when-downgrade\r\n\r\nRequest headers\n================\nHEAD /en HTTP/2\r\nHost: www.unibocconi.it\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.268997","0","0","0","1","0","200|0|0|https://www.unibocconi.it/en","0","0"),
("439","https://www.polytechnique.edu/","0000-00-00 00:00:00","2026-02-03 03:39:33","2026-02-03 03:39:33","2026-02-03 03:39:33","0","https://www.polytechnique.edu/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: sysdsi/6.6.6\r\ndate: Tue, 03 Feb 2026 03:39:33 GMT\r\ncontent-type: text/html; charset=UTF-8\r\ncontent-length: 243748\r\ncache-control: max-age=86400, public\r\nx-drupal-dynamic-cache: HIT\r\ncontent-language: fr\r\nx-content-type-options: nosniff\r\nx-frame-options: SAMEORIGIN\r\nexpires: Sun, 19 Nov 1978 05:00:00 GMT\r\nlast-modified: Tue, 03 Feb 2026 03:39:33 GMT\r\netag: &quot;1770089973&quot;\r\nvary: Cookie\r\nx-generator: Drupal 10 (https://www.drupal.org)\r\nstrict-transport-security: max-age=31536000; includeSubDomains\r\nx-frame-options: sameorigin\r\nx-content-type-options: nosniff\r\nreferrer-policy: no-referrer-when-downgrade\r\nx-xss-protection: 1; mode=block\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: www.polytechnique.edu\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.177467","0","0","0","1","0","200|0|0|https://www.polytechnique.edu/","0","0"),
("440","https://dualdiploma.org/?s=high+school+diploma+am%C3%A9ricain","0000-00-00 00:00:00","2026-02-03 03:38:58","2026-02-03 03:38:58","2026-02-03 03:38:58","0","https://dualdiploma.org/?s=high+school+diploma+am%C3%A9ricain","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 03:39:03 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /?s=high+school+diploma+am%C3%A9ricain HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.293064","0","0","0","1","0","200|0|0|https://dualdiploma.org/","0","0"),
("441","https://www.columbia.edu/","0000-00-00 00:00:00","2026-02-02 23:48:26","2026-02-02 23:48:26","2026-02-02 23:48:26","0","https://www.columbia.edu/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 403 ===\n\nResponse headers\n================\nHTTP/2 403 \r\ndate: Mon, 02 Feb 2026 23:48:26 GMT\r\ncontent-type: text/html; charset=UTF-8\r\naccept-ch: Sec-CH-UA-Bitness, Sec-CH-UA-Arch, Sec-CH-UA-Full-Version, Sec-CH-UA-Mobile, Sec-CH-UA-Model, Sec-CH-UA-Platform-Version, Sec-CH-UA-Full-Version-List, Sec-CH-UA-Platform, Sec-CH-UA, UA-Bitness, UA-Arch, UA-Full-Version, UA-Mobile, UA-Model, UA-Platform-Version, UA-Platform, UA\r\ncf-mitigated: challenge\r\ncritical-ch: Sec-CH-UA-Bitness, Sec-CH-UA-Arch, Sec-CH-UA-Full-Version, Sec-CH-UA-Mobile, Sec-CH-UA-Model, Sec-CH-UA-Platform-Version, Sec-CH-UA-Full-Version-List, Sec-CH-UA-Platform, Sec-CH-UA, UA-Bitness, UA-Arch, UA-Full-Version, UA-Mobile, UA-Model, UA-Platform-Version, UA-Platform, UA\r\ncross-origin-embedder-policy: require-corp\r\ncross-origin-opener-policy: same-origin\r\ncross-origin-resource-policy: same-origin\r\norigin-agent-cluster: ?1\r\npermissions-policy: accelerometer=(),browsing-topics=(),camera=(),clipboard-read=(),clipboard-write=(),geolocation=(),gyroscope=(),hid=(),interest-cohort=(),magnetometer=(),microphone=(),payment=(),publickey-credentials-get=(),screen-wake-lock=(),serial=(),sync-xhr=(),usb=()\r\nreferrer-policy: same-origin\r\nserver-timing: chlray;desc=&quot;9c7d94539e89288f&quot;\r\nx-content-type-options: nosniff\r\nx-frame-options: SAMEORIGIN\r\ncache-control: private, max-age=0, no-store, no-cache, must-revalidate, post-check=0, pre-check=0\r\nexpires: Thu, 01 Jan 1970 00:00:01 GMT\r\nset-cookie: __cf_bm=3G.NQfSDekAGMA8pAO87eUngM6bwbwjlaar8V.E1qX0-1770076106-1.0.1.1-JSp.7JpRah7.ghqrExzr2UXJ2yEC9nAvIWROYkx6r_4bpfKpaTaY8QPzEOXEtJHe8ARPz30PIptGizIQWkrdL_1RhE2zTEI6DxkuH9Ww5l0; path=/; expires=Tue, 03-Feb-26 00:18:26 GMT; domain=.www.columbia.edu; HttpOnly; Secure; SameSite=None\r\nvary: Accept-Encoding\r\nserver: cloudflare\r\ncf-ray: 9c7d94539e89288f-CDG\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nGET / HTTP/2\r\nHost: www.columbia.edu\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\nrange: bytes=0-2048\r\n\r\nResponse HTML\n================\n&lt;!DOCTYPE html&gt;&lt;html lang=&quot;en-US&quot;&gt;&lt;head&gt;&lt;title&gt;Just a moment...&lt;/title&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=Edge&quot;&gt;&lt;meta name=&quot;robots&quot; content=&quot;noindex,nofollow&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style&gt;*{box-sizing:border-box;margin:0;padding:0}html{line-height:1.15;-webkit-text-size-adjust:100%;color:#313131;font-family:system-ui,-apple-system,BlinkMacSystemFont,&quot;Segoe UI&quot;,Roboto,&quot;Helvetica Neue&quot;,Arial,&quot;Noto Sans&quot;,sans-serif,&quot;Apple Color Emoji&quot;,&quot;Segoe UI Emoji&quot;,&quot;Segoe UI Symbol&quot;,&quot;Noto Color Emoji&quot;}body{display:flex;flex-direction:column;height:100vh;min-height:100vh}.main-content{margin:8rem auto;padding-left:1.5rem;max-width:60rem}@media (width &lt;= 720px){.main-content{margin-top:4rem}}.h2{line-height:2.25rem;font-size:1.5rem;font-weight:500}@media (width &lt;= 720px){.h2{line-height:1.5rem;font-size:1.25rem}}#challenge-error-text{background-image:url(&quot;data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIzMiIgaGVpZ2h0PSIzMiIgZmlsbD0ibm9uZSI+PHBhdGggZmlsbD0iI0IyMEYwMyIgZD0iTTE2IDNhMTMgMTMgMCAxIDAgMTMgMTNBMTMuMDE1IDEzLjAxNSAwIDAgMCAxNiAzbTAgMjRhMTEgMTEgMCAxIDEgMTEtMTEgMTEuMDEgMTEuMDEgMCAwIDEtMTEgMTEiLz48cGF0aCBmaWxsPSIjQjIwRjAzIiBkPSJNMTcuMDM4IDE4LjYxNUgxNC44N0wxNC41NjMgOS41aDIuNzgzem0tMS4wODQgMS40MjdxLjY2IDAgMS4wNTcuMzg4LjQwNy4zODkuNDA3Ljk5NCAwIC41OTYtLjQwNy45ODQtLjM5Ny4zOS0xLjA1Ny4zODktLjY1IDAtMS4wNTYtLjM4OS0uMzk4LS4zODktLjM5OC0uOTg0IDAtLjU5Ny4zOTgtLjk4NS40MDYtLjM5NyAxLjA1Ni0uMzk3Ii8+PC9zdmc+&quot;);background-repeat:no-repeat;background-size:contain;padding-left:34px}@media (prefers-color-scheme: dark){body{background-color:#222;color:#d9d9d9}}&lt;/style&gt;&lt;meta http-equiv=&quot;refresh&quot; content=&quot;360&quot;&gt;&lt;/head&gt;&lt;body&gt;&lt;div class=&quot;main-wrapper&quot; role=&quot;main&quot;&gt;&lt;div class=&quot;main-content&quot;&gt;&lt;noscript&gt;&lt;div class=&quot;h2&quot;&gt;&lt;span id=&quot;challenge-error-text&quot;&gt;Enable JavaScript and cookies to continue&lt;/span&gt;&lt;/div&gt;&lt;/noscript&gt;&lt;/div&gt;&lt;/div&gt;&lt;script&gt;(function(){window._cf_chl_opt = {cvId: &#039;3&#039;,cZone: &#039;www.columbia.edu&#039;\nLe lien est valide.","403","","","0.149201","0","0","0","1","0","403|broken|0|https://www.columbia.edu/","1","1"),
("442","https://dauphine.psl.eu/","0000-00-00 00:00:00","2026-02-03 03:39:32","2026-02-03 03:39:32","2026-02-03 03:39:32","0","https://dauphine.psl.eu/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Tue, 03 Feb 2026 03:30:25 GMT\r\nserver: Apache\r\ncontent-language: fr-FR\r\nexpires: Tue, 03 Feb 2026 04:01:54 GMT\r\ncache-control: public, max-age=1889\r\npragma: public\r\nx-typo3-proxycaching: 0\r\nxkey: da7fd2e87d1ff72c1555c4f88dd3bd49cc40c8b8 da7fd2e87d1ff72c1555c4f88dd3bd49cc40c8b8_1\r\netag: &quot;327da6f93d6906f4fdf26fbc4966b15f-br&quot;\r\nlast-modified: Wed, 28 Jan 2026 09:11:10 GMT\r\nvary: Accept-Encoding\r\ncontent-encoding: br\r\nx-ua-compatible: IE=edge\r\nx-content-type-options: nosniff\r\ncontent-type: text/html; charset=utf-8\r\nvia: 2.0 alproxy\r\nage: 547\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: dauphine.psl.eu\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.096346","0","0","0","1","0","200|0|0|https://dauphine.psl.eu/","0","0"),
("443","https://www.hec.ca/","0000-00-00 00:00:00","2026-02-03 02:08:42","2026-02-03 02:08:42","2026-02-03 02:08:42","0","https://www.hec.ca/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Tue, 03 Feb 2026 02:08:43 GMT\r\ncontent-type: text/html; charset=UTF-8\r\ncf-ray: 9c7e61cc59d32155-CDG\r\ncf-cache-status: DYNAMIC\r\nage: 116\r\ncache-control: max-age=31536000, public\r\ncontent-language: fr\r\nexpires: Sun, 19 Nov 1978 05:00:00 GMT\r\nlast-modified: Tue, 03 Feb 2026 02:06:45 GMT\r\nserver: cloudflare\r\nstrict-transport-security: max-age=15552000; includeSubDomains\r\nvary: Cookie,Accept-Encoding\r\nvia: varnish\r\nx-ah-environment: prod\r\nx-cache: HIT\r\nx-cache-hits: 8\r\nx-content-type-options: nosniff\r\nx-drupal-cache: MISS\r\nx-drupal-dynamic-cache: MISS\r\nx-frame-options: SAMEORIGIN\r\nx-generator: Drupal 10 (https://www.drupal.org)\r\nx-request-id: v-fde4376c-00a4-11f1-8be9-eb3de31d6641\r\ncontent-encoding: br\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: www.hec.ca\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.463874","0","0","0","1","0","200|0|0|https://www.hec.ca/","0","0"),
("445","https://dualdiploma.org/academica-dual-diploma/#programme","0000-00-00 00:00:00","2026-02-03 03:39:09","2026-02-03 03:39:09","2026-02-03 03:39:09","0","https://dualdiploma.org/academica-dual-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 03:39:13 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14126&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14126&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /academica-dual-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.24994","0","0","0","1","0","200|0|0|https://dualdiploma.org/academica-dual-diploma/","0","0"),
("447","https://dualdiploma.org/wp-content/uploads/2024/12/ceremonie-de-remise-de-diplome-2024-du-bac-americain-800x533.webp","0000-00-00 00:00:00","2026-02-03 03:39:23","2026-02-03 03:39:23","2026-02-03 03:39:23","0","https://dualdiploma.org/wp-content/uploads/2024/12/ceremonie-de-remise-de-diplome-2024-du-bac-americain-800x533.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 03:39:27 GMT\r\ncontent-type: image/webp\r\ncontent-length: 47652\r\nlast-modified: Wed, 04 Dec 2024 10:35:55 GMT\r\netag: &quot;6750308b-ba24&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/12/ceremonie-de-remise-de-diplome-2024-du-bac-americain-800x533.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020815","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/12/ceremonie-de-remise-de-diplome-2024-du-bac-americain-800x533.webp","0","0"),
("448","https://dualdiploma.org/wp-content/uploads/2024/12/lancer-de-diplome-du-bac-americain-800x533.webp","0000-00-00 00:00:00","2026-02-03 03:38:52","2026-02-03 03:38:52","2026-02-03 03:38:52","0","https://dualdiploma.org/wp-content/uploads/2024/12/lancer-de-diplome-du-bac-americain-800x533.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 03:38:52 GMT\r\ncontent-type: image/webp\r\ncontent-length: 133650\r\nlast-modified: Wed, 04 Dec 2024 11:15:10 GMT\r\netag: &quot;675039be-20a12&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/12/lancer-de-diplome-du-bac-americain-800x533.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.040361","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/12/lancer-de-diplome-du-bac-americain-800x533.webp","0","0"),
("465","https://lh7-rt.googleusercontent.com/docsz/AD_4nXdizm2XaNYfb2olszDXo80iTgg4abP3w6O2PlicFae1o1FZkM5WKoRblj0VMVbfZ79kgpe-Ub1x_FP-iYaDtLOOdoKXjdRcRlGRDpIgPiQbKWlNE-dHcamupSy_knunnkkr-cRpcg?key=wRJohDMQHvGbsSGkYOpEFt5Y","0000-00-00 00:00:00","2026-02-02 02:38:25","2026-02-02 02:38:25","2026-02-02 02:38:25","0","https://lh7-rt.googleusercontent.com/docsz/AD_4nXdizm2XaNYfb2olszDXo80iTgg4abP3w6O2PlicFae1o1FZkM5WKoRblj0VMVbfZ79kgpe-Ub1x_FP-iYaDtLOOdoKXjdRcRlGRDpIgPiQbKWlNE-dHcamupSy_knunnkkr-cRpcg?key=wRJohDMQHvGbsSGkYOpEFt5Y","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ncontent-type: image/jpeg\r\ncross-origin-resource-policy: cross-origin\r\nvary: Origin\r\naccess-control-allow-origin: *\r\ntiming-allow-origin: *\r\naccess-control-expose-headers: Content-Length\r\netag: &quot;v0&quot;\r\nexpires: Tue, 03 Feb 2026 02:38:27 GMT\r\ncache-control: public, max-age=86400, no-transform\r\ncontent-disposition: inline;filename=&quot;unnamed.jpg&quot;\r\nx-content-type-options: nosniff\r\ndate: Mon, 02 Feb 2026 02:38:27 GMT\r\nserver: fife\r\ncontent-length: 176480\r\nx-xss-protection: 0\r\nalt-svc: h3=&quot;:443&quot;; ma=2592000,h3-29=&quot;:443&quot;; ma=2592000\r\n\r\nRequest headers\n================\nHEAD /docsz/AD_4nXdizm2XaNYfb2olszDXo80iTgg4abP3w6O2PlicFae1o1FZkM5WKoRblj0VMVbfZ79kgpe-Ub1x_FP-iYaDtLOOdoKXjdRcRlGRDpIgPiQbKWlNE-dHcamupSy_knunnkkr-cRpcg?key=wRJohDMQHvGbsSGkYOpEFt5Y HTTP/2\r\nHost: lh7-rt.googleusercontent.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.6144","0","0","0","1","0","200|0|0|https://lh7-rt.googleusercontent.com/docsz/AD_4nXdizm2XaNYfb2olszDXo80iTgg4abP3w6O2PlicFae1o1FZkM5WKoRblj0VMVbfZ79kgpe-Ub1x_FP-iYaDtLOOdoKXjdRcRlGRDpIgPiQbKWlNE-dHcamupSy_knunnkkr-cRpcg","0","0"),
("466","https://dualdiploma.org/wp-content/uploads/2024/12/lancer-de-diplome-du-bac-americain-600x400.webp","0000-00-00 00:00:00","2026-02-02 02:38:24","2026-02-02 02:38:24","2026-02-02 02:38:24","0","https://dualdiploma.org/wp-content/uploads/2024/12/lancer-de-diplome-du-bac-americain-600x400.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 02:38:24 GMT\r\ncontent-type: image/webp\r\ncontent-length: 80760\r\nlast-modified: Wed, 04 Dec 2024 11:15:10 GMT\r\netag: &quot;675039be-13b78&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2024/12/lancer-de-diplome-du-bac-americain-600x400.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.144711","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2024/12/lancer-de-diplome-du-bac-americain-600x400.webp","0","0"),
("467","https://lh7-rt.googleusercontent.com/docsz/AD_4nXd_HkBhbD6T5GPezHtoA97xgj6LGYR6JvAR9aIW1KvTfUZKlWpSVWGfDaHOEIe97PLjqdH_38g8QJylhT-M01k7A-MEuC-_hYMZZbkMmkgJCfO-OINtXPsR7rqN0IQWMHwGF2fNCA?key=wRJohDMQHvGbsSGkYOpEFt5Y","0000-00-00 00:00:00","2026-02-02 02:38:27","2026-02-02 02:38:27","2026-02-02 02:38:27","0","https://lh7-rt.googleusercontent.com/docsz/AD_4nXd_HkBhbD6T5GPezHtoA97xgj6LGYR6JvAR9aIW1KvTfUZKlWpSVWGfDaHOEIe97PLjqdH_38g8QJylhT-M01k7A-MEuC-_hYMZZbkMmkgJCfO-OINtXPsR7rqN0IQWMHwGF2fNCA?key=wRJohDMQHvGbsSGkYOpEFt5Y","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ncontent-type: image/jpeg\r\ncross-origin-resource-policy: cross-origin\r\nvary: Origin\r\naccess-control-allow-origin: *\r\ntiming-allow-origin: *\r\naccess-control-expose-headers: Content-Length\r\netag: &quot;v0&quot;\r\nexpires: Tue, 03 Feb 2026 02:38:29 GMT\r\ncache-control: public, max-age=86400, no-transform\r\ncontent-disposition: inline;filename=&quot;unnamed.jpg&quot;\r\nx-content-type-options: nosniff\r\ndate: Mon, 02 Feb 2026 02:38:29 GMT\r\nserver: fife\r\ncontent-length: 213973\r\nx-xss-protection: 0\r\nalt-svc: h3=&quot;:443&quot;; ma=2592000,h3-29=&quot;:443&quot;; ma=2592000\r\n\r\nRequest headers\n================\nHEAD /docsz/AD_4nXd_HkBhbD6T5GPezHtoA97xgj6LGYR6JvAR9aIW1KvTfUZKlWpSVWGfDaHOEIe97PLjqdH_38g8QJylhT-M01k7A-MEuC-_hYMZZbkMmkgJCfO-OINtXPsR7rqN0IQWMHwGF2fNCA?key=wRJohDMQHvGbsSGkYOpEFt5Y HTTP/2\r\nHost: lh7-rt.googleusercontent.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.629883","0","0","0","1","0","200|0|0|https://lh7-rt.googleusercontent.com/docsz/AD_4nXd_HkBhbD6T5GPezHtoA97xgj6LGYR6JvAR9aIW1KvTfUZKlWpSVWGfDaHOEIe97PLjqdH_38g8QJylhT-M01k7A-MEuC-_hYMZZbkMmkgJCfO-OINtXPsR7rqN0IQWMHwGF2fNCA","0","0"),
("468","https://lh7-rt.googleusercontent.com/docsz/AD_4nXdM1QwNYpcfAliFBKDqZg3_qJpsvBwzwRoxY5yrTZLYlL0zV8HK0pmHLn-02_agrBw0Xdh3-xwgzVws3aKW0Gmq5QS0Uyl8Yv72xq8zepjICiwlTVqjGss8-xrJH8z9cHXNot-bIQ?key=wRJohDMQHvGbsSGkYOpEFt5Y","0000-00-00 00:00:00","2026-02-02 02:38:24","2026-02-02 02:38:24","2026-02-02 02:38:24","0","https://lh7-rt.googleusercontent.com/docsz/AD_4nXdM1QwNYpcfAliFBKDqZg3_qJpsvBwzwRoxY5yrTZLYlL0zV8HK0pmHLn-02_agrBw0Xdh3-xwgzVws3aKW0Gmq5QS0Uyl8Yv72xq8zepjICiwlTVqjGss8-xrJH8z9cHXNot-bIQ?key=wRJohDMQHvGbsSGkYOpEFt5Y","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ncontent-type: image/jpeg\r\ncross-origin-resource-policy: cross-origin\r\nvary: Origin\r\naccess-control-allow-origin: *\r\ntiming-allow-origin: *\r\naccess-control-expose-headers: Content-Length\r\netag: &quot;v0&quot;\r\nexpires: Tue, 03 Feb 2026 02:38:25 GMT\r\ncache-control: public, max-age=86400, no-transform\r\ncontent-disposition: inline;filename=&quot;unnamed.jpg&quot;\r\nx-content-type-options: nosniff\r\ndate: Mon, 02 Feb 2026 02:38:25 GMT\r\nserver: fife\r\ncontent-length: 566274\r\nx-xss-protection: 0\r\nalt-svc: h3=&quot;:443&quot;; ma=2592000,h3-29=&quot;:443&quot;; ma=2592000\r\n\r\nRequest headers\n================\nHEAD /docsz/AD_4nXdM1QwNYpcfAliFBKDqZg3_qJpsvBwzwRoxY5yrTZLYlL0zV8HK0pmHLn-02_agrBw0Xdh3-xwgzVws3aKW0Gmq5QS0Uyl8Yv72xq8zepjICiwlTVqjGss8-xrJH8z9cHXNot-bIQ?key=wRJohDMQHvGbsSGkYOpEFt5Y HTTP/2\r\nHost: lh7-rt.googleusercontent.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.729586","0","0","0","1","0","200|0|0|https://lh7-rt.googleusercontent.com/docsz/AD_4nXdM1QwNYpcfAliFBKDqZg3_qJpsvBwzwRoxY5yrTZLYlL0zV8HK0pmHLn-02_agrBw0Xdh3-xwgzVws3aKW0Gmq5QS0Uyl8Yv72xq8zepjICiwlTVqjGss8-xrJH8z9cHXNot-bIQ","0","0"),
("470","https://dualdiploma.org/academica-dual-diploma/#diplome","0000-00-00 00:00:00","2026-02-01 07:00:06","2026-02-01 07:00:06","2026-02-01 07:00:06","0","https://dualdiploma.org/academica-dual-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 07:00:11 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/14126&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=14126&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /academica-dual-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.371999","0","0","0","1","0","200|0|0|https://dualdiploma.org/academica-dual-diploma/","0","0"),
("471","https://lh7-rt.googleusercontent.com/docsz/AD_4nXdZ4K63e7iqeas3gmt-TUYRLOVRtNt7Aud_CUCTvAKX281lVqr-tlcztPsxfMG9hmVO-hOhuo5pra6ITTudvQPYx9Mbj3JNLGZiPNaC2cCziFt2YvV90tWy5EPTNzvbBELAAa4q2g?key=wZ6-Sxrxu8Z_oSrUBApvQzv3","0000-00-00 00:00:00","2026-02-01 07:01:23","2026-02-01 07:01:23","2026-02-01 07:01:23","0","https://lh7-rt.googleusercontent.com/docsz/AD_4nXdZ4K63e7iqeas3gmt-TUYRLOVRtNt7Aud_CUCTvAKX281lVqr-tlcztPsxfMG9hmVO-hOhuo5pra6ITTudvQPYx9Mbj3JNLGZiPNaC2cCziFt2YvV90tWy5EPTNzvbBELAAa4q2g?key=wZ6-Sxrxu8Z_oSrUBApvQzv3","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ncontent-type: image/jpeg\r\ncross-origin-resource-policy: cross-origin\r\nvary: Origin\r\naccess-control-allow-origin: *\r\ntiming-allow-origin: *\r\naccess-control-expose-headers: Content-Length\r\netag: &quot;v0&quot;\r\nexpires: Mon, 02 Feb 2026 07:01:23 GMT\r\ncache-control: public, max-age=86400, no-transform\r\ncontent-disposition: inline;filename=&quot;unnamed.jpg&quot;\r\nx-content-type-options: nosniff\r\ndate: Sun, 01 Feb 2026 07:01:23 GMT\r\nserver: fife\r\ncontent-length: 1150504\r\nx-xss-protection: 0\r\nalt-svc: h3=&quot;:443&quot;; ma=2592000,h3-29=&quot;:443&quot;; ma=2592000\r\n\r\nRequest headers\n================\nHEAD /docsz/AD_4nXdZ4K63e7iqeas3gmt-TUYRLOVRtNt7Aud_CUCTvAKX281lVqr-tlcztPsxfMG9hmVO-hOhuo5pra6ITTudvQPYx9Mbj3JNLGZiPNaC2cCziFt2YvV90tWy5EPTNzvbBELAAa4q2g?key=wZ6-Sxrxu8Z_oSrUBApvQzv3 HTTP/2\r\nHost: lh7-rt.googleusercontent.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.621216","0","0","0","1","0","200|0|0|https://lh7-rt.googleusercontent.com/docsz/AD_4nXdZ4K63e7iqeas3gmt-TUYRLOVRtNt7Aud_CUCTvAKX281lVqr-tlcztPsxfMG9hmVO-hOhuo5pra6ITTudvQPYx9Mbj3JNLGZiPNaC2cCziFt2YvV90tWy5EPTNzvbBELAAa4q2g","0","0"),
("473","https://dualdiploma.org/wp-content/uploads/2025/01/FAQ-de-rentree-Jumpstart-24-25-Parents-Apres-le-Test.pdf","0000-00-00 00:00:00","2026-01-31 23:28:55","2026-01-31 23:28:55","2026-01-31 23:28:55","0","https://dualdiploma.org/wp-content/uploads/2025/01/FAQ-de-rentree-Jumpstart-24-25-Parents-Apres-le-Test.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 23:28:55 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 455441\r\nlast-modified: Thu, 09 Jan 2025 11:26:08 GMT\r\netag: &quot;677fb250-6f311&quot;\r\nexpires: Mon, 02 Mar 2026 23:28:55 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/01/FAQ-de-rentree-Jumpstart-24-25-Parents-Apres-le-Test.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02879","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/01/FAQ-de-rentree-Jumpstart-24-25-Parents-Apres-le-Test.pdf","0","0"),
("481","https://dualdiploma.org/inscription-webinaire-partenaire/","0000-00-00 00:00:00","2026-02-02 20:59:34","2026-02-02 20:59:34","2026-02-02 20:59:34","0","https://dualdiploma.org/inscription-webinaire-partenaire/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:59:40 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/15639&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=15639&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /inscription-webinaire-partenaire/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.689188","0","0","0","1","0","200|0|0|https://dualdiploma.org/inscription-webinaire-partenaire/","0","0"),
("483","https://dualdiploma.org/?s=College+Entrance+Exam+Prep","0000-00-00 00:00:00","2026-01-31 22:09:06","2026-01-31 22:09:06","2026-01-31 22:09:06","0","https://dualdiploma.org/?s=College+Entrance+Exam+Prep","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 22:09:06 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /?s=College+Entrance+Exam+Prep HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.26471","0","0","0","1","0","200|0|0|https://dualdiploma.org/","0","0"),
("484","https://www.georgetown.edu/","0000-00-00 00:00:00","2026-02-01 00:08:10","2026-02-01 00:08:10","2026-02-01 00:08:10","0","https://www.georgetown.edu/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ncache-control: public, max-age=86400\r\ncontent-encoding: gzip\r\ncontent-type: text/html; charset=UTF-8\r\npermissions-policy: geolocation=(self), microphone=(), camera=()\r\nreferrer-policy: no-referrer-when-downgrade\r\nserver: nginx\r\nstrict-transport-security: max-age=63072000; includeSubdomains; preload\r\nx-content-type-options: nosniff\r\nx-frame-options: SAMEORIGIN\r\nx-pantheon-styx-hostname: styx-fe2-a-848544cbb8-zxcwh\r\nx-styx-req-id: 2025aa28-fea2-11f0-a509-6e9421bf3059\r\nage: 41217\r\naccept-ranges: bytes\r\nvia: 1.1 varnish, 1.1 varnish, 1.1 varnish, 1.1 varnish\r\ndate: Sun, 01 Feb 2026 00:08:11 GMT\r\nx-served-by: cache-chi-kigq8000088-CHI, cache-lcy-eglc8600031-LCY, cache-lcy-egml8630068-LCY, cache-lcy-egml8630068-LCY\r\nx-cache: HIT, HIT, MISS, MISS\r\nx-cache-hits: 9, 10, 0, 0\r\nx-timer: S1769904492.506168,VS0,VE5\r\nvary: Accept-Encoding, Cookie, Cookie\r\ncontent-length: 53647\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: www.georgetown.edu\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.432902","0","0","0","1","0","200|0|0|https://www.georgetown.edu/","0","0"),
("485","https://www.brown.edu/","0000-00-00 00:00:00","2026-01-31 22:09:06","2026-01-31 22:09:06","2026-01-31 22:09:06","0","https://www.brown.edu/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Sat, 31 Jan 2026 22:09:07 GMT\r\ncontent-type: text/html; charset=UTF-8\r\ncf-ray: 9c6c8812cce4a105-CDG\r\ncf-cache-status: DYNAMIC\r\nage: 20530\r\ncache-control: max-age=86400, public\r\ncontent-language: en\r\nexpires: Sun, 19 Nov 1978 05:00:00 GMT\r\nlast-modified: Sat, 31 Jan 2026 16:26:56 GMT\r\nserver: cloudflare\r\nstrict-transport-security: max-age=300\r\nvary: Accept-Encoding, Cookie, Origin, Cookie, Cookie\r\nvia: 1.1 varnish, 1.1 varnish, 1.1 varnish, 1.1 varnish\r\nx-cache: HIT, HIT, MISS, MISS\r\nx-cache-hits: 29, 85, 0, 0\r\nx-content-type-options: nosniff\r\nx-drupal-dynamic-cache: MISS\r\nx-frame-options: SAMEORIGIN\r\nx-generator: Drupal 10 (https://www.drupal.org)\r\nx-pantheon-styx-hostname: styx-fe1-b-6d866b556d-c4z79\r\nx-served-by: cache-chi-klot8100163-CHI, cache-bru1480029-BRU, cache-bru1480054-BRU, cache-bru1480054-BRU\r\nx-styx-req-id: a91778c2-fec1-11f0-8657-ae4a755b37dc\r\nx-timer: S1769897347.058674,VS0,VE7\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: www.brown.edu\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.298755","0","0","0","1","0","200|0|0|https://www.brown.edu/","0","0"),
("486","https://lh7-rt.googleusercontent.com/docsz/AD_4nXdXwKTtrlLNxBsWYBNky-LpEmihJPRchWYp13bGjPaAUacWcNRo2NFh63Px_RRuKojjIW1DEqX8JmX2NMe8vsw4spOUYNahP0Mco5zA7mkgsZldNOj_KM3NqGSIc7fsZcyoY2XAkQ?key=fIu53lRuP0tc_GV7aNkHiUk0","0000-00-00 00:00:00","2026-01-31 22:09:05","2026-01-31 22:09:05","2026-01-31 22:09:05","0","https://lh7-rt.googleusercontent.com/docsz/AD_4nXdXwKTtrlLNxBsWYBNky-LpEmihJPRchWYp13bGjPaAUacWcNRo2NFh63Px_RRuKojjIW1DEqX8JmX2NMe8vsw4spOUYNahP0Mco5zA7mkgsZldNOj_KM3NqGSIc7fsZcyoY2XAkQ?key=fIu53lRuP0tc_GV7aNkHiUk0","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ncontent-type: image/jpeg\r\ncross-origin-resource-policy: cross-origin\r\nvary: Origin\r\naccess-control-allow-origin: *\r\ntiming-allow-origin: *\r\naccess-control-expose-headers: Content-Length\r\netag: &quot;v0&quot;\r\nexpires: Sun, 01 Feb 2026 22:09:06 GMT\r\ncache-control: public, max-age=86400, no-transform\r\ncontent-disposition: inline;filename=&quot;unnamed.jpg&quot;\r\nx-content-type-options: nosniff\r\ndate: Sat, 31 Jan 2026 22:09:06 GMT\r\nserver: fife\r\ncontent-length: 687926\r\nx-xss-protection: 0\r\nalt-svc: h3=&quot;:443&quot;; ma=2592000,h3-29=&quot;:443&quot;; ma=2592000\r\n\r\nRequest headers\n================\nHEAD /docsz/AD_4nXdXwKTtrlLNxBsWYBNky-LpEmihJPRchWYp13bGjPaAUacWcNRo2NFh63Px_RRuKojjIW1DEqX8JmX2NMe8vsw4spOUYNahP0Mco5zA7mkgsZldNOj_KM3NqGSIc7fsZcyoY2XAkQ?key=fIu53lRuP0tc_GV7aNkHiUk0 HTTP/2\r\nHost: lh7-rt.googleusercontent.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.531631","0","0","0","1","0","200|0|0|https://lh7-rt.googleusercontent.com/docsz/AD_4nXdXwKTtrlLNxBsWYBNky-LpEmihJPRchWYp13bGjPaAUacWcNRo2NFh63Px_RRuKojjIW1DEqX8JmX2NMe8vsw4spOUYNahP0Mco5zA7mkgsZldNOj_KM3NqGSIc7fsZcyoY2XAkQ","0","0"),
("487","https://www.sciencespo.fr/fr/","0000-00-00 00:00:00","2026-01-31 22:48:29","2026-01-31 22:48:29","2026-01-31 22:48:29","0","https://www.sciencespo.fr/fr/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/1.1 200 OK\r\nDate: Sat, 31 Jan 2026 22:48:29 GMT\r\nContent-Type: text/html\r\nContent-Length: 475698\r\nConnection: close\r\nLast-Modified: Fri, 30 Jan 2026 16:04:14 GMT\r\nETag: &quot;697cd67e-74232&quot;\r\nAccept-Ranges: bytes\r\nX-Frame-Options: SAMEORIGIN\r\nContent-Security-Policy: upgrade-insecure-requests\r\nStrict-Transport-Security: max-age=16000000; includeSubDomains; preload;\r\nX-Content-Type-Options: nosniff\r\nReferrer-Policy: no-referrer-when-downgrade\r\nX-XSS-Protection: 1;mode=block\r\nPermissions-Policy: interest-cohort=()\r\nSet-Cookie: SERVERID=webrouter02.reims; path=/; HttpOnly; Secure\r\nCache-control: private\r\n\r\nRequest headers\n================\nHEAD /fr/ HTTP/1.1\r\nHost: www.sciencespo.fr\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://dualdiploma.org\r\nConnection: close\r\n\r\n\nLe lien est valide.","200","","","0.371346","0","0","0","1","0","200|0|0|https://www.sciencespo.fr/fr/","0","0"),
("493","https://dualdiploma.org/wp-content/uploads/2025/01/young-asia-businesswoman-using-laptop-talk-colleague-about-plan-video-call-meeting-while-work-from-home-living-room-1-scaled.jpg","0000-00-00 00:00:00","2026-02-01 21:38:41","2026-02-01 21:38:41","2026-02-01 21:38:41","0","https://dualdiploma.org/wp-content/uploads/2025/01/young-asia-businesswoman-using-laptop-talk-colleague-about-plan-video-call-meeting-while-work-from-home-living-room-1-scaled.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 21:38:43 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 213536\r\nlast-modified: Thu, 30 Jan 2025 16:29:52 GMT\r\netag: &quot;679ba900-34220&quot;\r\nexpires: Tue, 03 Mar 2026 21:38:43 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/01/young-asia-businesswoman-using-laptop-talk-colleague-about-plan-video-call-meeting-while-work-from-home-living-room-1-scaled.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.036724","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/01/young-asia-businesswoman-using-laptop-talk-colleague-about-plan-video-call-meeting-while-work-from-home-living-room-1-scaled.jpg","0","0"),
("494","https://dualdiploma.org/wp-content/uploads/2025/01/Design-sans-titre-15.png","0000-00-00 00:00:00","2026-02-02 03:48:32","2026-02-02 03:48:32","2026-02-02 03:48:32","0","https://dualdiploma.org/wp-content/uploads/2025/01/Design-sans-titre-15.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 03:48:32 GMT\r\ncontent-type: image/png\r\ncontent-length: 13625\r\nlast-modified: Mon, 03 Feb 2025 16:45:55 GMT\r\netag: &quot;67a0f2c3-3539&quot;\r\nexpires: Wed, 04 Mar 2026 03:48:32 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/01/Design-sans-titre-15.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.150533","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/01/Design-sans-titre-15.png","0","0"),
("497","https://creatorapp.zohopublic.eu/dualdiploma/inscription-webinaire/form-perma/Formulaire_d_Inscription/bEnsq9ZCzuSW4PE74SEwOUa11hj3aYegDPJGbxngq5U0VmfNsKH52wDyxpO5qnG0OjhSwDWGz3rvxVnTNXDEU1BZpkqts0RWtmng","2025-09-13 19:39:00","2026-02-02 01:08:48","2025-09-10 19:28:20","2026-02-02 01:08:48","50","https://creatorapp.zohopublic.eu/dualdiploma/inscription-webinaire/form-perma/Formulaire_d_Inscription/bEnsq9ZCzuSW4PE74SEwOUa11hj3aYegDPJGbxngq5U0VmfNsKH52wDyxpO5qnG0OjhSwDWGz3rvxVnTNXDEU1BZpkqts0RWtmng","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 404 ===\n\nResponse headers\n================\nHTTP/1.1 404 \r\nServer: ZGS\r\nDate: Mon, 02 Feb 2026 01:08:49 GMT\r\nContent-Type: text/html;charset=UTF-8\r\nTransfer-Encoding: chunked\r\nConnection: close\r\nSet-Cookie: zalb_754b98fd32=5d6b8ad15ad2458cefbcff81fd09b937; Path=/; Secure; HttpOnly\r\nX-Content-Type-Options: nosniff\r\nSet-Cookie: zccpn=2711364c-2a2e-4366-8de3-d71ab11de9d5;path=/;SameSite=None;Secure;priority=high\r\nSet-Cookie: _zcsr_tmp=2711364c-2a2e-4366-8de3-d71ab11de9d5;path=/;SameSite=Strict;Secure;priority=high\r\nCache-Control: private,no-cache,no-store,max-age=0,must-revalidate\r\nPragma: no-cache\r\nExpires: Thu, 01 Jan 1970 00:00:00 GMT\r\nX-Frame-Options: DENY\r\nSet-Cookie: cli_rgn=FR; Max-Age=21600; Expires=Mon, 02 Feb 2026 07:08:48 GMT; Path=/; Secure; HttpOnly\r\nSet-Cookie: JSESSIONID=3FC7186E53577D9506187DD6A7AF3152; Path=/; Secure; HttpOnly\r\nvary: accept-encoding\r\nContent-Encoding: gzip\r\nContent-Language: en-US\r\nStrict-Transport-Security: max-age=64072000; includeSubDomains; preload\r\n\r\nRequest headers\n================\nGET /dualdiploma/inscription-webinaire/form-perma/Formulaire_d_Inscription/bEnsq9ZCzuSW4PE74SEwOUa11hj3aYegDPJGbxngq5U0VmfNsKH52wDyxpO5qnG0OjhSwDWGz3rvxVnTNXDEU1BZpkqts0RWtmng HTTP/1.1\r\nHost: creatorapp.zohopublic.eu\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://dualdiploma.org\r\nConnection: close\r\nRange: bytes=0-2048\r\n\r\nResponse HTML\n================\n\n&lt;!DOCTYPE html&gt;\n&lt;html&gt;&lt;head&gt;&lt;meta charset=&quot;UTF-8&quot;/&gt;\n&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1.0&quot;/&gt;&lt;title&gt;Zoho Creator&lt;/title&gt;&lt;link href=&quot;/zohocreator/downloadFavIcon/20077905137/1718825493889_favicon.jpg&quot; rel=&quot;SHORTCUT ICON&quot;/&gt;\n&lt;script nonce=&quot;p6hs3eIpXl4iIXCg8T/QAA==&quot;&gt;function setCookie(keyName,value,expiryTime,domain,path)\n{\nvar expdate=new Date();\nif(expiryTime)\n{\nexpdate.setTime(expdate.getTime()+(expiryTime*24*3600*1000));\n}\nelse\n{\nexpdate.setTime(expdate.getTime()+(365*24*3600*1000));\n}\nvar cookieStr = keyName+ &quot;=&quot; +escape(value)+ &quot;;expires=&quot;+expdate.toGMTString()+&quot;;&quot;;//No I18N\nif(domain)\n{\ncookieStr = cookieStr + &quot;domain=&quot;+escape(domain)+&quot;;&quot;;//No I18N\n}\nif(path)\n{\ncookieStr = cookieStr + &quot;path=&quot;+escape(path)+&quot;;&quot;;//No I18N\n}\ndocument.cookie=cookieStr;\n}\nfunction loadCSS(url){\nvar css = document.createElement(&quot;link&quot;);\ncss.type = &#039;text/css&#039;;\ncss.rel = &#039;stylesheet&#039;;\ncss.href = url;\ndocument.getElementsByTagName(&quot;head&quot;)[0].appendChild(css);\n}\nfunction getCookie(keyName){\ntry {\nif (document.cookie.length&gt;0){\ncookieBegin=document.cookie.indexOf(keyName + &quot;=&quot;); //No I18N\nif (cookieBegin!=-1){\ncookieBegin=cookieBegin + keyName.length+1;\ncookieEnd=document.cookie.indexOf(&quot;;&quot;,cookieBegin); //No I18N\nif (cookieEnd==-1){ \ncookieEnd=document.cookie.length;\n}\nreturn unescape(document.cookie.substring(cookieBegin,cookieEnd));\n}\n}	\n} \ncatch(e) {}\nreturn &quot;&quot;; //No I18N\n}\nfunction isNull(value){\nif(!value || value == &quot;undefined&quot; || typeof(value) == &quot;undefined&quot; || value == &quot;NULL&quot; || value == &quot;null&quot; || value.length == 0 || value == &quot;&quot;){\nreturn true;\n}\nreturn false;\n}\nfunction loadFiles(itemsToLoad,compressed,defer) { //don&#039;t remove this method from this file\nvar promises = itemsToLoad.map(function(url) {\nreturn loadFile(url,compressed,defer);\n});\nreturn Promise.all(promises);    \n}\nfunction loadFile(url,defer,compressed){ //don&#039;t remove this method from this file\nreturn new Promise(function(resolve, reject) {\nif(!compressed &amp;&amp; !defer){\nif(typeof(getConfig) != &quot;undefined&quot; &amp;&amp; !getConfig().useCompression &amp;&amp;\nLe lien est cassé.","404","","","0.451321","0","1","0","1","0","404|broken|0|https://creatorapp.zohopublic.eu/dualdiploma/inscription-webinaire/form-perma/Formulaire_d_Inscription/bEnsq9ZCzuSW4PE74SEwOUa11hj3aYegDPJGbxngq5U0VmfNsKH52wDyxpO5qnG0OjhSwDWGz3rvxVnTNXDE","0","0"),
("499","https://dualdiploma.org/wp-content/uploads/2025/02/Advanced-Electives-for-2025-26.pdf","0000-00-00 00:00:00","2026-02-02 23:48:26","2026-02-02 23:48:26","2026-02-02 23:48:26","0","https://dualdiploma.org/wp-content/uploads/2025/02/Advanced-Electives-for-2025-26.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 23:48:26 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 209468\r\nlast-modified: Thu, 13 Feb 2025 13:26:00 GMT\r\netag: &quot;67adf2e8-3323c&quot;\r\nexpires: Wed, 04 Mar 2026 23:48:26 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/Advanced-Electives-for-2025-26.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.022805","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/Advanced-Electives-for-2025-26.pdf","0","0"),
("507","https://dualdiploma.org/wp-content/uploads/2025/01/Design-sans-titre-15-1.png","0000-00-00 00:00:00","2026-02-01 01:00:12","2026-02-01 01:00:12","2026-02-01 01:00:12","0","https://dualdiploma.org/wp-content/uploads/2025/01/Design-sans-titre-15-1.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 01:00:17 GMT\r\ncontent-type: image/png\r\ncontent-length: 13625\r\nlast-modified: Thu, 20 Feb 2025 14:10:52 GMT\r\netag: &quot;67b737ec-3539&quot;\r\nexpires: Tue, 03 Mar 2026 01:00:17 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/01/Design-sans-titre-15-1.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.039609","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/01/Design-sans-titre-15-1.png","0","0"),
("511","https://www.elysee.fr/sommet-pour-l-action-sur-l-ia","0000-00-00 00:00:00","2026-02-03 01:58:12","2026-02-03 01:58:12","2026-02-03 01:58:12","0","https://www.elysee.fr/sommet-pour-l-action-sur-l-ia","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Tue, 03 Feb 2026 01:58:12 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nserver: cloudflare\r\nvary: Accept-Encoding\r\ncache-control: public, max-age=300, must-revalidate, s-maxage=300, stale-while-revalidate=600\r\nx-content-type-options: nosniff\r\nstrict-transport-security: max-age=31536000; includeSubDomains\r\nreferrer-policy: no-referrer, strict-origin-when-cross-origin\r\nx-frame-options: DENY\r\ncontent-security-policy-report-only: default-src &#039;self&#039; https:; base-uri https://www.elysee.fr; block-all-mixed-content; child-src *; font-src &#039;self&#039; data: https://fonts.gstatic.com https://www.elysee.fr https://admin.elysee.fr https://www.elysee.fr; form-action &#039;self&#039;; frame-ancestors &#039;none&#039;; img-src https://stats.g.doubleclick.net data: https://www.elysee.fr https://admin.elysee.fr https://www.elysee.fr https://captcha.liveidentity.com; plugin-types video/*; script-src &#039;unsafe-inline&#039; https://www.elysee.fr https://isho.elysee.fr https://admin.elysee.fr https://www.elysee.fr https://captcha.liveidentity.com https://platform.twitter.com https://www.instagram.com; style-src https://fonts.googleapis.com &#039;unsafe-inline&#039; https://www.elysee.fr https://admin.elysee.fr https://www.elysee.fr\r\nx-content-security-policy-report-only: default-src &#039;self&#039; https:; base-uri https://www.elysee.fr; block-all-mixed-content; child-src *; font-src &#039;self&#039; data: https://fonts.gstatic.com https://www.elysee.fr https://admin.elysee.fr https://www.elysee.fr; form-action &#039;self&#039;; frame-ancestors &#039;none&#039;; img-src https://stats.g.doubleclick.net data: https://www.elysee.fr https://admin.elysee.fr https://www.elysee.fr https://captcha.liveidentity.com; plugin-types video/*; script-src &#039;unsafe-inline&#039; https://www.elysee.fr https://isho.elysee.fr https://admin.elysee.fr https://www.elysee.fr https://captcha.liveidentity.com https://platform.twitter.com https://www.instagram.com; style-src https://fonts.googleapis.com &#039;unsafe-inline&#039; https://www.elysee.fr https://admin.elysee.fr https://www.elysee.fr\r\ncontent-security-policy: upgrade-insecure-requests\r\nx-content-security-policy: upgrade-insecure-requests\r\nx-xss-protection: 1; mode=block\r\nlast-modified: Tue, 03 Feb 2026 01:58:12 GMT\r\ncf-cache-status: EXPIRED\r\ncontent-encoding: gzip\r\ncf-ray: 9c7e5269999c99aa-CDG\r\n\r\nRequest headers\n================\nHEAD /sommet-pour-l-action-sur-l-ia HTTP/2\r\nHost: www.elysee.fr\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.284813","0","0","0","1","0","200|0|0|https://www.elysee.fr/sommet-pour-l-action-sur-l-ia","0","0"),
("512","https://edtechfrance.fr/","0000-00-00 00:00:00","2026-02-03 02:08:21","2026-02-03 02:08:21","2026-02-03 02:08:21","0","https://edtechfrance.fr/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Tue, 03 Feb 2026 02:08:22 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://edtechfrance.fr/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;, &lt;https://edtechfrance.fr/wp-json/wp/v2/pages/1481&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;, &lt;https://edtechfrance.fr/&gt;; rel=shortlink\r\nserver: o2switch-PowerBoost-v3\r\ncontent-encoding: br\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: edtechfrance.fr\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.833663","0","0","0","1","0","200|0|0|https://edtechfrance.fr/","0","0"),
("514","https://dualdiploma.org/wp-content/uploads/2025/02/Design-sans-titre-21.png","0000-00-00 00:00:00","2026-02-03 01:58:12","2026-02-03 01:58:12","2026-02-03 01:58:12","0","https://dualdiploma.org/wp-content/uploads/2025/02/Design-sans-titre-21.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 01:58:12 GMT\r\ncontent-type: image/png\r\ncontent-length: 298564\r\nlast-modified: Fri, 28 Feb 2025 13:45:33 GMT\r\netag: &quot;67c1bdfd-48e44&quot;\r\nexpires: Thu, 05 Mar 2026 01:58:12 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/Design-sans-titre-21.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020318","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/Design-sans-titre-21.png","0","0"),
("519","https://dualdiploma.org/wp-content/uploads/2025/02/Images-site-internet.png","0000-00-00 00:00:00","2026-02-03 02:08:26","2026-02-03 02:08:26","2026-02-03 02:08:26","0","https://dualdiploma.org/wp-content/uploads/2025/02/Images-site-internet.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 02:08:28 GMT\r\ncontent-type: image/png\r\ncontent-length: 837161\r\nlast-modified: Fri, 28 Feb 2025 14:50:17 GMT\r\netag: &quot;67c1cd29-cc629&quot;\r\nexpires: Thu, 05 Mar 2026 02:08:28 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/Images-site-internet.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.039402","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/Images-site-internet.png","0","0"),
("520","https://dualdiploma.org/wp-content/uploads/2025/02/accueil-2.png","0000-00-00 00:00:00","2026-02-03 02:08:37","2026-02-03 02:08:37","2026-02-03 02:08:37","0","https://dualdiploma.org/wp-content/uploads/2025/02/accueil-2.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 02:08:42 GMT\r\ncontent-type: image/png\r\ncontent-length: 3797799\r\nlast-modified: Fri, 28 Feb 2025 14:52:59 GMT\r\netag: &quot;67c1cdcb-39f327&quot;\r\nexpires: Thu, 05 Mar 2026 02:08:42 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/accueil-2.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.031184","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/accueil-2.png","0","0"),
("521","https://dualdiploma.org/wp-content/uploads/2025/02/logo_academica-dual-diploma-blanc.png","0000-00-00 00:00:00","2026-02-03 02:08:24","2026-02-03 02:08:24","2026-02-03 02:08:24","0","https://dualdiploma.org/wp-content/uploads/2025/02/logo_academica-dual-diploma-blanc.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 02:08:26 GMT\r\ncontent-type: image/png\r\ncontent-length: 93663\r\nlast-modified: Fri, 28 Feb 2025 14:55:25 GMT\r\netag: &quot;67c1ce5d-16ddf&quot;\r\nexpires: Thu, 05 Mar 2026 02:08:26 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/logo_academica-dual-diploma-blanc.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.035741","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/logo_academica-dual-diploma-blanc.png","0","0"),
("522","https://dualdiploma.org/wp-content/uploads/2025/02/Design-sans-titre-23.png","0000-00-00 00:00:00","2026-02-03 02:08:22","2026-02-03 02:08:22","2026-02-03 02:08:22","0","https://dualdiploma.org/wp-content/uploads/2025/02/Design-sans-titre-23.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 02:08:22 GMT\r\ncontent-type: image/png\r\ncontent-length: 259386\r\nlast-modified: Fri, 28 Feb 2025 14:56:50 GMT\r\netag: &quot;67c1ceb2-3f53a&quot;\r\nexpires: Thu, 05 Mar 2026 02:08:22 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/Design-sans-titre-23.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.032271","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/Design-sans-titre-23.png","0","0"),
("523","https://dualdiploma.org/wp-content/uploads/2025/02/8.png","0000-00-00 00:00:00","2026-02-03 03:38:52","2026-02-03 03:38:52","2026-02-03 03:38:52","0","https://dualdiploma.org/wp-content/uploads/2025/02/8.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 03:38:54 GMT\r\ncontent-type: image/png\r\ncontent-length: 134023\r\nlast-modified: Fri, 28 Feb 2025 15:43:33 GMT\r\netag: &quot;67c1d9a5-20b87&quot;\r\nexpires: Thu, 05 Mar 2026 03:38:54 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/8.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.161848","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/8.png","0","0"),
("524","https://dualdiploma.org/wp-content/uploads/2025/02/11.png","0000-00-00 00:00:00","2026-02-03 03:39:28","2026-02-03 03:39:28","2026-02-03 03:39:28","0","https://dualdiploma.org/wp-content/uploads/2025/02/11.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 03:39:32 GMT\r\ncontent-type: image/png\r\ncontent-length: 150394\r\nlast-modified: Fri, 28 Feb 2025 16:07:10 GMT\r\netag: &quot;67c1df2e-24b7a&quot;\r\nexpires: Thu, 05 Mar 2026 03:39:32 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/11.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.037528","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/11.png","0","0"),
("525","https://dualdiploma.org/wp-content/uploads/2025/02/14.png","0000-00-00 00:00:00","2026-02-03 03:39:18","2026-02-03 03:39:18","2026-02-03 03:39:18","0","https://dualdiploma.org/wp-content/uploads/2025/02/14.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 03:39:23 GMT\r\ncontent-type: image/png\r\ncontent-length: 157698\r\nlast-modified: Fri, 28 Feb 2025 16:14:22 GMT\r\netag: &quot;67c1e0de-26802&quot;\r\nexpires: Thu, 05 Mar 2026 03:39:23 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/14.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.152674","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/14.png","0","0"),
("526","https://dualdiploma.org/wp-content/uploads/2025/02/17-1.png","0000-00-00 00:00:00","2026-02-03 03:39:13","2026-02-03 03:39:13","2026-02-03 03:39:13","0","https://dualdiploma.org/wp-content/uploads/2025/02/17-1.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 03:39:18 GMT\r\ncontent-type: image/png\r\ncontent-length: 1131320\r\nlast-modified: Fri, 28 Feb 2025 16:24:56 GMT\r\netag: &quot;67c1e358-114338&quot;\r\nexpires: Thu, 05 Mar 2026 03:39:18 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/17-1.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.050108","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/17-1.png","0","0"),
("527","https://dualdiploma.org/wp-content/uploads/2025/02/16-1.png","0000-00-00 00:00:00","2026-02-03 03:38:54","2026-02-03 03:38:54","2026-02-03 03:38:54","0","https://dualdiploma.org/wp-content/uploads/2025/02/16-1.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 03:38:56 GMT\r\ncontent-type: image/png\r\ncontent-length: 572138\r\nlast-modified: Fri, 28 Feb 2025 16:33:11 GMT\r\netag: &quot;67c1e547-8baea&quot;\r\nexpires: Thu, 05 Mar 2026 03:38:56 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/16-1.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.043024","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/16-1.png","0","0"),
("528","https://dualdiploma.org/wp-content/uploads/2025/02/18-1.png","0000-00-00 00:00:00","2026-02-03 03:39:33","2026-02-03 03:39:33","2026-02-03 03:39:33","0","https://dualdiploma.org/wp-content/uploads/2025/02/18-1.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 03:39:38 GMT\r\ncontent-type: image/png\r\ncontent-length: 1050344\r\nlast-modified: Fri, 28 Feb 2025 16:39:11 GMT\r\netag: &quot;67c1e6af-1006e8&quot;\r\nexpires: Thu, 05 Mar 2026 03:39:38 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/18-1.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.031028","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/18-1.png","0","0"),
("529","https://dualdiploma.org/wp-content/uploads/2025/02/20.png","0000-00-00 00:00:00","2026-02-03 03:38:56","2026-02-03 03:38:56","2026-02-03 03:38:56","0","https://dualdiploma.org/wp-content/uploads/2025/02/20.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 03:38:58 GMT\r\ncontent-type: image/png\r\ncontent-length: 507938\r\nlast-modified: Fri, 28 Feb 2025 16:43:14 GMT\r\netag: &quot;67c1e7a2-7c022&quot;\r\nexpires: Thu, 05 Mar 2026 03:38:58 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/20.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.161453","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/20.png","0","0"),
("530","https://dualdiploma.org/wp-content/uploads/2025/02/19.png","0000-00-00 00:00:00","2026-02-03 03:39:04","2026-02-03 03:39:04","2026-02-03 03:39:04","0","https://dualdiploma.org/wp-content/uploads/2025/02/19.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 03:39:09 GMT\r\ncontent-type: image/png\r\ncontent-length: 542743\r\nlast-modified: Fri, 28 Feb 2025 16:43:14 GMT\r\netag: &quot;67c1e7a2-84817&quot;\r\nexpires: Thu, 05 Mar 2026 03:39:09 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/02/19.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.43044","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/02/19.png","0","0"),
("532","https://dualdiploma.org/blog/les-atouts-du-bilinguisme-dans-la-vie-active-des-jeunes-diplomes/","0000-00-00 00:00:00","2026-02-02 18:58:54","2026-02-02 18:58:54","2026-02-02 18:58:54","0","https://dualdiploma.org/blog/les-atouts-du-bilinguisme-dans-la-vie-active-des-jeunes-diplomes/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:58:59 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/3542&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=3542&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/les-atouts-du-bilinguisme-dans-la-vie-active-des-jeunes-diplomes/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.211367","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/les-atouts-du-bilinguisme-dans-la-vie-active-des-jeunes-diplomes/","0","0"),
("533","https://dualdiploma.org/blog/preparez-vous-pour-luniversite-avec-college-entrance-exam-prep/","0000-00-00 00:00:00","2026-02-02 20:58:59","2026-02-02 20:58:59","2026-02-02 20:58:59","0","https://dualdiploma.org/blog/preparez-vous-pour-luniversite-avec-college-entrance-exam-prep/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:59:04 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/10413&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=10413&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/preparez-vous-pour-luniversite-avec-college-entrance-exam-prep/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.227171","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/preparez-vous-pour-luniversite-avec-college-entrance-exam-prep/","0","0"),
("534","https://dualdiploma.org/blog/double-bac-francais-americain-quels-benefices/","0000-00-00 00:00:00","2026-02-02 20:59:09","2026-02-02 20:59:09","2026-02-02 20:59:09","0","https://dualdiploma.org/blog/double-bac-francais-americain-quels-benefices/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:59:14 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/166654&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=166654&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/double-bac-francais-americain-quels-benefices/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.328456","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/double-bac-francais-americain-quels-benefices/","0","0"),
("535","https://dualdiploma.org/blog/remise-des-diplomes-2024-une-ceremonie-a-lamericaine-pour-lobtention-du-high-school-diploma/","0000-00-00 00:00:00","2026-02-02 20:59:45","2026-02-02 20:59:45","2026-02-02 20:59:45","0","https://dualdiploma.org/blog/remise-des-diplomes-2024-une-ceremonie-a-lamericaine-pour-lobtention-du-high-school-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:59:49 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/17242&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=17242&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/remise-des-diplomes-2024-une-ceremonie-a-lamericaine-pour-lobtention-du-high-school-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.307635","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/remise-des-diplomes-2024-une-ceremonie-a-lamericaine-pour-lobtention-du-high-school-diploma/","0","0"),
("536","https://dualdiploma.org/blog/obtenir-le-bac-americain-us-high-school-diploma-depuis-la-france-grace-au-digital/","0000-00-00 00:00:00","2026-02-02 20:58:39","2026-02-02 20:58:39","2026-02-02 20:58:39","0","https://dualdiploma.org/blog/obtenir-le-bac-americain-us-high-school-diploma-depuis-la-france-grace-au-digital/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:58:39 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/4701&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=4701&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/obtenir-le-bac-americain-us-high-school-diploma-depuis-la-france-grace-au-digital/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.243835","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/obtenir-le-bac-americain-us-high-school-diploma-depuis-la-france-grace-au-digital/","0","0"),
("537","https://dualdiploma.org/blog/differences-et-complementarites-des-pedagogies-francaise-et-americaine/","0000-00-00 00:00:00","2026-02-02 20:58:54","2026-02-02 20:58:54","2026-02-02 20:58:54","0","https://dualdiploma.org/blog/differences-et-complementarites-des-pedagogies-francaise-et-americaine/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:58:59 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/5181&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=5181&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/differences-et-complementarites-des-pedagogies-francaise-et-americaine/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.251657","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/differences-et-complementarites-des-pedagogies-francaise-et-americaine/","0","0"),
("538","https://dualdiploma.org/blog/a-partnership-of-excellence-academica-international-studies-and-the-international-office-of-catholic-education-redefine-international-education/","0000-00-00 00:00:00","2026-02-02 20:59:19","2026-02-02 20:59:19","2026-02-02 20:59:19","0","https://dualdiploma.org/blog/a-partnership-of-excellence-academica-international-studies-and-the-international-office-of-catholic-education-redefine-international-education/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:59:24 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/13378&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=13378&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/a-partnership-of-excellence-academica-international-studies-and-the-international-office-of-catholic-education-redefine-international-education/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.258559","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/a-partnership-of-excellence-academica-international-studies-and-the-international-office-of-catholic-education-redefine-international-education/","0","0");

INSERT IGNORE INTO `da_blc_links` VALUES 
("539","https://dualdiploma.org/blog/le-club-model-un-du-dual-diploma/","0000-00-00 00:00:00","2026-02-02 20:59:54","2026-02-02 20:59:54","2026-02-02 20:59:54","0","https://dualdiploma.org/blog/le-club-model-un-du-dual-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:59:59 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/16334&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=16334&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/le-club-model-un-du-dual-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.276591","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/le-club-model-un-du-dual-diploma/","0","0"),
("540","https://dualdiploma.org/blog/le-bac-en-europe-doubles-diplomes-et-diversite-des-parcours/","0000-00-00 00:00:00","2026-02-02 20:59:40","2026-02-02 20:59:40","2026-02-02 20:59:40","0","https://dualdiploma.org/blog/le-bac-en-europe-doubles-diplomes-et-diversite-des-parcours/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:59:45 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/16371&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=16371&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/le-bac-en-europe-doubles-diplomes-et-diversite-des-parcours/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.33315","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/le-bac-en-europe-doubles-diplomes-et-diversite-des-parcours/","0","0"),
("541","https://dualdiploma.org/blog/temoignage-pedagogie-dual-diploma-academica/","0000-00-00 00:00:00","2026-02-02 20:58:45","2026-02-02 20:58:45","2026-02-02 20:58:45","0","https://dualdiploma.org/blog/temoignage-pedagogie-dual-diploma-academica/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:58:49 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/7371&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=7371&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/temoignage-pedagogie-dual-diploma-academica/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.229814","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/temoignage-pedagogie-dual-diploma-academica/","0","0"),
("542","https://dualdiploma.org/academica-dual-diploma","0000-00-00 00:00:00","2026-02-02 20:58:41","2026-02-02 20:58:41","2026-02-02 20:58:41","0","https://dualdiploma.org/academica-dual-diploma","1","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 301 ===\n\nResponse headers\n================\nHTTP/2 301 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:58:43 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nlocation: https://dualdiploma.org/academica-dual-diploma/\r\nexpires: Mon, 02 Feb 2026 21:58:43 GMT\r\ncache-control: max-age=3600\r\nx-redirect-by: WordPress\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\n\r\nRequest headers\n================\nHEAD /academica-dual-diploma HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","301","","","0.236514","0","0","0","1","0","301|0|0|https://dualdiploma.org/academica-dual-diploma","0","0"),
("543","https://dualdiploma.org/blog/les-clubs-du-dual-diploma-des-experiences-dapprentissage-enrichissantes-et-diversifiees/","0000-00-00 00:00:00","2026-02-02 20:59:14","2026-02-02 20:59:14","2026-02-02 20:59:14","0","https://dualdiploma.org/blog/les-clubs-du-dual-diploma-des-experiences-dapprentissage-enrichissantes-et-diversifiees/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:59:19 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/13710&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=13710&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/les-clubs-du-dual-diploma-des-experiences-dapprentissage-enrichissantes-et-diversifiees/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.366507","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/les-clubs-du-dual-diploma-des-experiences-dapprentissage-enrichissantes-et-diversifiees/","0","0"),
("544","https://dualdiploma.org/blog/le-dual-diploma-times-donner-une-voix-a-nos-eleves-avec-le-journalisme/","0000-00-00 00:00:00","2026-02-02 20:59:29","2026-02-02 20:59:29","2026-02-02 20:59:29","0","https://dualdiploma.org/blog/le-dual-diploma-times-donner-une-voix-a-nos-eleves-avec-le-journalisme/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:59:34 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/12819&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=12819&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/le-dual-diploma-times-donner-une-voix-a-nos-eleves-avec-le-journalisme/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.230115","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/le-dual-diploma-times-donner-une-voix-a-nos-eleves-avec-le-journalisme/","0","0"),
("545","https://dualdiploma.org/blog/ceremonie-de-graduation-2023-dacademica-dual-diploma/","0000-00-00 00:00:00","2026-02-02 20:59:49","2026-02-02 20:59:49","2026-02-02 20:59:49","0","https://dualdiploma.org/blog/ceremonie-de-graduation-2023-dacademica-dual-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:59:54 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/13139&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=13139&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/ceremonie-de-graduation-2023-dacademica-dual-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.272816","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/ceremonie-de-graduation-2023-dacademica-dual-diploma/","0","0"),
("546","https://dualdiploma.org/blog/enseignement-catholique-academica-au-congres-mondial-de-l-oiec/","0000-00-00 00:00:00","2026-02-02 20:58:43","2026-02-02 20:58:43","2026-02-02 20:58:43","0","https://dualdiploma.org/blog/enseignement-catholique-academica-au-congres-mondial-de-l-oiec/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:58:45 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/12311&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=12311&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/enseignement-catholique-academica-au-congres-mondial-de-l-oiec/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.268047","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/enseignement-catholique-academica-au-congres-mondial-de-l-oiec/","0","0"),
("547","https://www.lacordaire.com/le-lycee/filieres-et-options-au-lycee-lacordaire/#toggle-id-9","0000-00-00 00:00:00","2026-02-02 20:58:45","2026-02-02 20:58:45","2026-02-02 20:58:45","0","https://www.lacordaire.com/le-lycee/filieres-et-options-au-lycee-lacordaire/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/1.1 200 OK\r\nDate: Mon, 02 Feb 2026 20:58:45 GMT\r\nServer: Apache\r\nLast-Modified: Mon, 02 Feb 2026 18:23:54 GMT\r\nCache-Control: max-age=0\r\nExpires: Mon, 02 Feb 2026 20:58:45 GMT\r\nVary: Accept-Encoding\r\nConnection: close\r\nContent-Type: text/html; charset=UTF-8\r\n\r\nRequest headers\n================\nHEAD /le-lycee/filieres-et-options-au-lycee-lacordaire/ HTTP/1.1\r\nHost: www.lacordaire.com\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://dualdiploma.org\r\nConnection: close\r\n\r\n\nLe lien est valide.","200","","","0.127547","0","0","0","1","0","200|0|0|https://www.lacordaire.com/le-lycee/filieres-et-options-au-lycee-lacordaire/","0","0"),
("549","https://dualdiploma.org/blog/enseignement-a-distance-les-professeurs-academica-partagent-leurs-expertises-et-outils/","0000-00-00 00:00:00","2026-02-02 20:58:49","2026-02-02 20:58:49","2026-02-02 20:58:49","0","https://dualdiploma.org/blog/enseignement-a-distance-les-professeurs-academica-partagent-leurs-expertises-et-outils/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:58:54 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/4813&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=4813&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/enseignement-a-distance-les-professeurs-academica-partagent-leurs-expertises-et-outils/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.365244","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/enseignement-a-distance-les-professeurs-academica-partagent-leurs-expertises-et-outils/","0","0"),
("550","https://dualdiploma.org/blog/decouvrir-le-dual-diploma-academica-bac-francais-us-high-school-diploma/","0000-00-00 00:00:00","2026-02-02 20:59:24","2026-02-02 20:59:24","2026-02-02 20:59:24","0","https://dualdiploma.org/blog/decouvrir-le-dual-diploma-academica-bac-francais-us-high-school-diploma/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:59:29 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/posts/3449&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=3449&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /blog/decouvrir-le-dual-diploma-academica-bac-francais-us-high-school-diploma/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.257385","0","0","0","1","0","200|0|0|https://dualdiploma.org/blog/decouvrir-le-dual-diploma-academica-bac-francais-us-high-school-diploma/","0","0"),
("551","https://www.education.gouv.fr/reussir-au-lycee/l-abibac-6638?Cookies=true","0000-00-00 00:00:00","2026-02-02 23:48:26","2026-02-02 23:48:26","2026-02-02 23:48:26","0","https://www.education.gouv.fr/reussir-au-lycee/l-abibac-6638?Cookies=true","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 403 ===\n\nResponse headers\n================\nHTTP/2 403 \r\ndate: Mon, 02 Feb 2026 23:48:27 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nx-frame-options: SAMEORIGIN\r\nreferrer-policy: same-origin\r\ncache-control: private, max-age=0, no-store, no-cache, must-revalidate, post-check=0, pre-check=0\r\nexpires: Thu, 01 Jan 1970 00:00:01 GMT\r\nvary: Accept-Encoding\r\nserver: cloudflare\r\ncf-ray: 9c7d94571dec3c7b-CDG\r\ncontent-encoding: gzip\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nGET /reussir-au-lycee/l-abibac-6638?Cookies=true HTTP/2\r\nHost: www.education.gouv.fr\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\nrange: bytes=0-2048\r\n\r\nResponse HTML\n================\n&lt;!DOCTYPE html&gt;\n&lt;!--[if lt IE 7]&gt; &lt;html class=&quot;no-js ie6 oldie&quot; lang=&quot;en-US&quot;&gt; &lt;![endif]--&gt;\n&lt;!--[if IE 7]&gt;    &lt;html class=&quot;no-js ie7 oldie&quot; lang=&quot;en-US&quot;&gt; &lt;![endif]--&gt;\n&lt;!--[if IE 8]&gt;    &lt;html class=&quot;no-js ie8 oldie&quot; lang=&quot;en-US&quot;&gt; &lt;![endif]--&gt;\n&lt;!--[if gt IE 8]&gt;&lt;!--&gt; &lt;html class=&quot;no-js&quot; lang=&quot;en-US&quot;&gt; &lt;!--&lt;![endif]--&gt;\n&lt;head&gt;\n&lt;title&gt;Attention Required! | Cloudflare&lt;/title&gt;\n&lt;meta charset=&quot;UTF-8&quot; /&gt;\n&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot; /&gt;\n&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=Edge&quot; /&gt;\n&lt;meta name=&quot;robots&quot; content=&quot;noindex, nofollow&quot; /&gt;\n&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot; /&gt;\n&lt;link rel=&quot;stylesheet&quot; id=&quot;cf_styles-css&quot; href=&quot;/cdn-cgi/styles/cf.errors.css&quot; /&gt;\n&lt;!--[if lt IE 9]&gt;&lt;link rel=&quot;stylesheet&quot; id=&#039;cf_styles-ie-css&#039; href=&quot;/cdn-cgi/styles/cf.errors.ie.css&quot; /&gt;&lt;![endif]--&gt;\n&lt;style&gt;body{margin:0;padding:0}&lt;/style&gt;\n\n\n&lt;!--[if gte IE 10]&gt;&lt;!--&gt;\n&lt;script&gt;\n  if (!navigator.cookieEnabled) {\n    window.addEventListener(&#039;DOMContentLoaded&#039;, function () {\n      var cookieEl = document.getElementById(&#039;cookie-alert&#039;);\n      cookieEl.style.display = &#039;block&#039;;\n    })\n  }\n&lt;/script&gt;\n&lt;!--&lt;![endif]--&gt;\n\n\n&lt;/head&gt;\n&lt;body&gt;\n  &lt;div id=&quot;cf-wrapper&quot;&gt;\n    &lt;div class=&quot;cf-alert cf-alert-error cf-cookie-error&quot; id=&quot;cookie-alert&quot; data-translate=&quot;enable_cookies&quot;&gt;Please enable cookies.&lt;/div&gt;\n    &lt;div id=&quot;cf-error-details&quot; class=&quot;cf-error-details-wrapper&quot;&gt;\n      &lt;div class=&quot;cf-wrapper cf-header cf-error-overview&quot;&gt;\n        &lt;h1 data-translate=&quot;block_headline&quot;&gt;Sorry, you have been blocked&lt;/h1&gt;\n        &lt;h2 class=&quot;cf-subheadline&quot;&gt;&lt;span data-translate=&quot;unable_to_access&quot;&gt;You are unable to access&lt;/span&gt; education.gouv.fr&lt;/h2&gt;\n      &lt;/div&gt;&lt;!-- /.header --&gt;\n\n      &lt;div class=&quot;cf-section cf-highlight&quot;&gt;\n        &lt;div class=&quot;cf-wrapper&quot;&gt;\n          &lt;div class=&quot;cf-screenshot-container cf-screenshot-full&quot;&gt;\n            \n              &lt;span class=&quot;cf-no-screenshot error&quot;&gt;&lt;/span&gt;\n            \n          &lt;/div&gt;\n        &lt;/div&gt;\n      &lt;/div&gt;&lt;!-- /.captcha-container --&gt;\n\n      &lt;div class=&quot;cf-section cf-wrapper&quot;&gt;\n        &lt;d\nLe lien est valide.","403","","","0.117518","0","0","0","1","0","403|broken|0|https://www.education.gouv.fr/reussir-au-lycee/l-abibac-6638","1","1"),
("552","https://dualdiploma.org/wp-content/uploads/2025/03/Lia-Seirotti.jpeg","0000-00-00 00:00:00","2026-02-01 02:18:26","2026-02-01 02:18:26","2026-02-01 02:18:26","0","https://dualdiploma.org/wp-content/uploads/2025/03/Lia-Seirotti.jpeg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 02:18:26 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 13314\r\nlast-modified: Mon, 03 Mar 2025 17:46:40 GMT\r\netag: &quot;67c5eb00-3402&quot;\r\nexpires: Tue, 03 Mar 2026 02:18:26 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/Lia-Seirotti.jpeg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.037574","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/Lia-Seirotti.jpeg","0","0"),
("553","https://ais.academica.org/lia-seirotti/","0000-00-00 00:00:00","2026-02-01 18:28:26","2026-02-01 18:28:26","2026-02-01 18:28:26","0","https://ais.academica.org/lia-seirotti/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Sun, 01 Feb 2026 18:28:26 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nserver: cloudflare\r\nreport-to: {&quot;group&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https://a.nel.cloudflare.com/report/v4?s=%2F4tx396uge8%2FhQ8vf%2FOCv%2F0Tci5%2Fg0XGD4DV4jrYc31ySFceAxtICB0%2B%2F3SLLYBfnBK7%2BcOiJ5qXT%2BZPphAx3h%2BPQ03lJhYtE5KETiy7vphVT%2FncUsZHJ9MjFtpj&quot;}]}\r\nlast-modified: Fri, 30 Jan 2026 00:12:51 GMT\r\nvary: Accept-Encoding\r\nnel: {&quot;report_to&quot;:&quot;cf-nel&quot;,&quot;success_fraction&quot;:0.0,&quot;max_age&quot;:604800}\r\ncache-control: max-age=0, no-cache, no-store, must-revalidate\r\npragma: no-cache\r\nexpires: Mon, 29 Oct 1923 20:30:00 GMT\r\nstrict-transport-security: max-age=15768000; includeSubDomains\r\nx-powered-by: PleskLin\r\ncf-cache-status: DYNAMIC\r\ncontent-encoding: br\r\ncf-ray: 9c738230cf068c76-CDG\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nHEAD /lia-seirotti/ HTTP/2\r\nHost: ais.academica.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.39821","0","0","0","1","0","200|0|0|https://ais.academica.org/lia-seirotti/","0","0"),
("555","https://dualdiploma.org/wp-content/uploads/2020/04/webinaire-classe-virtuelle.webp","0000-00-00 00:00:00","2026-02-01 00:59:42","2026-02-01 00:59:42","2026-02-01 00:59:42","0","https://dualdiploma.org/wp-content/uploads/2020/04/webinaire-classe-virtuelle.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 00:59:47 GMT\r\ncontent-type: image/webp\r\ncontent-length: 62924\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-f5cc&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2020/04/webinaire-classe-virtuelle.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.05546","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2020/04/webinaire-classe-virtuelle.webp","0","0"),
("556","https://dualdiploma.org/wp-content/uploads/2020/07/shutterstock_174215792-scaled-1.webp","0000-00-00 00:00:00","2026-02-01 01:00:02","2026-02-01 01:00:02","2026-02-01 01:00:02","0","https://dualdiploma.org/wp-content/uploads/2020/07/shutterstock_174215792-scaled-1.webp","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 01:00:07 GMT\r\ncontent-type: image/webp\r\ncontent-length: 186386\r\nlast-modified: Wed, 10 Jul 2024 11:17:14 GMT\r\netag: &quot;668e6dba-2d812&quot;\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2020/07/shutterstock_174215792-scaled-1.webp HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038107","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2020/07/shutterstock_174215792-scaled-1.webp","0","0"),
("557","https://www.snceel.fr/en-2025-tous-a-la-villette/","0000-00-00 00:00:00","2026-02-02 20:29:01","2026-02-02 20:29:01","2026-02-02 20:29:01","0","https://www.snceel.fr/en-2025-tous-a-la-villette/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:29:02 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nx-powered-by: PHP/8.2.29\r\nlink: &lt;https://www.snceel.fr/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://www.snceel.fr/wp-json/wp/v2/posts/19389&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://www.snceel.fr/?p=19389&gt;; rel=shortlink\r\nstrict-transport-security: max-age=63072000\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /en-2025-tous-a-la-villette/ HTTP/2\r\nHost: www.snceel.fr\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.22595","0","0","0","1","0","200|0|0|https://www.snceel.fr/en-2025-tous-a-la-villette/","0","0"),
("558","https://institution-robin.com/","0000-00-00 00:00:00","2026-02-02 20:29:06","2026-02-02 20:29:06","2026-02-02 20:29:06","0","https://institution-robin.com/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ncontent-type: text/html; charset=UTF-8\r\nx-ws-ratelimit-limit: 1000\r\nx-ws-ratelimit-remaining: 999\r\ndate: Mon, 02 Feb 2026 20:29:07 GMT\r\nserver: Apache\r\nx-powered-by: PHP/7.4.33\r\nlink: &lt;https://institution-robin.com/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;, &lt;https://institution-robin.com/wp-json/wp/v2/pages/12&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;, &lt;https://institution-robin.com/&gt;; rel=shortlink\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: institution-robin.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","1.26096","0","0","0","1","0","200|0|0|https://institution-robin.com/","0","0"),
("559","https://www.linkedin.com/in/j%C3%A9r%C3%A9my-torresan-9a93b0265/overlay/about-this-profile/","2025-03-18 10:47:42","2026-02-02 20:28:26","0000-00-00 00:00:00","2026-02-02 20:28:26","108","https://www.linkedin.com/in/j%C3%A9r%C3%A9my-torresan-9a93b0265/overlay/about-this-profile/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 999 ===\n\nResponse headers\n================\nHTTP/2 999 \r\ndate: Mon, 02 Feb 2026 20:28:27 GMT\r\ncontent-type: text/html\r\ncontent-length: 1530\r\nx-li-fabric: prod-ltx1\r\npragma: no-cache\r\nexpires: Thu, 01 Jan 1970 00:00:00 GMT\r\ncache-control: no-cache, no-store, no-transform\r\nx-li-pop: cf-prod-ltx1-x\r\nx-li-proto: http/2\r\nx-li-uuid: AAZJ3SpTd2yYBNpeSxsDhA==\r\nset-cookie: trkCode=bf; Max-Age=5\r\ncf-cache-status: DYNAMIC\r\nset-cookie: trkInfo=AQH5Q0kIpb4WkAAAAZwgCtIQAOuYfbww864NqR5AVoA-8OKmieaMFXJEwrHVHMdsiMKcS-ZV6YClpFpIT7xz2CBa_LEJK5Lg1wiVSkRhVschmf_G2D_ULEM26XStQUcrt2Ov45o=; Max-Age=5\r\nset-cookie: rtc=AQG3ZkYt8swVmAAAAZwgCtIQE7bjG1Sc7xNC2qma1Xhsr-qTljnTKRM4upblYaWp38TaJ3FWNP4OFFst2WUQugHpw0PZJ-n7PXKVOA-9rcFCfJ-AgcpQM4dSfycDeVfUXeLm-LYAQxCeWwoynM5ZDZ1bQ54JvTc8hptsge3LA0_W16ekoCoIS8QlQluo4bHlO-Avtk3lGW9swxHJ9958RGwvzps2j9w=; Max-Age=120; path=/; domain=.linkedin.com\r\nset-cookie: __cf_bm=p91Z83xfBc6nGWNMS50hAm1GJideCB29z99g5ox.yjQ-1770064107-1.0.1.1-fDDOOMTWfQBC_Zjjzh_zDgHQ9BKI0zhVTsJHgVjfIOwmxSZJt1u1J6Epn_iHLKyjKCnbSkE1pHfLvP.HGSqCHuHuLuiDEjy.hD2jw9sp0Yw; path=/; expires=Mon, 02-Feb-26 20:58:27 GMT; domain=.linkedin.com; HttpOnly; Secure; SameSite=None\r\nstrict-transport-security: max-age=31536000\r\nx-content-type-options: nosniff\r\nserver: cloudflare\r\ncf-ray: 9c7c6f5c2b73119e-CDG\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nHEAD /in/j%C3%A9r%C3%A9my-torresan-9a93b0265/overlay/about-this-profile/ HTTP/2\r\nHost: www.linkedin.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est cassé.","999","warning","Erreur inconnue","0.203883","0","0","1","1","0","999|0|0|https://www.linkedin.com/in/j%C3%A9r%C3%A9my-torresan-9a93b0265/overlay/about-this-profile/","0","0"),
("560","https://dualdiploma.org/wp-content/uploads/2025/03/1741973581197-2-800x600.jpg","0000-00-00 00:00:00","2026-02-02 20:28:41","2026-02-02 20:28:41","2026-02-02 20:28:41","0","https://dualdiploma.org/wp-content/uploads/2025/03/1741973581197-2-800x600.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:28:46 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 97268\r\nlast-modified: Mon, 17 Mar 2025 17:46:53 GMT\r\netag: &quot;67d8600d-17bf4&quot;\r\nexpires: Wed, 04 Mar 2026 20:28:46 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/1741973581197-2-800x600.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.033698","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/1741973581197-2-800x600.jpg","0","0"),
("561","https://dualdiploma.org/wp-content/uploads/2025/03/POST-SIGNATURE-LINKEDIN-800x600.png","0000-00-00 00:00:00","2026-02-02 20:28:20","2026-02-02 20:28:20","2026-02-02 20:28:20","0","https://dualdiploma.org/wp-content/uploads/2025/03/POST-SIGNATURE-LINKEDIN-800x600.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:28:22 GMT\r\ncontent-type: image/png\r\ncontent-length: 637830\r\nlast-modified: Mon, 17 Mar 2025 11:38:50 GMT\r\netag: &quot;67d809ca-9bb86&quot;\r\nexpires: Wed, 04 Mar 2026 20:28:22 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/POST-SIGNATURE-LINKEDIN-800x600.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.145242","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/POST-SIGNATURE-LINKEDIN-800x600.png","0","0"),
("564","https://dualdiploma.org/wp-content/uploads/2025/03/accueil-4-1.png","0000-00-00 00:00:00","2026-02-01 20:08:39","2026-02-01 20:08:39","2026-02-01 20:08:39","0","https://dualdiploma.org/wp-content/uploads/2025/03/accueil-4-1.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 20:08:39 GMT\r\ncontent-type: image/png\r\ncontent-length: 1016616\r\nlast-modified: Thu, 20 Mar 2025 10:21:59 GMT\r\netag: &quot;67dbec47-f8328&quot;\r\nexpires: Tue, 03 Mar 2026 20:08:39 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/accueil-4-1.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.04963","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/accueil-4-1.png","0","0"),
("565","https://dualdiploma.org/wp-content/uploads/2025/03/22.png","0000-00-00 00:00:00","2026-02-02 00:28:22","2026-02-02 00:28:22","2026-02-02 00:28:22","0","https://dualdiploma.org/wp-content/uploads/2025/03/22.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 00:28:22 GMT\r\ncontent-type: image/png\r\ncontent-length: 820919\r\nlast-modified: Thu, 20 Mar 2025 14:06:27 GMT\r\netag: &quot;67dc20e3-c86b7&quot;\r\nexpires: Wed, 04 Mar 2026 00:28:22 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/22.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.028057","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/22.png","0","0"),
("566","https://dualdiploma.org/wp-content/uploads/2025/03/23.jpg","0000-00-00 00:00:00","2026-02-02 00:28:22","2026-02-02 00:28:22","2026-02-02 00:28:22","0","https://dualdiploma.org/wp-content/uploads/2025/03/23.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 00:28:24 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 267762\r\nlast-modified: Thu, 20 Mar 2025 14:15:16 GMT\r\netag: &quot;67dc22f4-415f2&quot;\r\nexpires: Wed, 04 Mar 2026 00:28:24 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/23.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.041156","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/23.jpg","0","0"),
("568","https://dualdiploma.org/wp-content/uploads/2025/03/dd-logo-carre-vert.png","0000-00-00 00:00:00","2026-02-03 00:28:53","2026-02-03 00:28:53","2026-02-03 00:28:53","0","https://dualdiploma.org/wp-content/uploads/2025/03/dd-logo-carre-vert.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 00:28:53 GMT\r\ncontent-type: image/png\r\ncontent-length: 90649\r\nlast-modified: Thu, 27 Mar 2025 14:59:22 GMT\r\netag: &quot;67e567ca-16219&quot;\r\nexpires: Thu, 05 Mar 2026 00:28:53 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/dd-logo-carre-vert.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.035323","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/dd-logo-carre-vert.png","0","0"),
("569","https://dualdiploma.org/wp-content/uploads/2025/03/Logo-Dual-Diploma-2-1.png","0000-00-00 00:00:00","2026-02-03 02:08:28","2026-02-03 02:08:28","2026-02-03 02:08:28","0","https://dualdiploma.org/wp-content/uploads/2025/03/Logo-Dual-Diploma-2-1.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 02:08:32 GMT\r\ncontent-type: image/png\r\ncontent-length: 1395135\r\nlast-modified: Thu, 27 Mar 2025 16:43:37 GMT\r\netag: &quot;67e58039-1549bf&quot;\r\nexpires: Thu, 05 Mar 2026 02:08:32 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/Logo-Dual-Diploma-2-1.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.028222","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/Logo-Dual-Diploma-2-1.png","0","0"),
("570","https://dualdiploma.org/wp-content/uploads/2025/03/dd-logo-carre-blanc.png","0000-00-00 00:00:00","2026-02-03 02:08:22","2026-02-03 02:08:22","2026-02-03 02:08:22","0","https://dualdiploma.org/wp-content/uploads/2025/03/dd-logo-carre-blanc.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 02:08:24 GMT\r\ncontent-type: image/png\r\ncontent-length: 108418\r\nlast-modified: Thu, 27 Mar 2025 14:59:13 GMT\r\netag: &quot;67e567c1-1a782&quot;\r\nexpires: Thu, 05 Mar 2026 02:08:24 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/dd-logo-carre-blanc.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.04791","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/dd-logo-carre-blanc.png","0","0"),
("571","https://dualdiploma.org/wp-content/uploads/2025/03/Logo-Dual-Diploma-1-1.png","0000-00-00 00:00:00","2026-02-03 02:08:32","2026-02-03 02:08:32","2026-02-03 02:08:32","0","https://dualdiploma.org/wp-content/uploads/2025/03/Logo-Dual-Diploma-1-1.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 02:08:37 GMT\r\ncontent-type: image/png\r\ncontent-length: 56222\r\nlast-modified: Thu, 27 Mar 2025 16:43:34 GMT\r\netag: &quot;67e58036-db9e&quot;\r\nexpires: Thu, 05 Mar 2026 02:08:37 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/Logo-Dual-Diploma-1-1.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.047201","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/Logo-Dual-Diploma-1-1.png","0","0"),
("573","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-005-e1744360456826.jpg","0000-00-00 00:00:00","2026-02-02 18:58:39","2026-02-02 18:58:39","2026-02-02 18:58:39","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-005-e1744360456826.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:58:44 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 109546\r\nlast-modified: Fri, 11 Apr 2025 08:34:16 GMT\r\netag: &quot;67f8d408-1abea&quot;\r\nexpires: Wed, 04 Mar 2026 18:58:44 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-005-e1744360456826.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.035446","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-005-e1744360456826.jpg","0","0"),
("574","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-015-e1744360591735.jpg","0000-00-00 00:00:00","2026-02-02 18:58:11","2026-02-02 18:58:11","2026-02-02 18:58:11","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-015-e1744360591735.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:58:13 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 111717\r\nlast-modified: Fri, 11 Apr 2025 08:36:31 GMT\r\netag: &quot;67f8d48f-1b465&quot;\r\nexpires: Wed, 04 Mar 2026 18:58:13 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-015-e1744360591735.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.031505","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-015-e1744360591735.jpg","0","0"),
("575","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-012-e1744360625182.jpg","0000-00-00 00:00:00","2026-02-02 18:59:04","2026-02-02 18:59:04","2026-02-02 18:59:04","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-012-e1744360625182.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:59:09 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 209291\r\nlast-modified: Fri, 11 Apr 2025 08:37:05 GMT\r\netag: &quot;67f8d4b1-3318b&quot;\r\nexpires: Wed, 04 Mar 2026 18:59:09 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-012-e1744360625182.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.021136","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-012-e1744360625182.jpg","0","0"),
("576","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-025-e1744360809551.jpg","0000-00-00 00:00:00","2026-02-02 18:58:13","2026-02-02 18:58:13","2026-02-02 18:58:13","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-025-e1744360809551.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:58:15 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 127531\r\nlast-modified: Fri, 11 Apr 2025 08:40:09 GMT\r\netag: &quot;67f8d569-1f22b&quot;\r\nexpires: Wed, 04 Mar 2026 18:58:15 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-025-e1744360809551.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.032859","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-025-e1744360809551.jpg","0","0"),
("577","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-009-1-e1744361908394.jpg","0000-00-00 00:00:00","2026-02-02 18:58:49","2026-02-02 18:58:49","2026-02-02 18:58:49","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-009-1-e1744361908394.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:58:54 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 180193\r\nlast-modified: Fri, 11 Apr 2025 08:58:28 GMT\r\netag: &quot;67f8d9b4-2bfe1&quot;\r\nexpires: Wed, 04 Mar 2026 18:58:54 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-009-1-e1744361908394.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.170633","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-009-1-e1744361908394.jpg","0","0"),
("578","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-002-e1744362093608.jpg","0000-00-00 00:00:00","2026-02-02 18:59:14","2026-02-02 18:59:14","2026-02-02 18:59:14","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-002-e1744362093608.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:59:19 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 236289\r\nlast-modified: Fri, 11 Apr 2025 09:01:33 GMT\r\netag: &quot;67f8da6d-39b01&quot;\r\nexpires: Wed, 04 Mar 2026 18:59:19 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-002-e1744362093608.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020393","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-002-e1744362093608.jpg","0","0"),
("579","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-006-e1744362331153.jpg","0000-00-00 00:00:00","2026-02-02 18:58:19","2026-02-02 18:58:19","2026-02-02 18:58:19","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-006-e1744362331153.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:58:24 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 127961\r\nlast-modified: Fri, 11 Apr 2025 09:05:31 GMT\r\netag: &quot;67f8db5b-1f3d9&quot;\r\nexpires: Wed, 04 Mar 2026 18:58:24 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-006-e1744362331153.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.021551","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-006-e1744362331153.jpg","0","0"),
("580","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-007-e1744362432503.jpg","0000-00-00 00:00:00","2026-02-02 18:58:15","2026-02-02 18:58:15","2026-02-02 18:58:15","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-007-e1744362432503.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:58:19 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 98290\r\nlast-modified: Fri, 11 Apr 2025 09:07:12 GMT\r\netag: &quot;67f8dbc0-17ff2&quot;\r\nexpires: Wed, 04 Mar 2026 18:58:19 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-007-e1744362432503.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.03711","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-007-e1744362432503.jpg","0","0"),
("582","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-011-e1744360992225.jpg","0000-00-00 00:00:00","2026-02-02 18:58:09","2026-02-02 18:58:09","2026-02-02 18:58:09","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-011-e1744360992225.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:58:11 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 196506\r\nlast-modified: Fri, 11 Apr 2025 08:43:12 GMT\r\netag: &quot;67f8d620-2ff9a&quot;\r\nexpires: Wed, 04 Mar 2026 18:58:11 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-011-e1744360992225.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.027524","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-011-e1744360992225.jpg","0","0"),
("583","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-010-e1744362857518.jpg","0000-00-00 00:00:00","2026-02-02 18:59:09","2026-02-02 18:59:09","2026-02-02 18:59:09","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-010-e1744362857518.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:59:14 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 99098\r\nlast-modified: Fri, 11 Apr 2025 09:14:17 GMT\r\netag: &quot;67f8dd69-1831a&quot;\r\nexpires: Wed, 04 Mar 2026 18:59:14 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-010-e1744362857518.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.028361","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-010-e1744362857518.jpg","0","0"),
("584","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-013-e1744362919450.jpg","0000-00-00 00:00:00","2026-02-02 18:58:29","2026-02-02 18:58:29","2026-02-02 18:58:29","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-013-e1744362919450.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:58:34 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 141791\r\nlast-modified: Fri, 11 Apr 2025 09:15:19 GMT\r\netag: &quot;67f8dda7-229df&quot;\r\nexpires: Wed, 04 Mar 2026 18:58:34 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-013-e1744362919450.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.031313","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-013-e1744362919450.jpg","0","0"),
("585","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-001-e1744363047157.jpg","0000-00-00 00:00:00","2026-02-02 18:58:44","2026-02-02 18:58:44","2026-02-02 18:58:44","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-001-e1744363047157.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:58:49 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 230141\r\nlast-modified: Fri, 11 Apr 2025 09:17:27 GMT\r\netag: &quot;67f8de27-382fd&quot;\r\nexpires: Wed, 04 Mar 2026 18:58:49 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-001-e1744363047157.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038484","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-001-e1744363047157.jpg","0","0"),
("586","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-019-e1744363101232.jpg","0000-00-00 00:00:00","2026-02-02 18:58:59","2026-02-02 18:58:59","2026-02-02 18:58:59","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-019-e1744363101232.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:59:04 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 158992\r\nlast-modified: Fri, 11 Apr 2025 09:18:22 GMT\r\netag: &quot;67f8de5e-26d10&quot;\r\nexpires: Wed, 04 Mar 2026 18:59:04 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-019-e1744363101232.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.043707","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-019-e1744363101232.jpg","0","0"),
("587","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-020-e1744363432714.jpg","0000-00-00 00:00:00","2026-02-02 18:58:09","2026-02-02 18:58:09","2026-02-02 18:58:09","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-020-e1744363432714.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:58:09 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 111679\r\nlast-modified: Fri, 11 Apr 2025 09:23:52 GMT\r\netag: &quot;67f8dfa8-1b43f&quot;\r\nexpires: Wed, 04 Mar 2026 18:58:09 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-020-e1744363432714.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.033412","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-020-e1744363432714.jpg","0","0"),
("588","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-014-e1744363568759.jpg","0000-00-00 00:00:00","2026-02-02 18:58:24","2026-02-02 18:58:24","2026-02-02 18:58:24","0","https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-014-e1744363568759.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:58:29 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 124830\r\nlast-modified: Fri, 11 Apr 2025 09:26:08 GMT\r\netag: &quot;67f8e030-1e79e&quot;\r\nexpires: Wed, 04 Mar 2026 18:58:29 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/250318-Academica-Portraits-014-e1744363568759.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.022817","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/250318-Academica-Portraits-014-e1744363568759.jpg","0","0"),
("590","https://dualdiploma.org/wp-content/uploads/2025/04/Site-Page-equipe-1.png","0000-00-00 00:00:00","2026-02-02 18:58:34","2026-02-02 18:58:34","2026-02-02 18:58:34","0","https://dualdiploma.org/wp-content/uploads/2025/04/Site-Page-equipe-1.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 18:58:39 GMT\r\ncontent-type: image/png\r\ncontent-length: 388279\r\nlast-modified: Fri, 11 Apr 2025 10:07:40 GMT\r\netag: &quot;67f8e9ec-5ecb7&quot;\r\nexpires: Wed, 04 Mar 2026 18:58:39 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/Site-Page-equipe-1.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.040864","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/Site-Page-equipe-1.png","0","0"),
("591","https://ais.academica.org/?_gl=1%2Avgonlw%2A_up%2AMQ..%2A_ga%2AMjAzNzU4MzU2LjE3NDE5NTk4NTQ.%2A_ga_RNTF8F9BXT%2AMTc0MTk1OTg1My4xLjEuMTc0MTk2MjMzOC4wLjAuMA..%2A_ga_B8LVJ0X6ST%2AMTc0MTk1OTg1My4xLjEuMTc0MTk2MjMzOC4wLjAuMA..","0000-00-00 00:00:00","2026-01-31 21:28:37","2026-01-31 21:28:37","2026-01-31 21:28:37","0","https://ais.academica.org/?_gl=1%2Avgonlw%2A_up%2AMQ..%2A_ga%2AMjAzNzU4MzU2LjE3NDE5NTk4NTQ.%2A_ga_RNTF8F9BXT%2AMTc0MTk1OTg1My4xLjEuMTc0MTk2MjMzOC4wLjAuMA..%2A_ga_B8LVJ0X6ST%2AMTc0MTk1OTg1My4xLjEuMTc0MTk2MjMzOC4wLjAuMA..","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Sat, 31 Jan 2026 21:28:39 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nserver: cloudflare\r\nx-powered-by: PHP/8.2.30\r\nx-powered-by: PleskLin\r\ncf-edge-cache: cache,platform=wordpress\r\nlink: &lt;https://ais.academica.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;, &lt;https://ais.academica.org/wp-json/wp/v2/pages/2&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;, &lt;https://ais.academica.org/&gt;; rel=shortlink\r\nstrict-transport-security: max-age=15768000; includeSubDomains\r\nnel: {&quot;report_to&quot;:&quot;cf-nel&quot;,&quot;success_fraction&quot;:0.0,&quot;max_age&quot;:604800}\r\ncf-cache-status: DYNAMIC\r\nreport-to: {&quot;group&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https://a.nel.cloudflare.com/report/v4?s=X2hyCLxHnza9DGSPJiQBT5Lr%2Bg0DJC%2BMSt6LMySwwRnYjfoMjxwfdcUmglBw7xCqZGcnZVf9xjHj6Jmg7lPHlh%2Be5RlQJG4ERv3EL0Ak1OzD7%2FzBRE8WVUOdx2HA&quot;}]}\r\ncontent-encoding: br\r\ncf-ray: 9c6c4cca9f457ae7-CDG\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nHEAD /?_gl=1%2Avgonlw%2A_up%2AMQ..%2A_ga%2AMjAzNzU4MzU2LjE3NDE5NTk4NTQ.%2A_ga_RNTF8F9BXT%2AMTc0MTk1OTg1My4xLjEuMTc0MTk2MjMzOC4wLjAuMA..%2A_ga_B8LVJ0X6ST%2AMTc0MTk1OTg1My4xLjEuMTc0MTk2MjMzOC4wLjAuMA.. HTTP/2\r\nHost: ais.academica.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.637045","0","0","0","1","0","200|0|0|https://ais.academica.org/","0","0"),
("592","https://ais.academica.org/student-recognition/?_gl=1%2Aa2p4jk%2A_up%2AMQ..%2A_ga%2AMjAzODgzNjgzOC4xNzQxOTYyMzc4%2A_ga_B8LVJ0X6ST%2AMTc0MTk2MjM3Ny4xLjAuMTc0MTk2MjM3Ny4wLjAuMA..%2A_ga_RNTF8F9BXT%2AMTc0MTk2MjM3Ny4xLjAuMTc0MTk2MjM3Ny4wLjAuMA..","0000-00-00 00:00:00","2026-01-31 21:28:36","2026-01-31 21:28:36","2026-01-31 21:28:36","0","https://ais.academica.org/student-recognition/?_gl=1%2Aa2p4jk%2A_up%2AMQ..%2A_ga%2AMjAzODgzNjgzOC4xNzQxOTYyMzc4%2A_ga_B8LVJ0X6ST%2AMTc0MTk2MjM3Ny4xLjAuMTc0MTk2MjM3Ny4wLjAuMA..%2A_ga_RNTF8F9BXT%2AMTc0MTk2MjM3Ny4xLjAuMTc0MTk2MjM3Ny4wLjAuMA..","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Sat, 31 Jan 2026 21:28:37 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nserver: cloudflare\r\nx-powered-by: PHP/8.2.30\r\nx-powered-by: PleskLin\r\ncf-edge-cache: cache,platform=wordpress\r\nlink: &lt;https://ais.academica.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;, &lt;https://ais.academica.org/wp-json/wp/v2/categories/45&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nstrict-transport-security: max-age=15768000; includeSubDomains\r\nnel: {&quot;report_to&quot;:&quot;cf-nel&quot;,&quot;success_fraction&quot;:0.0,&quot;max_age&quot;:604800}\r\ncf-cache-status: DYNAMIC\r\nreport-to: {&quot;group&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https://a.nel.cloudflare.com/report/v4?s=db%2BgPtteN4ek4AEjB2Qi%2BlE3x8TgxI9mdykykyJpRVCCr7xA%2Fmjr4JiA%2F3Exo0%2B6rxUG2kpkKZFVHUtXKIDU3en3aTIjfhXZhQcoAp2qf3H%2FMEPoYB53LeofSlYR&quot;}]}\r\ncontent-encoding: br\r\ncf-ray: 9c6c4cbe6d9dda89-CDG\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nHEAD /student-recognition/?_gl=1%2Aa2p4jk%2A_up%2AMQ..%2A_ga%2AMjAzODgzNjgzOC4xNzQxOTYyMzc4%2A_ga_B8LVJ0X6ST%2AMTc0MTk2MjM3Ny4xLjAuMTc0MTk2MjM3Ny4wLjAuMA..%2A_ga_RNTF8F9BXT%2AMTc0MTk2MjM3Ny4xLjAuMTc0MTk2MjM3Ny4wLjAuMA.. HTTP/2\r\nHost: ais.academica.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.746505","0","0","0","1","0","200|0|0|https://ais.academica.org/student-recognition/","0","0"),
("593","https://dualdiploma.org/wp-content/uploads/2025/03/Francillette-Cedric-Photo-e1736540765914-800x804.jpg","0000-00-00 00:00:00","2026-01-31 21:28:37","2026-01-31 21:28:37","2026-01-31 21:28:37","0","https://dualdiploma.org/wp-content/uploads/2025/03/Francillette-Cedric-Photo-e1736540765914-800x804.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 21:28:37 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 67843\r\nlast-modified: Fri, 14 Mar 2025 14:17:40 GMT\r\netag: &quot;67d43a84-10903&quot;\r\nexpires: Mon, 02 Mar 2026 21:28:37 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/Francillette-Cedric-Photo-e1736540765914-800x804.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.033188","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/Francillette-Cedric-Photo-e1736540765914-800x804.jpg","0","0"),
("594","https://dualdiploma.org/wp-content/uploads/2025/03/IMG_0015.jpeg","0000-00-00 00:00:00","2026-01-31 21:08:29","2026-01-31 21:08:29","2026-01-31 21:08:29","0","https://dualdiploma.org/wp-content/uploads/2025/03/IMG_0015.jpeg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 21:08:31 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 109208\r\nlast-modified: Fri, 14 Mar 2025 14:21:50 GMT\r\netag: &quot;67d43b7e-1aa98&quot;\r\nexpires: Mon, 02 Mar 2026 21:08:31 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/IMG_0015.jpeg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.037887","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/IMG_0015.jpeg","0","0"),
("595","https://dualdiploma.org/wp-content/uploads/2025/03/Cours-visio-800x803.png","0000-00-00 00:00:00","2026-01-31 21:08:27","2026-01-31 21:08:27","2026-01-31 21:08:27","0","https://dualdiploma.org/wp-content/uploads/2025/03/Cours-visio-800x803.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 21:08:27 GMT\r\ncontent-type: image/png\r\ncontent-length: 821855\r\nlast-modified: Wed, 19 Mar 2025 16:12:27 GMT\r\netag: &quot;67daeceb-c8a5f&quot;\r\nexpires: Mon, 02 Mar 2026 21:08:27 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/Cours-visio-800x803.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.145404","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/Cours-visio-800x803.png","0","0"),
("596","https://dualdiploma.org/wp-content/uploads/2025/03/Logo-Dual-Diploma-Transparent-1-800x272.png","0000-00-00 00:00:00","2026-01-31 21:08:27","2026-01-31 21:08:27","2026-01-31 21:08:27","0","https://dualdiploma.org/wp-content/uploads/2025/03/Logo-Dual-Diploma-Transparent-1-800x272.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 21:08:29 GMT\r\ncontent-type: image/png\r\ncontent-length: 67990\r\nlast-modified: Wed, 19 Mar 2025 16:14:15 GMT\r\netag: &quot;67daed57-10996&quot;\r\nexpires: Mon, 02 Mar 2026 21:08:29 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/03/Logo-Dual-Diploma-Transparent-1-800x272.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.035514","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/03/Logo-Dual-Diploma-Transparent-1-800x272.png","0","0"),
("597","https://www.instagram.com/lou_cinematic/","0000-00-00 00:00:00","2026-02-01 16:38:35","2026-02-01 16:38:35","2026-02-01 16:38:35","0","https://www.instagram.com/lou_cinematic/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nvary: Accept-Encoding\r\ncontent-encoding: br\r\nset-cookie: csrftoken=arjbE--mhmEGL7D6oor5ZU; expires=Mon, 08-Mar-2027 16:38:36 GMT; Max-Age=34560000; path=/; domain=.instagram.com; secure\r\naccept-ch-lifetime: 4838400\r\naccept-ch: viewport-width,dpr,Sec-CH-Prefers-Color-Scheme,Sec-CH-UA-Full-Version-List,Sec-CH-UA-Platform-Version,Sec-CH-UA-Model\r\nreporting-endpoints: coop_report=&quot;https://www.facebook.com/browser_reporting/coop/?minimize=0&quot;, default=&quot;https://www.instagram.com/error/ig_web_error_reports/?device_level=unknown&amp;brsid=7601937134729751972&amp;comet_app_key=7&amp;cpp=C3&amp;cv=1032761598&amp;st=1769963916078&quot;, permissions_policy=&quot;https://www.instagram.com/error/ig_web_error_reports/&quot;\r\nreport-to: {&quot;max_age&quot;:2592000,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/www.facebook.com\\/browser_reporting\\/coop\\/?minimize=0&quot;}],&quot;group&quot;:&quot;coop_report&quot;,&quot;include_subdomains&quot;:true}, {&quot;max_age&quot;:259200,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/www.instagram.com\\/error\\/ig_web_error_reports\\/?device_level=unknown&amp;brsid=7601937134729751972&amp;comet_app_key=7&amp;cpp=C3&amp;cv=1032761598&amp;st=1769963916078&quot;}]}, {&quot;max_age&quot;:21600,&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/www.instagram.com\\/error\\/ig_web_error_reports\\/&quot;}],&quot;group&quot;:&quot;permissions_policy&quot;}\r\ncontent-security-policy-report-only: default-src *.facebook.com *.fbcdn.net *.instagram.com blob:;script-src *.instagram.com static.cdninstagram.com *.facebook.com *.fbcdn.net *.facebook.net 127.0.0.1:* &#039;nonce-Ov7CyBn4&#039; blob: &#039;self&#039; https://*.google-analytics.com https://translate.google.com https://apis.google.com https://accounts.google.com &#039;report-sample&#039;;style-src *.instagram.com static.cdninstagram.com data: blob: &#039;unsafe-inline&#039; *.fbcdn.net *.facebook.com;connect-src *.instagram.com wss://edge-chat.instagram.com connect.facebook.net *.facebook.com facebook.com *.fbcdn.net *.facebook.net wss://*.facebook.com:* ws://localhost:* blob: *.cdninstagram.com wss://*.instagram.com:* &#039;self&#039; https://meta.privacy-gateway.cloudflare.com/relay;font-src *.instagram.com static.cdninstagram.com data: *.fbcdn.net *.intern.facebook.com *.facebook.com https://fonts.gstatic.com;img-src *.instagram.com *.facebook.com *.fbcdn.net data: *.cdninstagram.com *.whatsapp.net blob: *.fbsbx.com android-webview-video-poster: *.oculuscdn.com *.giphy.com *.tenor.co *.tenor.com www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk https://www.gstatic.com https://*.google-analytics.com;media-src *.facebook.com *.fbcdn.net *.instagram.com *.cdninstagram.com *.fbsbx.com data: blob: https://*.giphy.com *.tenor.co *.tenor.com;child-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;frame-src *.instagram.com *.facebook.com *.fbsbx.com fbsbx.com data: www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk;manifest-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;object-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;block-all-mixed-content;report-uri https://www.facebook.com/csp/reporting/?minimize=0;\r\ncontent-security-policy: default-src *.facebook.com *.fbcdn.net *.instagram.com blob:;script-src *.instagram.com static.cdninstagram.com *.facebook.com *.fbcdn.net *.facebook.net 127.0.0.1:* &#039;nonce-Ov7CyBn4&#039; blob: &#039;self&#039; &#039;unsafe-eval&#039; https://*.google-analytics.com https://translate.google.com https://apis.google.com https://accounts.google.com;style-src *.instagram.com static.cdninstagram.com data: blob: &#039;unsafe-inline&#039; *.fbcdn.net *.facebook.com;connect-src *.instagram.com wss://edge-chat.instagram.com connect.facebook.net *.facebook.com facebook.com *.fbcdn.net *.facebook.net wss://*.facebook.com:* ws://localhost:* blob: *.cdninstagram.com wss://*.instagram.com:* &#039;self&#039; https://meta.privacy-gateway.cloudflare.com/relay;font-src *.instagram.com static.cdninstagram.com data: *.fbcdn.net *.intern.facebook.com *.facebook.com https://fonts.gstatic.com;img-src *.instagram.com *.facebook.com *.fbcdn.net data: *.cdninstagram.com *.whatsapp.net blob: *.fbsbx.com android-webview-video-poster: *.oculuscdn.com *.giphy.com *.tenor.co *.tenor.com www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk https://www.gstatic.com https://*.google-analytics.com;media-src *.facebook.com *.fbcdn.net *.instagram.com *.cdninstagram.com *.fbsbx.com data: blob: https://*.giphy.com *.tenor.co *.tenor.com;child-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;frame-src *.instagram.com *.facebook.com *.fbsbx.com fbsbx.com data: www.googleadservices.com *.doubleclick.net *.google.com *.google.co.uk;manifest-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;object-src *.facebook.com *.fbcdn.net *.instagram.com data: blob:;block-all-mixed-content;upgrade-insecure-requests;\r\nx-frame-options: DENY\r\ndocument-policy: force-load-at-top\r\ndocument-policy: include-js-call-stacks-in-crash-reports\r\npermissions-policy: accelerometer=(self), attribution-reporting=(), autoplay=(), bluetooth=(), camera=(self), ch-device-memory=(), ch-downlink=(), ch-dpr=(), ch-ect=(), ch-rtt=(), ch-save-data=(), ch-ua-arch=(), ch-ua-bitness=(), ch-viewport-height=(), ch-viewport-width=(), ch-width=(), clipboard-read=(), clipboard-write=(self), compute-pressure=(), display-capture=(self), encrypted-media=(), fullscreen=(self), gamepad=(), geolocation=(self), gyroscope=(self), hid=(), idle-detection=(), interest-cohort=(), keyboard-map=(), local-fonts=(), magnetometer=(), microphone=(self), midi=(), otp-credentials=(self), payment=(), picture-in-picture=(self), private-state-token-issuance=(), publickey-credentials-get=(), screen-wake-lock=(), serial=(), shared-storage=(), shared-storage-select-url=(), private-state-token-redemption=(), usb=(), unload=(self), window-management=(), xr-spatial-tracking=();report-to=&quot;permissions_policy&quot;\r\ncross-origin-resource-policy: same-origin\r\norigin-trial: ArDvqjFKr1fHThlSM8Kkp74sxlOCFTeqYJMXCGqCG/VJmcYlO/0UavmpqPDit2KppDf1THInNpwA36GmtgPOug8AAAB2eyJvcmlnaW4iOiJodHRwczovL3d3dy5pbnN0YWdyYW0uY29tOjQ0MyIsImZlYXR1cmUiOiJDcmFzaFJlcG9ydGluZ1N0b3JhZ2VBUEkiLCJleHBpcnkiOjE3NzY3Mjk2MDAsImlzU3ViZG9tYWluIjp0cnVlfQ==\r\ncross-origin-opener-policy: same-origin-allow-popups\r\npragma: no-cache\r\ncache-control: private, no-cache, no-store, must-revalidate\r\nexpires: Sat, 01 Jan 2000 00:00:00 GMT\r\nx-content-type-options: nosniff\r\nx-xss-protection: 0\r\norigin-agent-cluster: ?1\r\nstrict-transport-security: max-age=31536000; preload; includeSubDomains\r\nx-stack: www\r\ncontent-type: text/html; charset=&quot;utf-8&quot;\r\nx-fb-debug: 9D/W7AlwDwNA8RA9JKa8uTvvK/yx9DGKLhbNk8S9xyvSIdInbCX3vDbbI91E9G/wkGZJ4sVCiQBDdxCHYh+q8g==\r\ndate: Sun, 01 Feb 2026 16:38:36 GMT\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\nx-fb-connection-quality: EXCELLENT; q=0.9, rtt=4, rtx=0, c=16, mss=1380, tbw=3852, tp=-1, tpl=-1, uplat=135, ullat=0\r\n\r\nRequest headers\n================\nHEAD /lou_cinematic/ HTTP/2\r\nHost: www.instagram.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.264424","0","0","0","1","0","200|0|0|https://www.instagram.com/lou_cinematic/","0","0"),
("598","https://www.youtube.com/watch?v=qn53lNoB4n8","2025-04-22 08:28:11","2026-02-01 16:38:35","0000-00-00 00:00:00","2026-02-01 16:38:35","96","https://www.youtube.com/watch?v=qn53lNoB4n8","0","<em>(Using YouTube API)</em>\n\n403 Forbidden\nUnknown YouTube API response received.\n---\nmessage: Method doesn&#039;t allow unregistered callers (callers without established identity). Please use API Key or other form of API consumer identity to call this API.\ndomain: global\nreason: forbidden\n\nLe lien est cassé.","403","warning","forbidden","0.061836","0","0","1","1","0","youtube|403|0|0|-|-","0","0"),
("599","https://dualdiploma.org/wp-content/uploads/2025/04/Capture-decran-2025-04-14-141705-1.png","0000-00-00 00:00:00","2026-02-01 16:38:35","2026-02-01 16:38:35","2026-02-01 16:38:35","0","https://dualdiploma.org/wp-content/uploads/2025/04/Capture-decran-2025-04-14-141705-1.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 16:38:35 GMT\r\ncontent-type: image/png\r\ncontent-length: 301825\r\nlast-modified: Mon, 14 Apr 2025 13:07:17 GMT\r\netag: &quot;67fd0885-49b01&quot;\r\nexpires: Tue, 03 Mar 2026 16:38:35 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/Capture-decran-2025-04-14-141705-1.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.030437","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/Capture-decran-2025-04-14-141705-1.png","0","0"),
("600","https://dualdiploma.org/wp-content/uploads/2025/04/Winner-colegia-Film-Festival-800x1000.png","0000-00-00 00:00:00","2026-02-01 16:38:37","2026-02-01 16:38:37","2026-02-01 16:38:37","0","https://dualdiploma.org/wp-content/uploads/2025/04/Winner-colegia-Film-Festival-800x1000.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 16:38:39 GMT\r\ncontent-type: image/png\r\ncontent-length: 789896\r\nlast-modified: Mon, 14 Apr 2025 13:04:35 GMT\r\netag: &quot;67fd07e3-c0d88&quot;\r\nexpires: Tue, 03 Mar 2026 16:38:39 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/Winner-colegia-Film-Festival-800x1000.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.033734","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/Winner-colegia-Film-Festival-800x1000.png","0","0"),
("601","https://dualdiploma.zohobookings.eu/#/91739000003279130","0000-00-00 00:00:00","2026-02-02 16:38:17","2026-02-02 16:38:17","2026-02-02 16:38:17","0","https://dualdiploma.zohobookings.eu/#/91739000003279130","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/1.1 200 \r\nServer: ZGS\r\nDate: Mon, 02 Feb 2026 16:38:18 GMT\r\nContent-Type: text/html;charset=UTF-8\r\nTransfer-Encoding: chunked\r\nConnection: close\r\nSet-Cookie: zalb_a4a4a9ea5f=be759874e89d9c5bb16e4324aa7bedb5; Path=/; Secure; HttpOnly\r\nX-Content-Type-Options: nosniff\r\nSet-Cookie: zccpn=c07d8488-7706-45f6-a573-8f80c066357e;path=/;SameSite=None;Secure;priority=high\r\nSet-Cookie: _zcsr_tmp=c07d8488-7706-45f6-a573-8f80c066357e;path=/;SameSite=Strict;Secure;priority=high\r\nCache-Control: private,no-cache,no-store,max-age=0,must-revalidate\r\nPragma: no-cache\r\nExpires: Thu, 01 Jan 1970 00:00:00 GMT\r\nX-Frame-Options: SAMEORIGIN\r\nVary: sec-fetch-dest,sec-fetch-mode,sec-fetch-site,sec-fetch-user,accept-encoding\r\nSet-Cookie: JSESSIONID=BCFC6D8ACB0E86A1552835AB5AA725C7; Path=/; Secure; HttpOnly\r\nContent-Encoding: gzip\r\nContent-Language: en-US\r\nStrict-Transport-Security: max-age=64072000; includeSubDomains; preload\r\n\r\nRequest headers\n================\nGET / HTTP/1.1\r\nHost: dualdiploma.zohobookings.eu\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://dualdiploma.org\r\nConnection: close\r\nRange: bytes=0-2048\r\n\r\n\nLe lien est valide.","200","","","0.260428","0","0","0","1","0","200|0|0|https://dualdiploma.zohobookings.eu/#/91739000003279130","0","0"),
("602","https://www.canva.com/design/DAGmBI3Z_sg/OKGG7bddiBEK-St6BRfFog/view?utm_content=DAGmBI3Z_sg&utm_campaign=designshare&utm_medium=link&utm_source=publishsharelink&mode=preview","0000-00-00 00:00:00","2026-02-02 22:29:17","2026-02-02 22:29:17","2026-02-02 22:29:17","0","https://www.canva.com/design/DAGmBI3Z_sg/OKGG7bddiBEK-St6BRfFog/view?utm_content=DAGmBI3Z_sg&utm_campaign=designshare&utm_medium=link&utm_source=publishsharelink&mode=preview","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Mon, 02 Feb 2026 22:29:17 GMT\r\ncontent-type: text/html;charset=utf-8\r\ncf-ray: 9c7d206129880277-CDG\r\ncf-cache-status: DYNAMIC\r\ncache-control: no-cache, no-store\r\nexpires: Thu, 1 Jan 1970 00:00:00 GMT\r\nset-cookie: CDI=06e473f3-a61f-46b5-8681-452f25b386e0; Max-Age=31536000; Expires=Tue, 02 Feb 2027 22:29:17 GMT; Path=/; Secure; HTTPOnly; SameSite=None\r\nstrict-transport-security: max-age=31536000; includeSubDomains; preload\r\npragma: No-cache\r\naccept-ch: Sec-CH-UA-Platform-Version\r\ncontent-security-policy: frame-ancestors https://canvateam.zendesk.com https://phoenix.canva.com https://www.canva-iris.com https://enterprise.canva.com https://www.affinity.studio;\r\nreferrer-policy: strict-origin-when-cross-origin\r\nx-content-type-options: nosniff\r\nx-frame-options: deny\r\nx-request-id: 9c7d206129880277\r\nx-xss-protection: 1; mode=block\r\nreport-to: {&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/a.nel.cloudflare.com\\/report\\/v4?s=glf%2BI8L%2FS93Ed%2For7XU8NzCPSXjLNq4phqT1MraZzs9CgH8Wrrq%2BngL3HbKlNQBVU2HQDcVUVmujq4OugvHJ5q0pLLNbG2CmCYS5c%2BZos85coTmrOqcW4Gk%2Bt6aUkGqCPfJ2AJQkYNLB4r4%3D&quot;}],&quot;group&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800}\r\nnel: {&quot;success_fraction&quot;:0.01,&quot;report_to&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800}\r\nvary: Accept-Encoding\r\nset-cookie: CL=en; Max-Age=2592000; Expires=Wed, 04 Mar 2026 22:29:17 GMT; Path=/; Secure; SameSite=None\r\nset-cookie: CPA=cnvanLbO-aJUae-Mlqpbb4ORGYjsvr_7oNRm6-4ufAi3djA03O7Po_KZQ0oddZILSbUCDRX3r6J0-_r6jkU0n5u5fENnBpfuXw0xFG48TtZzGbRbGmpab8qxvooh-2OVR-X6Ryx-LsX52HrTH1M5VZbFZRxvNqxhKR9-c0l682XqPjDqpooodcnk0WliRrtbC8DFYMSdkydpFLMVt2ACE7GnMK3n_g4MBl666Lq4-RTIKRyNZjxXAzKvm1QvYltvklb6F7SlEIuCbzAqcFq4N4obrehKzYsMkcpPgmQmDzdILOZ97fGJ_4NkIq5vxQX_4Gc4KIeYDuVmkaikK3W_X95M7KnZ6CKEnhPDoiDSLClIGfoGUgP29hx-_2FQy4tAE8Tnqe4plCpX-0SgeHvelIT2ediaLCmqnH5_Gmi4Rc0IHughO7YohR7SZf3ntN1xUOR1TCa9z0y27I-zVjdx1QjUIvJS31Fuk3V3ZlvmkZG9VoxrQoNdu96WWQIXkH3HIo4s8qBD-oJh_JRWL7TjdeigfFj4_zbZp6Y2ZeN2RV_vJCv0yY4VWjoeZosBMfKYKqHAkAhOejFhfR15Oi1nEI7LrWUcnvyaOUMQBIIXnoxwlWu1rvA3W5kLErQCbFaVUOZEnZZdaPmNMh3Cog3Wl9e05KTDoRFTQhW2wR2yyF-J9bw92B3ys3srEa0PuVyYqOBmwV-vDpA2dbfdd44; Max-Age=10800; Expires=Tue, 03 Feb 2026 01:29:17 GMT; Path=/; Secure; HTTPOnly; SameSite=None\r\nset-cookie: __cf_bm=IcPVHOfk_ntuNc_QxFBmo3bKSYBWFSlNUSJfKZg8lNE-1770071357-1.0.1.1-njkGD6SOIBmOlFS2srpFTFuR_6OoNFRLr.rKgsLIob5l5aznBIkduCX1pMRgyB9DOtOSQbKUxhaoPgPgaOHqVC7S1VOgQVkEaZL1q9V5MFg; path=/; expires=Mon, 02-Feb-26 22:59:17 GMT; domain=.canva.com; HttpOnly; Secure; SameSite=None\r\nset-cookie: _cfuvid=_rR5kkqT.ibPGSZNFeukY8T0Joi6Q5QFVa1s2GK2bMs-1770071357931-0.0.1.1-604800000; path=/; domain=.canva.com; HttpOnly; Secure; SameSite=None\r\nserver: cloudflare\r\ncontent-encoding: br\r\n\r\nRequest headers\n================\nHEAD /design/DAGmBI3Z_sg/OKGG7bddiBEK-St6BRfFog/view?utm_content=DAGmBI3Z_sg&amp;utm_campaign=designshare&amp;utm_medium=link&amp;utm_source=publishsharelink&amp;mode=preview HTTP/2\r\nHost: www.canva.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.370422","0","0","0","1","0","200|0|0|https://www.canva.com/design/DAGmBI3Z_sg/OKGG7bddiBEK-St6BRfFog/view","0","0"),
("606","https://dualdiploma.org/wp-content/uploads/2025/04/Carrousel-instagram-p11-1.png","0000-00-00 00:00:00","2026-02-02 23:48:28","2026-02-02 23:48:28","2026-02-02 23:48:28","0","https://dualdiploma.org/wp-content/uploads/2025/04/Carrousel-instagram-p11-1.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 23:48:30 GMT\r\ncontent-type: image/png\r\ncontent-length: 486255\r\nlast-modified: Tue, 29 Apr 2025 15:24:34 GMT\r\netag: &quot;6810ef32-76b6f&quot;\r\nexpires: Wed, 04 Mar 2026 23:48:30 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/04/Carrousel-instagram-p11-1.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.144947","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/04/Carrousel-instagram-p11-1.png","0","0"),
("607","https://dualdiploma.org/wp-content/uploads/2025/05/Carrousel-instagram-p3-2.png","0000-00-00 00:00:00","2026-02-02 23:48:27","2026-02-02 23:48:27","2026-02-02 23:48:27","0","https://dualdiploma.org/wp-content/uploads/2025/05/Carrousel-instagram-p3-2.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 23:48:28 GMT\r\ncontent-type: image/png\r\ncontent-length: 967244\r\nlast-modified: Mon, 05 May 2025 15:11:08 GMT\r\netag: &quot;6818d50c-ec24c&quot;\r\nexpires: Wed, 04 Mar 2026 23:48:28 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/05/Carrousel-instagram-p3-2.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.019165","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/05/Carrousel-instagram-p3-2.png","0","0"),
("608","mailto:com@dualdiploma.org","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","2026-02-03 00:28:53","92","","0","L’extension ne sait pas comment vérifier ce type de lien.","0","","","0","0","0","0","1","0","","0","0"),
("609","https://dualdiploma.org/blog/tag/classe-virtuelle/","2025-06-13 13:29:09","2026-02-02 20:58:39","2025-06-10 13:28:10","2026-02-02 20:58:39","81","https://dualdiploma.org/blog/tag/classe-virtuelle/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 404 ===\n\nResponse headers\n================\nHTTP/2 404 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:58:41 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nexpires: Wed, 11 Jan 1984 05:00:00 GMT\r\ncache-control: no-cache, must-revalidate, max-age=0, no-store, private\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nGET /blog/tag/classe-virtuelle/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\nrange: bytes=0-2048\r\n\r\nResponse HTML\n================\n&lt;!doctype html&gt;\n&lt;html lang=&quot;fr-FR&quot;&gt;\n&lt;head&gt;\n	&lt;meta charset=&quot;UTF-8&quot;&gt;\n	&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1&quot;&gt;\n	&lt;link rel=&quot;shortcut icon&quot; href=&quot;https://dualdiploma.org/wp-content/themes/digitool/assets/images/DD-favicon.svg&quot; /&gt;\n	&lt;link rel=&quot;profile&quot; href=&quot;https://gmpg.org/xfn/11&quot;&gt;\n	\n	&lt;script&gt;(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({&#039;gtm.start&#039;:\n	new Date().getTime(),event:&#039;gtm.js&#039;});var f=d.getElementsByTagName(s)[0],\n	j=d.createElement(s),dl=l!=&#039;dataLayer&#039;?&#039;&amp;l=&#039;+l:&#039;&#039;;j.async=true;j.src=\n	&#039;https://www.googletagmanager.com/gtm.js?id=&#039;+i+dl;f.parentNode.insertBefore(j,f);\n	})(window,document,&#039;script&#039;,&#039;dataLayer&#039;,&#039;GTM-T3JNHVN&#039;);&lt;/script&gt;\n	\n	&lt;meta name=&#039;robots&#039; content=&#039;noindex, follow&#039; /&gt;\n\n&lt;script type=&quot;text/javascript&quot; id=&quot;google_gtagjs-js-consent-mode-data-layer&quot;&gt;\n/* &lt;![CDATA[ */\nwindow.dataLayer = window.dataLayer || [];function gtag(){dataLayer.push(arguments);}\ngtag(&#039;consent&#039;, &#039;default&#039;, {&quot;ad_personalization&quot;:&quot;denied&quot;,&quot;ad_storage&quot;:&quot;denied&quot;,&quot;ad_user_data&quot;:&quot;denied&quot;,&quot;analytics_storage&quot;:&quot;denied&quot;,&quot;functionality_storage&quot;:&quot;denied&quot;,&quot;security_storage&quot;:&quot;denied&quot;,&quot;personalization_storage&quot;:&quot;denied&quot;,&quot;region&quot;:[&quot;AT&quot;,&quot;BE&quot;,&quot;BG&quot;,&quot;CH&quot;,&quot;CY&quot;,&quot;CZ&quot;,&quot;DE&quot;,&quot;DK&quot;,&quot;EE&quot;,&quot;ES&quot;,&quot;FI&quot;,&quot;FR&quot;,&quot;GB&quot;,&quot;GR&quot;,&quot;HR&quot;,&quot;HU&quot;,&quot;IE&quot;,&quot;IS&quot;,&quot;IT&quot;,&quot;LI&quot;,&quot;LT&quot;,&quot;LU&quot;,&quot;LV&quot;,&quot;MT&quot;,&quot;NL&quot;,&quot;NO&quot;,&quot;PL&quot;,&quot;PT&quot;,&quot;RO&quot;,&quot;SE&quot;,&quot;SI&quot;,&quot;SK&quot;],&quot;wait_for_update&quot;:500});\nwindow._googlesitekitConsentCategoryMap = {&quot;statistics&quot;:[&quot;analytics_storage&quot;],&quot;marketing&quot;:[&quot;ad_storage&quot;,&quot;ad_user_data&quot;,&quot;ad_personalization&quot;],&quot;functional&quot;:[&quot;functionality_storage&quot;,&quot;security_storage&quot;],&quot;preferences&quot;:[&quot;personalization_storage&quot;]};\nwindow._googlesitekitConsents = {&quot;ad_personalization&quot;:&quot;denied&quot;,&quot;ad_storage&quot;:&quot;denied&quot;,&quot;ad_user_data&quot;:&quot;denied&quot;,&quot;analytics_storage&quot;:&quot;denied&quot;,&quot;functionality_storage&quot;:&quot;denied&quot;,&quot;security_storage&quot;:&quot;denied&quot;,&quot;personalization_storage&quot;:&quot;denied&quot;,&quot;region&quot;:[&quot;AT&quot;,&quot;BE&quot;,&quot;BG&quot;,&quot;CH&quot;,&quot;CY&quot;,&quot;CZ&quot;,&quot;DE&quot;,&quot;DK&quot;,&quot;EE&quot;,&quot;ES&quot;,&quot;FI&quot;,&quot;FR&quot;,&quot;GB&quot;,&quot;GR&quot;,&quot;HR&quot;,&quot;HU&quot;,&quot;IE&quot;,&quot;IS&quot;,&quot;IT&quot;,&quot;LI&quot;,&quot;LT&quot;,&quot;LU&quot;,&quot;LV&quot;,&quot;MT&quot;,&quot;NL&quot;,&quot;NO&quot;,&quot;PL&quot;,&quot;PT&quot;,&quot;RO&quot;,&quot;SE&quot;,&quot;SI&quot;,&quot;SK&quot;],&quot;wait_for_update&quot;:500};\n/* ]]&gt; */\n&lt;/script&gt;\n\n\n	\n	&lt;title&gt;Page non trou\nLe lien est cassé.","404","","","0.404656","0","1","0","1","0","404|broken|0|https://dualdiploma.org/blog/tag/classe-virtuelle/","0","0"),
("611","https://dualdiploma.org/wp-content/uploads/2025/05/Cursus-Cours-2025-2026.pdf","0000-00-00 00:00:00","2026-02-02 20:59:04","2026-02-02 20:59:04","2026-02-02 20:59:04","0","https://dualdiploma.org/wp-content/uploads/2025/05/Cursus-Cours-2025-2026.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 20:59:09 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 370809\r\nlast-modified: Wed, 14 May 2025 14:27:50 GMT\r\netag: &quot;6824a866-5a879&quot;\r\nexpires: Wed, 04 Mar 2026 20:59:09 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/05/Cursus-Cours-2025-2026.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.029282","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/05/Cursus-Cours-2025-2026.pdf","0","0"),
("612","https://dualdiploma.org/wp-content/uploads/2025/05/AIS-Dual-Diploma-Course-Catalog-2025-2026_AP.pdf","0000-00-00 00:00:00","2026-01-31 15:48:17","2026-01-31 15:48:17","2026-01-31 15:48:17","0","https://dualdiploma.org/wp-content/uploads/2025/05/AIS-Dual-Diploma-Course-Catalog-2025-2026_AP.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 15:48:17 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 288866\r\nlast-modified: Thu, 15 May 2025 07:47:41 GMT\r\netag: &quot;68259c1d-46862&quot;\r\nexpires: Mon, 02 Mar 2026 15:48:17 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/05/AIS-Dual-Diploma-Course-Catalog-2025-2026_AP.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.028556","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/05/AIS-Dual-Diploma-Course-Catalog-2025-2026_AP.pdf","0","0"),
("614","https://www.canva.com/fr_fr/free/","2025-11-21 20:29:03","2026-02-02 00:08:32","2025-11-18 20:18:22","2026-02-02 00:08:32","27","https://www.canva.com/fr_fr/free/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 403 ===\n\nResponse headers\n================\nHTTP/2 403 \r\ndate: Mon, 02 Feb 2026 00:08:32 GMT\r\ncontent-type: text/html; charset=UTF-8\r\naccept-ch: Sec-CH-UA-Bitness, Sec-CH-UA-Arch, Sec-CH-UA-Full-Version, Sec-CH-UA-Mobile, Sec-CH-UA-Model, Sec-CH-UA-Platform-Version, Sec-CH-UA-Full-Version-List, Sec-CH-UA-Platform, Sec-CH-UA, UA-Bitness, UA-Arch, UA-Full-Version, UA-Mobile, UA-Model, UA-Platform-Version, UA-Platform, UA\r\ncf-mitigated: challenge\r\ncritical-ch: Sec-CH-UA-Bitness, Sec-CH-UA-Arch, Sec-CH-UA-Full-Version, Sec-CH-UA-Mobile, Sec-CH-UA-Model, Sec-CH-UA-Platform-Version, Sec-CH-UA-Full-Version-List, Sec-CH-UA-Platform, Sec-CH-UA, UA-Bitness, UA-Arch, UA-Full-Version, UA-Mobile, UA-Model, UA-Platform-Version, UA-Platform, UA\r\ncross-origin-embedder-policy: require-corp\r\ncross-origin-opener-policy: same-origin\r\ncross-origin-resource-policy: same-origin\r\norigin-agent-cluster: ?1\r\npermissions-policy: accelerometer=(),browsing-topics=(),camera=(),clipboard-read=(),clipboard-write=(),geolocation=(),gyroscope=(),hid=(),interest-cohort=(),magnetometer=(),microphone=(),payment=(),publickey-credentials-get=(),screen-wake-lock=(),serial=(),sync-xhr=(),usb=()\r\nreferrer-policy: same-origin\r\nserver-timing: chlray;desc=&quot;9c757462cf4f2a20&quot;\r\nx-content-type-options: nosniff\r\nx-frame-options: SAMEORIGIN\r\ncache-control: private, max-age=0, no-store, no-cache, must-revalidate, post-check=0, pre-check=0\r\nexpires: Thu, 01 Jan 1970 00:00:01 GMT\r\nset-cookie: __cf_bm=751MVBMMYnBCO.7T6ho2WZnL_PRHem2WXw4e.utqEk0-1769990912-1.0.1.1-xiQwSBxZ4b6HlRWbB2V3x2QFhc2Wi5ImHLEnJkprdWbyo2AGJKAGEcn88EiXAujk1MvDssOvIOG4oPDeJHFpA0TuGkwYeyV2DuOvDkuYof4; path=/; expires=Mon, 02-Feb-26 00:38:32 GMT; domain=.canva.com; HttpOnly; Secure; SameSite=None\r\nreport-to: {&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/a.nel.cloudflare.com\\/report\\/v4?s=H3vyBIdkZAUbCvH4hU2xvRr3ee5NEv4oaFY2xshNSBheiD9eCinyPpMr7nbY7Q706bYYhi9OviB%2FxH7SptFW%2FhNGESXN8vufkWpANlRFb4BIZ5YjO4%2F4l49rczfjXhyewNRDpjOZM0TpC6o%3D&quot;}],&quot;group&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800}\r\nnel: {&quot;success_fraction&quot;:0.01,&quot;report_to&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800}\r\nvary: Accept-Encoding\r\nstrict-transport-security: max-age=31536000; includeSubDomains; preload\r\nserver: cloudflare\r\ncf-ray: 9c757462cf4f2a20-CDG\r\ncontent-encoding: br\r\n\r\nRequest headers\n================\nGET /fr_fr/free/ HTTP/2\r\nHost: www.canva.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\nrange: bytes=0-2048\r\n\r\nResponse HTML\n================\n&lt;!DOCTYPE html&gt;\n&lt;html&gt;\n&lt;head&gt;\n&lt;meta charset=&quot;utf-8&quot;&gt;\n&lt;title&gt;Canva&lt;/title&gt;\n&lt;meta name=&quot;viewport&quot; content=&quot;maximum-scale=1.0, width=500&quot; /&gt;\n&lt;meta name=&quot;apple-mobile-web-app-capable&quot; content=&quot;yes&quot; /&gt;\n&lt;style&gt;@font-face{font-family:Open Sans;font-stretch:normal;font-style:normal;font-weight:300;src:url(data:font/woff2;base64,d09GMgABAAAAADIgAA8AAAAAYfAAADHEAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGk4bixAcPAZgP1NUQVRaAHQREAqBknj3eAuDOAABNgIkA4ZkBCAFhGQHkCEbslEl7NhL4XYAJUl+W0RUkpYdRS0enLqL//+WQOWwhdgGfxvaaIUtD8tSeAmwUi2hQvskJwkFPffdez3nzf5kms+3Ma6cbcvXmIgnHAAM4YBwaAKiB9IY9k19mn/zkJMcobFPcn+e3+af+4oShxMLCyPXYDSoWMXYjGIOM8BeVZp/8lZsLXN/X1z+VRR8/a993q6q7jcbIiljCTSj/UKIxKmcqIUJgJG55Xw1w9YZgm12zom6OWfNgYUYNaM3Y8MEGxSQUFCREKUEsTASwaheuFDHXKULV25z1e4X/YsGHdwJYXpqlQHjbEpLYSGuLxSwJ72Mw4j8H+dEtiFD36qlOut5hCyUCvo87v7brP5HIlUQGVM7mSGtEtn1lkBd4PUt2b2NqgQYE7UtFOpvU5JSoCAJSf5eZ9lK/9k3XisgB72p7jgERUNQXdLUmV56/1s66ckLkpesgK1Db8iHYHl3xt7dMBfNUYlY7QYAKgCuitQpmgKhTNFVhDzQr6X2drovXEKXsEyFi/I15u5vsuk/CPDelVgBkVUMqrqqss5WWF8bY9kB2fc4RCO2+WKvk+fFmsYYxVH8FaEYAW3v7bmbbNUsD+dSUWwrSYXC+6SAAANjeLCCjJUxwA0pCKKIzhPxNCSaaE1MZF5iARcKV7kBriwUlZmiTVAKdvBgb7YXK24pB9KPpdcGIBJSdjteASHPG2vK8uTrmvzS5Jv8vJrkh3F1FR4sHtURit8SNEX0EVgGnwAQmZAhmz0Rc+AvRLDY8enNsQH97hzvHPYn9L1RPdtnPDDiuLg5RdJlwh8MzCnYAeAcaeuIJAcaeuU+HwPKJAAQgA3EQMIjl8lG4QKgaCKdK1bqrW4/8sb5a9VtMLLUGnfehmlzjjhl3PM/ZKBlwHhK6Vf+gJ7Vm/qEfmCAUZgRNliWspOzPDVSPrqjMAVl90S0Ej1DCmVIqQKVqUYN/oZN0DTN0SKt0Au96xJbtK5vu9ShHh3Scen1ny7qmu7oEe3R+IL9wjGciRvjfAsstKuHWpQp9nOIZY51ssc6y3kucoXr3ORJXqWj0UvUrdngbd7jLtPW+aT7bPBl3/AH/J6faHkU8W/4H4Ig2AQv5rGJY9wzPF4JiDSRiY88acmJKiWpiiYtmQLCVzYNwn7a72HahjqtXeJElIdP7rJaF72HhxsATKaPY+UeMRRtwWPwJwY6lhnXYg9nMGSouWtVHj0ZhxBb6BHWbKwljp7WYu8YKWpFf8hjyuEzpYFmPieuECZSsJMUzAADNDHCOxrdgKsQSzM4YTmNjHQvsBqPEKuDAiqbBXzIAys4C7bwP1F0yIET1BUhjbopUEz7kLBfRbRbI23skpBOhwKJG3AfauEJtEAnkyt4I+0HFTDL9hhAbOmcLFDBS6EavOlEoIt0EJF9ZLvjWLCCBkiuV76Gy5S7soXtF/gQK4zhg/A50mNYBsY4w5jz2E1Q0Dc7Awr6X85AgI6tqhkHu7OrYHKiVJB3Gx4TLgq6bP+GgjGYm4L+siwXi1l4HK/ycA2ggSgiJQ6xBx5+CBQe4RPNAHvrYWoADQ0sREGPSQcmmhEAjIENRvAgfgmDEJzBGZxVZ5gC6l\nLe lien est cassé.","403","","","0.114062","0","1","0","1","0","403|broken|0|https://www.canva.com/fr_fr/free/","0","0"),
("615","https://www.canva.com/design/DAGp3sTX-HA/6LVutxSXMKeBLgZi9eaDgg/view?utm_content=DAGp3sTX-HA&utm_campaign=designshare&utm_medium=link&utm_source=publishsharelink&mode=preview","0000-00-00 00:00:00","2026-02-01 21:38:37","2026-02-01 21:38:37","2026-02-01 21:38:37","0","https://www.canva.com/design/DAGp3sTX-HA/6LVutxSXMKeBLgZi9eaDgg/view?utm_content=DAGp3sTX-HA&utm_campaign=designshare&utm_medium=link&utm_source=publishsharelink&mode=preview","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Sun, 01 Feb 2026 21:38:37 GMT\r\ncontent-type: text/html;charset=utf-8\r\ncf-ray: 9c7498c8b94e9ea2-CDG\r\ncf-cache-status: DYNAMIC\r\ncache-control: no-cache, no-store\r\nexpires: Thu, 1 Jan 1970 00:00:00 GMT\r\nset-cookie: CDI=72d3ee27-21bc-4213-89dd-4350982b0a0f; Max-Age=31536000; Expires=Mon, 01 Feb 2027 21:38:37 GMT; Path=/; Secure; HTTPOnly; SameSite=None\r\nstrict-transport-security: max-age=31536000; includeSubDomains; preload\r\npragma: No-cache\r\naccept-ch: Sec-CH-UA-Platform-Version\r\ncontent-security-policy: frame-ancestors https://canvateam.zendesk.com https://phoenix.canva.com https://www.canva-iris.com https://enterprise.canva.com https://www.affinity.studio;\r\nreferrer-policy: strict-origin-when-cross-origin\r\nx-content-type-options: nosniff\r\nx-frame-options: deny\r\nx-request-id: 9c7498c8b94e9ea2\r\nx-xss-protection: 1; mode=block\r\nreport-to: {&quot;endpoints&quot;:[{&quot;url&quot;:&quot;https:\\/\\/a.nel.cloudflare.com\\/report\\/v4?s=Z4cu4CsF53FUj30sXAvS8c7OA1TLTDoiXVo%2FsjzsKE7IGQMTvo2r%2F2JTZd0epOOLyH6mrDW%2BK76%2B15YawCMfFuAPqIXzVoYcmjQ45ek5m%2Bh8fruAh%2BEhB%2BPU3EzmRYL0AjrJxhh2OTvXjbg%3D&quot;}],&quot;group&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800}\r\nnel: {&quot;success_fraction&quot;:0.01,&quot;report_to&quot;:&quot;cf-nel&quot;,&quot;max_age&quot;:604800}\r\nvary: Accept-Encoding\r\nset-cookie: CL=en; Max-Age=2592000; Expires=Tue, 03 Mar 2026 21:38:37 GMT; Path=/; Secure; SameSite=None\r\nset-cookie: CPA=cnvan7lCJ0jNrQsRC1EnoHWdx3rq4tJANjanonfDP35DI601ZGPSW1CzrgwxI9sZWDc8niErSDULvGnwCIAzmG0DGQSTCWEZEui8XXLrmKQwdqzn3Og7jygRkdF8yOvVEMPYTBw7WChROonXGlUouOeP4eLCMjCZ6E_Nk_-Zo4eoMcU9T2xYMv4Y5tdf6gNMEjh3SPO2P6cKasjLxeuS4m8E61ovQ5pfKBdYKJ0KMPK7Sg8gsWl1O8LVH_3Cgn5bkyO-HAsT6hLMl84qr6oyybWMUjE1JkRhxYw1eYam7m-TxN1w29dZqKzCf49swOZ7ahrBQpPews7sBMobtWxp8hEQgYe1b9MqK8lhwzf1OtDmTl_mCxFqZgGcAs_7da25hPYzLbQqMRHP93O8iewZr8prdZgXO4zd9tl5RrDD5KQGCaHJniH2K7jwi3KNX2khNAB_shdjW-EBwXIA4jpdWi9KsTAZp6s9S_PCPcAkKa2wr2jR4tjbmQaFAsB2O8XbmsxfvsXwd0I-z2yIp7wU6uJn35yUoUb67Z9qnJGjtI81--g5D6B1c6m53a4crUw0EoLTqfDVLwtJpnDPNbgDrM59oaOVMgTlgaoQT0e_KWKWG553f_oD0LuVoInxG84QXZal6nHhgoEKhqHy1s0WFXDNfM3l-QGlP2JpWZvjJXeHKCWGONmEU0-M9VX_h00jDam7HF_dzMwf388f9c1; Max-Age=10800; Expires=Mon, 02 Feb 2026 00:38:37 GMT; Path=/; Secure; HTTPOnly; SameSite=None\r\nset-cookie: __cf_bm=Qd4ygojK9pQHYeszSQp.6ukqA_CpuNRlalewjuRiRI8-1769981917-1.0.1.1-UoG9DB_3JpyB39eKQ6Z1Zu7jXGjUSWRF32..1OcvyVUYDoUW1vc2xk2SgQCb7THBYl6QBSgc8.u9ASVyYPYLUVwKwvmJtRgKcKm4UAr9C.I; path=/; expires=Sun, 01-Feb-26 22:08:37 GMT; domain=.canva.com; HttpOnly; Secure; SameSite=None\r\nset-cookie: _cfuvid=hRc0CC16kIl6WEIv5TDQ_I7GIzzDcgFn3eb2ilScETM-1769981917859-0.0.1.1-604800000; path=/; domain=.canva.com; HttpOnly; Secure; SameSite=None\r\nserver: cloudflare\r\ncontent-encoding: br\r\n\r\nRequest headers\n================\nHEAD /design/DAGp3sTX-HA/6LVutxSXMKeBLgZi9eaDgg/view?utm_content=DAGp3sTX-HA&amp;utm_campaign=designshare&amp;utm_medium=link&amp;utm_source=publishsharelink&amp;mode=preview HTTP/2\r\nHost: www.canva.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.356007","0","0","0","1","0","200|0|0|https://www.canva.com/design/DAGp3sTX-HA/6LVutxSXMKeBLgZi9eaDgg/view","0","0"),
("622","https://www.lamerci.com/","0000-00-00 00:00:00","2026-02-01 21:39:07","2026-02-01 21:39:07","2026-02-01 21:39:07","0","https://www.lamerci.com/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Sun, 01 Feb 2026 21:39:08 GMT\r\nserver: Apache\r\nlink: &lt;https://www.lamerci.com/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;, &lt;https://www.lamerci.com/wp-json/wp/v2/pages/2&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;, &lt;https://www.lamerci.com/&gt;; rel=shortlink\r\ncache-control: max-age=0, public\r\nexpires: Sun, 01 Feb 2026 21:39:08 GMT\r\nvary: Accept-Encoding\r\ncontent-encoding: br\r\ncontent-type: text/html; charset=UTF-8\r\nvia: 2.0 alproxy\r\ncontent-length: 1\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: www.lamerci.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.166421","0","0","0","1","0","200|0|0|https://www.lamerci.com/","0","0"),
("623","https://www.graduationsource.com/blog/why-we-turn-tassel#:~:text=Why%20Do%20We%20Turn%20The,confirming%20your%20newfound%20graduate%20status.","2025-07-15 15:55:34","2026-02-01 23:08:10","0000-00-00 00:00:00","2026-02-01 23:08:10","70","https://www.graduationsource.com/blog/why-we-turn-tassel","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 403 ===\n\nResponse headers\n================\nHTTP/2 403 \r\ndate: Sun, 01 Feb 2026 23:08:10 GMT\r\ncontent-type: text/html; charset=UTF-8\r\naccept-ch: Sec-CH-UA-Bitness, Sec-CH-UA-Arch, Sec-CH-UA-Full-Version, Sec-CH-UA-Mobile, Sec-CH-UA-Model, Sec-CH-UA-Platform-Version, Sec-CH-UA-Full-Version-List, Sec-CH-UA-Platform, Sec-CH-UA, UA-Bitness, UA-Arch, UA-Full-Version, UA-Mobile, UA-Model, UA-Platform-Version, UA-Platform, UA\r\ncf-mitigated: challenge\r\ncritical-ch: Sec-CH-UA-Bitness, Sec-CH-UA-Arch, Sec-CH-UA-Full-Version, Sec-CH-UA-Mobile, Sec-CH-UA-Model, Sec-CH-UA-Platform-Version, Sec-CH-UA-Full-Version-List, Sec-CH-UA-Platform, Sec-CH-UA, UA-Bitness, UA-Arch, UA-Full-Version, UA-Mobile, UA-Model, UA-Platform-Version, UA-Platform, UA\r\ncross-origin-embedder-policy: require-corp\r\ncross-origin-opener-policy: same-origin\r\ncross-origin-resource-policy: same-origin\r\norigin-agent-cluster: ?1\r\npermissions-policy: accelerometer=(),browsing-topics=(),camera=(),clipboard-read=(),clipboard-write=(),geolocation=(),gyroscope=(),hid=(),interest-cohort=(),magnetometer=(),microphone=(),payment=(),publickey-credentials-get=(),screen-wake-lock=(),serial=(),sync-xhr=(),usb=()\r\nreferrer-policy: same-origin\r\nserver-timing: chlray;desc=&quot;9c751bf3ffc2f158&quot;\r\nx-content-type-options: nosniff\r\nx-frame-options: SAMEORIGIN\r\ncache-control: private, max-age=0, no-store, no-cache, must-revalidate, post-check=0, pre-check=0\r\nexpires: Thu, 01 Jan 1970 00:00:01 GMT\r\nvary: Accept-Encoding\r\nserver: cloudflare\r\ncf-ray: 9c751bf3ffc2f158-CDG\r\ncontent-encoding: br\r\n\r\nRequest headers\n================\nGET /blog/why-we-turn-tassel HTTP/2\r\nHost: www.graduationsource.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\nrange: bytes=0-2048\r\n\r\nResponse HTML\n================\n&lt;!DOCTYPE html&gt;&lt;html lang=&quot;en-US&quot;&gt;&lt;head&gt;&lt;title&gt;Just a moment...&lt;/title&gt;&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=UTF-8&quot;&gt;&lt;meta http-equiv=&quot;X-UA-Compatible&quot; content=&quot;IE=Edge&quot;&gt;&lt;meta name=&quot;robots&quot; content=&quot;noindex,nofollow&quot;&gt;&lt;meta name=&quot;viewport&quot; content=&quot;width=device-width,initial-scale=1&quot;&gt;&lt;style&gt;*{box-sizing:border-box;margin:0;padding:0}html{line-height:1.15;-webkit-text-size-adjust:100%;color:#313131;font-family:system-ui,-apple-system,BlinkMacSystemFont,&quot;Segoe UI&quot;,Roboto,&quot;Helvetica Neue&quot;,Arial,&quot;Noto Sans&quot;,sans-serif,&quot;Apple Color Emoji&quot;,&quot;Segoe UI Emoji&quot;,&quot;Segoe UI Symbol&quot;,&quot;Noto Color Emoji&quot;}body{display:flex;flex-direction:column;height:100vh;min-height:100vh}.main-content{margin:8rem auto;padding-left:1.5rem;max-width:60rem}@media (width &lt;= 720px){.main-content{margin-top:4rem}}.h2{line-height:2.25rem;font-size:1.5rem;font-weight:500}@media (width &lt;= 720px){.h2{line-height:1.5rem;font-size:1.25rem}}#challenge-error-text{background-image:url(&quot;data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIzMiIgaGVpZ2h0PSIzMiIgZmlsbD0ibm9uZSI+PHBhdGggZmlsbD0iI0IyMEYwMyIgZD0iTTE2IDNhMTMgMTMgMCAxIDAgMTMgMTNBMTMuMDE1IDEzLjAxNSAwIDAgMCAxNiAzbTAgMjRhMTEgMTEgMCAxIDEgMTEtMTEgMTEuMDEgMTEuMDEgMCAwIDEtMTEgMTEiLz48cGF0aCBmaWxsPSIjQjIwRjAzIiBkPSJNMTcuMDM4IDE4LjYxNUgxNC44N0wxNC41NjMgOS41aDIuNzgzem0tMS4wODQgMS40MjdxLjY2IDAgMS4wNTcuMzg4LjQwNy4zODkuNDA3Ljk5NCAwIC41OTYtLjQwNy45ODQtLjM5Ny4zOS0xLjA1Ny4zODktLjY1IDAtMS4wNTYtLjM4OS0uMzk4LS4zODktLjM5OC0uOTg0IDAtLjU5Ny4zOTgtLjk4NS40MDYtLjM5NyAxLjA1Ni0uMzk3Ii8+PC9zdmc+&quot;);background-repeat:no-repeat;background-size:contain;padding-left:34px}@media (prefers-color-scheme: dark){body{background-color:#222;color:#d9d9d9}}&lt;/style&gt;&lt;meta http-equiv=&quot;refresh&quot; content=&quot;360&quot;&gt;&lt;/head&gt;&lt;body&gt;&lt;div class=&quot;main-wrapper&quot; role=&quot;main&quot;&gt;&lt;div class=&quot;main-content&quot;&gt;&lt;noscript&gt;&lt;div class=&quot;h2&quot;&gt;&lt;span id=&quot;challenge-error-text&quot;&gt;Enable JavaScript and cookies to continue&lt;/span&gt;&lt;/div&gt;&lt;/noscript&gt;&lt;/div&gt;&lt;/div&gt;&lt;script&gt;(function(){window._cf_chl_opt = {cvId: &#039;3&#039;,cZone: &#039;www.graduationsou\nLe lien est cassé.","403","","","0.083148","0","1","0","1","0","403|broken|0|https://www.graduationsource.com/blog/why-we-turn-tassel","0","0"),
("624","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09937-800x450.jpg","0000-00-00 00:00:00","2026-02-01 21:38:39","2026-02-01 21:38:39","2026-02-01 21:38:39","0","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09937-800x450.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 21:38:41 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 173765\r\nlast-modified: Tue, 15 Jul 2025 14:10:03 GMT\r\netag: &quot;6876613b-2a6c5&quot;\r\nexpires: Tue, 03 Mar 2026 21:38:41 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/07/DSC09937-800x450.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.027013","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/07/DSC09937-800x450.jpg","0","0"),
("625","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09610-800x450.jpg","0000-00-00 00:00:00","2026-02-01 21:39:13","2026-02-01 21:39:13","2026-02-01 21:39:13","0","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09610-800x450.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 21:39:18 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 126633\r\nlast-modified: Tue, 15 Jul 2025 14:10:24 GMT\r\netag: &quot;68766150-1eea9&quot;\r\nexpires: Tue, 03 Mar 2026 21:39:18 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/07/DSC09610-800x450.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.148277","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/07/DSC09610-800x450.jpg","0","0"),
("626","https://dualdiploma.org/wp-content/uploads/2025/07/DSC00229-800x450.jpg","0000-00-00 00:00:00","2026-02-01 21:38:52","2026-02-01 21:38:52","2026-02-01 21:38:52","0","https://dualdiploma.org/wp-content/uploads/2025/07/DSC00229-800x450.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 21:38:57 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 147730\r\nlast-modified: Tue, 15 Jul 2025 14:26:29 GMT\r\netag: &quot;68766515-24112&quot;\r\nexpires: Tue, 03 Mar 2026 21:38:57 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/07/DSC00229-800x450.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.023581","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/07/DSC00229-800x450.jpg","0","0"),
("627","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09692-800x450.jpg","0000-00-00 00:00:00","2026-02-01 21:38:37","2026-02-01 21:38:37","2026-02-01 21:38:37","0","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09692-800x450.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 21:38:37 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 133934\r\nlast-modified: Tue, 15 Jul 2025 14:06:14 GMT\r\netag: &quot;68766056-20b2e&quot;\r\nexpires: Tue, 03 Mar 2026 21:38:37 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/07/DSC09692-800x450.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.031897","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/07/DSC09692-800x450.jpg","0","0"),
("628","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09891-1-800x450.jpg","0000-00-00 00:00:00","2026-02-01 21:39:02","2026-02-01 21:39:02","2026-02-01 21:39:02","0","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09891-1-800x450.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 21:39:07 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 124394\r\nlast-modified: Tue, 15 Jul 2025 14:27:10 GMT\r\netag: &quot;6876653e-1e5ea&quot;\r\nexpires: Tue, 03 Mar 2026 21:39:07 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/07/DSC09891-1-800x450.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.022485","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/07/DSC09891-1-800x450.jpg","0","0"),
("629","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09794-800x450.jpg","0000-00-00 00:00:00","2026-02-01 21:39:08","2026-02-01 21:39:08","2026-02-01 21:39:08","0","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09794-800x450.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 21:39:13 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 118753\r\nlast-modified: Tue, 15 Jul 2025 14:08:12 GMT\r\netag: &quot;687660cc-1cfe1&quot;\r\nexpires: Tue, 03 Mar 2026 21:39:13 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/07/DSC09794-800x450.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.029625","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/07/DSC09794-800x450.jpg","0","0"),
("630","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09828-800x450.jpg","0000-00-00 00:00:00","2026-02-01 21:38:47","2026-02-01 21:38:47","2026-02-01 21:38:47","0","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09828-800x450.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 21:38:52 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 116847\r\nlast-modified: Tue, 15 Jul 2025 14:08:59 GMT\r\netag: &quot;687660fb-1c86f&quot;\r\nexpires: Tue, 03 Mar 2026 21:38:52 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/07/DSC09828-800x450.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.020407","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/07/DSC09828-800x450.jpg","0","0"),
("631","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09848-800x450.jpg","0000-00-00 00:00:00","2026-02-01 21:38:37","2026-02-01 21:38:37","2026-02-01 21:38:37","0","https://dualdiploma.org/wp-content/uploads/2025/07/DSC09848-800x450.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 21:38:39 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 156129\r\nlast-modified: Tue, 15 Jul 2025 14:27:03 GMT\r\netag: &quot;68766537-261e1&quot;\r\nexpires: Tue, 03 Mar 2026 21:38:39 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/07/DSC09848-800x450.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.023409","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/07/DSC09848-800x450.jpg","0","0"),
("632","https://www.ice.gov/sevis","0000-00-00 00:00:00","2026-01-31 17:18:40","2026-01-31 17:18:40","2026-01-31 17:18:40","0","https://www.ice.gov/sevis","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/1.1 200 OK\r\nContent-Type: text/html; charset=UTF-8\r\nServer: Apache\r\nX-Content-Type-Options: nosniff\r\nContent-Language: en\r\nLast-Modified: Sat, 31 Jan 2026 17:01:54 GMT\r\nETag: &quot;1769878914&quot;\r\nX-Generator: Drupal 11 (https://www.drupal.org)\r\nContent-Security-Policy: report-uri /report-csp-violation; upgrade-insecure-requests\r\nX-Content-Security-Policy: report-uri /report-csp-violation; upgrade-insecure-requests\r\nX-WebKit-CSP: report-uri /report-csp-violation; upgrade-insecure-requests\r\nX-XSS-Protection: 1; mode=block\r\nX-WCM-H: WCM-15-201\r\nContent-Encoding: gzip\r\nContent-Length: 24453\r\nCache-Control: public, max-age=2594\r\nExpires: Sat, 31 Jan 2026 18:01:55 GMT\r\nDate: Sat, 31 Jan 2026 17:18:41 GMT\r\nConnection: close\r\nVary: Accept-Encoding\r\nStrict-Transport-Security: max-age=31536000 ; includeSubDomains\r\nX-Frame-Options: SAMEORIGIN\r\n\r\nRequest headers\n================\nHEAD /sevis HTTP/1.1\r\nHost: www.ice.gov\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://dualdiploma.org\r\nConnection: close\r\n\r\n\nLe lien est valide.","200","","","0.202367","0","0","0","1","0","200|0|0|https://www.ice.gov/sevis","0","0");

INSERT IGNORE INTO `da_blc_links` VALUES 
("633","https://fr.usembassy.gov/fr/visas-fr/","0000-00-00 00:00:00","2026-01-31 17:38:20","2026-01-31 17:38:20","2026-01-31 17:38:20","0","https://fr.usembassy.gov/fr/visas-fr/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ncontent-type: text/html\r\ncontent-length: 188865\r\ndate: Sat, 31 Jan 2026 17:38:21 GMT\r\nlast-modified: Sun, 12 Jan 2025 16:04:29 GMT\r\netag: &quot;73d4060dd1985e086d76de36e128abc5&quot;\r\nx-amz-server-side-encryption: AES256\r\nx-amz-version-id: yxLqt_9k1MYenl8PRGxYlraZKbTF0i0G\r\naccept-ranges: bytes\r\nserver: AmazonS3\r\nx-cache: Error from cloudfront\r\nvia: 1.1 60c3e06bb21aa996755639a990cd71da.cloudfront.net (CloudFront)\r\nx-amz-cf-pop: LHR5-P4\r\nx-amz-cf-id: oIkDoq_gQSFJA_-afJbaM-MX8ySvA2OaBHb45prZOdU3GSdVyAX-RA==\r\n\r\nRequest headers\n================\nHEAD /fr/visas-fr/ HTTP/2\r\nHost: fr.usembassy.gov\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.330628","0","0","0","1","0","200|0|0|https://fr.usembassy.gov/fr/visas-fr/","0","0"),
("634","https://dualdiploma.org/wp-content/uploads/2025/08/image-800x533.jpeg","0000-00-00 00:00:00","2026-01-31 17:38:20","2026-01-31 17:38:20","2026-01-31 17:38:20","0","https://dualdiploma.org/wp-content/uploads/2025/08/image-800x533.jpeg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 17:38:20 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 50248\r\nlast-modified: Mon, 25 Aug 2025 08:47:09 GMT\r\netag: &quot;68ac230d-c448&quot;\r\nexpires: Mon, 02 Mar 2026 17:38:20 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/08/image-800x533.jpeg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.023217","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/08/image-800x533.jpeg","0","0"),
("635","https://lh7-rt.googleusercontent.com/docsz/AD_4nXe3Rvc8j4mOSOWZWQAEWCE4gANFKKtKmTWtPPqOKdRmCTI-Uly8gY5VBsRXvK9Ya6KCCxFqyGjgKbSSx1Xr1_VRwePs42-7FB4qBOcP0LOlTHP2QvFRJkm5kwGbLllaXA0B842A?key=PWhMsYmAQYQ2m49QYM8tHHiz","0000-00-00 00:00:00","2026-01-31 17:28:17","2026-01-31 17:28:17","2026-01-31 17:28:17","0","https://lh7-rt.googleusercontent.com/docsz/AD_4nXe3Rvc8j4mOSOWZWQAEWCE4gANFKKtKmTWtPPqOKdRmCTI-Uly8gY5VBsRXvK9Ya6KCCxFqyGjgKbSSx1Xr1_VRwePs42-7FB4qBOcP0LOlTHP2QvFRJkm5kwGbLllaXA0B842A?key=PWhMsYmAQYQ2m49QYM8tHHiz","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ncontent-type: image/jpeg\r\ncross-origin-resource-policy: cross-origin\r\nvary: Origin\r\naccess-control-expose-headers: Content-Length\r\netag: &quot;v0&quot;\r\nexpires: Fri, 01 Jan 1990 00:00:00 GMT\r\ncache-control: private, max-age=86400, no-transform\r\ncontent-disposition: inline;filename=&quot;unnamed.jpg&quot;\r\nx-content-type-options: nosniff\r\ndate: Sat, 31 Jan 2026 17:28:17 GMT\r\nserver: fife\r\ncontent-length: 573100\r\nx-xss-protection: 0\r\nalt-svc: h3=&quot;:443&quot;; ma=2592000,h3-29=&quot;:443&quot;; ma=2592000\r\n\r\nRequest headers\n================\nHEAD /docsz/AD_4nXe3Rvc8j4mOSOWZWQAEWCE4gANFKKtKmTWtPPqOKdRmCTI-Uly8gY5VBsRXvK9Ya6KCCxFqyGjgKbSSx1Xr1_VRwePs42-7FB4qBOcP0LOlTHP2QvFRJkm5kwGbLllaXA0B842A?key=PWhMsYmAQYQ2m49QYM8tHHiz HTTP/2\r\nHost: lh7-rt.googleusercontent.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.505594","0","0","0","1","0","200|0|0|https://lh7-rt.googleusercontent.com/docsz/AD_4nXe3Rvc8j4mOSOWZWQAEWCE4gANFKKtKmTWtPPqOKdRmCTI-Uly8gY5VBsRXvK9Ya6KCCxFqyGjgKbSSx1Xr1_VRwePs42-7FB4qBOcP0LOlTHP2QvFRJkm5kwGbLllaXA0B842A","0","0"),
("636","https://dualdiploma.org/wp-content/uploads/2025/09/unnamed.jpg","0000-00-00 00:00:00","2026-01-31 18:28:52","2026-01-31 18:28:52","2026-01-31 18:28:52","0","https://dualdiploma.org/wp-content/uploads/2025/09/unnamed.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 18:28:54 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 973485\r\nlast-modified: Wed, 03 Sep 2025 14:04:12 GMT\r\netag: &quot;68b84adc-edaad&quot;\r\nexpires: Mon, 02 Mar 2026 18:28:54 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/09/unnamed.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.041977","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/09/unnamed.jpg","0","0"),
("637","https://dualdiploma.org/wp-content/uploads/2025/09/Master-Calendar-Dual-Diploma-2025-2026.pdf","0000-00-00 00:00:00","2026-02-01 17:28:47","2026-02-01 17:28:47","2026-02-01 17:28:47","0","https://dualdiploma.org/wp-content/uploads/2025/09/Master-Calendar-Dual-Diploma-2025-2026.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 17:28:47 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 158204\r\nlast-modified: Thu, 04 Sep 2025 13:38:38 GMT\r\netag: &quot;68b9965e-269fc&quot;\r\nexpires: Tue, 03 Mar 2026 17:28:47 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/09/Master-Calendar-Dual-Diploma-2025-2026.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.145733","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/09/Master-Calendar-Dual-Diploma-2025-2026.pdf","0","0"),
("638","https://dualdiploma.org/wp-content/uploads/2025/09/Kit-Program-Director_25-26_compressed.pdf","0000-00-00 00:00:00","2026-02-01 17:28:51","2026-02-01 17:28:51","2026-02-01 17:28:51","0","https://dualdiploma.org/wp-content/uploads/2025/09/Kit-Program-Director_25-26_compressed.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 17:28:53 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 3215537\r\nlast-modified: Thu, 04 Sep 2025 13:46:15 GMT\r\netag: &quot;68b99827-3110b1&quot;\r\nexpires: Tue, 03 Mar 2026 17:28:53 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/09/Kit-Program-Director_25-26_compressed.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.139547","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/09/Kit-Program-Director_25-26_compressed.pdf","0","0"),
("639","https://dualdiploma.org/wp-content/uploads/2025/09/AIS-Program-Director-Handbook-2025-2026.pdf","0000-00-00 00:00:00","2026-02-01 17:28:49","2026-02-01 17:28:49","2026-02-01 17:28:49","0","https://dualdiploma.org/wp-content/uploads/2025/09/AIS-Program-Director-Handbook-2025-2026.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 17:28:51 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 794845\r\nlast-modified: Thu, 04 Sep 2025 13:38:02 GMT\r\netag: &quot;68b9963a-c20dd&quot;\r\nexpires: Tue, 03 Mar 2026 17:28:51 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/09/AIS-Program-Director-Handbook-2025-2026.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.025881","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/09/AIS-Program-Director-Handbook-2025-2026.pdf","0","0"),
("640","https://dualdiploma.org/wp-content/uploads/2025/09/Formulaire-de-desistement-2025-2026.pdf","0000-00-00 00:00:00","2026-02-01 17:28:47","2026-02-01 17:28:47","2026-02-01 17:28:47","0","https://dualdiploma.org/wp-content/uploads/2025/09/Formulaire-de-desistement-2025-2026.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 17:28:49 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 158650\r\nlast-modified: Thu, 04 Sep 2025 13:56:34 GMT\r\netag: &quot;68b99a92-26bba&quot;\r\nexpires: Tue, 03 Mar 2026 17:28:49 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/09/Formulaire-de-desistement-2025-2026.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.040647","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/09/Formulaire-de-desistement-2025-2026.pdf","0","0"),
("642","https://dualdiploma.org/wp-content/uploads/2025/08/image-1-800x533.jpeg","0000-00-00 00:00:00","2026-02-02 13:48:41","2026-02-02 13:48:41","2026-02-02 13:48:41","0","https://dualdiploma.org/wp-content/uploads/2025/08/image-1-800x533.jpeg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 13:48:46 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 36688\r\nlast-modified: Mon, 25 Aug 2025 09:01:12 GMT\r\netag: &quot;68ac2658-8f50&quot;\r\nexpires: Wed, 04 Mar 2026 13:48:46 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/08/image-1-800x533.jpeg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.025804","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/08/image-1-800x533.jpeg","0","0"),
("643","https://dualdiploma.org/wp-content/uploads/2025/08/image-2-800x533.jpeg","0000-00-00 00:00:00","2026-02-02 13:48:31","2026-02-02 13:48:31","2026-02-02 13:48:31","0","https://dualdiploma.org/wp-content/uploads/2025/08/image-2-800x533.jpeg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 13:48:31 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 35162\r\nlast-modified: Mon, 25 Aug 2025 09:02:25 GMT\r\netag: &quot;68ac26a1-895a&quot;\r\nexpires: Wed, 04 Mar 2026 13:48:31 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/08/image-2-800x533.jpeg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.044402","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/08/image-2-800x533.jpeg","0","0"),
("644","https://dualdiploma.org/wp-content/uploads/2025/09/AD_4nXdKWNp58_k1nYFL-YKNm4EYl8VmqQTJbyQYyhveBo8Ug3Wyc7wFJvvXFEbEI-9SzIW14EGIxXq_ngwb9QcgyH9VbaJQPXU4Lik2UwlGpM6wJaOGQOdfJfvpCXH-rznezzb021oHqQ.jpg","0000-00-00 00:00:00","2026-02-02 13:48:35","2026-02-02 13:48:35","2026-02-02 13:48:35","0","https://dualdiploma.org/wp-content/uploads/2025/09/AD_4nXdKWNp58_k1nYFL-YKNm4EYl8VmqQTJbyQYyhveBo8Ug3Wyc7wFJvvXFEbEI-9SzIW14EGIxXq_ngwb9QcgyH9VbaJQPXU4Lik2UwlGpM6wJaOGQOdfJfvpCXH-rznezzb021oHqQ.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 13:48:37 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 78586\r\nlast-modified: Mon, 08 Sep 2025 09:41:16 GMT\r\netag: &quot;68bea4bc-132fa&quot;\r\nexpires: Wed, 04 Mar 2026 13:48:37 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/09/AD_4nXdKWNp58_k1nYFL-YKNm4EYl8VmqQTJbyQYyhveBo8Ug3Wyc7wFJvvXFEbEI-9SzIW14EGIxXq_ngwb9QcgyH9VbaJQPXU4Lik2UwlGpM6wJaOGQOdfJfvpCXH-rznezzb021oHqQ.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.03372","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/09/AD_4nXdKWNp58_k1nYFL-YKNm4EYl8VmqQTJbyQYyhveBo8Ug3Wyc7wFJvvXFEbEI-9SzIW14EGIxXq_ngwb9QcgyH9VbaJQPXU4Lik2UwlGpM6wJaOGQOdfJfvpCXH-rznezzb021oHq","0","0"),
("645","https://dualdiploma.org/wp-content/uploads/2025/09/AD_4nXfGObTYW6eH_fXPIjAl7m_P40c4NG4g9fCzx9DRESGpV0pPqYwk9vHg2-LI2xP_DfKMfXQLtPJhowuNyGpVk0JfyWou3_gSfr0H-bNepn5FbygRoD7qUHuxXRIDtVP3NR6u0cyPIw.png","0000-00-00 00:00:00","2026-02-02 13:48:46","2026-02-02 13:48:46","2026-02-02 13:48:46","0","https://dualdiploma.org/wp-content/uploads/2025/09/AD_4nXfGObTYW6eH_fXPIjAl7m_P40c4NG4g9fCzx9DRESGpV0pPqYwk9vHg2-LI2xP_DfKMfXQLtPJhowuNyGpVk0JfyWou3_gSfr0H-bNepn5FbygRoD7qUHuxXRIDtVP3NR6u0cyPIw.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 13:48:51 GMT\r\ncontent-type: image/png\r\ncontent-length: 242640\r\nlast-modified: Mon, 08 Sep 2025 09:41:16 GMT\r\netag: &quot;68bea4bc-3b3d0&quot;\r\nexpires: Wed, 04 Mar 2026 13:48:51 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/09/AD_4nXfGObTYW6eH_fXPIjAl7m_P40c4NG4g9fCzx9DRESGpV0pPqYwk9vHg2-LI2xP_DfKMfXQLtPJhowuNyGpVk0JfyWou3_gSfr0H-bNepn5FbygRoD7qUHuxXRIDtVP3NR6u0cyPIw.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.026738","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/09/AD_4nXfGObTYW6eH_fXPIjAl7m_P40c4NG4g9fCzx9DRESGpV0pPqYwk9vHg2-LI2xP_DfKMfXQLtPJhowuNyGpVk0JfyWou3_gSfr0H-bNepn5FbygRoD7qUHuxXRIDtVP3NR6u0cyPI","0","0"),
("646","https://dualdiploma.org/wp-content/uploads/2025/08/image-3-800x434.jpeg","0000-00-00 00:00:00","2026-02-02 13:48:37","2026-02-02 13:48:37","2026-02-02 13:48:37","0","https://dualdiploma.org/wp-content/uploads/2025/08/image-3-800x434.jpeg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 13:48:41 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 34236\r\nlast-modified: Mon, 25 Aug 2025 09:04:35 GMT\r\netag: &quot;68ac2723-85bc&quot;\r\nexpires: Wed, 04 Mar 2026 13:48:41 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/08/image-3-800x434.jpeg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.026346","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/08/image-3-800x434.jpeg","0","0"),
("647","https://dualdiploma.org/wp-content/uploads/2025/09/ARTICLE-LINKEDIN-CV-1-800x800.png","0000-00-00 00:00:00","2026-02-02 16:38:30","2026-02-02 16:38:30","2026-02-02 16:38:30","0","https://dualdiploma.org/wp-content/uploads/2025/09/ARTICLE-LINKEDIN-CV-1-800x800.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 16:38:33 GMT\r\ncontent-type: image/png\r\ncontent-length: 608365\r\nlast-modified: Mon, 08 Sep 2025 12:20:32 GMT\r\netag: &quot;68beca10-9486d&quot;\r\nexpires: Wed, 04 Mar 2026 16:38:33 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/09/ARTICLE-LINKEDIN-CV-1-800x800.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024371","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/09/ARTICLE-LINKEDIN-CV-1-800x800.png","0","0"),
("649","https://dualdiploma.org/irregular-verbs-trainer/","0000-00-00 00:00:00","2026-02-01 20:38:18","2026-02-01 20:38:18","2026-02-01 20:38:18","0","https://dualdiploma.org/irregular-verbs-trainer/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 20:38:20 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nvary: Accept-Encoding\r\nlink: &lt;https://dualdiploma.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nlink: &lt;https://dualdiploma.org/wp-json/wp/v2/pages/843670&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nlink: &lt;https://dualdiploma.org/?p=843670&gt;; rel=shortlink\r\nx-frame-options: SAMEORIGIN\r\nx-content-type-options: nosniff\r\nx-xss-protection: 1; mode=block\r\nstrict-transport-security: max-age=15552001; includeSubdomains; preload\r\ncontent-encoding: gzip\r\n\r\nRequest headers\n================\nHEAD /irregular-verbs-trainer/ HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.199335","0","0","0","1","0","200|0|0|https://dualdiploma.org/irregular-verbs-trainer/","0","0"),
("650","https://dualdiploma.org/wp-content/uploads/2025/08/image-800x533.png","0000-00-00 00:00:00","2026-02-01 20:38:18","2026-02-01 20:38:18","2026-02-01 20:38:18","0","https://dualdiploma.org/wp-content/uploads/2025/08/image-800x533.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 20:38:18 GMT\r\ncontent-type: image/png\r\ncontent-length: 228007\r\nlast-modified: Mon, 25 Aug 2025 08:40:48 GMT\r\netag: &quot;68ac2190-37aa7&quot;\r\nexpires: Tue, 03 Mar 2026 20:38:18 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/08/image-800x533.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.131128","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/08/image-800x533.png","0","0"),
("651","https://dualdiploma.org/wp-content/uploads/2025/08/image-1-800x533.png","0000-00-00 00:00:00","2026-02-01 20:38:20","2026-02-01 20:38:20","2026-02-01 20:38:20","0","https://dualdiploma.org/wp-content/uploads/2025/08/image-1-800x533.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 20:38:22 GMT\r\ncontent-type: image/png\r\ncontent-length: 206268\r\nlast-modified: Mon, 25 Aug 2025 08:45:23 GMT\r\netag: &quot;68ac22a3-325bc&quot;\r\nexpires: Tue, 03 Mar 2026 20:38:22 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/08/image-1-800x533.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02027","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/08/image-1-800x533.png","0","0"),
("652","https://dualdiploma.org/wp-content/uploads/2025/09/Memo-de-rentree-Program-Director-25-26.pdf","0000-00-00 00:00:00","2026-02-01 14:28:13","2026-02-01 14:28:13","2026-02-01 14:28:13","0","https://dualdiploma.org/wp-content/uploads/2025/09/Memo-de-rentree-Program-Director-25-26.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 14:28:13 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 330566\r\nlast-modified: Mon, 22 Sep 2025 09:48:21 GMT\r\netag: &quot;68d11b65-50b46&quot;\r\nexpires: Tue, 03 Mar 2026 14:28:13 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/09/Memo-de-rentree-Program-Director-25-26.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.024448","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/09/Memo-de-rentree-Program-Director-25-26.pdf","0","0"),
("654","https://dualdiploma.org/wp-content/uploads/2025/09/Lien-Webinaire-de-rentree-25-26-USA.pdf","0000-00-00 00:00:00","2026-02-01 12:48:25","2026-02-01 12:48:25","2026-02-01 12:48:25","0","https://dualdiploma.org/wp-content/uploads/2025/09/Lien-Webinaire-de-rentree-25-26-USA.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 12:48:29 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 116905\r\nlast-modified: Thu, 25 Sep 2025 07:56:28 GMT\r\netag: &quot;68d4f5ac-1c8a9&quot;\r\nexpires: Tue, 03 Mar 2026 12:48:29 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/09/Lien-Webinaire-de-rentree-25-26-USA.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.037032","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/09/Lien-Webinaire-de-rentree-25-26-USA.pdf","0","0"),
("656","https://www.mlfmonde.org/","0000-00-00 00:00:00","2026-02-01 12:48:17","2026-02-01 12:48:17","2026-02-01 12:48:17","0","https://www.mlfmonde.org/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ncache-control: no-store, no-cache, must-revalidate\r\ncontent-encoding: gzip\r\ncontent-type: text/html; charset=UTF-8\r\ndate: Sun, 01 Feb 2026 12:48:18 GMT\r\nexpires: Thu, 19 Nov 1981 08:52:00 GMT\r\nlink: &lt;https://www.mlfmonde.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\npragma: no-cache\r\nreferrer-policy: same-origin\r\nserver: nginx\r\nset-cookie: PHPSESSID=6152d84c68e76b7bb0ea4c1261a8a2fe; path=/\r\nstrict-transport-security: max-age=31536000; includeSubDomains; preload\r\nvary: Accept-Encoding,Origin\r\nx-content-type-options: nosniff\r\nx-download-options: noopen\r\nx-frame-options: sameorigin\r\nx-permitted-cross-domain-policies: none\r\nx-xss-protection: 1; mode=block\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: www.mlfmonde.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.978825","0","0","0","1","0","200|0|0|https://www.mlfmonde.org/","0","0"),
("657","https://www.mlfmonde.org","0000-00-00 00:00:00","2026-02-01 12:48:23","2026-02-01 12:48:23","2026-02-01 12:48:23","0","https://www.mlfmonde.org/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ncache-control: no-store, no-cache, must-revalidate\r\ncontent-encoding: gzip\r\ncontent-type: text/html; charset=UTF-8\r\ndate: Sun, 01 Feb 2026 12:48:23 GMT\r\nexpires: Thu, 19 Nov 1981 08:52:00 GMT\r\nlink: &lt;https://www.mlfmonde.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\npragma: no-cache\r\nreferrer-policy: same-origin\r\nserver: nginx\r\nset-cookie: PHPSESSID=693c1206b4302e9a36f399164e264419; path=/\r\nstrict-transport-security: max-age=31536000; includeSubDomains; preload\r\nvary: Accept-Encoding,Origin\r\nx-content-type-options: nosniff\r\nx-download-options: noopen\r\nx-frame-options: sameorigin\r\nx-permitted-cross-domain-policies: none\r\nx-xss-protection: 1; mode=block\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: www.mlfmonde.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.67452","0","0","0","1","0","200|0|0|https://www.mlfmonde.org/","0","0"),
("658","https://dualdiploma.org/wp-content/uploads/2025/09/IMG_4358-800x504.jpg","0000-00-00 00:00:00","2026-02-01 12:48:23","2026-02-01 12:48:23","2026-02-01 12:48:23","0","https://dualdiploma.org/wp-content/uploads/2025/09/IMG_4358-800x504.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 12:48:25 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 67878\r\nlast-modified: Tue, 23 Sep 2025 14:37:33 GMT\r\netag: &quot;68d2b0ad-10926&quot;\r\nexpires: Tue, 03 Mar 2026 12:48:25 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/09/IMG_4358-800x504.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.035938","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/09/IMG_4358-800x504.jpg","0","0"),
("659","https://dualdiploma.org/wp-content/uploads/2025/09/IMG_2051-800x448.jpg","0000-00-00 00:00:00","2026-02-01 12:48:19","2026-02-01 12:48:19","2026-02-01 12:48:19","0","https://dualdiploma.org/wp-content/uploads/2025/09/IMG_2051-800x448.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 12:48:19 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 48550\r\nlast-modified: Tue, 23 Sep 2025 14:52:59 GMT\r\netag: &quot;68d2b44b-bda6&quot;\r\nexpires: Tue, 03 Mar 2026 12:48:19 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/09/IMG_2051-800x448.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.056149","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/09/IMG_2051-800x448.jpg","0","0"),
("660","https://dualdiploma.org/wp-content/uploads/2025/09/Dual-Diploma-4-800x1200.png","0000-00-00 00:00:00","2026-02-01 12:48:19","2026-02-01 12:48:19","2026-02-01 12:48:19","0","https://dualdiploma.org/wp-content/uploads/2025/09/Dual-Diploma-4-800x1200.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 12:48:21 GMT\r\ncontent-type: image/png\r\ncontent-length: 996466\r\nlast-modified: Tue, 23 Sep 2025 14:54:42 GMT\r\netag: &quot;68d2b4b2-f3472&quot;\r\nexpires: Tue, 03 Mar 2026 12:48:21 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/09/Dual-Diploma-4-800x1200.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.03638","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/09/Dual-Diploma-4-800x1200.png","0","0"),
("662","https://www.service-public.fr/particuliers/vosdroits/F34739","0000-00-00 00:00:00","2026-01-31 17:38:24","2026-01-31 17:38:24","2026-01-31 17:38:24","0","https://www.service-public.fr/particuliers/vosdroits/F34739","1","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 301 ===\n\nResponse headers\n================\nHTTP/1.1 301 Moved Permanently\r\nDate: Sat, 31 Jan 2026 17:38:24 GMT\r\nContent-Type: text/html\r\nContent-Length: 162\r\nConnection: close\r\nLocation: https://www.service-public.gouv.fr/particuliers/vosdroits/F34739\r\nSet-Cookie: TS012e9d3d=012a7f58e0a74a0f39e610d41eecb26d6ecc680e3b78a9bbea79faa7e77522ec00da7283c314e34183c911ffbbd4c35a2b0138de21; Path=/; Domain=.www.service-public.fr; Secure; HttpOnly\r\n\r\nRequest headers\n================\nHEAD /particuliers/vosdroits/F34739 HTTP/1.1\r\nHost: www.service-public.fr\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://dualdiploma.org\r\nConnection: close\r\n\r\n\nLe lien est valide.","301","","","0.121254","0","0","0","1","0","301|0|0|https://www.service-public.fr/particuliers/vosdroits/F34739","0","0"),
("663","https://www.etsglobal.org/mq/fr/test-type-family/test-toefl-ibt","0000-00-00 00:00:00","2026-01-31 17:28:19","2026-01-31 17:28:19","2026-01-31 17:28:19","0","https://www.etsglobal.org/mq/fr/test-type-family/test-toefl-ibt","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\naccept-ranges: bytes\r\nage: 78562\r\ncache-control: public, s-maxage=1814400\r\ncontent-encoding: gzip\r\ncontent-language: fr\r\ncontent-security-policy: form-action &#039;none&#039;; frame-ancestors &#039;none&#039;; worker-src &#039;self&#039;\r\ncontent-type: text/html; charset=utf-8\r\ndate: Fri, 30 Jan 2026 19:38:56 GMT\r\netag: W/&quot;72680-zHVgJlYBNEQm49ZoKU5qSqTqLtk&quot;\r\nserver: nginx/1.24.0 (Ubuntu)\r\nstrict-transport-security: max-age=63072000; includeSubDomains; preload\r\nvary: Accept-Encoding, Accept-Encoding\r\nvia: 1.1 varnish (Varnish/7.1)\r\nx-cache: hit cached\r\nx-content-type-options: nosniff\r\nx-frame-options: DENY\r\nx-powered-by: Express\r\nx-varnish: 22446602 2950751\r\ncontent-length: 83709\r\n\r\nRequest headers\n================\nHEAD /mq/fr/test-type-family/test-toefl-ibt HTTP/2\r\nHost: www.etsglobal.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.073977","0","0","0","1","0","200|0|0|https://www.etsglobal.org/mq/fr/test-type-family/test-toefl-ibt","0","0"),
("664","https://ielts.org/","0000-00-00 00:00:00","2026-01-31 17:18:41","2026-01-31 17:18:41","2026-01-31 17:18:41","0","https://ielts.org/","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Sat, 31 Jan 2026 17:18:41 GMT\r\ncontent-type: text/html; charset=UTF-8\r\ncf-ray: 9c6adea34927301f-CDG\r\ncf-cache-status: HIT\r\nage: 545\r\ncache-control: max-age=600, stale-while-revalidate=30, stale-if-error=86400\r\nexpires: Sat, 31 Jan 2026 17:19:36 GMT\r\nlast-modified: Sat, 31 Jan 2026 17:09:36 GMT\r\nlink: &lt;https://ielts.org/&gt;; rel=&#039;canonical&#039;\r\nserver: cloudflare\r\nstrict-transport-security: max-age=15552000; includeSubDomains\r\nvary: Accept-Encoding, X-Requested-With\r\nvia: id=48d53dd8;timestamp=2026-01-28T17:35:19.284051Z gateway\r\nserver-timing: esi;dur=24.0;desc=&quot;9c6adea362d61388-CDG&quot;,fetch;dur=24.0,total;dur=28.0\r\nx-amzn-trace-id: Root=1-697e374f-2e055d14038e56867bb8acb0;Parent=4b493916835ce532;Sampled=0;Lineage=1:271c3e7a:0\r\ncdn-cache-control: max-age=600, stale-while-revalidate=30, stale-if-error=86400\r\ncontent-security-policy-report-only: default-src &#039;self&#039; https://d3q9kdqrtloda.cloudfront.net/ https://i.ytimg.com/ https://www.youtube-nocookie.com/ https://noembed.com/ https://cdn.plyr.io/ https://cdn-ukwest.onetrust.com/ https://geolocation.onetrust.com/ https://www.google.com/ https://googleads.g.doubleclick.net/ https://www.google-analytics.com/ https://stats.g.doubleclick.net/ https://px.ads.linkedin.com/ https://api.hubapi.com/ https://cta-service-cms2.hubspot.com/ https://c1001.report.gbss.io/ https://analytics.tiktok.com/ https://forms.hubspot.com/ https://region1.analytics.google.com/ https://*.analytics.google.com/ https://region1.google-analytics.com/ https://*.google-analytics.com/ https://pagead2.googlesyndication.com https://privacyportal-uk.onetrust.com/ https://*.onetrust.com/ https://cambridgeenglish.formstack.com/forms/ieltstrf https://cambridgeenglish.formstack.com/forms/ielts_recognising_organisation https://cambridgeenglish.formstack.com/; style-src &#039;self&#039; &#039;unsafe-inline&#039; https://static.formstack.com/forms/css/ https://static.formstack.com/common/css/ https://cdn.craft.cloud; script-src &#039;self&#039; https://www.youtube.com/ https://cambridgeenglish.formstack.com/forms/ &#039;sha256-5woGd/mZkUg7jRI9rPBZPHKC+LdyheFkTyKDMVNRNAs=&#039; https://static.hotjar.com/c/ https://static.formstack.com/forms/js/ &#039;sha256-BEia3zQX2ZCFqcEfWBg9chT7nMc26YOr506FmhGqIfE=&#039; &#039;sha256-z+rMOYNYmUbRI0OKIZH9HZneWmS3dJkEIDLisI+5LwI=&#039; &#039;sha256-4QifgdTNZlur9Y/OOGOV3SggRLnQQR4peyehG9Y5buo=&#039; https://www.google.com/ https://www.gstatic.com/ https://cdn-ukwest.onetrust.com/ https://www.googletagmanager.com/ &#039;sha256-rbMVlXlWb1FxlmTxqO6hQI+5VPCMoqHMqeyWMrzk9E4=&#039; &#039;sha256-IgMQOOOedQeMPBl7lSreMVPmJvU62bc6l8HcsGXnbWc=&#039; &#039;sha256-/6m2tVE+3ZAyrBnUps+rDpHpCwMi0VgW9mdVym2y2cE=&#039; &#039;sha256-nanbr0ZSJrOvEvr6c5gV8UarYfjNXF+TAtmA9GjvyJ0=&#039; &#039;sha256-ATpn7Ex50rRSNqmoA432bWfqvlsGB6CD/7fE2WtoU5A=&#039; &#039;sha256-iXVjrS+TzaVqRdjZV8gecO6OkuAcobYu2OjiJVT8LYU=&#039; &#039;sha256-+WTu64J4HVaiLZC0nSjR9XxbZZg1xX7cdNM/WA/pDcQ=&#039; &#039;sha256-tOY0R/wVWZCxGQPtXP0ptphYuCKkCpgNHQy/ZkwhCCY=&#039; &#039;sha256-xc61KVzUrz5aO4ACQyRqjH2fPpfIb/xoMmSSEiU+PWU=&#039; &#039;sha256-wyNlDF2abbsDx6TZogcKckBQwZ4N8qFR3SAepboU7Sk=&#039; &#039;sha256-tOY0R/wVWZCxGQPtXP0ptphYuCKkCpgNHQy/ZkwhCCY=&#039; blob: &#039;unsafe-eval&#039; https://www.google-analytics.com/ https://snap.licdn.com/ https://googleads.g.doubleclick.net/ https://static.ads-twitter.com https://www.googleadservices.com/ https://connect.facebook.net/ https://a.quora.com/ https://js.hs-scripts.com/ https://analytics.tiktok.com/ https://cdn.gbqofs.com/ https://cl.qualaroo.com/ https://assets.ubembed.com/ https://js.hs-analytics.net/ https://js.hsadspixel.net/ https://js.hsleadflows.net/ https://js.hs-banner.com/ https://js.hubspot.com/ https://cdn.gbqofs.com/ https://analytics.tiktok.com/ https://cdn.gbqofs.com/ https://snap.licdn.com/ https://14d7fb0767d540569b202283222297c0.js.ubembed.com/ &#039;sha256-1e5RR2OpHhuX2h0Bat19DsNTmqbo4M3T1pqfeTXCHaA=&#039;; object-src &#039;none&#039;; font-src &#039;self&#039; https://static.formstack.com/forms/fonts/; img-src &#039;self&#039; data: https://d3q9kdqrtloda.cloudfront.net/ https://s3.eu-west-2.amazonaws.com/ielts-web-static/ www.googletagmanager.com https://i.ytimg.com/ https://cdn-ukwest.onetrust.com/ https://ad.doubleclick.net/ https://px.ads.linkedin.com/ https://googleads.g.doubleclick.net/ https://www.google.com/ https://t.co https://analytics.twitter.com/ https://www.facebook.com/ https://q.quora.com/ https://adservice.google.com/ https://perf-na1.hsforms.com/ https://*.google.ad/ https://*.google.ae/ https://*.google.com.af/ https://*.google.com.ag/ https://*.google.al/ https://*.google.am/ https://*.google.co.ao/ https://*.google.com.ar/ https://*.google.as/ https://*.google.at/ https://*.google.com.au/ https://*.google.az/ https://*.google.ba/ https://*.google.com.bd/ https://*.google.be/ https://*.google.bf/ https://*.google.bg/ https://*.google.com.bh/ https://*.google.bi/ https://*.google.bj/ https://*.google.com.bn/ https://*.google.com.bo/ https://*.google.com.br/ https://*.google.bs/ https://*.google.bt/ https://*.google.co.bw/ https://*.google.by/ https://*.google.com.bz/ https://*.google.ca/ https://*.google.cd/ https://*.google.cf/ https://*.google.cg/ https://*.google.ch/ https://*.google.ci/ https://*.google.co.ck/ https://*.google.cl/ https://*.google.cm/ https://*.google.cn/ https://*.google.com.co/ https://*.google.co.cr/ https://*.google.com.cu/ https://*.google.cv/ https://*.google.com.cy/ https://*.google.cz/ https://*.google.de/ https://*.google.dj/ https://*.google.dk/ https://*.google.dm/ https://*.google.com.do/ https://*.google.dz/ https://*.google.com.ec/ https://*.google.ee/ https://*.google.com.eg/ https://*.google.es/ https://*.google.com.et/ https://*.google.fi/ https://*.google.com.fj/ https://*.google.fm/ https://*.google.fr/ https://*.google.ga/ https://*.google.ge/ https://*.google.gg/ https://*.google.com.gh/ https://*.google.com.gi/ https://*.google.gl/ https://*.google.gm/ https://*.google.gr/ https://*.google.com.gt/ https://*.google.gy/ https://*.google.com.hk/ https://*.google.hn/ https://*.google.hr/ https://*.google.ht/ https://*.google.hu/ https://*.google.co.id/ https://*.google.ie/ https://*.google.co.il/ https://*.google.im/ https://*.google.co.in/ https://*.google.iq/ https://*.google.is/ https://*.google.it/ https://*.google.je/ https://*.google.com.jm/ https://*.google.jo/ https://*.google.co.jp/ https://*.google.co.ke/ https://*.google.com.kh/ https://*.google.ki/ https://*.google.kg/ https://*.google.co.kr/ https://*.google.com.kw/ https://*.google.kz/ https://*.google.la/ https://*.google.com.lb/ https://*.google.li/ https://*.google.lk/ https://*.google.co.ls/ https://*.google.lt/ https://*.google.lu/ https://*.google.lv/ https://*.google.com.ly/ https://*.google.co.ma/ https://*.google.md/ https://*.google.me/ https://*.google.mg/ https://*.google.mk/ https://*.google.ml/ https://*.google.com.mm/ https://*.google.mn/ https://*.google.com.mt/ https://*.google.mu/ https://*.google.mv/ https://*.google.mw/ https://*.google.com.mx/ https://*.google.com.my/ https://*.google.co.mz/ https://*.google.com.na/ https://*.google.com.ng/ https://*.google.com.ni/ https://*.google.ne/ https://*.google.nl/ https://*.google.no/ https://*.google.com.np/ https://*.google.nr/ https://*.google.nu/ https://*.google.co.nz/ https://*.google.com.om/ https://*.google.com.pa/ https://*.google.com.pe/ https://*.google.com.pg/ https://*.google.com.ph/ https://*.google.com.pk/ https://*.google.pl/ https://*.google.pn/ https://*.google.com.pr/ https://*.google.ps/ https://*.google.pt/ https://*.google.com.py/ https://*.google.com.qa/ https://*.google.ro/ https://*.google.ru/ https://*.google.rw/ https://*.google.com.sa/ https://*.google.com.sb/ https://*.google.sc/ https://*.google.se/ https://*.google.com.sg/ https://*.google.sh/ https://*.google.si/ https://*.google.sk/ https://*.google.com.sl/ https://*.google.sn/ https://*.google.so/ https://*.google.sm/ https://*.google.sr/ https://*.google.st/ https://*.google.com.sv/ https://*.google.td/ https://*.google.tg/ https://*.google.co.th/ https://*.google.com.tj/ https://*.google.tl/ https://*.google.tm/ https://*.google.tn/ https://*.google.to/ https://*.google.com.tr/ https://*.google.tt/ https://*.google.com.tw/ https://*.google.co.tz/ https://*.google.com.ua/ https://*.google.co.ug/ https://*.google.co.uk/ https://*.google.com.uy/ https://*.google.co.uz/ https://*.google.com.vc/ https://*.google.co.ve/ https://*.google.co.vi/ https://*.google.com.vn/ https://*.google.vu/ https://*.google.ws/ https://*.google.rs/ https://*.google.co.za/ https://*.google.co.zm/ https://*.google.co.zw/ https://*.google.cat/ https://www.google-analytics.com/ https://*.linkedin.com/ https://*.amazonaws.com/ielts-web-static/ https://adservice.google.co.uk/ https://cdn.craft.cloud; frame-src &#039;self&#039; https://www.google.com/ https://www.youtube-nocookie.com/ https://www.youtube.com/ https://dntcl.qualaroo.com/ https://td.doubleclick.net/ https://cambridgeenglish.formstack.com/ https://*.formstack.com https://www.googletagmanager.com/;\r\nreferrer-policy: no-referrer-when-downgrade\r\nx-amzn-requestid: f0c0511a-7484-475f-9e19-eacb2717e2c0\r\nx-content-type-options: nosniff\r\nx-frame-options: DENY\r\nx-permitted-cross-domain-policies: none\r\nx-powered-by: SEOmatic\r\nx-robots-tag: all\r\nset-cookie: __cf_bm=RBf_wbJ.ghpxY5afAzc6GDXpUbc3l73z6G9QCB0Uz88-1769879921.161595-1.0.1.1-zg1nWmA..kLV8bIt1PbWBgn5L83RCZgzuhWPNXEvTpvAOqDmCjCzEZyGcRpYnqEZ5D4eqm7ZhMgPvLnd6LAbV3weaQaTts1K1ghO16V53tDYoyUcpubqiwVqUMkb4V21; HttpOnly; Secure; Path=/; Domain=craft.cloud; Expires=Sat, 31 Jan 2026 17:48:41 GMT\r\ncontent-encoding: br\r\nalt-svc: h3=&quot;:443&quot;; ma=86400\r\n\r\nRequest headers\n================\nHEAD / HTTP/2\r\nHost: ielts.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.105284","0","0","0","1","0","200|0|0|https://ielts.org/","0","0"),
("665","https://www.etsglobal.org/fr/fr","0000-00-00 00:00:00","2026-01-31 17:28:14","2026-01-31 17:28:14","2026-01-31 17:28:14","0","https://www.etsglobal.org/fr/fr","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\naccept-ranges: bytes\r\nage: 91351\r\ncache-control: public, s-maxage=1814400\r\ncontent-encoding: gzip\r\ncontent-language: fr\r\ncontent-security-policy: form-action &#039;none&#039;; frame-ancestors &#039;none&#039;; worker-src &#039;self&#039;\r\ncontent-type: text/html; charset=utf-8\r\ndate: Fri, 30 Jan 2026 16:05:43 GMT\r\netag: W/&quot;67398-a9JPZLXaUGC//l6NTLBY7T+y+bk&quot;\r\nserver: nginx/1.24.0 (Ubuntu)\r\nstrict-transport-security: max-age=63072000; includeSubDomains; preload\r\nvary: Accept-Encoding, Accept-Encoding\r\nvia: 1.1 varnish (Varnish/7.1)\r\nx-cache: hit cached\r\nx-content-type-options: nosniff\r\nx-frame-options: DENY\r\nx-powered-by: Express\r\nx-varnish: 22446595 16\r\ncontent-length: 69994\r\n\r\nRequest headers\n================\nHEAD /fr/fr HTTP/2\r\nHost: www.etsglobal.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.31526","0","0","0","1","0","200|0|0|https://www.etsglobal.org/fr/fr","0","0"),
("666","https://dualdiploma.org/wp-content/uploads/2025/10/image-800x541.png","0000-00-00 00:00:00","2026-01-31 17:28:15","2026-01-31 17:28:15","2026-01-31 17:28:15","0","https://dualdiploma.org/wp-content/uploads/2025/10/image-800x541.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 17:28:15 GMT\r\ncontent-type: image/png\r\ncontent-length: 257820\r\nlast-modified: Mon, 06 Oct 2025 14:28:08 GMT\r\netag: &quot;68e3d1f8-3ef1c&quot;\r\nexpires: Mon, 02 Mar 2026 17:28:15 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/image-800x541.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038673","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/image-800x541.png","0","0"),
("667","https://dualdiploma.org/wp-content/uploads/2025/08/cheerful-young-graphic-designer-lady-using-digital-graphic-tablet-while-working-late-modern-office-night-asia-professional-female-using-laptop-computer-retoucher-sitting-living-room-home-800x450.jpg","0000-00-00 00:00:00","2026-01-31 17:18:41","2026-01-31 17:18:41","2026-01-31 17:18:41","0","https://dualdiploma.org/wp-content/uploads/2025/08/cheerful-young-graphic-designer-lady-using-digital-graphic-tablet-while-working-late-modern-office-night-asia-professional-female-using-laptop-computer-retoucher-sitting-living-room-home-800x450.jpg","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 17:18:45 GMT\r\ncontent-type: image/jpeg\r\ncontent-length: 74625\r\nlast-modified: Mon, 25 Aug 2025 07:47:40 GMT\r\netag: &quot;68ac151c-12381&quot;\r\nexpires: Mon, 02 Mar 2026 17:18:45 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/08/cheerful-young-graphic-designer-lady-using-digital-graphic-tablet-while-working-late-modern-office-night-asia-professional-female-using-laptop-computer-retoucher-sitting-living-room-home-800x450.jpg HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.04848","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/08/cheerful-young-graphic-designer-lady-using-digital-graphic-tablet-while-working-late-modern-office-night-asia-professional-female-using-lapto","0","0"),
("668","https://dualdiploma.org/wp-content/uploads/2025/10/image-1-800x534.png","0000-00-00 00:00:00","2026-01-31 17:38:22","2026-01-31 17:38:22","2026-01-31 17:38:22","0","https://dualdiploma.org/wp-content/uploads/2025/10/image-1-800x534.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 17:38:24 GMT\r\ncontent-type: image/png\r\ncontent-length: 284000\r\nlast-modified: Mon, 06 Oct 2025 14:30:05 GMT\r\netag: &quot;68e3d26d-45560&quot;\r\nexpires: Mon, 02 Mar 2026 17:38:24 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/image-1-800x534.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.038765","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/image-1-800x534.png","0","0"),
("670","https://dualdiploma.org/wp-content/uploads/2025/10/Louis-Vieville-2-4.png","0000-00-00 00:00:00","2026-02-02 13:48:33","2026-02-02 13:48:33","2026-02-02 13:48:33","0","https://dualdiploma.org/wp-content/uploads/2025/10/Louis-Vieville-2-4.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 13:48:35 GMT\r\ncontent-type: image/png\r\ncontent-length: 2121841\r\nlast-modified: Tue, 14 Oct 2025 10:23:40 GMT\r\netag: &quot;68ee24ac-206071&quot;\r\nexpires: Wed, 04 Mar 2026 13:48:35 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/Louis-Vieville-2-4.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.142321","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/Louis-Vieville-2-4.png","0","0"),
("671","https://dualdiploma.org/wp-content/uploads/2025/10/AGUIRAR-Imane-2-2.png","0000-00-00 00:00:00","2026-02-02 13:48:31","2026-02-02 13:48:31","2026-02-02 13:48:31","0","https://dualdiploma.org/wp-content/uploads/2025/10/AGUIRAR-Imane-2-2.png","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Mon, 02 Feb 2026 13:48:33 GMT\r\ncontent-type: image/png\r\ncontent-length: 1838607\r\nlast-modified: Tue, 14 Oct 2025 10:30:14 GMT\r\netag: &quot;68ee2636-1c0e0f&quot;\r\nexpires: Wed, 04 Mar 2026 13:48:33 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/AGUIRAR-Imane-2-2.png HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.021101","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/AGUIRAR-Imane-2-2.png","0","0"),
("672","https://dualdiploma.org/wp-content/uploads/2025/10/Informations-Plagiat-et-Academic-Integrity-Policies.pdf","0000-00-00 00:00:00","2026-02-03 12:08:16","2026-02-03 12:08:16","2026-02-03 12:08:16","0","https://dualdiploma.org/wp-content/uploads/2025/10/Informations-Plagiat-et-Academic-Integrity-Policies.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Tue, 03 Feb 2026 12:08:16 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 331629\r\nlast-modified: Wed, 15 Oct 2025 08:52:13 GMT\r\netag: &quot;68ef60bd-50f6d&quot;\r\nexpires: Thu, 05 Mar 2026 12:08:16 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/Informations-Plagiat-et-Academic-Integrity-Policies.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.037388","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/Informations-Plagiat-et-Academic-Integrity-Policies.pdf","0","0"),
("673","https://dualdiploma.org/wp-content/uploads/2025/10/Tuto-AVE-SIS-Colegia_Program-director_25-26.pdf","0000-00-00 00:00:00","2026-01-31 17:18:34","2026-01-31 17:18:34","2026-01-31 17:18:34","0","https://dualdiploma.org/wp-content/uploads/2025/10/Tuto-AVE-SIS-Colegia_Program-director_25-26.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 17:18:36 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 6244373\r\nlast-modified: Wed, 15 Oct 2025 14:17:48 GMT\r\netag: &quot;68efad0c-5f4815&quot;\r\nexpires: Mon, 02 Mar 2026 17:18:36 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/Tuto-AVE-SIS-Colegia_Program-director_25-26.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.033531","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/Tuto-AVE-SIS-Colegia_Program-director_25-26.pdf","0","0"),
("674","https://dualdiploma.org/wp-content/uploads/2025/10/AIS-Dual-Diploma-Master-Calendar-2025-26-Jumpstart.pdf","0000-00-00 00:00:00","2026-01-31 17:28:17","2026-01-31 17:28:17","2026-01-31 17:28:17","0","https://dualdiploma.org/wp-content/uploads/2025/10/AIS-Dual-Diploma-Master-Calendar-2025-26-Jumpstart.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 17:28:19 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 153252\r\nlast-modified: Wed, 15 Oct 2025 14:48:00 GMT\r\netag: &quot;68efb420-256a4&quot;\r\nexpires: Mon, 02 Mar 2026 17:28:19 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/AIS-Dual-Diploma-Master-Calendar-2025-26-Jumpstart.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.035578","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/AIS-Dual-Diploma-Master-Calendar-2025-26-Jumpstart.pdf","0","0"),
("675","https://dualdiploma.org/wp-content/uploads/2025/10/Programme-Jumpstart-2025-26.pdf","0000-00-00 00:00:00","2026-01-31 17:38:20","2026-01-31 17:38:20","2026-01-31 17:38:20","0","https://dualdiploma.org/wp-content/uploads/2025/10/Programme-Jumpstart-2025-26.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 17:38:22 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 169800\r\nlast-modified: Wed, 15 Oct 2025 14:53:57 GMT\r\netag: &quot;68efb585-29748&quot;\r\nexpires: Mon, 02 Mar 2026 17:38:22 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/Programme-Jumpstart-2025-26.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.046241","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/Programme-Jumpstart-2025-26.pdf","0","0"),
("676","https://dualdiploma.org/wp-content/uploads/2025/10/Dual-Diploma-Academica-2025-26-Jumpstart-EP.pdf","0000-00-00 00:00:00","2026-01-31 18:28:50","2026-01-31 18:28:50","2026-01-31 18:28:50","0","https://dualdiploma.org/wp-content/uploads/2025/10/Dual-Diploma-Academica-2025-26-Jumpstart-EP.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 18:28:52 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 6535718\r\nlast-modified: Wed, 15 Oct 2025 15:26:42 GMT\r\netag: &quot;68efbd32-63ba26&quot;\r\nexpires: Mon, 02 Mar 2026 18:28:52 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/Dual-Diploma-Academica-2025-26-Jumpstart-EP.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.02115","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/Dual-Diploma-Academica-2025-26-Jumpstart-EP.pdf","0","0"),
("677","https://dualdiploma.org/wp-content/uploads/2025/10/FAQ-de-rentree-PARENTS-Jumpstart-Avant-le-Test-25-26.pdf","0000-00-00 00:00:00","2026-01-31 18:28:50","2026-01-31 18:28:50","2026-01-31 18:28:50","0","https://dualdiploma.org/wp-content/uploads/2025/10/FAQ-de-rentree-PARENTS-Jumpstart-Avant-le-Test-25-26.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 18:28:50 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 466597\r\nlast-modified: Wed, 15 Oct 2025 15:27:47 GMT\r\netag: &quot;68efbd73-71ea5&quot;\r\nexpires: Mon, 02 Mar 2026 18:28:50 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/FAQ-de-rentree-PARENTS-Jumpstart-Avant-le-Test-25-26.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.029428","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/FAQ-de-rentree-PARENTS-Jumpstart-Avant-le-Test-25-26.pdf","0","0"),
("678","https://dualdiploma.org/wp-content/uploads/2025/10/AIS-Dual-Diploma-Program-Certficate-of-Participation-2026.pdf","0000-00-00 00:00:00","2026-01-31 18:49:02","2026-01-31 18:49:02","2026-01-31 18:49:02","0","https://dualdiploma.org/wp-content/uploads/2025/10/AIS-Dual-Diploma-Program-Certficate-of-Participation-2026.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sat, 31 Jan 2026 18:49:02 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 182093\r\nlast-modified: Wed, 15 Oct 2025 15:53:32 GMT\r\netag: &quot;68efc37c-2c74d&quot;\r\nexpires: Mon, 02 Mar 2026 18:49:02 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/AIS-Dual-Diploma-Program-Certficate-of-Participation-2026.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.028179","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/AIS-Dual-Diploma-Program-Certficate-of-Participation-2026.pdf","0","0"),
("679","https://youtu.be/6v4azt3gRkM?si=8FuVZac-yC6F8O7e","2025-10-16 08:48:06","2026-02-01 11:38:39","0000-00-00 00:00:00","2026-02-01 11:38:39","37","https://youtu.be/6v4azt3gRkM?si=8FuVZac-yC6F8O7e","0","<em>(Using YouTube API)</em>\n\n403 Forbidden\nUnknown YouTube API response received.\n---\nmessage: Method doesn&#039;t allow unregistered callers (callers without established identity). Please use API Key or other form of API consumer identity to call this API.\ndomain: global\nreason: forbidden\n\nLe lien est cassé.","403","warning","forbidden","0.068829","0","0","1","1","0","youtube|403|0|0|-|-","0","0"),
("680","https://dualdiploma.org/wp-content/uploads/2025/10/Collecte_bulletins_Academica_2025-10-20.pdf","0000-00-00 00:00:00","2026-02-01 11:38:39","2026-02-01 11:38:39","2026-02-01 11:38:39","0","https://dualdiploma.org/wp-content/uploads/2025/10/Collecte_bulletins_Academica_2025-10-20.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 11:38:41 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 239197\r\nlast-modified: Wed, 22 Oct 2025 08:36:44 GMT\r\netag: &quot;68f8979c-3a65d&quot;\r\nexpires: Tue, 03 Mar 2026 11:38:41 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/Collecte_bulletins_Academica_2025-10-20.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.031988","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/Collecte_bulletins_Academica_2025-10-20.pdf","0","0"),
("681","https://dualdiploma.org/wp-content/uploads/2025/10/Informations-Competitive-College-Club-CCC-2025-26-1.pdf","0000-00-00 00:00:00","2026-02-01 12:48:21","2026-02-01 12:48:21","2026-02-01 12:48:21","0","https://dualdiploma.org/wp-content/uploads/2025/10/Informations-Competitive-College-Club-CCC-2025-26-1.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 12:48:23 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 198775\r\nlast-modified: Wed, 22 Oct 2025 09:54:44 GMT\r\netag: &quot;68f8a9e4-30877&quot;\r\nexpires: Tue, 03 Mar 2026 12:48:23 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/Informations-Competitive-College-Club-CCC-2025-26-1.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.039949","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/Informations-Competitive-College-Club-CCC-2025-26-1.pdf","0","0"),
("682","https://dualdiploma.org/wp-content/uploads/2025/10/Etudier-aux-Etats-Unis_25-26.pdf","0000-00-00 00:00:00","2026-02-01 16:38:36","2026-02-01 16:38:36","2026-02-01 16:38:36","0","https://dualdiploma.org/wp-content/uploads/2025/10/Etudier-aux-Etats-Unis_25-26.pdf","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nserver: nginx\r\ndate: Sun, 01 Feb 2026 16:38:37 GMT\r\ncontent-type: application/pdf\r\ncontent-length: 465082\r\nlast-modified: Wed, 22 Oct 2025 13:45:49 GMT\r\netag: &quot;68f8e00d-718ba&quot;\r\nexpires: Tue, 03 Mar 2026 16:38:37 GMT\r\ncache-control: max-age=2592000\r\naccess-control-allow-origin: *\r\ncache-control: public, must-revalidate, proxy-revalidate, immutable, stale-while-revalidate=86400, stale-if-error=604800\r\naccept-ranges: bytes\r\n\r\nRequest headers\n================\nHEAD /wp-content/uploads/2025/10/Etudier-aux-Etats-Unis_25-26.pdf HTTP/2\r\nHost: dualdiploma.org\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.052985","0","0","0","1","0","200|0|0|https://dualdiploma.org/wp-content/uploads/2025/10/Etudier-aux-Etats-Unis_25-26.pdf","0","0"),
("683","https://www.timeshighereducation.com/world-university-rankings/latest/world-ranking","0000-00-00 00:00:00","2026-02-02 12:36:22","2026-02-02 12:36:22","2026-02-02 12:36:22","0","https://www.timeshighereducation.com/world-university-rankings/latest/world-ranking","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ncache-control: max-age=600, public\r\netag: &quot;bh5c0rid4d1tpj0&quot;\r\nlast-modified: Mon, 02 Feb 2026 08:26:27 GMT\r\ncontent-type: text/html; charset=utf-8\r\naccept-ranges: bytes\r\ndate: Mon, 02 Feb 2026 12:36:26 GMT\r\nvia: 1.1 varnish\r\nage: 9282\r\nset-cookie: geoCountry=FR; Domain=.prod.the-internal.cloud; Path=/\r\nset-cookie: siteCountry=GB; Max-Age=63072000; Domain=.prod.the-internal.cloud; Path=/\r\nx-served-by: cache-lcy-egml8630046-LCY, cache-lcy-egml8630037-LCY\r\nx-cache: MISS, HIT\r\nx-cache-hits: 0, 1\r\nx-timer: S1770035786.377410,VS0,VE4\r\nvary: Accept-Encoding\r\ncontent-length: 3073497\r\n\r\nRequest headers\n================\nHEAD /world-university-rankings/latest/world-ranking HTTP/2\r\nHost: www.timeshighereducation.com\r\nuser-agent: WPMU DEV Broken Link Checker Local Engine\r\naccept: */*\r\naccept-encoding: deflate, gzip, br\r\nreferer: https://dualdiploma.org\r\nconnection: close\r\n\r\n\nLe lien est valide.","200","","","0.032108","0","0","0","1","0","200|0|0|https://www.timeshighereducation.com/world-university-rankings/latest/world-ranking","0","0"),
("684","https://www.timeshighereducation.com/world-university-rankings/methodology","0000-00-00 00:00:00","2026-02-02 12:36:15","2026-02-02 12:36:15","2026-02-02 12:36:15","0","https://www.timeshighereducation.com/world-university-rankings/methodology","0","[Warning] Could\'t follow the redirect URL (if any) because safemode or open base dir enabled\n=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\nstrict-transport-security: max