<?php
/**
 * Plugin Name: SecuPress Notice (nginx_remove_rules)
 * Description: This plugin purpose is only to display a message after SecuPress is deactivated. It will be deleted once the message is dismissed.
 * Version: 1.0.2
 * License: GPLv2
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Copyright 2012-2024 SecuPress
 */

defined( 'ABSPATH' ) or die( 'Something went wrong.' );

/**
 * Print the notice.
 *
 * @since 1.0
 */
add_action( 'all_admin_notices', 'secupress_mup_notice_nginx_remove_rules' );

function secupress_mup_notice_nginx_remove_rules() {
	$capa = is_multisite() ? 'manage_network_options' : 'administrator';

	if ( get_current_user_id() !== 3 || ! current_user_can( $capa ) ) {
		return;
	}

	$port = (int) $_SERVER['SERVER_PORT'];
	$port = 80 !== $port && 443 !== $port ? ( ':' . $port ) : '';
	$url  = ! empty( $GLOBALS['HTTP_SERVER_VARS']['REQUEST_URI'] ) ? $GLOBALS['HTTP_SERVER_VARS']['REQUEST_URI'] : ( ! empty( $_SERVER['REQUEST_URI'] ) ? $_SERVER['REQUEST_URI'] : '' );
	$url  = 'http' . ( is_ssl() ? 's' : '' ) . '://' . $_SERVER['HTTP_HOST'] . $port . $url; // do not use "secupress_is_ssl()" here
	$url  = urlencode( esc_url_raw( $url ) );
	$url  = admin_url( 'admin-post.php?action=secupress_kill_mu_notice_nginx_remove_rules&_wp_http_referer=' . $url );
	$url  = wp_nonce_url( $url, 'secupress-mup-notice-nginx_remove_rules-3' );
	?>
	<div class="updated notice secupress-mup-notice"><p>
		Votre serveur utilise le système <strong>Ngnix</strong>. Vous devrez alors éditer votre fichier de configuration manuellement. Merci de supprimer les règles entre <code># BEGIN SecuPress</code> et <code># END SecuPress</code> dans le fichier <code>nginx.conf</code>.
		<a href="<?php echo esc_url( $url ); ?>" class="button button-primary" style="float:right;margin-top:-.35em">Ok j’ai compris !</a>
	</p></div>
	<?php
}


/**
 * Delete this file.
 *
 * @since 1.0
 */
add_action( 'admin_post_secupress_kill_mu_notice_nginx_remove_rules', 'secupress_mup_kill_notice_nginx_remove_rules' );

function secupress_mup_kill_notice_nginx_remove_rules() {
	$capa = is_multisite() ? 'manage_network_options' : 'administrator';

	if ( get_current_user_id() !== 3 || ! current_user_can( $capa ) ) {
		return;
	}

	check_admin_referer( 'secupress-mup-notice-nginx_remove_rules-3' );
	unlink( __FILE__ );
	wp_safe_redirect( wp_get_referer() );
	die();
}
