<?php

/**
 * Plugin Name: [Dual Diploma] - Redirection vers URL avec préfixe /blog/
 * Description: Redirige les articles du blog sans le préfixe /blog/ et log les redirections.
 * Author: Maxime Potier
 * Author Email: maxime.potier@gmail.com
 * Version: 1.1
 */

add_action('template_redirect', 'dd_safe_redirect_blog_posts');

function dd_safe_redirect_blog_posts()
{
    if (is_admin() || is_feed() || is_preview() || !is_404()) {
        return;
    }

    global $wp;
    $requested_path = trim($wp->request, '/');

    // ⚠️ Exclure les slugs vides (page d'accueil ou équivalent)
    if ($requested_path === '' || $requested_path === '/' || $requested_path === false) {
        return;
    }

    // Ne rien faire si l'URL commence déjà par blog/
    if (strpos($requested_path, 'blog/') === 0) {
        return;
    }

    // Vérifie si l'article existe avec le chemin blog/...
    $possible_post_path = 'blog/' . $requested_path;
    $post = get_page_by_path($possible_post_path, OBJECT, 'post');

    if ($post && $post->post_type === 'post' && $post->post_status === 'publish') {
        $new_url = home_url('/blog/' . $requested_path . '/');
        dd_log_blog_redirect($requested_path, $new_url);
        wp_redirect($new_url, 301);
        exit;
    }
}

function dd_log_blog_redirect($old_path, $new_url)
{
    $upload_dir = wp_upload_dir();
    $log_file = trailingslashit($upload_dir['basedir']) . 'dd-blog-redirect.log';

    $date = date_i18n('Y-m-d H:i:s');
    $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown IP';
    $ref = $_SERVER['HTTP_REFERER'] ?? 'no referer';

    $log_entry = "[{$date}] IP: {$ip} - From: /{$old_path} → To: {$new_url} - Referer: {$ref}" . PHP_EOL;

    file_put_contents($log_file, $log_entry, FILE_APPEND);
}
