// Countdown Top Bar JS
// Will be implemented: countdown logic

document.addEventListener("DOMContentLoaded", function () {
  var timer = document.getElementById("dd-countdown-timer");
  var topbar = document.getElementById("dd-countdown-topbar");
  if (!timer || !topbar || !ddCountdownData || !ddCountdownData.datetime)
    return;

  // Insert topbar just before the selected element
  var target = null;
  var topbarHeight = 42; // Topbar height in px
  var isFixedHeader = false;
  var originalTop = 0;

  // Detect WP admin bar (32px desktop, 46px mobile)
  var hasAdminBar = document.body.classList.contains("admin-bar");
  var adminBarHeight = hasAdminBar ? (window.innerWidth > 782 ? 32 : 46) : 0;

  if (ddCountdownData.selector) {
    target = document.querySelector(ddCountdownData.selector);
    if (target && target.parentNode) {
      target.parentNode.insertBefore(topbar, target);

      // Handle fixed/sticky positioned target
      var targetStyle = window.getComputedStyle(target);
      var targetPosition = targetStyle.position;

      if (targetPosition === "fixed" || targetPosition === "sticky") {
        isFixedHeader = true;
        originalTop = parseFloat(targetStyle.top) || 0;

        // Offset the target by topbar height (admin bar offset is already in originalTop)
        target.style.top = (originalTop + topbarHeight) + "px";

        // Add padding to body to prevent content from being hidden
        document.body.style.paddingTop = topbarHeight + "px";

        // Make topbar fixed as well to stay visible, below admin bar
        topbar.style.position = "fixed";
        topbar.style.top = adminBarHeight + "px";
        topbar.style.left = "0";
        topbar.style.right = "0";

        // Add class to body for CSS adjustments (e.g. mobile menu button)
        document.body.classList.add("dd-countdown-active");
      }

      // Override max-height if enabled
      if (ddCountdownData.overrideMaxHeight) {
        var val = ddCountdownData.maxHeightSelect;
        if (
          val === "custom_px" &&
          Number(ddCountdownData.maxHeightCustom) > 0
        ) {
          target.style.maxHeight = ddCountdownData.maxHeightCustom + "px";
        } else if (val) {
          target.style.maxHeight = val;
        }
        target.style.overflow = "visible";
      }
    }
  }

  // Reset fixed header styles when topbar is hidden
  function resetFixedHeaderStyles() {
    if (isFixedHeader && target) {
      target.style.top = originalTop + "px";
      document.body.style.paddingTop = "";
      document.body.classList.remove("dd-countdown-active");
    }
  }

  var before = topbar.querySelector(".dd-countdown-msg-before");
  var after = topbar.querySelector(".dd-countdown-msg-after");
  var endMsg = topbar.querySelector(".dd-countdown-msg-end");

  function pad(n) {
    return n < 10 ? "0" + n : n;
  }

  function renderCountdown(d, h, m, s) {
    var mode = ddCountdownData.displayMode || "days_hours_minutes_seconds";
    var out = "";
    if (mode === "days") {
      out = d + " " + ddCountdownData.labelDays;
    } else if (mode === "days_hours") {
      out =
        d +
        " " +
        ddCountdownData.labelDays +
        " " +
        pad(h) +
        " " +
        ddCountdownData.labelHours;
    } else if (mode === "days_hours_minutes") {
      out =
        d +
        " " +
        ddCountdownData.labelDays +
        " " +
        pad(h) +
        " " +
        ddCountdownData.labelHours +
        " " +
        pad(m) +
        " " +
        ddCountdownData.labelMinutes;
    } else {
      out =
        d +
        " " +
        ddCountdownData.labelDays +
        " " +
        pad(h) +
        " " +
        ddCountdownData.labelHours +
        " " +
        pad(m) +
        " " +
        ddCountdownData.labelMinutes +
        " " +
        pad(s) +
        " " +
        ddCountdownData.labelSeconds;
    }
    return out;
  }

  function updateCountdown() {
    var end = new Date(ddCountdownData.datetime.replace(/-/g, "/"));
    var now = new Date();
    var diff = end - now;
    if (diff > 0) {
      var d = Math.floor(diff / (1000 * 60 * 60 * 24));
      var h = Math.floor((diff / (1000 * 60 * 60)) % 24);
      var m = Math.floor((diff / (1000 * 60)) % 60);
      var s = Math.floor((diff / 1000) % 60);
      timer.textContent = renderCountdown(d, h, m, s);
      timer.style.display = "";
      if (before) before.style.display = "";
      if (after) after.style.display = "";
      if (endMsg) endMsg.style.display = "none";
    } else {
      timer.style.display = "none";
      if (before) before.style.display = "none";
      if (after) after.style.display = "none";
      if (endMsg && ddCountdownData.msgEnd) {
        endMsg.style.display = "";
      } else {
        topbar.style.display = "none";
        resetFixedHeaderStyles();
      }
      clearInterval(interval);
    }
  }

  // Affiche la top bar
  topbar.style.display = "";
  updateCountdown();
  var interval = setInterval(updateCountdown, 1000);

  // Ajout du défilement si activé
  if (ddCountdownData.marquee) {
    topbar.classList.add("dd-countdown-marquee");
    var inner = topbar.querySelector(".dd-countdown-marquee-inner");
    // Scroll infini : duplication du contenu
    if (inner) {
      var original = inner.innerHTML;
      inner.innerHTML =
        original + '<span class="dd-marquee-gap"></span>' + original;
      topbar.classList.add("marquee-infinite");
    }
    // Vitesse personnalisée
    var speed = parseInt(ddCountdownData.marqueeSpeed, 10);
    if (inner && !isNaN(speed) && speed > 0) {
      inner.style.setProperty("--dd-marquee-speed", speed + "s");
    }
    // Comportement
    if (ddCountdownData.marqueeBehavior === "reverse") {
      topbar.classList.add("reverse");
    } else if (ddCountdownData.marqueeBehavior === "pause_on_hover") {
      topbar.classList.add("pause-on-hover");
    }
  }

  // Second countdown after .dd-countdown
  if (
    typeof ddCountdown2Data !== "undefined" &&
    ddCountdown2Data.enabled &&
    ddCountdown2Data.datetime
  ) {
    var ddCountdownEl = document.querySelector(".dd-countdown");
    if (ddCountdownEl) {
      var wrapper2;
      if (ddCountdown2Data.link) {
        wrapper2 = document.createElement("a");
        wrapper2.href = ddCountdown2Data.link;
        wrapper2.target = "_self";
        wrapper2.rel = "noopener noreferrer";
      } else {
        wrapper2 = document.createElement("div");
      }
      wrapper2.className = "custom-countdown-wrapper";
      wrapper2.innerHTML = `
        <div class="custom-countdown-msg-before">${
          ddCountdown2Data.msgBefore || ""
        }</div>
        <div>
        <span class="custom-countdown-timer"></span>
        <span class="custom-countdown-msg-after">${
          ddCountdown2Data.msgAfter || ""
        }</span>
        <span class="custom-countdown-msg-end" style="display:none;">${
          ddCountdown2Data.msgEnd || ""
        }</span></div>
      `;
      ddCountdownEl.parentNode.insertBefore(
        wrapper2,
        ddCountdownEl.nextSibling
      );

      function pad2(n) {
        return n < 10 ? "0" + n : n;
      }
      function renderCountdown2(d, h, m, s) {
        var mode = ddCountdown2Data.displayMode || "days_hours_minutes_seconds";
        var out = "";
        if (mode === "days") {
          out = d + " " + ddCountdown2Data.labelDays;
        } else if (mode === "days_hours") {
          out =
            d +
            " " +
            ddCountdown2Data.labelDays +
            " " +
            pad2(h) +
            " " +
            ddCountdown2Data.labelHours;
        } else if (mode === "days_hours_minutes") {
          out =
            d +
            " " +
            ddCountdown2Data.labelDays +
            " " +
            pad2(h) +
            " " +
            ddCountdown2Data.labelHours +
            " " +
            pad2(m) +
            " " +
            ddCountdown2Data.labelMinutes;
        } else {
          out =
            d +
            " " +
            ddCountdown2Data.labelDays +
            " " +
            pad2(h) +
            " " +
            ddCountdown2Data.labelHours +
            " " +
            pad2(m) +
            " " +
            ddCountdown2Data.labelMinutes +
            " " +
            pad2(s) +
            " " +
            ddCountdown2Data.labelSeconds;
        }
        return out;
      }
      function updateCountdown2() {
        var end = new Date(ddCountdown2Data.datetime.replace(/-/g, "/"));
        var now = new Date();
        var diff = end - now;
        var timer2 = wrapper2.querySelector(".custom-countdown-timer");
        var before2 = wrapper2.querySelector(".custom-countdown-msg-before");
        var after2 = wrapper2.querySelector(".custom-countdown-msg-after");
        var endMsg2 = wrapper2.querySelector(".custom-countdown-msg-end");
        if (diff > 0) {
          var d = Math.floor(diff / (1000 * 60 * 60 * 24));
          var h = Math.floor((diff / (1000 * 60 * 60)) % 24);
          var m = Math.floor((diff / (1000 * 60)) % 60);
          var s = Math.floor((diff / 1000) % 60);
          timer2.textContent = renderCountdown2(d, h, m, s);
          timer2.style.display = "";
          if (before2) before2.style.display = "";
          if (after2) after2.style.display = "";
          if (endMsg2) endMsg2.style.display = "none";
        } else {
          timer2.style.display = "none";
          if (before2) before2.style.display = "none";
          if (after2) after2.style.display = "none";
          if (endMsg2 && ddCountdown2Data.msgEnd) {
            endMsg2.style.display = "";
          } else {
            wrapper2.style.display = "none";
          }
          clearInterval(interval2);
        }
      }
      updateCountdown2();
      var interval2 = setInterval(updateCountdown2, 1000);
    }
  }
});
