<?php
// Main plugin class for DD Countdown Top Bar
if (! defined('ABSPATH')) exit; // Exit if accessed directly

class DD_Countdown
{
    public function __construct()
    {
        add_action('wp_head', [$this, 'inject_top_bar']);
        add_action('wp_enqueue_scripts', [$this, 'enqueue_assets']);
    }

    public function inject_top_bar()
    {
        // Get ACF options
        if (!function_exists('get_field')) return;
        $enabled = get_field('dd_countdown_enable', 'option');
        if (!$enabled) return;

        $datetime = get_field('dd_countdown_datetime', 'option');
        $bgcolor = get_field('dd_countdown_bgcolor', 'option') ?: '#111827';
        $textcolor = get_field('dd_countdown_textcolor', 'option') ?: '#fff';
        $fontsize = get_field('dd_countdown_fontsize', 'option') ?: 20;
        $msg_before = get_field('dd_countdown_msg_before', 'option');
        $msg_after = get_field('dd_countdown_msg_after', 'option');
        $msg_end = get_field('dd_countdown_msg_end', 'option');
        $selector = get_field('dd_countdown_selector', 'option') ?: 'body';
        $custom_css = get_field('dd_countdown_custom_css', 'option');

        if (!$datetime) return;

        // Output custom CSS if set
        if ($custom_css) {
            echo '<style id="dd-countdown-custom-css">' . $custom_css . '</style>';
        }

        // Output top bar (hidden by default, will be moved by JS)
?>
        <div id="dd-countdown-topbar" class="dd-countdown-topbar" style="background: <?php echo esc_attr($bgcolor); ?>; color: <?php echo esc_attr($textcolor); ?>; font-size: <?php echo esc_attr($fontsize); ?>px; width:100%; text-align:center; position:relative; z-index:9999; padding:8px 0; display:none;">
            <div class="dd-countdown-marquee-inner">
                <?php if ($msg_before) : ?>
                    <span class="dd-countdown-msg-before"><?php echo esc_html($msg_before); ?></span>&nbsp;
                <?php endif; ?>
                <span id="dd-countdown-timer" data-datetime="<?php echo esc_attr($datetime); ?>"></span>
                <?php if ($msg_after) : ?>
                    <span class="dd-countdown-msg-after"><?php echo esc_html($msg_after); ?></span>
                <?php endif; ?>
            </div>
            <?php if ($msg_end) : ?>
                <span class="dd-countdown-msg-end" style="display:none;"><?php echo esc_html($msg_end); ?></span>
            <?php endif; ?>
        </div>
<?php
    }

    public function enqueue_assets()
    {
        if (!function_exists('get_field')) return;
        $enabled = get_field('dd_countdown_enable', 'option');
        if (!$enabled) return;

        wp_enqueue_style('dd-countdown-css', DD_COUNTDOWN_URL . 'assets/css/dd-countdown.css', [], '1.0.0');
        wp_enqueue_script('dd-countdown-js', DD_COUNTDOWN_URL . 'assets/js/dd-countdown.js', [], '1.0.4', true);

        $datetime = get_field('dd_countdown_datetime', 'option');
        $msg_after = get_field('dd_countdown_msg_after', 'option');
        $selector = get_field('dd_countdown_selector', 'option') ?: 'body';
        $override_maxheight = get_field('dd_countdown_override_maxheight', 'option');
        $maxheight_select = get_field('dd_countdown_maxheight_select', 'option');
        $maxheight_custom = get_field('dd_countdown_maxheight_custom', 'option');
        $display_mode = get_field('dd_countdown_display_mode', 'option') ?: 'days_hours_minutes_seconds';
        $label_days = get_field('dd_countdown_label_days', 'option') ?: 'j';
        $label_hours = get_field('dd_countdown_label_hours', 'option') ?: 'h';
        $label_minutes = get_field('dd_countdown_label_minutes', 'option') ?: 'm';
        $label_seconds = get_field('dd_countdown_label_seconds', 'option') ?: 's';
        $msg_end = get_field('dd_countdown_msg_end', 'option');
        $marquee = get_field('dd_countdown_marquee', 'option');
        $marquee_speed = get_field('dd_countdown_marquee_speed', 'option');
        $marquee_behavior = get_field('dd_countdown_marquee_behavior', 'option');
        wp_localize_script('dd-countdown-js', 'ddCountdownData', [
            'datetime' => $datetime,
            'msgAfter' => $msg_after,
            'msgEnd' => $msg_end,
            'selector' => $selector,
            'overrideMaxHeight' => $override_maxheight,
            'maxHeightSelect' => $maxheight_select,
            'maxHeightCustom' => $maxheight_custom,
            'displayMode' => $display_mode,
            'labelDays' => $label_days,
            'labelHours' => $label_hours,
            'labelMinutes' => $label_minutes,
            'labelSeconds' => $label_seconds,
            'marquee' => $marquee,
            'marqueeSpeed' => $marquee_speed,
            'marqueeBehavior' => $marquee_behavior
        ]);

        $enabled2 = get_field('dd_countdown2_enable', 'option');
        $datetime2 = get_field('dd_countdown2_datetime', 'option');
        $msg_before2 = get_field('dd_countdown2_msg_before', 'option');
        $msg_after2 = get_field('dd_countdown2_msg_after', 'option');
        $msg_end2 = get_field('dd_countdown2_msg_end', 'option');
        $display_mode2 = get_field('dd_countdown2_display_mode', 'option') ?: 'days_hours_minutes_seconds';
        $label_days2 = get_field('dd_countdown2_label_days', 'option') ?: 'j';
        $label_hours2 = get_field('dd_countdown2_label_hours', 'option') ?: 'h';
        $label_minutes2 = get_field('dd_countdown2_label_minutes', 'option') ?: 'm';
        $label_seconds2 = get_field('dd_countdown2_label_seconds', 'option') ?: 's';
        $link2 = get_field('dd_countdown2_link', 'option');
        wp_localize_script('dd-countdown-js', 'ddCountdown2Data', [
            'enabled' => $enabled2,
            'datetime' => $datetime2,
            'msgBefore' => $msg_before2,
            'msgAfter' => $msg_after2,
            'msgEnd' => $msg_end2,
            'displayMode' => $display_mode2,
            'labelDays' => $label_days2,
            'labelHours' => $label_hours2,
            'labelMinutes' => $label_minutes2,
            'labelSeconds' => $label_seconds2,
            'link' => $link2
        ]);
    }
}
