<?php
/**
 * Module Name: Module Notifications
 * Description: Send an email when a module have been deactivated since more than 1 hour
 * Main Module: alerts
 * Author: SecuPress
 * Version: 2.3.18
 */

defined( 'SECUPRESS_VERSION' ) or die( 'Something went wrong.' );

add_action( 'secupress.pro.plugins.deactivation',                                     'secupress_module_alerts_deactivation' );
add_action( 'secupress.modules.deactivate_submodule_' . basename( __FILE__, '.php' ), 'secupress_module_alerts_deactivation' );
/**
 * Delete the option
 *
 * @since 2.3.18
 */
function secupress_module_alerts_deactivation() {
	delete_option( SECUPRESS_MODULE_ALERTS );
}

add_action( 'admin_head', 'secupress_manage_submodule_alerts' );
/**
 * Handle the possible module alerts foujd in DB, send the mail, update the option
 *
 * @since 2.3.18
 * @author Julio Potier
 **/
function secupress_manage_submodule_alerts() {
	if ( ! secupress_is_soft_request() ) {
		return;
	}
	$alerts = secupress_get_submodule_alerts();
	foreach ( $alerts as $id => $args ) {
		if ( ( $args['time'] + secupress_get_submodule_alert_timing( 'hours' ) ) < time() ) {
			secupress_submodule_alert_email( $args );
			if ( count( get_users( [ 'capability' => secupress_get_capability( true, 'notice-module-alerts' ), 'fields' => 'ID' ] ) ) ) {
				secupress_add_transient_notice( sprintf( __( 'The module "%1$s" has been deactivated %2$s. Please reactivate it if needed.', 'secupress' ), $args['module_name'], secupress_get_submodule_alert_timing( 'ago' ) ), 'updated' );
			}
			unset( $alerts[ $id ] );
		}
	}
	if ( ! empty( $alerts ) ) {
		update_option( SECUPRESS_MODULE_ALERTS, $alerts );
	} else {
		delete_option( SECUPRESS_MODULE_ALERTS );
	}
}
