<?php
defined( 'ABSPATH' ) or die( 'Something went wrong.' );

/** --------------------------------------------------------------------------------------------- */
/** ON MODULE SETTINGS SAVE ===================================================================== */
/** --------------------------------------------------------------------------------------------- */

/**
 * Callback to filter, sanitize and de/activate submodules
 *
 * @since 2.2.6
 * @author Julio Potier
 *
 * @param (array) $settings The module settings.
 *
 * @return (array) The sanitized and validated settings.
 */
function secupress_pro_firewall_settings_callback( $settings ) {
	$modulenow = 'firewall';
	$activate  = secupress_get_submodule_activations( $modulenow );
	$settings  = $settings && is_array( $settings ) ? $settings : [];
	/*
	 * Each submodule has its own sanitization function.
	 * The `$settings` parameter is passed by reference.
	 */

	// Country Management.
	secupress_pro_geoip_settings_callback( $modulenow, $settings );

	// Pro part
	secupress_pro_bbq_settings_callback( $modulenow, $activate );

	// Free part
	secupress_firewall_settings_callback( $settings );

	return $settings;
}


/**
 * BBQ Features Pro
 *
 * @since 2.2.6
 *
 * @param (string)     $modulenow
 * @param (array)      $activate
 */
function secupress_pro_bbq_settings_callback( $modulenow, $activate ) {
	secupress_manage_submodule( $modulenow, 'block-ai', isset( $activate['bbq-headers_block-ai'] ) );
}

/**
 * Country Management plugin.
 *
 * @since 1.0
 *
 * @param (string)     $modulenow Current module.
 * @param (array)      $settings  The module settings, passed by reference.
 */
function secupress_pro_geoip_settings_callback( $modulenow, &$settings ) {
	// Settings.
	$geoip_values = array( '-1' => 1, 'blacklist' => 1, 'whitelist' => 1 );

	$settings['geoip-system_countries'] = ! empty( $settings['geoip-system_countries'] ) && is_array( $settings['geoip-system_countries'] ) ? array_map( 'sanitize_text_field', $settings['geoip-system_countries'] ) : [];

	if ( ! $settings['geoip-system_countries'] || empty( $settings['geoip-system_type'] ) || ! isset( $geoip_values[ $settings['geoip-system_type'] ] ) ) {
		$settings['geoip-system_type'] = '-1';
	}

	// (De)Activation.
	secupress_manage_submodule( $modulenow, 'geoip-system', ( '-1' !== $settings['geoip-system_type'] ) );

	// Make sure to not block the user.
	if ( '-1' !== $settings['geoip-system_type'] && function_exists( 'secupress_geoip2country' ) ) {

		$country_code = secupress_geoip2country( secupress_get_ip() );

		if ( $country_code ) {
			$is_whitelist = 'whitelist' === $settings['geoip-system_type'];
			$countries    = array_flip( $settings['geoip-system_countries'] );

			if ( isset( $countries[ $country_code ] ) && ! $is_whitelist ) {
				secupress_add_transient_notice( __( 'You cannot block your own country, it has been removed from the disallowed list.', 'secupress' ), 'info' );
				// Unblacklist the user country.
				unset( $countries[ $country_code ] );
				$settings['geoip-system_countries'] = array_flip( $countries );

			} elseif ( ! isset( $countries[ $country_code ] ) && $is_whitelist ) {
				// Whitelist the user country.
				secupress_add_transient_notice( __( 'You cannot block your own country, it has been added to the allowed list.', 'secupress' ), 'info' );
				$countries   = array_flip( $countries );
				$countries[] = $country_code;
				$settings['geoip-system_countries'] = $countries;
			}
		}
	}
}
