<?php
/**
 * Module Name: Block AI Bots
 * Description: Block requests received with AI user-agents.
 * Main Module: firewall
 * Author: SecuPress
 * Version: 2.2.6
 */

defined( 'SECUPRESS_VERSION' ) or die( 'Something went wrong.' );

add_action( 'secupress.plugins.loaded', 'secupress_block_ai_user_agents', 6 );
/**
 * Filter the user agent to block it or not
 *
 * @since 2.2.6
 */
function secupress_block_ai_user_agents() {

	$user_agent = isset( $_SERVER['HTTP_USER_AGENT'] ) ? trim( $_SERVER['HTTP_USER_AGENT'] ) : '';
	// Empty is fine, can't harm anything.
	if ( empty( $user_agent ) ) {
		return;
	}

	$ai_user_agents     = secupress_firewall_bbq_referer_content_ai_bots_list_default();
	if ( ! empty( $ai_user_agents ) ) {
		$ai_user_agents = implode( ',', explode( "\n", $ai_user_agents ) );
		$ai_user_agents = preg_replace( '#\s*,\s*#', '|', preg_quote( $ai_user_agents ) );
		$ai_user_agents = trim( $ai_user_agents, '| ' );

		while ( false !== strpos( $ai_user_agents, '||' ) ) {
			$ai_user_agents = str_replace( '||', '|', $ai_user_agents );
		}
		$ai_user_agents .= ( $ai_user_agents ? '|' : '' ) . '\(.*?\)\s*\{.*?;\s*\}\s*;';

		preg_match( '#' . $ai_user_agents . '#', $user_agent, $matches );
		if ( ! empty( $matches ) ) {
			secupress_block( 'UAAI', [ 'code' => 403, 'b64' => [ 'data' => $matches ] ] );
		}
	}

}
