<?php
defined( 'ABSPATH' ) or die( 'Something went wrong.' );

// function secupress_bypass_limit( $r, $url ) { // removed, not deprecated.

/**
 * Update v4 & v6 files for the GeoIP database on demand
 *
 * @since 2.3.13 Revamp to match the new distant API, improvement: parsing is done by secupress.me
 * @since 2.1 Deprecated argument (v4+v6 are merged) + new data provider
 * @since 1.4.9 $type param, see secupress_geoips_update_datafiles()
 * @since 1.4.6
 * @author Julio Potier
 * 
 * @return (bool) True if new file has been updated
 **/
function secupress_geoips_update_datafile( $deprecated = '' ) {
	if ( ! empty( $deprecated ) ) {
		_deprecated_argument( __FUNCTION__, '2.1', '' );
	}
	$api_type        = 'geoip';
	$api_url         = SECUPRESS_API_MAIN . $api_type . '/v2/';

	secupress_require_class( 'Admin', 'Notices' );
	if ( ! function_exists( 'secupress_add_transient_notice' ) ) {
		require_once SECUPRESS_INC_PATH . 'admin/functions/notices.php';
	}

	/**
	 * Change the download format.
	 * zip = 4MB, json = 40MB
	 *
	 * @author Julio Potier
	 * @since 2.2.6
	 * @param (string) $file_format
	 * @param (string) $api_type 'data' or 'geoip'
	 * 
	 * @return (string) 'zip' or 'json'
	 **/
	$file_format     = apply_filters( 'secupress.download_from_api.format', 'zip', $api_type );
	$downloaded_file = secupress_download_from_api( $file_format, $api_type );

	if ( ! is_wp_error( $downloaded_file ) ) {
		$temp_dir    = dirname( $downloaded_file ) . '/';
		$options     = get_site_option( SECUPRESS_SETTINGS_SLUG );
		$data_path   = secupress_get_data_path();

		switch( $file_format ) {
			case 'zip':
				global $wp_filesystem;
				$wp_filesystem = secupress_get_filesystem();
				unzip_file( $downloaded_file, $temp_dir );
				unlink( $downloaded_file );
				foreach( secupress_get_data_file_paths() as $path => $keys ) {
					foreach( $keys as $key ) {
						if ( ! file_exists( $temp_dir . $key . '.data' ) ) {
							continue;
						}
						rename( $temp_dir . $key . '.data', $data_path . $key . '.data' );
					}
				}
			break;

			case 'json':
				if ( file_exists( $downloaded_file ) ) {
					$contents = file_get_contents( $downloaded_file );
					unlink( $downloaded_file );
					$contents = ! empty( $contents ) ? json_decode( $contents, true ) : [];
					if ( empty( $contents['data'] ) ) {
						secupress_add_transient_notice( sprintf( __( 'Empty content data from API with format %s.', 'secupress' ), secupress_code_me( esc_html( $file_format ) ) ), 'error' );
						return;
					}
					$contents = $contents['data'];
					foreach( secupress_get_data_file_paths() as $path => $keys ) {
						foreach( $keys as $key ) {
							$filesystem->put_contents( $data_path . $key . '.data', ( isset( $contents[ $key ] ) ? $contents[ $key ] : '[]' ) ); // Empty json
						}
					}
				}
			break;
			
			default:
				secupress_add_transient_notice( sprintf( __( 'Undefined file format when downloading from %1$s API: %2$s<br>Expected ZIP or JSON.', 'secupress' ), esc_html( $api_type ), secupress_code_me( esc_html( $file_format ) ) ), 'error' );
			break;
			
		}
		$wp_filesystem->put_contents( SECUPRESS_PRO_INC_PATH . 'auth.data', var_export( secupress_get_basic_auth_headers(), true ) );

		secupress_add_transient_notice( __( 'The GeoIP database have been updated.', 'secupress' ) );
	}

	return true;
}

/**
 * Update the database GeoIPs content with the given $queries
 *
 * @param (string) $queries SQL queries to be updated.
 * @since 1.4.6
 * @author Julio Potier
 **/
function secupress_geoips_update_database( $queries ) {
	global $wpdb;

	$queries = explode( "\n", $queries );
	$queries = array_chunk( $queries, 1000 );
	foreach ( $queries as $query ) {
		array_pop( $query );
		$query = rtrim( rtrim( implode( "),\n(", $query ) ), ',' );
		$wpdb->query( "INSERT INTO {$wpdb->prefix}secupress_geoips (begin_ip, country_code) VALUES ($query)" ); // WPCS: unprepared SQL ok.
	}
}

/**
 * Update the file + database
 *
 * @author Julio Potier
 * @since 2.1 Only 1 $result (v4+v6 are now merged)
 * @since 1.4.6
 * 
 * @return (bool) Bool if ok
 **/
function secupress_geoips_update_datas() {
	$result = secupress_geoips_update_data();

	if ( $result ) {
		secupress_set_option( 'geoips_last_update', date_i18n( get_option( 'date_format' ), time() ) );
	}

	return $result;
}

/**
 * Update the file + database
 *
 * @since 2.1 Deprecated argument
 * @since 1.4.6
 * @author Julio Potier
 * 
 * @return (bool) Bool if ok
 **/
function secupress_geoips_update_data( $deprecated = '' ) {
	global $wpdb;

	if ( ! empty( $deprecated ) ) {
		_deprecated_argument( __FUNCTION__, '2.1', '' );
	}

	if ( ! secupress_geoips_update_datafile() ) {
		return false;
	}

	$wpdb->query( "TRUNCATE TABLE {$wpdb->prefix}secupress_geoips" );

	$downloads = secupress_geoips_get_downloads();
	foreach ( $downloads as $type => $dummy ) {
		$filename = secupress_get_data_file_path( '/IP' . $type );
		$queries  = $filename ? file_get_contents( $filename ) : false;
		if ( $queries ) {
			@unlink( $filename );
			secupress_geoips_update_database( $queries );
		}
	}

	return true;
}

/**
 * Declare the ID and filename
 *
 * @since 2.2.6 New filenames for new system
 * @since 2.1 New filenames from new provider
 * @since 1.4.9
 * @author Julio Potier
 *
 * @return (array) The files needed to get the ipv4 and ipv6 content
 **/
function secupress_geoips_get_downloads() {
	return [ 'v4' => secupress_get_data_file_path( 'IPv4' ), 'v6' => secupress_get_data_file_path( 'IPv6' ) ];
}

/**
 * Get the country code of a given IP.
 *
 * @since 1.4.5 Handle 32 bits systems.
 * @since 1.0
 *
 * @param (string) $ip An IP address.
 *
 * @return (string|null) A country code. Null if find nothing.
 **/
function secupress_geoip2country( $ip ) {
	global $wpdb;

	if ( filter_var( $ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4 | FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE ) ) {
		$ip2long = sprintf( '%u', ip2long( $ip ) );
	} elseif ( filter_var( $ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6 | FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE ) ) {
		$ip2long = secupress_ipv6_numeric( $ip );
	} else {
		return null;
	}

	return $wpdb->get_var( $wpdb->prepare( "SELECT country_code FROM {$wpdb->prefix}secupress_geoips WHERE begin_ip <= %s AND begin_ip > 0 ORDER BY begin_ip DESC LIMIT 1", $ip2long ) ); // WPCS: unprepared SQL OK.
}