<?php
defined( 'ABSPATH' ) or die( 'Something went wrong.' );


/**
 * Background Bad Themes class.
 *
 * @package SecuPress
 * @since 2.2.6
 */
class SecuPress_Background_Process_Bad_Themes extends WP_Background_Process {

	const VERSION        = '1.0';

	/**
	 * Prefix used to build the global process identifier.
	 *
	 * @var (string)
	 */
	protected $prefix = 'secupress';

	/**
	 * Suffix used to build the global process identifier.
	 *
	 * @var (string)
	 */
	protected $action = 'bad_themes';

	/**
	 * The reference to *Singleton* instance of this class.
	 *
	 * @var (object)
	 */
	protected static $_instance;

	/**
	 * The cron interval
	 *
	 * @var (int)
	 */
	public $cron_interval = 1;


	/**
	 * Get the instance of this class.
	 *
	 * @since 1.0
	 *
	 * @return (object) The *Singleton* instance.
	 */
	final public static function get_instance() {
		if ( ! isset( static::$_instance ) ) {
			static::$_instance = new static;
		}

		return static::$_instance;
	}


	/**
	 * Task: check if a theme exists, has been removed from wp repo, or not updated since 2y
	 *
	 * @param (string) $theme_file
	 *
	 * @return (bool) false to remove the item from the queue.
	 */
	protected function task( $theme_dir ) {
		$url         = 'https://api.wordpress.org/themes/info/1.2/?action=theme_information&fields[sections]=0&fields[contributors]=0&fields[screenshots]=0&fields[tags]=0&fields[versions]=0&fields[banners]=0&fields[donate_link]=0&fields[preview_link]=0&fields[commercial_support_url]=0&fields[repository_url]=0&fields[business_model]=0&fields[added]=0&fields[name]=0&fields[slug]=0&fields[author]=0&fields[author_profile]=0&fields[requires]=0&fields[tested]=0&fields[requires_php]=0&fields[rating]=0&fields[ratings]=0&fields[num_ratings]=0&fields[support_url]=0&fields[support_threads]=0&fields[support_threads_resolved]=0&fields[active_installs]=0&fields[homepage]=0&fields[download_link]=0&fields[upgrade_notice]=0&fields[last_updated]=1&slug=';
		$url        .= $theme_dir;
		$response    = wp_remote_get( $url, ['timeout' => 3] );
		if ( is_wp_error( $response ) ) {
			return false;
		}
		$response    = json_decode( wp_remote_retrieve_body( $response ), true );
		if ( JSON_ERROR_NONE !== json_last_error() ) {
			return false;
		}
		if ( isset( $response['error'] ) ) {
			switch ( $response['error'] ) {
				case 'Theme not found': // DO NOT TRANSLATE
					return false;
				break;

				case 'closed': // DO NOT TRANSLATE
					$themes                 = get_site_option( SECUPRESS_CLOSED_THEMES, [] );
					$themes[ $theme_dir ] = ( isset( $response['closed_date'] ) ? strtotime( $response['closed_date'] ) : time() ) . '|' . esc_html( $response['reason'] );
					update_site_option( SECUPRESS_CLOSED_THEMES, $themes, false );
				break;
			}
		} elseif ( isset( $response['last_updated'] ) && ( strtotime( $response['last_updated'] ) + ( 2 * YEAR_IN_SECONDS ) < time() ) ) {
			$themes                 = get_site_option( SECUPRESS_OLD_THEMES, [] );
			$themes[ $theme_dir ] = strtotime( $response['last_updated'] );
			update_site_option( SECUPRESS_OLD_THEMES, $themes, false );
		}
		return false;
	}

	protected function complete() {
		secupress_scanit( 'Bad_Old_Themes' );
	}

}
