/* global jQuery, ajaxurl, wp.i18n, spSessionsControlL10n, secupressIsSpaceOrEnterKey */
(function($, d, w) {
	spSessionsControlL10n.userId = Number(spSessionsControlL10n.userId);

	// Make notice dismissible.
	function makeNoticeDismissible() {
		$('#secupress-sessions-control-notice').each(function() {
			var $el = $(this),
				$button = $('<button/>', {
					type: 'button',
					class: 'notice-dismiss',
					html: '<span class="screen-reader-text"></span>'
				}),
				btnText = wp.i18n.dismiss || '';

			$button.find('.screen-reader-text').text(btnText);
			$button.on('click.wp-dismiss-notice', function(e) {
				e.preventDefault();
				$el.fadeTo(100, 0, function() {
					$el.slideUp(100, function() {
						$el.remove();
					});
				});
			});

			$el.append($button);
		});
	}

	// Display a notice.
	function displayNotice(r) {
		if (!r.data || !r.data.message) {
			return;
		}

		var $notice = $('#secupress-sessions-control-notice'),
			$title = $('.wrap > h1, .wrap > h2').first();

		if ($notice.length) {
			$notice.removeClass('updated error').addClass(r.success ? 'updated' : 'error').children('p').remove();
			$notice.prepend('<p>' + r.data.message + '</p>');
		} else {
			$notice = $('<div/>', {
				id: 'secupress-sessions-control-notice',
				class: 'updated notice is-dismissible',
				html: '<p>' + r.data.message + '</p>'
			});

			if ($title.length) {
				$title.after($notice);
			} else {
				$('.wrap').first().prepend($notice);
			}

			makeNoticeDismissible();
		}
	}

	// Change cells text.
	function changeCellText($buttons) {
		$buttons.closest('tr').each(function() {
			var id = Number(this.id.replace('user-', '')),
				message = id === spSessionsControlL10n.userId ? spSessionsControlL10n.currentUserCellText : spSessionsControlL10n.otherUsersCellText;

			$(this).children('.column-secupress-sessions').html('<em>' + message + '</em>').find('#user_' + id).prop('checked', false);
		});
	}

	// Disable a button.
	function prepareAjaxCall(e, button) {
		if ("keyup" === e.type && !secupressIsSpaceOrEnterKey(e)) {
			return false;
		}

		var $button = $(button);
		if ($button.hasClass('disabled')) {
			return false;
		}

		$button.addClass('disabled').attr('aria-disabled', 'true');
		e.preventDefault();

		return $button.attr('href') ? $button.attr('href').replace('users.php', 'admin-ajax.php') : false;
	}

	// Bulk actions enhancement.
	$('.bulkactions select').append($('<option/>', {
		value: 'secupress-destroy-user-sessions',
		text: spSessionsControlL10n.destroySessionsText
	}));

	$('.bulkactions select').first().closest('form').on('submit.secupress', function(e) {
		var $this = $(this),
			$buttons = $this.find('[type="submit"]'),
			params = {
				action: 'secupress-destroy-user-sessions',
				_wpnonce: spSessionsControlL10n.bulkNonce,
				users: []
			},
			hasAction = false;

		if ($buttons.first().prop('disabled')) {
			return;
		}

		$.each($this.serializeArray(), function(i, v) {
			if ('action' === v.name || 'action2' === v.name) {
				hasAction = 'secupress-destroy-user-sessions' === v.value;
			} else if ('users[]' === v.name) {
				params.users.push(Number(v.value));
			}
		});

		if (!hasAction || !params.users.length) {
			e.preventDefault();
			return;
		}

		$buttons.addClass('disabled').attr('aria-disabled', 'true');
		e.preventDefault();

		$.getJSON(ajaxurl, params)
			.done(function(r) {
				if (!r || !r.data) {
					return;
				}

				if (r.success) {
					$.each(r.data.ids, function(i, id) {
						changeCellText($('#user-' + id));
					});
				}

				displayNotice(r);
			})
			.always(function() {
				$buttons.removeClass('disabled').attr('aria-disabled', 'false');
			});
	}).find('[type="submit"]').removeClass('disabled').attr('aria-disabled', 'false');

})(jQuery, document, window);
