<?php
/**
 * Plugin Name: SecuPress Pro with Simple SSL – Simple and Performant Security
 * Plugin URI: https://secupress.me
 * Description: More than a plugin, the guarantee of a protected website by experts.
 * Author: SecuPress
 * Author URI: https://secupress.me
 * Version: 2.6
 * Code Name: Makeshift
 * Network: true
 * Contributors: SecuPress, juliobox, GregLone
 * License: GPLv2
 * Domain Path: /languages/
 * Requires at least: 5.4
 * Requires PHP: 7.0
 * Copyright 2012-2026 SecuPress
 * 
 *  ██████╗███████╗ █████╗██╗   ██╗██████╗ ██████╗ ███████╗ ██████╗ ██████╗   ███╗   ███╗███████╗
 * ██╔════╝██╔════╝██╔═══╝██║   ██║██╔══██╗██╔══██╗██╔════╝██╔════╝██╔════╝   ████╗ ████║██╔════╝
 * ███████╗█████╗  ██║    ██║   ██║██████╔╝██████╔╝█████╗  ███████╗███████╗   ██╔████╔██║█████╗  
 * ╚════██║██╔══╝  ██║    ██║   ██║██╔═══╝ ██╔═██╝ ██╔══╝  ╚════██║╚════██║   ██║╚██╔╝██║██╔══╝  
 * ███████║███████╗ █████╗╚██████╔╝██║     ██║  ██╗███████╗███████║███████║██╗██║ ╚═╝ ██║███████╗
 * ╚══════╝╚══════╝ ╚════╝ ╚═════╝ ╚═╝     ╚═╝  ╚═╝╚══════╝╚══════╝ ╚═════╝╚═╝╚═╝     ╚═╝╚══════╝  
 *
 */

defined( 'ABSPATH' ) or die( 'Something went wrong.' );


/** --------------------------------------------------------------------------------------------- */
/** DEAL WITH THE FREE VERSION ================================================================== */
/** ----------------------------------------------------------------------------------------------*/

require_once( plugin_dir_path( __FILE__ ) . 'pro/classes/admin/class-secupress-pro-admin-remove-free-plugin.php' );

SecuPress_Pro_Admin_Remove_Free_Plugin::get_instance( __FILE__ );


/** --------------------------------------------------------------------------------------------- */
/** DEFINES ===================================================================================== */
/** ----------------------------------------------------------------------------------------------*/

// Common constants
if ( ! defined( 'SECUPRESS_FILE' ) ) {
	define( 'SECUPRESS_FILE', __FILE__ );
}
require_once( plugin_dir_path( __FILE__ ) . 'defines.php' );

// Pro
define( 'SECUPRESS_HTTP_LOGS'                 , 'secupress_http_logs' );
define( 'SECUPRESS_MODULE_ALERTS'             , 'secupress_module_alerts' );
define( 'SECUPRESS_PRO_INC_PATH'              , SECUPRESS_PATH . 'pro/' );
define( 'SECUPRESS_PRO_ADMIN_PATH'            , SECUPRESS_PRO_INC_PATH . 'admin/' );
define( 'SECUPRESS_PRO_ADMIN_SETTINGS_MODULES', SECUPRESS_PRO_ADMIN_PATH . 'modules/' );
define( 'SECUPRESS_PRO_CLASSES_PATH'          , SECUPRESS_PRO_INC_PATH . 'classes/' );
define( 'SECUPRESS_PRO_MODULES_PATH'          , SECUPRESS_PRO_INC_PATH . 'modules/' );
define( 'SECUPRESS_CONTENT_SPAM_SCAN'         , 'secupress_content_spam_scan' );
define( 'SECUPRESS_CONTENT_ALLOWED'           , 'secupress_content_allowed' );
define( 'SECUPRESS_MALWARE_SCAN_LAST_TIME'    , 'secupress_malware_scan_last_time' );
define( 'SECUPRESS_PRO_URL'                   , plugin_dir_url( SECUPRESS_FILE ) . 'pro/' );
define( 'SECUPRESS_PRO_MODULES_URL'           , SECUPRESS_PRO_URL . 'modules/' );
define( 'SECUPRESS_PRO_VERSION'               , SECUPRESS_VERSION );


/** --------------------------------------------------------------------------------------------- */
/** INIT ======================================================================================== */
/** ----------------------------------------------------------------------------------------------*/

require_once( SECUPRESS_INC_PATH     . 'secupress.php' );
if ( $secupress_is_playground ) {
	return; // DO NOT LOAD SECUPRESS
}
require_once( SECUPRESS_PRO_INC_PATH . 'functions/pluggable.php' );
require_once( SECUPRESS_PRO_INC_PATH . 'activation.php' );


add_action( 'secupress.loaded', 'secupress_pro_init', 0 );
/**
 * Load the pro version after the free version.
 *
 * @since 1.0
 */
function secupress_pro_init() {
	// Make sure Poedit keeps our plugin headers.
	/** Translators: Plugin Name of the plugin/theme */
	__( 'SecuPress Pro — WordPress Security', 'secupress' );
	/** Translators: Description of the plugin/theme */
	__( 'More than a plugin, the guarantee of a protected website by experts.', 'secupress' );

	// Functions.
	secupress_pro_load_functions();

	// Hooks.
	require_once( SECUPRESS_PRO_INC_PATH . 'common.php' );

	if ( ! is_admin() ) {
		return;
	}

	// Hooks.
	require_once( SECUPRESS_PRO_ADMIN_PATH . 'migrate.php' );

	if ( ! secupress_is_pro() ) {
		return;
	}

	if ( is_admin() ) {
		// Free downgrade.
		SecuPress_Pro_Admin_Free_Downgrade::get_instance();
	}

	require_once( SECUPRESS_PRO_ADMIN_PATH . 'admin.php' );
	require_once( SECUPRESS_PRO_ADMIN_PATH . 'ajax-post-callbacks.php' );
}


/**
 * Include files that contain our functions.
 *
 * @since 1.3
 * @author Grégory Viguier
 */
function secupress_pro_load_functions() {
	static $done = false;

	if ( $done ) {
		return;
	}
	$done = true;

	/**
	 * Require our functions.
	 */
	require_once( SECUPRESS_PRO_INC_PATH . 'functions/deprecated.php' );
	require_once( SECUPRESS_PRO_INC_PATH . 'functions/common.php' );

	if ( ! is_admin() ) {
		return;
	}

	// The Free downgrade class.
	secupress_pro_require_class( 'Admin', 'Free_Downgrade' );
}
