<?php
/**
 * The template for displaying archive pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package digitool
 */

get_header(); 
$term = get_queried_object();
?>

<main id="site-main" class="alignwide" itemscope itemprop="mainEntity" itemtype="http://schema.org/WebPageElement">
	<?php if (function_exists('the_breadcrumb')) the_breadcrumb(); ?>
	<?php
	if ( have_posts() ) : ?>
		<section>
			<article class="entry-content"  itemscope itemtype="http://schema.org/Article">		
				<?php if(get_field('titre', $term)) { ?>
					<header>
						<h1><?php the_field('titre', $term);?></h1>
					</header>
				<?php } else { ?> 
					<h1><?php echo $term->name;?></h1>
				<?php } ?>
				<?php if(get_field('contenu', $term)) { ?>
					<?php the_field('contenu',$term);?>
				<?php } ?>
			</article>
		</section>
		<section class="alignwide">	
			<div  id="articles-list" class="stdGrid col-3 articles-list">
				<?php while ( have_posts() ) : the_post(); ?>
					<article itemscope itemtype="http://schema.org/Article">
						<?php if ( has_post_thumbnail() ) :
							the_post_thumbnail('medium');
						endif; ?>
						<div class="contentBlock" itemprop="articleBody">
							<h2 class="entry-title" itemprop="headline"><a href="<?php the_permalink();?>" rel="bookmark"><?php the_title();?></a></h2>
							<?php the_excerpt(); ?>
							<?php wp_link_pages( array(
								'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'digitool' ),
								'after'  => '</div>',
							) ); ?>
						</div><!-- .entry-content -->
					</article><!-- #post-<?php the_ID(); ?> -->
				<?php endwhile; ?>
			</div>
		</section>						
		<?php if( function_exists('EvPagination')) :
			echo EvPagination();
		endif; 
	endif; ?>
</main><!-- #primary -->

<?php
get_footer();
