/*--------------------------------------------------------------
# Réseaux sociaux
--------------------------------------------------------------*/
document.addEventListener('DOMContentLoaded', function () {
  var reseaux = document.querySelectorAll('.wp-social-link a');
  if(reseaux){
    reseaux.forEach(function (lien) {
      lien.setAttribute('target', '_blank');
    });
  }  
});

/*--------------------------------------------------------------
# Modal : pop-up
--------------------------------------------------------------*/
document.addEventListener( 'DOMContentLoaded', function () {
  // Get DOM Elements
  var fichemodals = document.querySelectorAll('.fichemodal');
  //console.log(modal);
  if (fichemodals != null){
    fichemodals.forEach(function(fichemodal, index) {

      // Generate unique ID for each modal
      var modalId = 'modal-' + index;
      // Get close button within the modal
      var modal = fichemodal.querySelector('.modal');
      modal.setAttribute('id', modalId);

      var modalBTN = fichemodal.querySelector('a');
      modalBTN.setAttribute('href', "#"+modalId);
      
      var closeBtn = modal.querySelector('.close');

      modalBTN.addEventListener('click', function(e) {
        modal.classList.toggle('active');
        ytbLite = document.querySelector("#"+modal.id+' .yt-lite');
        ytbID = ytbLite.getAttribute('data-id');
        console.log(ytbID);
        ytbLite.style.backgroundImage = "url('https://i.ytimg.com/vi/"+ytbID+"/hqdefault.jpg')";
      });

      closeBtn.addEventListener('click', function(e){
        modal.classList.toggle('active');
        ytbLite.style.backgroundImage = "";
        ytbLite.innerHTML = "";
      });
    });
  }
});

/*--------------------------------------------------------------
# Filtre : etablissements
--------------------------------------------------------------*/
document.addEventListener( 'DOMContentLoaded', function () {
  
  filtre = document.querySelector('.filtre');
  if(filtre){    
    const btnMore = document.querySelector('.btn-more .wp-block-button__link');
    let articlesToShow = 6;
    inputPays = document.querySelector('.filtre select[name="pays"]');
    inputVille = document.querySelector('.filtre select[name="ville"]');
    inputNom = document.querySelector('.filtre input[name="nom"]');
    buttonFiltre = document.querySelector('.filtre .wp-block-button__link');
    all_etablissements = document.querySelectorAll('.all_etablissements .type-etablissement');
    errorMessage = document.querySelector('.notfound');
    
    function clearFiltre(e){
      //console.log('changement');
      // Récupérations des établissements et des inputs
      inputPays = document.querySelector('.filtre select[name="pays"]');
      inputVille = document.querySelector('.filtre select[name="ville"]');
      inputNom = document.querySelector('.filtre input[name="nom"]');
    
      var marqueursFiltres = [];
      let rawNom = inputNom.value; // Texte original avec accents 
      let normalizedNom = rawNom.toLowerCase() .normalize("NFD").replace(/[\u0300-\u036f]+/g, "") .replace(/\s+/g, ' ').trim(); 
      valueSearch = normalizedNom;


      if (inputVille && normalizedNom) {
        for (let option of inputVille.options) {
          let optionText = option.innerText.trim(); // ex: "Rezé"
          let optionNormalized = optionText.toLowerCase()
            .normalize("NFD").replace(/[\u0300-\u036f]+/g, "")
            .replace(/\s+/g, ' ').trim();           // ex: "reze"

          if (normalizedNom.includes(optionNormalized)) {
            console.log("Je cherche : " + normalizedNom);
            console.log("Valeur trouvée : " + optionNormalized);
            console.log("Champ trouvé : " + optionText);

            inputVille.value = option.value;

            // Supprimer ville via index dans texte normalisé
            let indexNorm = normalizedNom.indexOf(optionNormalized);
            if (indexNorm !== -1) {
              // Pour retrouver l’index dans le texte original
              const regexAccent = new RegExp(optionText, 'i');
              inputNom.value = rawNom.replace(regexAccent, '').replace(/\s+/g, ' ').trim();
            }

            break;
          }
        }
      }
    
      all_etablissements.forEach(function(etablissement) {
        // Je récupère le marker et la classe unique de l'établissement
        var classes = etablissement.className.split(' ');
        var postClass = classes.find(function(className) {
          return className.startsWith('post-');
        });
        var marker = document.querySelector('.leaflet-marker-pane img.'+postClass);
        //console.log(postClass);
          // Je récupère le nom/ville/pays de l'établissement
        nomEtablissement = etablissement.querySelector('.title');
        nomEtablissementLabel = nomEtablissement.getAttribute('data-label');
        nomEtablissementLabel = nomEtablissementLabel.toLowerCase();
        nomEtablissementLabel = nomEtablissementLabel.normalize("NFD").replace(/[\u0300-\u036f]+/g, "")
        nomEtablissementLabel = nomEtablissementLabel.replace("’", "'");
        //console.log('nomEtablissementLabel :' + nomEtablissementLabel);

        villeEtablissement = etablissement.querySelector('.ville');
        villeEtablissementLabel = villeEtablissement.getAttribute('data-label');
        //console.log('villeEtablissementLabel :' + villeEtablissementLabel);

        paysEtablissement = etablissement.querySelector('.pays');
        if(!paysEtablissement){
          console.log(etablissement);
        }
        paysEtablissementLabel = paysEtablissement.getAttribute('data-label');
        //console.log('paysEtablissementLabel :' + paysEtablissementLabel);
    
        // J'affiche l'établissements
        if(etablissement.classList.contains('desactive')) {
          etablissement.classList.remove('desactive');
          marker.classList.remove('desactive');
        };
    
        // Je rajoute la classe "desactive" à l'établissement et au marker en fonction des critères de recherches :
        // Nom
        //console.log(valueSearch);
        

        if(!etablissement.classList.contains('desactive') && valueSearch != "all" && !nomEtablissementLabel.includes(valueSearch)){
          //console.log('nomEtablissementLabel :' + nomEtablissementLabel);
          etablissement.classList.add('desactive');
          marker.classList.add('desactive');
        }
        
        // Ville
        //console.log(inputVille.value);
        if(!etablissement.classList.contains('desactive') && inputVille.value != "all" && villeEtablissementLabel != inputVille.value){
          etablissement.classList.add('desactive');
          marker.classList.add('desactive');
        }
        
        // Pays
        //console.log(inputPays.value);
        if(!etablissement.classList.contains('desactive') && inputPays.value != "all" && paysEtablissementLabel != inputPays.value){
          etablissement.classList.add('desactive');
          marker.classList.add('desactive');
        }
        if(!etablissement.classList.contains('desactive')){
          //console.log(postClass);
          
          // Loop through all layers of the map
          map.eachLayer(function(layer) {
            // Check if the layer is a marker and it has the desired class
            if (layer instanceof L.Marker && layer.getElement() && layer.getElement().classList.contains(postClass)) {
                // Marker found, assign it to the variable and stop the loop
                marqueursFiltres.push(layer);
            }
          });
        } 
      });
      //console.log(marqueursFiltres);
      return marqueursFiltres[0];
    }
    function showArticles() {
      if(!errorMessage.classList.contains('hidden')){
        errorMessage.classList.add('hidden');
      }
      activeArticles = Array.from(all_etablissements).filter(article => !article.classList.contains('desactive'));
      //console.log(activeArticles);
      activeArticles.forEach((article, index) => {
          if (index < articlesToShow) {
              article.classList.remove('hidden');
          } else {
              article.classList.add('hidden');
          }
      });
      if (activeArticles.length < articlesToShow) {
        btnMore.style.display = "none";
      }
      if (activeArticles.length == 0) {
        errorMessage.classList.remove('hidden');
      }
    }
    // Fonction pour recentrer la carte sur les marqueurs filtrés
    function recentrerCarte() {
      //console.log("je recentre ");
      tabMarker = clearFiltre();      
      if(tabMarker){
        // Get the latitude and longitude of the marker
        var latitude = tabMarker.getLatLng().lat;
        var longitude = tabMarker.getLatLng().lng;
        // Set the view of the map around the marker with an appropriate zoom level
        map.setView([latitude, longitude], 6); // '13' is an example zoom level
      }else{
        // Set the view of the map around the marker with an appropriate zoom level
        map.setView([48.8566, 2.3522], 5); // '13' is an example zoom level
      }
    }
    buttonFiltre.addEventListener('click', function(){
      clearFiltre();
      recentrerCarte();      
      showArticles();
    });
    btnMore.addEventListener('click', function() {
      articlesToShow += 6;
      showArticles();
    });
    inputNom.addEventListener('keydown', function(event){
      if (event.key === 'Enter') {
        clearFiltre();
        recentrerCarte();      
        showArticles();
      }
    });
    // Initial display
    showArticles();
  } 

});

/*--------------------------------------------------------------
# Scroll
--------------------------------------------------------------*/
window.addEventListener('DOMContentLoaded', function() {

  // Sélectionne tous les liens dont l'attribut href commence par #
  var liensAncre = document.querySelectorAll('a[href^="#"]');
  var menu = document.querySelector('.site-header');
  // Parcours de la liste des liens et récupération de leur attribut href
  liensAncre.forEach(function(lien) {
    lien.addEventListener('click', function() {
      setTimeout(() => {
        //console.log("Retardée d'une seconde.");

        // Récupère l'ID de l'ancre cible
        var targetId = this.getAttribute('href').substring(1);

        // Sélectionne l'élément cible par son ID
        var targetElement = document.getElementById(targetId);

        // Vérifie si l'élément cible existe
        if (targetElement) {
          // Récupère les coordonnées de l'élément cible par rapport à la fenêtre
          var targetRect = targetElement.getBoundingClientRect().top + window.pageYOffset;

          // Ajuster le décalage (par exemple, une hauteur de menu fixe)
          const offset = menu.offsetHeight; // Ajustez cette valeur selon vos besoins
          // Faire défiler la page jusqu'à la position ajustée
          window.scrollTo({
              top: targetRect - offset,
              behavior: 'smooth'
          });
        }
      }, 100);  
    });
  });
  // Vérifiez s'il y a une ancre dans l'URL
  const anchor = window.location.hash;
  if (anchor) {
      // Attendre que tout soit chargé
      setTimeout(function() {
          // Sélectionner l'élément d'ancrage
          const element = document.querySelector(anchor);
          //console.log(element);
          if (element) {
            //console.log(element);
              // Simulez le clic sur l'élément
              element.click();
              // Calculer la position de l'élément
              const elementPosition = element.getBoundingClientRect().top + window.pageYOffset;
              // Ajuster le décalage (par exemple, une hauteur de menu fixe)
              const offset = 100; // Ajustez cette valeur selon vos besoins
              // Faire défiler la page jusqu'à la position ajustée
              window.scrollTo({
                  top: elementPosition - offset,
                  behavior: 'smooth'
              });
              //element.click();
          }
      }, 0);
  }
});

document.addEventListener('DOMContentLoaded', function(){
  var rdv = document.querySelector('#rdv');
  //console.log(rdv);
  if(rdv){
    // Récupérer l'élément qui précède l'élément avec l'ID "#rdv"
    var elementPrecedent = rdv.previousElementSibling;

    // Vérifier si l'élément précédent existe et s'il n'a pas la classe "pbottom"
    if (elementPrecedent && !elementPrecedent.classList.contains('pbottom')) {
        // Ajouter la classe "pbottom" à l'élément précédent
        elementPrecedent.classList.add('pbottom');
    }
  }  
});

document.addEventListener('DOMContentLoaded', function(){
  allLinks = document.querySelectorAll('a');
  allLinks.forEach(function(lien) {
    meta = lien.getAttribute('alt');
    if(meta == null){
      lien.setAttribute('alt', lien.innerText);
    }
  });
});

document.addEventListener('DOMContentLoaded', function () {
  var liteVids = document.querySelectorAll('.yt-lite');
  liteVids.forEach(function (lite) {
      lite.addEventListener('click', function () {
          var iframe = document.createElement('iframe');
          iframe.src = 'https://www.youtube.com/embed/' + lite.dataset.id + '?autoplay=1';
          iframe.setAttribute('frameborder', '0');
          iframe.setAttribute('allow', 'accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture');
          iframe.setAttribute('allowfullscreen', 'allowfullscreen');
          this.innerHTML = '';
          this.appendChild(iframe);
      });
  });
});

document.addEventListener("DOMContentLoaded", function () {
  const anchorLinks = document.querySelectorAll('.primary-menu-container a[href^="#"], .primary-menu-container a[href*="#"]');

  anchorLinks.forEach(link => {
    link.addEventListener("click", function () {
      // Vérifie si le lien pointe vers une ancre sur la même page
      const currentURL = window.location.href.split("#")[0];
      const targetURL = link.href.split("#")[0];

      if (currentURL === targetURL) {

        // Si un bouton burger est utilisé
        const burger = document.querySelector("#primary-mobile-menu");
        if (burger) {
          burger.click(); // Simule un clic sur le bouton de fermeture
        }
      }
    });
  });
});

/*--------------------------------------------------------------
# Article : Search article
--------------------------------------------------------------*/
document.addEventListener("DOMContentLoaded", function () {
  const articleFilter = document.querySelector(".post-filter");
  if(articleFilter){
      const searchInput = articleFilter.querySelector('input.name');
      const typeBtn = document.getElementById("typeBtn");
      const typeMenu = document.getElementById("typeMenu");
      const typeInput = document.getElementById("typeInput");
      const typeSelected = document.getElementById("typeSelected");
      const searchButton = articleFilter.querySelector(".wp-block-search__button");

      // Toggle du menu déroulant
      typeBtn.addEventListener("click", function () {
          typeMenu.style.display = (typeMenu.style.display === "block") ? "none" : "block";
      });

      // Choix dans la liste
      typeMenu.querySelectorAll("li").forEach(item => {
          item.addEventListener("click", function () {
              typeInput.value = item.getAttribute("data-value");
              typeSelected.textContent = item.textContent;
              typeMenu.style.display = "none";
          });
      });

      searchInput.addEventListener('keypress', function(e){
        if(e.key === "Enter"){
          searchButton.click();
        }
      });
      // Lancer la recherche
      searchButton.addEventListener("click", function () {
          let url = "/search-post/";
          let params = [];

          if (searchInput.value) params.push(`key=${searchInput.value}`);
          if (typeInput.value) params.push(`type=${typeInput.value}`);

          if (params.length > 0) {
              url += "?" + params.join("&");
          }

          window.location.href = url;
      });

      // Fermer si clic hors du menu
      document.addEventListener("click", function (event) {
          if (!typeBtn.contains(event.target) && !typeMenu.contains(event.target)) {
              typeMenu.style.display = "none";
          }
      });
  }
});
