/*--------------------------------------------------------------
# FAQ
--------------------------------------------------------------*/
document.addEventListener('DOMContentLoaded', function () {
    // 👇️ set `id` attribute on element
    boxs = document.querySelectorAll('.schema-faq');
    //console.log(boxs);
    for (const table of boxs) {
        //console.log(table);
        if(table){
            const cells = table.getElementsByClassName('schema-faq-section');
            for (const cell of cells) {
                document.getElementById(cell.id).onclick = function() {myFunction(cell.id)};
                //console.log(cell.id);
                // Mettre les réponses en display none
                document.querySelector('#'+cell.id + " .schema-faq-question").innerHTML += '<div class="fa-arrow"><i class="fa-solid fa-chevron-right"></i><i class="fa-solid fa-chevron-down"></i></div>';
                document.querySelector("#"+cell.id + " .schema-faq-answer").style.display = "none";
                document.querySelector("#"+cell.id + " .schema-faq-question .fa-chevron-down").style.display = "none";
                document.querySelector("#"+cell.id + " .schema-faq-question .fa-chevron-right").style.display = "flex";
            }
        } 
    };
    faqs = document.querySelectorAll('ul.questions');
    for(const faq of faqs){
        questions = faq.children;
        for(const question of questions){
            questionCible = question.querySelector('a');
            questionCible.addEventListener('click', function(){
                faqCible = this.getAttribute('href').substring(1);
                faqCible = document.querySelector('#'+faqCible);
                faqCible.click();
            });
        }
    }       
});

function myFunction(event)
{
    const element = document.getElementById(event);
    let classEvent = element.getAttribute("class");
    //console.log(classEvent);
    if (classEvent == "schema-faq-section active") {
        document.querySelector('#'+event).classList.remove('active');
        document.querySelector("#"+event + " .schema-faq-answer").style.display = "none";
        document.querySelector("#"+event + " .schema-faq-question .fa-chevron-down").style.display = "none";
        document.querySelector("#"+event + " .schema-faq-question .fa-chevron-right").style.display = "flex";
    } else {
        document.querySelector('#'+event).classList.add('active');
        document.querySelector("#"+event + " .schema-faq-answer").style.display = "block";
        document.querySelector("#"+event + " .schema-faq-question .fa-chevron-right").style.display = "none";
        document.querySelector("#"+event + " .schema-faq-question .fa-chevron-down").style.display = "flex";
    }
}