<?php
/*
 * Fonctions
 * Custom functions, support, custom post types and more.
 *
 * @author: Stéphanie Vachon | @vachon_steph
 * @link https://www.agence-digitool.com
 * @package digitool
 * @since 1.0
 * @version 1.0
 */


/* Fonctions Globals
-----------------------------------------------------------------*/
//include('inc/required_plugins.php');
include('inc/clean.php');
include('inc/enqueues.php');
include('inc/contents.php');
include('inc/digitool.php');

/* Fonctions Components
-----------------------------------------------------------------*/
include('inc/components/breadcrumbs.php');
include('inc/components/menu.php');
include('inc/components/pagination.php');
include('inc/components/images.php');

/* Fonctions Custom Post Type (ex : services)
-----------------------------------------------------------------*/
include('inc/cpt-references.php');
include('inc/cpt-partenaire.php');
include('inc/cpt-questions.php');

// Hooks
add_filter( 'upload_mimes', 'digitool_mime_types' );
add_filter( 'wp_check_filetype_and_ext', 'digitool_file_types', 10, 4 );
//add_action('template_redirect', 'redirect_404_to_home');

// Autoriser l'import des fichiers SVG et WEBP
function digitool_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    $mimes['webp'] = 'image/webp';
    return $mimes;
}

// Contrôle de l'import d'un WEBP
function digitool_file_types( $types, $file, $filename, $mimes ) {
	if ( false !== strpos( $filename, '.webp' ) ) {
    	$types['ext'] = 'webp';
   		$types['type'] = 'image/webp';
	}
	return $types;
}

/* // Redirige les page 404. 
function redirect_404_to_home() {
    if (is_404()) {
        wp_redirect(home_url(), 301);
        exit();
    }
} */


function slugify($text){
    // Remplace les caractères spéciaux par des tirets
    $text = preg_replace('~[^\pL\d]+~u', '-', $text);

    // Convertit les caractères à une lettre vers leurs équivalents ASCII
    $text = fctRetirerAccents($text);

    // Supprime les caractères non désirés
    $text = preg_replace('~[^-\w]+~', '', $text);

    // Supprime les tirets en double
    $text = trim($text, '-');

    // Convertit en minuscules
    $text = strtolower($text);

    if (empty($text)) {
        return 'n-a';
    }

    return $text;
}

function fctRetirerAccents($varMaChaine){
	$search  = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'à', 'á', 'â', 'ã', 'ä', 'å', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ð', 'ò', 'ó', 'ô', 'õ', 'ö', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ');
	//Préférez str_replace à strtr car strtr travaille directement sur les octets, ce qui pose problème en UTF-8
	$replace = array('A', 'A', 'A', 'A', 'A', 'A', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 'a', 'a', 'a', 'a', 'a', 'a', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y');

	$varMaChaine = str_replace($search, $replace, $varMaChaine);
	return $varMaChaine; //On retourne le résultat
}

// Fonction pour afficher un message simple
function mon_shortcode() {
    return "<p>".get_stylesheet_directory_uri()."/assets/images/DD-picto-facebook.svg</p>";
}

function remove_shortcodes_and_inline_styles($content) {
    // Enlever tous les shortcodes
    $content = preg_replace('/\[.*?\]/', '', $content);

    // Enlever les balises <h1>
    $content = preg_replace('/<h1[^>]*>(.*?)<\/h1>/si', '', $content);

    // Enlever les styles inline correspondant à "color"
    $content = preg_replace('/ style=("|\')([^"\']+)?\bcolor\s*:\s*[^"\']*;?([^"\']*)("|\')/i', '', $content);

    return $content;
}

function augmenter_limite_resultats_recherche($query) {
    if ($query->is_search && !is_admin()) {
        $query->set('posts_per_page', -1); // -1 pour afficher tous les résultats
    }
}
add_action('pre_get_posts', 'augmenter_limite_resultats_recherche');

function genererChoixBloc($field) {
    // Récupérez les taxonomies associées au type de publication personnalisé.
    $blocks = get_posts( array(
        'post_type' => [ 'wp_block' ]
    ) );

    // Parcourez le tableau des taxonomies et affichez-les.
    if($blocks != null){
        foreach ($blocks as $block){
        //var_dump($block);
        $name = $block->post_title;
        $id = $block->ID;
        $field['choices'][ $id ] = $name;
    }
    }

    return $field;
}
add_filter('acf/load_field/name=selectionner_le_bloc', 'genererChoixBloc');

function custom_excerpt_more($more) {
    global $post;
    // Vérifiez si le post est de type "question"
    if ($post->post_type == 'question') {
        return '';
    }
    return '... <a class="more-link" href="' . get_permalink($post->ID) . '">' . __('Lire la suite', 'textdomain') . '</a>';
}
add_filter('excerpt_more', 'custom_excerpt_more');


function getYouTubeVideoID($url) {
    // Vérifier si l'URL contient 'youtube.com/embed/'
    $pattern = '/youtube\.com\/embed\/([a-zA-Z0-9_-]+)/i';
    
    // Si on trouve une correspondance, retourner l'ID
    if (preg_match($pattern, $url, $matches)) {
        return $matches[1]; // L'ID est dans le premier groupe capturé
    }
    
    // Retourner null si aucune correspondance n'est trouvée
    return null;
}