<?php
/**
 * The header for our theme
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package digitool
 */

$class = get_field('classe_page');
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="shortcut icon" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/DD-favicon.svg" />
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<!-- Google Tag Manager. -->
	<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
	new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
	j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
	'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
	})(window,document,'script','dataLayer','GTM-T3JNHVN');</script>
	<!-- End Google Tag Manager -->
	<?php wp_head(); ?>
</head>

<body <?php body_class($class); ?>>
	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#primary">
			<?php esc_html_e( 'Passer au contenu', 'digitool' ); 
			$custom_logo_id = get_theme_mod( 'custom_logo' );
			$logo = wp_get_attachment_image_src( $custom_logo_id , 'thumbnail' ); ?>
		</a>
		<header id="masthead" class="site-header" role="banner">
			<div class="wp-block-group alignfull is-nowrap is-layout-flex wp-container-core-group-layout-2 wp-block-group-is-layout-flex">
				<div class="wp-block-site-logo">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="custom-logo-link" rel="home">
						<?php echo digitool_get_the_svg(esc_url( $logo[0] )); ?>
					</a>
				</div>
				<div class="wp-block-group is-content-justification-right is-nowrap is-layout-flex wp-container-core-group-layout-1 wp-block-group-is-layout-flex">
				<?php
					$masque_le_webinaire = get_field('masque_le_webinaire', 'option');
					$lien_webinaire_externe = get_field('lien_webinaire_externe', 'option');
					$lien_webinaire = get_field('lien_webinaire', 'option');
					$masque_les_inscriptions = get_field('masque_les_inscriptions', 'option');
					$lien_inscription_externe = get_field('lien_inscription_externe', 'option');
					$lien_inscrivezvous = get_field('lien_inscrivez-vous', 'option');
					$url = get_bloginfo('url'); ?>

					<div class="wp-block-buttons mobile-hidden is-layout-flex wp-block-buttons-is-layout-flex">
						<div class="wp-block-button <?php echo $masque_le_webinaire[0]; ?>">
							<a href="<?php echo $lien_webinaire; ?>" <?php if($lien_webinaire_externe){ echo 'target="_blank"';} ?> class="wp-block-button__link has-base-color has-primary-background-color has-text-color has-background has-link-color wp-element-button">Assistez au Webinaire <?php echo digitool_get_the_svg($url.'/wp-content/uploads/2024/03/DD-picto-webinaire.svg'); ?></a>
						</div>
						<div class="wp-block-button is-style-fill">
							<a href="/contact/" class="wp-block-button__link has-base-color has-secondary-background-color has-text-color has-background has-link-color wp-element-button" style="border-width:1px">Contactez-nous</a>
						</div>
						<div class="wp-block-button <?php echo $masque_les_inscriptions[0]; ?>">
							<a href="<?php echo $lien_inscrivezvous; ?>" <?php if($lien_inscription_externe){ echo 'target="_blank"';} ?>  class="wp-block-button__link has-base-color has-tertiary-background-color has-text-color has-background has-link-color wp-element-button">Inscrivez-vous</a>
						</div>
					</div>
				
					<nav id="site-navigation" class="primary-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Menu principal', 'digitool' ); ?>">
						<div class="menu-button-container">
							<button id="primary-mobile-menu" class="button" aria-controls="primary-menu-list" aria-expanded="false">
								<span class="dropdown-icon open"><?php esc_html_e( 'Menu', 'digitool' ); ?>
									<span class="burger-menu"><i class="fa-solid fa-bars"></i></span>
								</span>
								<span class="dropdown-icon close"><?php esc_html_e( '', 'digitool' ); ?>
									<span class="burger-menu"><i class="fa-solid fa-xmark"></i></span>
								</span>
							</button><!-- #primary-mobile-menu -->
						</div><!-- .menu-button-container -->
							<div class="primary-menu-container">
								<?php reblex_display_block(14244); ?>
									
								<?php
								$walker = new Menu_With_Description; 
								
								wp_nav_menu(
									array(
										'theme_location'  => 'primary',
										'menu_class'      => 'menu-wrapper',
										'container' => false,
										'items_wrap'      => '<ul id="primary-menu-list" class="%2$s">%3$s </ul>',
										'fallback_cb'     => false, 
										'walker' 		  => $walker
									)
								);
								reblex_display_block(16645);
								?>					
							</div>						
					</nav>
				</div>					
			</div>
		</header>
