<?php
/*
 *  NETTOYAGE DU WORDPRESS // cf. fonctions.php
 */

/* Nettoyage et suppression des liens inutiles du header
-----------------------------------------------------------------*/
add_action( 'init', 'clean_loading' );
function clean_loading() {
  remove_action('wp_head', 'feed_links_extra', 3);
  remove_action('wp_head', 'feed_links', 2);
  remove_action('wp_head', 'rsd_link');
  remove_action('wp_head', 'wlwmanifest_link');
  remove_action('wp_head', 'wp_generator');
  remove_action('wp_head', 'start_post_rel_link', 10, 0);
  remove_action('wp_head', 'parent_post_rel_link', 10, 0);
  remove_action('wp_head', 'index_rel_link');
  remove_action('wp_head', 'adjacent_posts_rel_link', 10, 0);
  remove_action('wp_head', 'wp_shortlink_wp_head', 10, 0);

  // Emojis
  remove_action('admin_print_styles', 'print_emoji_styles');
  remove_action('wp_head', 'print_emoji_detection_script', 7);
  remove_action('admin_print_scripts', 'print_emoji_detection_script');
  remove_action('wp_print_styles', 'print_emoji_styles');
  remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
  remove_filter('the_content_feed', 'wp_staticize_emoji');
  remove_filter('comment_text_rss', 'wp_staticize_emoji');
  add_filter( 'tiny_mce_plugins', 'disable_emojis_tinymce' );
  add_filter( 'wp_resource_hints', 'disable_emojis_remove_dns_prefetch', 10, 2 );

  // Liens posts
  add_filter('index_rel_link', false);
  add_filter('parent_post_rel_link', false);
  add_filter('start_post_rel_link', false);
  add_filter('previous_post_rel_link', false);
  add_filter('next_post_rel_link', false);

  // Supprime les cookies inutiles
  remove_action('set_comment_cookies', 'wp_set_comment_cookies');

  // TEST
  /* remove_action( 'wp_enqueue_scripts', 'wp_enqueue_global_styles' );
  remove_action( 'wp_body_open', 'wp_global_styles_render_svg_filters' ); */
}

/* Nettoyage des commentaires
-----------------------------------------------------------------*/
// Supprime les commentaires sur les médias
function filter_media_comment_status( $open, $post_id ) {
  $post = get_post( $post_id );
  if( $post->post_type == 'attachment' ) {
      return false;
  }
  return $open;
}
add_filter( 'comments_open', 'filter_media_comment_status', 10 , 2 );


add_action('admin_init', function () {
  global $pagenow;
  
  if ($pagenow === 'edit-comments.php') {
      wp_redirect(admin_url());
      exit;
  }

  // Retire les champs commentaires du dashboard
  remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal');

  // Désactive les commentaires dans les post types
  foreach (get_post_types() as $post_type) {
      if (post_type_supports($post_type, 'comments')) {
          remove_post_type_support($post_type, 'comments');
          remove_post_type_support($post_type, 'trackbacks');
      }
  }
});

// Fermer les commentaires sur le front
add_filter('comments_open', '__return_false', 20, 2);
add_filter('pings_open', '__return_false', 20, 2);

// Cacher les commentaires existants
add_filter('comments_array', '__return_empty_array', 10, 2);

// Retirer la page commentaires du menu
add_action('admin_menu', function () {
  remove_menu_page('edit-comments.php');
});

// Retirer le lien vers les commentaires dans la barre admin
add_action('init', function () {
  if (is_admin_bar_showing()) {
      remove_action('admin_bar_menu', 'wp_admin_bar_comments_menu', 60);
  }
});

// Supprimer les commentaires HTML
add_action('get_header', function() {
  ob_start(function($buffer) {
      // Utiliser une expression régulière pour supprimer les commentaires HTML
      $buffer = preg_replace('/<!--(.|\s)*?-->/', '', $buffer);
      return $buffer;
  });
});

add_action('wp_head', function() {
  ob_end_flush();
}, 100);

/* Autres
-----------------------------------------------------------------*/
// Enleve la version des Stylesheets/Scripts
add_filter('script_loader_src', 'remove_src_version');
add_filter('style_loader_src', 'remove_src_version');
function remove_src_version ( $src ) {
  global $wp_version;
  $version_str = '?ver='.$wp_version;
  $version_str_offset = strlen( $src ) - strlen( $version_str );
  if( substr( $src, $version_str_offset ) == $version_str )
    return substr( $src, 0, $version_str_offset );
  else
    return $src;
}

// remove WP-Embed 
function my_deregister_scripts(){
  wp_deregister_script( 'wp-embed' );
}
add_action( 'wp_footer', 'my_deregister_scripts' );

// Supprime users du sitemap.xml
add_filter( 'wp_sitemaps_add_provider', function ($provider, $name) {
  return ( $name == 'users' ) ? false : $provider;
}, 10, 2);

// Met à jour les extensions, le coeur, le theme, et les traductions automatiquement
add_filter( 'auto_update_plugin', '__return_true' );
add_filter( 'auto_update_core', '__return_true' );
add_filter( 'auto_update_theme', '__return_true' );
add_filter( 'auto_update_translation', '__return_true' );

/**
 * Filter function used to remove the tinymce emoji plugin.
 * 
 * @param array $plugins 
 * @return array Difference betwen the two arrays
 */
function disable_emojis_tinymce( $plugins ) {
  if ( is_array( $plugins ) ) {
  return array_diff( $plugins, array( 'wpemoji' ) );
  } else {
  return array();
  }
 }

 /**
 * Remove emoji CDN hostname from DNS prefetching hints.
 *
 * @param array $urls URLs to print for resource hints.
 * @param string $relation_type The relation type the URLs are printed for.
 * @return array Difference betwen the two arrays.
 */
function disable_emojis_remove_dns_prefetch( $urls, $relation_type ) {
  if ( 'dns-prefetch' == $relation_type ) {
  /** This filter is documented in wp-includes/formatting.php */
  $emoji_svg_url = apply_filters( 'emoji_svg_url', 'https://s.w.org/images/core/emoji/2/svg/' );
 
 $urls = array_diff( $urls, array( $emoji_svg_url ) );
  }
 
 return $urls;
 }