<?php
/*
 *  IMAGES // cf. fonctions.php
 */

/* Désactive la création des différents formats d'images en admin
* Ne conserve que la thumbnail par défaut
-----------------------------------------------------------------*/
add_filter( 'intermediate_image_sizes', "onlyThumb", 99 );
function onlyThumb( $array ) {
	if ( is_admin() ) :
  	return array("thumbnail");
	else :
		return $array;
	endif;
}

/* Definitions des tailles d'images
-----------------------------------------------------------------*/
if (function_exists('add_theme_support')) {

	// Qualité des images
	add_filter('jpeg_quality', function() {
		return (int)70;
	});

  add_theme_support('post-thumbnails');

}

/* Ajoute automatiquement le titre de l'image si le alt n'est pas rempli - titre de l'article sinon ? 
-----------------------------------------------------------------*/
// function digitool_add_img_title( $attr, $attachment = null ) {
  
//     $img_title = trim( strip_tags( $attachment->post_title ) );
//     $img_alt = trim( strip_tags( get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true ) ) );
// 	if(empty($img_alt)) {
// 		$attr['alt'] = $img_title;
// 	} else {
// 		$attr['alt'] = $img_alt;
// 	}
//     $attr['title'] = $img_title;

//     return $attr;
// }
// add_filter( 'wp_get_attachment_image_attributes','digitool_add_img_title', 10, 3 );

// /* Nettoie les medias uploadés
// -----------------------------------------------------------------*/
// add_filter( 'sanitize_file_name', 'remove_accents', 10, 1 );
// add_filter( 'sanitize_file_name_chars', 'sanitize_file_name_chars', 10, 1 );
// function sanitize_file_name_chars( $special_chars = array() ) {
// 	$special_chars = array_merge( array( '’', '‘', '“', '”', '«', '»', '‹', '›', '—', 'æ', 'œ', '€' ), $special_chars );
// 	return $special_chars;
// }

function digitool_render_block($block_content, $block) {
    // Vérifiez le type de bloc
    if ($block['blockName'] === 'core/image') {
        // Utiliser une expression régulière pour extraire la balise img
        $pattern = '/<img[^>]+src=["\']([^"\']+)[^>]*alt=["\']([^"\']*)[^>]*>/i';
        preg_match($pattern, $block['innerHTML'], $img);

        // Si l'image a bien un lien
        if (!empty($img)) {
            $imgUrl = esc_url($img[1]);  // Utilisation de esc_url pour nettoyer l'URL
            // Récupère le chemin du ficher image
            $path = str_replace(home_url(), ABSPATH, $imgUrl);
            $chemin_du_fichier = realpath($path);
            
            // Vérifier que le fichier existe
            if ($chemin_du_fichier && file_exists($chemin_du_fichier)) {
                $mime_type = mime_content_type($chemin_du_fichier);
                // Vérifier que l'image est un SVG
                if ($mime_type === 'image/svg+xml') {
                    $svgContent = file_get_contents($path);

                    // Remplacer la balise img par le SVG
                    $newHtml = preg_replace($pattern, $svgContent, $block['innerHTML']);
                    return $newHtml;
                } 
            }
            // Mise à jour de l'attribut 'alt'
            if (!empty($block['attrs']['id'])) {
                $img_ID = $block["attrs"]["id"];
                $img_title = get_the_title($img_ID);
                $img_title = str_replace(array('-', '_'), ' ', $img_title);

                // Remplacer l'attribut 'alt' dans le HTML
                $newHtml = preg_replace('/alt=["\'][^"\']*["\']/', 'alt="' . esc_attr($img_title) . '"', $block['innerHTML']);
                return $newHtml;
            }

        }
    }
    if ($block['blockName'] === 'core/social-link') {
        $urlTheme = get_stylesheet_directory_uri();
        // Utiliser une expression régulière pour extraire la balise img
        preg_match('/<svg[^>]*>(.*?)<\/svg>/s', $block_content, $img);

        //var_dump($urlTheme.'/assets/images/DD-picto-facebook.svg');
        // Si l'image a bien un lien
        if (!empty($img)) {
            switch($block['attrs']['service']){
                case "facebook":
                    $svg = digitool_get_the_svg($urlTheme.'/assets/images/DD-picto-facebook.svg');
                break;
                case "x":
                    $svg = digitool_get_the_svg($urlTheme.'/assets/images/DD-picto-twitter.svg');
                break;
                case "instagram":
                    $svg = digitool_get_the_svg($urlTheme.'/assets/images/DD-picto-instagram.svg');
                break;
                case "linkedin": 
                    $svg = digitool_get_the_svg($urlTheme.'/assets/images/DD-picto-linkedin.svg');
                break;
                case "youtube":
                    $svg = digitool_get_the_svg($urlTheme.'/assets/images/DD-picto-youtube.svg');
                break;
                case "tiktok":
                    $svg = digitool_get_the_svg($urlTheme.'/assets/images/DD-picto-tiktok.svg');
                break;
            }
            if($svg == ""){
                $svg = $block['attrs']['service'];
            }
            //var_dump($svg);

            // Remplacer la balise img par le SVG
            $newHtml = preg_replace('/<svg[^>]*>(.*?)<\/svg>/s', $svg, $block_content);
            return $newHtml;
        }
    }
    return $block_content;
}
add_filter('render_block', 'digitool_render_block', 10, 2);

function digitool_get_the_svg($img){
    // Utilisation de esc_url pour nettoyer l'URL
    $imgUrl = esc_url($img); 
    

    // Récupère le chemin du ficher image
    $homeURL = home_url();

    $path = str_replace($homeURL, ABSPATH, $imgUrl);
    $chemin_du_fichier = realpath($path);
            
    // Vérifier que le fichier existe
    if ($chemin_du_fichier && file_exists($chemin_du_fichier)) {
        $mime_type = mime_content_type($chemin_du_fichier);
        // Vérifier que l'image est un SVG
        if ($mime_type === 'image/svg+xml') {
            $svgContent = file_get_contents($path);
            return $svgContent;
        }
        else{
            return 'erreur';
        } 
    }
}