<?php
/*
 *  MENU // cf. fonctions.php
 */

/* Definition des zones de menu
-----------------------------------------------------------------*/
register_nav_menus( array(
	'primary' => __( 'Principal', 'digitool' ),
	'footer_menu' => __( 'Menu footer', 'digitool' )
) );

// Ajoute les itemprop de schema.org aux menus
add_filter( 'nav_menu_link_attributes', 'add_menu_link_atts', 10, 3 );
function add_menu_link_atts( $atts, $item, $args ) {
  $atts['itemprop'] = 'url';
  return $atts;
}

add_filter( 'nav_menu_attributes', 'add_menu_atts', 10, 3 );
function add_menu_atts( $atts, $item, $args ) {
  $atts['itemprop'] = 'url';
  return $atts;
}

// Ajoute un "page active" sur le current (access)
add_filter( 'nav_menu_link_attributes', 'add_title_active_current', 10, 3 );
function add_title_active_current( $atts, $item, $args ) {
  if ( $item->current == true ) {
    $atts['title'] =$item->title.' - page active';
  }
  return $atts;
}

/* // Ajoute un toggle pour le submenu
function digitool_add_sub_menu_toggle( $output, $item, $depth, $args ) {
	if ( 0 === $depth && in_array( 'menu-item-has-children', $item->classes, true ) ) {

		// Add toggle button.
		$output .= '<button class="sub-menu-toggle" aria-expanded="false" onClick="digitoolExpandSubMenu(this)">';
		$output .= '<span class="icon-plus"> + </span>';
		$output .= '<span class="icon-minus"> - </span>';
		$output .= '<span class="screen-reader-text">' . esc_html__( 'Open menu', 'digitool' ) . '</span>';
		$output .= '</button>';
	}
	return $output;
}
add_filter( 'walker_nav_menu_start_el', 'digitool_add_sub_menu_toggle', 10, 4 ); */

class Menu_With_Description extends Walker_Nav_Menu {
    // Remplacez la fonction de sortie de l'élément de menu pour inclure également la description
    function start_el( &$output, $item, $depth = 0, $args = null, $id = 0 ) {
        $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

        $class_names = $value = '';

        $classes = empty( $item->classes ) ? array() : (array) $item->classes;

        $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args, $depth ) );
        $class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

        $id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args, $depth );
        $id = $id ? ' id="' . esc_attr( $id ) . '"' : '';

        $output .= $indent . '<li' . $id . $value . $class_names .'>';

        $atts = array();
        $atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
        $atts['target'] = ! empty( $item->target )     ? $item->target     : '';
        $atts['rel']    = ! empty( $item->xfn )        ? $item->xfn        : '';
        $atts['href']   = ! empty( $item->url )        ? $item->url        : '';

        $atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );

        $attributes = '';
        foreach ( $atts as $attr => $value ) {
            if ( ! empty( $value ) ) {
                $value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
                $attributes .= ' ' . $attr . '="' . $value . '"';
            }
        }

        $item_output = $args->before;
        $item_output .= '<a'. $attributes .'>';
        /** This filter is documented in wp-includes/post-template.php */
        $item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
        $item_output .= '<span class="description">' . $item->description . '</span>';
        $item_output .= '</a>';
        // Include the description here        
        $item_output .= $args->after;

        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
    }
}
