<?php
/*
 *  PAGINATION // cf. fonctions.php
 */

// Pagination sous la forme : Precedent - 1 - 2 - 3 - Suivant
add_action('init', 'EvPagination');
function EvPagination( $query = false ) {
  global $wp_query;
  if ( !$query ) :
    $query = $wp_query;
  endif;

  $big = 999999999;
  $pagilinks = paginate_links(array(
    'base' => str_replace($big, '%#%', get_pagenum_link($big)),
    'format' => '?paged=%#%',
    'current' => max(1, get_query_var('paged')),
    'total'       => $query->max_num_pages,
    'prev_next'   => true,
    'prev_text'   => __('Page pr&eacute;c&eacute;dente', 'digitool'),
    'next_text'   => __('Page suivante', 'digitool'),
  ));
  $pagination = "<div id='listPagination' role='navigation' itemscope itemtype='http://schema.org/SiteNavigationElement/Pagination'>";
  $pagination .= $pagilinks;
  $pagination .= "</div>";

  $dochtml = new DOMDocument('1.0', 'UTF-8');
  $dochtml->loadHTML(
    '<?xml encoding="UTF-8">' . $pagination,
    LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD
  );
  $pages = $dochtml->getElementsByTagName('a');
  foreach($pages as $page) :
    $page->setAttribute('itemprop', 'relatedLink/pagination');
  endforeach;
  $pagination = $dochtml->saveHTML( $dochtml->getElementByID('listPagination') );
  return $pagination;
}