<?php
/*
 *  Contents // cf. fonctions.php
 */


/* Theme Support
-----------------------------------------------------------------*/

function digitool_setup() {

    // Ajouter le support des menus
    add_theme_support('menus');

    // Ajouter les feed dans l'en-tête
    add_theme_support('automatic-feed-links');

    //Balise title
    add_theme_support( 'title-tag' );

   // Ajout le Thumbnail Theme Support
    add_theme_support('post-thumbnails');

    add_image_size( 'x-small', 200, 9999, false);
    add_image_size( 'small', 400, 9999, false);
    add_image_size( 'medium', 600, 9999, false);
    add_image_size( 'large', 800, 9999, false);
    add_image_size( 'x-large', 1000, 9999, false);
		
  // Ajout du logo 
    add_theme_support( 'custom-logo' );  
}
add_action( 'after_setup_theme', 'digitool_setup' );


/* Fonctions usuelles des articles
-----------------------------------------------------------------*/
function evReadMore() {
	if ( ! is_admin() ) {
		return '<div class="more-link-container"><a class="more-link" href="' . esc_url( get_permalink() ) .'"><span aria-label="' . get_the_title().'">' . 'Lire la suite du contenu' . '</span></a></div>';
	}
}
// Filter the excerpt more link.
add_filter( 'excerpt_more', 'evReadMore' );


/* [SECURITÉ] NETTOIE LES CARACTERES SUR NOTAMMENT LES $_GET ET $_POST
// sanitize_text_field...
-----------------------------------------------------------------*/
function evSanitize($str) {
	if (get_magic_quotes_gpc()) :
		$sanitize = mysqli_real_escape_string(stripslashes($str));
  else :
		$sanitize = mysqli_real_escape_string($str);
	endif;
	return $sanitize;
}


//limitation de l'upload
// function filter_site_upload_size_limit( $size ) {
// 	$size = 5*1024**2;
// 	return $size;
// }
// add_filter( 'upload_size_limit', 'filter_site_upload_size_limit', 20 );


/* Clean url video */
function getYoutubeId($url) {
    $regex = '/(?:youtube(?:-nocookie)?\.com\/(?:[^\/\n\s]+\/\S+\/|(?:v|e(?:mbed)?)\/|\S*?[?&]v=)|youtu\.be\/)([a-zA-Z0-9_-]{11})/mi';
    preg_match($regex, $url, $matches);
    return isset($matches[1]) ? $matches[1] : null;
}

function getVimeoId($url) {
  $regex = '/vimeo\.com\/(?:video\/)?(\d+)/i';
  preg_match($regex, $url, $matches);
  return isset($matches[1]) ? $matches[1] : null;
}


/* Création des blocks Gutenberg/ACF
-----------------------------------------------------------------*/

add_action('acf/init', 'my_acf_init_block_types');
function my_acf_init_block_types() {

  if( function_exists('acf_register_block_type') ) {

    acf_register_block_type(array(
      'name'              => 'test',
      'title'             => __('Bloc test'),
      'description'       => __('Bloc test'),
      'render_template'   => 'template-parts/blocks/test.php',
      'category'          => 'formatting',
      'icon'              => 'admin-customizer',
      'keywords'          => array('test'),
      'mode'              => 'edit',
    ));

    acf_register_block_type(array(
      'name'              => 'interview',
      'title'             => __('Bloc interview'),
      'description'       => __('Bloc interview '),
      'render_template'   => 'template-parts/blocks/interview.php',
      'typesegory'          => 'formatting',
      'icon'              => 'video-alt3',
      'keywords'          => array( 'interview' ),
      'mode' => 'edit',
    ));

    acf_register_block_type(array(
      'name'              => 'video',
      'title'             => __('Bloc Vidéo'),
      'description'       => __('Bloc vidéo '),
      'render_template'   => 'template-parts/blocks/modal.php',
      'typesegory'          => 'formatting',
      'icon'              => 'video-alt3',
      'keywords'          => array( 'modal' ),
      'mode' => 'edit',
    ));

    acf_register_block_type(array(
      'name'              => 'reseaux',
      'title'             => __('Réseaux sociaux'),
      'description'       => __('Bloc pour l\'affichage des réseaux sociaux'),
      'render_template'   => 'template-parts/blocks/reseau.php',
      'typesegory'          => 'formatting',
      'icon'              => 'share',
      'keywords'          => array( 'social' ),
      'mode' => 'edit',
    ));
    
    acf_register_block_type(array(
      'name'              => 'SVG',
      'title'             => __('Transforme SVG'),
      'description'       => __('Bloc pour l\'affichage des SVG'),
      'render_template'   => 'template-parts/blocks/svg.php',
      'typesegory'          => 'formatting',
      'icon'              => 'format-image',
      'keywords'          => array( 'svg' ),
      'mode' => 'edit',
    ));
    acf_register_block_type(array(
      'name'              => 'Map',
      'title'             => __('Affichage Map'),
      'description'       => __('Bloc pour l\'affichage des etablissements'),
      'render_template'   => 'template-parts/blocks/map.php',
      'typesegory'          => 'formatting',
      'icon'              => 'format-image',
      'keywords'          => array( 'map' ),
      'mode' => 'edit',
    ));
    acf_register_block_type(array(
      'name'              => 'faq',
      'title'             => __('faq'),
      'description'       => __('faq'),
      'render_template'   => 'template-parts/blocks/faq.php',
      'typesegory'          => 'formatting',
      'icon'              => 'format-image',
      'keywords'          => array( 'faq' ),
      'mode' => 'edit',
    ));
    acf_register_block_type(array(
      'name'              => 'faq-individuel',
      'title'             => __('faq individuel'),
      'description'       => __('faq avec choix'),
      'render_template'   => 'template-parts/blocks/faq-indiv.php',
      'typesegory'          => 'formatting',
      'icon'              => 'format-image',
      'keywords'          => array( 'faq-indiv' ),
      'mode' => 'edit',
    ));
    acf_register_block_type(array(
      'name'              => 'Témoignages',
      'title'             => __('Témoignages'),
      'description'       => __(''),
      'render_template'   => 'template-parts/blocks/temoignage.php',
      'typesegory'          => 'formatting',
      'icon'              => 'format-image',
      'keywords'          => array( 'temoignage' ),
      'mode' => 'edit',
    ));
    acf_register_block_type(array(
      'name'              => 'Bloc sombre',
      'title'             => __('Bloc sombre'),
      'description'       => __(''),
      'render_template'   => 'template-parts/blocks/sombre.php',
      'typesegory'          => 'formatting',
      'icon'              => 'format-image',
      'keywords'          => array( 'bloc', 'sombre' ),
      'mode' => 'edit',
    ));
    acf_register_block_type(array(
      'name'              => 'Boutons menus',
      'title'             => __('Bloc boutons menus'),
      'description'       => __(''),
      'render_template'   => 'template-parts/blocks/header-btn.php',
      'typesegory'          => 'formatting',
      'icon'              => 'format-image',
      'keywords'          => array( 'bouton', 'menu' ),
      'mode' => 'edit',
    ));
  }
}



/* functions pour lister les taxo/typesegories d'un post 
s'utilise <?php custom_taxonomies_terms_links(); ?>
-----------------------------------------------------------------*/
function custom_taxonomies_terms_links() {
  global $post, $post_id;
  $post = get_post($post->ID);
  $post_type = $post->post_type;
  $taxonomies = get_object_taxonomies($post_type);
  foreach ($taxonomies as $taxonomy) {
    $terms = get_the_terms( $post->ID, $taxonomy );
    
    if ( !empty( $terms ) ) {
      $out = array();
      foreach ( $terms as $term )
      
     echo '<a href="' .get_term_link($term->slug, $taxonomy) .'">'.$term->name.'</a> ';
     
    }
  }
  return;
}

/* Antispam 
-----------------------------------------------------------------*/
function wpdocs_hide_email_shortcode( $atts , $content = null ) {
  if ( ! is_email( $content ) ) {
      return;
  }
  return '<a href="' . esc_url('mailto:' . antispambot( $content ) ) . '">' . esc_html( antispambot( $content ) ) . '</a>';
}
add_shortcode( 'email', 'wpdocs_hide_email_shortcode' );


function genererChoixType($field) {
  // Récupérer les types de publications
  $args = array(
    'public'   => true,
    '_builtin' => false // Cela exclut les types de publications par défaut de WordPress
  );
  $post_types = get_post_types($args, 'objects');

  // Parcourez le tableau des publitypesions et affichez-les.
  if($post_types != null){
    foreach ($post_types as $post_type) {
      // Vérifier si l'auteur du type de publication est vous
      $slug = $post_type->name;
      $name = $post_type->label;
      $name = ucwords($name);
      $field['choices'][ $slug ] = $name;
    }
  }

  return $field;
}
add_filter('acf/load_field/name=type_a_afficher', 'genererChoixType');  