<?php
/* CPT partenaire */
add_action( 'init', 'register_cpt_partenaire', 10 );

function register_cpt_partenaire() {
register_post_type( "partenaire", array (
    'labels' => 
    array (
    'name' => 'partenaires',
    'singular_name' => 'partenaire',
    'add_new' => 'Ajouter',
    'add_new_item' => 'Ajouter un nouveau partenaire',
    'edit_item' => 'Modifier le partenaire',
    'new_item' => 'Nouveau partenaire',
    'view_item' => 'Voir le partenaire',
    'search_items' => 'Chercher un partenaire',
    'not_found' => 'Aucun partenaire trouvé',
    'not_found_in_trash' => 'Aucun partenaire trouvé dans la corbeille',
    'parent_item_colon' => 'partenaire parent :',
    ),
    'description' => '',
    'publicly_queryable' => false,
    'exclude_from_search' => true,
    'map_meta_cap' => true,
    'capability_type' => 'post',
    'public' => false,
    'hierarchical' => false,
    'rewrite' => 
    array (
        'slug' => 'partenaire',
        'with_front' => true,
        'pages' => true,
        'feeds' => true,
    ),
    'has_archive' => false,
    'query_var' => 'partenaire',
    'taxonomies' => array('pays', 'ville', 'academie'),
    'supports' => 
    array (
        0 => 'title',
        1 => 'editor',
        3 => 'thumbnail'
    ),
    'show_in_rest' => true,
    'show_ui' => true,
    'menu_position' => 30,
    'menu_icon' => 'dashicons-admin-page',
    'can_export' => true,
    'show_in_nav_menus' => true,
    'show_in_menu' => true,
    )
    );

    add_rewrite_rule('(.?.+?)/page/?([0-9]{1,})/?$', 'index.php?pagename=$matches[1]&paged=$matches[2]', 'top'); 
}
register_taxonomy('ville', array( 'partenaire'), array(
    'hierarchical' => true,
    'labels' => array(
        'name' => __( 'Ville' ),
        'singular_name' => __( 'Ville' ),
        'search_items' =>  __( 'Rechercher une ville' ),
        'all_items' => __( 'Toutes les villes' ),
        'edit_item' => __( 'Editer les villes' ),
        'update_item' => __( 'Mettre à jour la ville' ),
        'add_new_item' => __( 'Ajouter une nouvelle ville' ),
        'new_item_name' => __( 'Nom de la nouvelle ville' ),
        'menu_name' => __( 'Ville' ),
    ),
        'rewrite' => array(
        'slug' => 'ville'),
        'with_front' => true,
        'hierarchical' => true,
        'show_admin_column' => true,
        'show_ui' => true,
        'show_in_rest' => true,
    )
);

register_taxonomy('academie', array( 'partenaire'), array(
    'hierarchical' => true,
    'labels' => array(
        'name' => __( 'Académies' ),
        'singular_name' => __( 'Académie' ),
        'search_items' =>  __( 'Rechercher une académie' ),
        'all_items' => __( 'Toutes les académies' ),
        'edit_item' => __( 'Editer les académies' ),
        'update_item' => __( 'Mettre à jour l\'académie' ),
        'add_new_item' => __( 'Ajouter une nouvelle académie' ),
        'new_item_name' => __( 'Nom de la nouvelle académie' ),
        'menu_name' => __( 'Académie' ),
    ),
        'rewrite' => array(
        'slug' => 'academie'),
        'with_front' => true,
        'hierarchical' => true,
        'show_admin_column' => true,
        'show_ui' => true,
        'show_in_rest' => true,
    )
);