<?php
/* CPT question */
add_action( 'init', 'register_cpt_question', 10 );

function register_cpt_question() {
register_post_type( "question", array (
    'labels' => 
    array (
    'name' => 'Questions',
    'singular_name' => 'question',
    'add_new' => 'Ajouter',
    'add_new_item' => 'Ajouter une nouvelle question',
    'edit_item' => 'Modifier la question',
    'new_item' => 'Nouvelle question',
    'view_item' => 'Voir la question',
    'search_items' => 'Chercher une question',
    'not_found' => 'Aucune question trouvée',
    'not_found_in_trash' => 'Aucune question trouvée dans la corbeille',
    'parent_item_colon' => 'question parent :',
    ),
    'description' => '',
    'publicly_queryable' => false,
    'exclude_from_search' => false,
    'map_meta_cap' => true,
    'capability_type' => 'post',
    'public' => false,
    'hierarchical' => false,
    'rewrite' => 
    array (
        'slug' => 'question',
        'with_front' => true,
        'pages' => true,
        'feeds' => true,
    ),
    'has_archive' => false,
    'query_var' => 'question',
    'taxonomies' => array('type'),
    'supports' => 
    array (
        0 => 'title',
        1 => 'editor',
        3 => 'thumbnail'
    ),
    'show_in_rest' => true,
    'show_ui' => true,
    'menu_position' => 30,
    'menu_icon' => 'dashicons-admin-page',
    'can_export' => true,
    'show_in_nav_menus' => true,
    'show_in_menu' => true,
    )
    );

    add_rewrite_rule('(.?.+?)/page/?([0-9]{1,})/?$', 'index.php?pagename=$matches[1]&paged=$matches[2]', 'top'); 
}
register_taxonomy('type', array( 'question'), array(
    'hierarchical' => true,
    'labels' => array(
        'name' => __( 'Type' ),
        'singular_name' => __( 'Type' ),
        'search_items' =>  __( 'Rechercher un type' ),
        'all_items' => __( 'Tous les types' ),
        'edit_item' => __( 'Editer les types' ),
        'update_item' => __( 'Mettre à jour le type' ),
        'add_new_item' => __( 'Ajouter un nouveau type' ),
        'new_item_name' => __( 'Nom du nouveau type' ),
        'menu_name' => __( 'Types' ),
    ),
        'rewrite' => array(
        'slug' => 'type'),
        'with_front' => true,
        'hierarchical' => true,
        'show_admin_column' => true,
        'show_ui' => true,
        'show_in_rest' => true,
        'rest_base' => 'type_question',
    )
);