<?php
/* CPT etablissement */
add_action( 'init', 'register_cpt_etablissement', 10 );

function register_cpt_etablissement() {
register_post_type( "etablissement", array (
    'labels' => 
    array (
    'name' => 'Post-bac',
    'singular_name' => 'Post-bac',
    'add_new' => 'Ajouter',
    'add_new_item' => 'Ajouter un nouveau établissement Post-bac',
    'edit_item' => 'Modifier l\'établissement Post-bac',
    'new_item' => 'Nouveau établissement Post-bac',
    'view_item' => 'Voir l\'établissement Post-bac',
    'search_items' => 'Chercher un établissement Post-bac',
    'not_found' => 'Aucun établissement trouvé',
    'not_found_in_trash' => 'Aucun établissement trouvé dans la corbeille',
    'parent_item_colon' => 'établissement parent :',
    ),
    'description' => '',
    'publicly_queryable' => false,
    'exclude_from_search' => true,
    'map_meta_cap' => true,
    'capability_type' => 'post',
    'public' => false,
    'hierarchical' => false,
    'rewrite' => 
    array (
        'slug' => 'etablissement',
        'with_front' => true,
        'pages' => true,
        'feeds' => true,
    ),
    'has_archive' => false,
    'query_var' => 'etablissement',
    'taxonomies' => array('type_etablissement', 'pays'),
    'supports' => 
    array (
        0 => 'title',
        1 => 'editor',
        3 => 'thumbnail'
    ),
    'show_in_rest' => true,
    'show_ui' => true,
    'menu_position' => 30,
    'menu_icon' => 'dashicons-admin-page',
    'can_export' => true,
    'show_in_nav_menus' => true,
    'show_in_menu' => true,
    )
    );

    add_rewrite_rule('(.?.+?)/page/?([0-9]{1,})/?$', 'index.php?pagename=$matches[1]&paged=$matches[2]', 'top'); 
}

register_taxonomy('type_etablissement', array('etablissement'), array(
    'hierarchical' => true,
    'labels' => array(
        'name' => __( 'Types' ),
        'singular_name' => __( 'Type' ),
        'search_items' =>  __( 'Rechercher un type' ),
        'all_items' => __( 'Toutes les types' ),
        'edit_item' => __( 'Editer les types' ),
        'update_item' => __( 'Mettre à jour le type' ),
        'add_new_item' => __( 'Ajouter un nouveau type' ),
        'new_item_name' => __( 'Nom du nouveau type' ),
        'menu_name' => __( 'Types' ),
    ),
        'rewrite' => array(
        'slug' => 'type_etablissement'),
        'with_front' => true,
        'hierarchical' => true,
        'show_admin_column' => true,
        'show_ui' => true,
        'show_in_rest' => true,
    )
);

register_taxonomy('pays', array('etablissement', 'partenaire'), array(
    'hierarchical' => true,
    'labels' => array(
        'name' => __( 'Pays' ),
        'singular_name' => __( 'pays' ),
        'search_items' =>  __( 'Rechercher un pays' ),
        'all_items' => __( 'Toutes les pays' ),
        'edit_item' => __( 'Editer les pays' ),
        'update_item' => __( 'Mettre à jour le pays' ),
        'add_new_item' => __( 'Ajouter un nouveau pays' ),
        'new_item_name' => __( 'Nom du nouveau pays' ),
        'menu_name' => __( 'Pays' ),
    ),
        'rewrite' => array(
        'slug' => 'pays'),
        'with_front' => true,
        'hierarchical' => true,
        'show_admin_column' => true,
        'show_ui' => true,
        'show_in_rest' => true,
    )
);


   
   
 