<?php
function custom_avatar_for_agencetool_users($avatar, $id_or_email, $size, $default, $alt) {
    // Définir l'URL de l'image de profil par défaut pour les utilisateurs agence-tool
    $agencetool_avatar_url = 'https://agencetool.fr/wp-content/uploads/2023/10/agencetool-logo.svg';

    // Vérifier si l'e-mail se termine par @agence-tool.fr
    $email = '';
    if (is_numeric($id_or_email)) {
        $user = get_userdata($id_or_email);
        $email = $user->user_email;
    } elseif (is_object($id_or_email)) {
        if (!empty($id_or_email->user_id)) {
            $user = get_userdata($id_or_email->user_id);
            $email = $user->user_email;
        } elseif (!empty($id_or_email->comment_author_email)) {
            $email = $id_or_email->comment_author_email;
        }
    } else {
        $email = $id_or_email;
    }

    if (str_ends_with($email, '@agence-tool.fr')) {
        // Remplacer l'avatar par défaut par l'avatar de Agence-Tool
        $avatar = "<img alt='{$alt}' src='{$agencetool_avatar_url}' class='avatar avatar-{$size} photo' height='{$size}' width='{$size}' />";
    }

    return $avatar;
}
add_filter('get_avatar', 'custom_avatar_for_agencetool_users', 10, 5);