<?php
/**
 * The main template file
 *
 * @package digitool
 */

get_header(); ?>

<main id="primary" class="site-main ">
	<?php if (function_exists('the_breadcrumb')) the_breadcrumb(); ?>
	<?php if ( have_posts() ) : ?>
		<?php get_template_part('page-actualites'); ?> <!-- Inclut le contenu de page-actualites.php -->
	<?php else : ?>
		<section class="no-results not-found">
			<header class="page-header">
				<h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'digitool' ); ?></h1>
			</header><!-- .page-header -->
			<div class="page-content">
				<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
					<p>
						<?php printf(
							wp_kses(
								/* translators: 1: link to WP admin new post page. */
								__( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'digitool' ),
								array(
									'a' => array(
										'href' => array(),
									),
								)
							),
							esc_url( admin_url( 'post-new.php' ) )
						);
					?></p>
				<?php elseif ( is_search() ) : ?>
					<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'digitool' ); ?></p>
					<?php
						get_search_form();
				else : ?>
					<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'digitool' ); ?></p>
					<?php
						get_search_form();
				endif; ?>
			</div><!-- .page-content -->
		</section><!-- .no-results -->
	<?php endif; ?>
</main><!-- #primary -->

<?php get_footer();
