<?php
/**
 * Template Name: Page actualités
 *
 */
get_header(); ?>
<nav id="nav-breadcrumbs" aria-label="breadcrumbs" class="alignwide">
	<ol id="breadcrumbs" itemscope="" itemtype="http://schema.org/BreadcrumbList">
		<li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem">
			<a itemscope="" itemtype="http://schema.org/Thing" itemprop="item" href="<?php echo get_bloginfo('url'); ?>">Accueil</a>
			<meta itemprop="position" content="1"> 
			<span aria-hidden="true">→</span> 
			<span class="current" aria-current="location" itemscope="" itemtype="http://schema.org/Thing" itemprop="item" itemid="/category/this-page">
				<span itemprop="name">Blog</span>
			</span>
		</li>
	</ol>
</nav>	
<?php if ( have_posts() ) : ?>
	<section class="alignwide">
		<div class="entry-content">			
			<h1 class="page-title">Blog</h1>
		</div>
	</section>
	<section>
		<div class="post-filter alignwide">
			<?php $types = get_terms([
				'taxonomy' => 'post_tag', // 'post_tag' = étiquettes d'articles
				'hide_empty' => true,    // ou true si tu veux ignorer les tags sans article
			]);
			?> 
			<input type="text" class="name" placeholder="Par mots-clés">
			<div class="dropdown">
				<button class="dropdown-toggle" id="typeBtn">
					<span>Par thématique</span>
					<p id="typeSelected"></p>
				</button>
				<ul class="dropdown-menu" id="typeMenu">
					<?php foreach ($types as $type) : ?>
						<li data-value="<?= esc_attr($type->slug); ?>"><?= esc_html($type->name); ?></li>
					<?php endforeach; ?>
				</ul>
				<input type="hidden" name="type" id="typeInput">
			</div>
			<button aria-label="Rechercher" class="wp-block-search__button has-icon wp-element-button" type="submit">Rechercher 
				<svg class="search-icon" viewBox="0 0 24 24" width="24" height="24">
					<path d="M13 5c-3.3 0-6 2.7-6 6 0 1.4.5 2.7 1.3 3.7l-3.8 3.8 1.1 1.1 3.8-3.8c1 .8 2.3 1.3 3.7 1.3 3.3 0 6-2.7 6-6S16.3 5 13 5zm0 10.5c-2.5 0-4.5-2-4.5-4.5s2-4.5 4.5-4.5 4.5 2 4.5 4.5-2 4.5-4.5 4.5z"></path>
				</svg>
			</button>
		</div>
	</section>
	<section class="alignwide" itemscope itemtype="http://schema.org/Article">
		<div id="articles-list" class="stdGrid col-3 articles-list"> 
			<?php $paged = get_query_var('paged') ? get_query_var('paged') : 1;
			$args = array('post_type' => 'post', 'paged' => $paged);
			$loop = new WP_Query( $args );
			while ($loop->have_posts() ) : $loop->the_post(); ?>
				<article itemprop="articleBody">
					<?php if ( has_post_thumbnail() ) : ?>
						<figure class="wp-block-post-featured-image">
							<a href="<?php the_permalink();?>" target="_self"><?php the_post_thumbnail('medium');?></a>
						</figure>
						
					<?php endif; ?>
					<div class="contentBlock">
						<h2 class="entry-title has-text-color has-contrast-color" itemprop="headline"><?php the_title();?></h2>
						<p class="has-text-align-right">Lire la suite</p>
						<?php wp_link_pages( array(
							'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'digitool' ),
							'after'  => '</div>',
						) ); ?>
					</div><!-- .entry-content -->
					<footer class="entry-footer">
					</footer><!-- .entry-footer -->
				</article><!-- #post-<?php the_ID(); ?> -->			
			<?php endwhile; ?>
		</div>
	</section>
	<?php if( function_exists('EvPagination')) :
		echo EvPagination($loop);
	endif; ?>
<?php endif; ?>

<?php
get_footer();
