<?php
/**
 * Template Name: Page Services
 *
 */
get_header(); ?>

<main id="site-main" class="alignwide" itemscope itemprop="mainEntity" itemtype="http://schema.org/WebPageElement">
	<?php if (function_exists('the_breadcrumb')) the_breadcrumb(); ?>
	<section itemscope itemtype="http://schema.org/Article">
		<article class="entry-content" itemscope itemprop="articleBody">
			<?php the_content();?>
		</article>
	</section>
	<section class="alignwide">
		<div id="articles-list" class="stdGrid col-3 articles-list">
			<?php $paged = get_query_var('paged') ? get_query_var('paged') : 1;
			$args = array('post_type' => 'services', 'paged' => $paged);
			$loop = new WP_Query( $args ); 
			
			while ($loop->have_posts() ) : $loop->the_post(); ?>
				<article itemscope itemtype="http://schema.org/Article">
					<?php if ( has_post_thumbnail() ) :
						the_post_thumbnail();
					endif; ?>
					<div class="contentBlock" itemprop="articleBody">
						<h2 class="entry-title" itemprop="headline"><a href="<?php the_permalink();?>" rel="bookmark"><?php the_title();?></a></h2>
						<div class="category-name"></div>
						<?php the_excerpt(); 
						wp_link_pages( array(
							'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'digitool' ),
							'after'  => '</div>',
						) ); ?>
					</div><!-- .entry-content -->
				</article><!-- #post-<?php the_ID(); ?> -->
			<?php endwhile; ?>
		</div>
		<?php if( function_exists('EvPagination')) :
			echo EvPagination($loop);
		endif; ?>
	</section>
</main><!-- #primary -->

<?php get_footer();