<?php
/**
 * Template Name: Recherche Articles
 */

get_header(); ?>
<main id="primary" class="site-main" itemscope itemprop="mainEntity" itemtype="http://schema.org/WebPageElement">
    <nav id="nav-breadcrumbs" aria-label="breadcrumbs" class="alignwide">
        <ol id="breadcrumbs" itemscope="" itemtype="http://schema.org/BreadcrumbList">
            <li itemprop="itemListElement" itemscope="" itemtype="http://schema.org/ListItem">
                <a itemscope="" itemtype="http://schema.org/Thing" itemprop="item" href="https://test5.lagencetool.fr" alt="Accueil">Accueil</a>
                <meta itemprop="position" content="1"> 
                <span aria-hidden="true">→</span> 
                <a itemscope="" itemtype="http://schema.org/Thing" itemprop="item" href="https://test5.lagencetool.fr/actualites" alt="Actualités">Actualités</a>
                <meta itemprop="position" content="2"> 
                <span aria-hidden="true">→</span> 
                <span class="current" aria-current="location" itemscope="" itemtype="http://schema.org/Thing" itemprop="item" itemid="/category/this-page">
                    <span itemprop="name">Recherche article</span>
                </span>
            </li>
        </ol>
    </nav>
	<section>
        <div class="search-results alignwide">
            <h1>Résultats de votre recherche</h1>

            <?php
            $type = isset($_GET['type']) ? sanitize_text_field($_GET['type']) : '';
            $search = isset($_GET['key']) ? sanitize_text_field($_GET['key']) : '';
            

            $args = [
                'post_type' => 'post',
                'posts_per_page' => -1,
                's' => $search,
            ];

            if ($type) {
                $args['tax_query'][] = [
                    'taxonomy' => 'post_tag',
                    'field' => 'slug',
                    'terms' => $type,
                ];
            }

            $query = new WP_Query($args);

            if ($query->have_posts()) :
                echo '<div id="articles-list" class="stdGrid col-3 articles-list">';
                while ($query->have_posts()) : $query->the_post(); ?>
                    <article itemprop="articleBody">
					<?php if ( has_post_thumbnail() ) : ?>
						<figure class="wp-block-post-featured-image">
							<a href="<?php the_permalink();?>" target="_self"><?php the_post_thumbnail('medium');?></a>
						</figure>
						
					<?php endif; ?>
					<div class="contentBlock">
						<h2 class="entry-title has-text-color has-contrast-color" itemprop="headline"><?php the_title();?></h2>
						<p class="has-text-align-right">Lire la suite</p>
						<?php wp_link_pages( array(
							'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'digitool' ),
							'after'  => '</div>',
						) ); ?>
					</div><!-- .entry-content -->
					<footer class="entry-footer">
					</footer><!-- .entry-footer -->
				</article><!-- #post-<?php the_ID(); ?> -->	
                <?php endwhile;
                echo '</div>';
            else :
                echo "<p>Aucun article trouvé.</p>";
            endif;

            wp_reset_postdata();
            ?>
        </div>
    </section>	
</main><!-- #primary -->

<?php get_footer(); ?>
