<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package digitool
 */

get_header(); 
$search = get_search_query();
?>
<main id="primary" class="site-main">
	<?php if (function_exists('the_breadcrumb')) the_breadcrumb(); ?>

	<div class="wp-block-group alignwide">
			<header class="page-header">
				<h1 class="page-title"><?php
					printf( esc_html__( 'Résultats pour: %s', 'digitool' ), '<span>' . get_search_query() . '</span>' );
				?></h1>
			</header><!-- .page-header -->
	<?php 

	// Récupérer l'URL de la page référente
	$referer = wp_get_referer();
	
	// Vérifier si la page référente contient "f-a-q"
	if (strpos($referer, 'f-a-q') !== false) {
		$args = [
			'post_type' => [ 'question' ],
			'nopaging' => true,
			's' => $search,
		];
		// The Query
		$questions = new WP_Query( $args );

		// The Loop...
		if ( $questions->have_posts() ) {
			while ( $questions->have_posts() ) {
				$questions->the_post(); 
				$excerpt = get_the_excerpt();
				$question_text = get_the_title();
				$question_id = sanitize_title($question_text); ?>
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<?php the_title( sprintf( '<h2 class="entry-title">', esc_url( get_permalink() ) ), '</h2>' ); ?>
					<div class="entry-summary">
						<?php echo $excerpt; ?>
						<div class="more-link-container"><a class="more-link" href="<?php echo get_bloginfo('url');?>/f-a-q/#faq-question-<?php echo $question_id; ?>"><span aria-label="<?php echo $question_text; ?>">Lire la suite du contenu</span></a></div>
					</div><!-- .entry-summary -->

				</article><!-- #post-<?php the_ID(); ?> -->
			<?php }
		} else {
			// no posts found
			echo "<p>Il n'y a aucun résultat.</p>";
		}		
	} else {
		if ( have_posts() ) : 
			while ( have_posts() ) : the_post(); 
				$postType = get_post_type();
				if($postType != 'question') :
					$title = get_the_title();
					if (strpos($title, 'Merci') === false && strpos($title, 'Remerciement') === false) :?>	
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<h2 class="entry-title"><a href="<?php echo get_the_permalink();?>"><?php echo get_the_title(); ?></a></h2>
						<div class="entry-summary">
							<?php the_excerpt(); ?>
							<div class="more-link-container"><a class="more-link" href="<?php echo get_the_permalink(); ?>">Lire la suite</a></div>
						</div><!-- .entry-summary -->
					</article><!-- #post-<?php the_ID(); ?> -->
					<?php endif;
				else: ?>					
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<?php the_title( sprintf( '<h2 class="entry-title">', esc_url( get_permalink() ) ), '</h2>' ); ?>
						<div class="entry-summary">
							<?php the_content(); ?>
							
						</div><!-- .entry-summary -->
					</article><!-- #post-<?php the_ID(); ?> -->
				<?php endif;
			endwhile;
			the_posts_navigation(); ?>
		<?php else :
			echo "<p>Il n'y a aucun résultat.</p>";
		endif; 
	}?>

</main><!-- #primary -->

<?php
get_footer();
