<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package sarangie
 */

get_header(); ?>

<main id="primary" class="site-main" itemscope itemprop="mainEntity" itemtype="http://schema.org/WebPageElement">
    <?php if (function_exists('the_breadcrumb')) the_breadcrumb(); ?>
	<section>
		<?php while ( have_posts() ) : the_post(); ?>
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> itemscope itemtype="http://schema.org/Article">
				<div class="entry-content" itemprop="articleBody">
					<div class="wp-block-group alignfull has-global-padding is-layout-constrained" style="margin: 2rem auto;">
                        <div class="wp-block-columns alignwide is-layout-flex wp-block-columns-is-layout-flex">
                            <div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:66.66%">
                            <p class="date"><?php echo get_the_date(); ?></p>
                            <h1><?php echo the_title(); ?></h1>
                            <!-- Début : A activer ou non depuis le back office -->
                            <?php $post_ID = get_the_ID();
                            $activeThumbnail = get_field('afficher_limage_mis_en_avant', $post_ID);
                            //var_dump($activeThumbnail);
                            if($activeThumbnail): ?>
                            <figure style="margin-bottom:0;" class="wp-block-post-featured-image">
                                <img src="<?php echo the_post_thumbnail_url(); ?>" alt="">
                            </figure> 
                            <?php endif; ?>
                            <!-- Fin : A activer ou non depuis le back office -->
                            <?php the_content(); ?>
                            </div>
                            <div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow has-lightgreen-background-color" style="flex-basis:33.33%">
                                <div class="post-filter">
                                    <?php $types = get_terms([
                                        'taxonomy' => 'post_tag', // 'post_tag' = étiquettes d'articles
                                        'hide_empty' => true,    // ou true si tu veux ignorer les tags sans article
                                    ]);
                                    ?> 
                                    <input type="text" class="name" placeholder="Par mots-clés">
                                    <div class="dropdown">
                                        <button class="dropdown-toggle" id="typeBtn">
                                            <span>Par thématique</span>
                                            <p id="typeSelected"></p>
                                        </button>
                                        <ul class="dropdown-menu" id="typeMenu">
                                            <?php foreach ($types as $type) : ?>
                                                <li data-value="<?= esc_attr($type->slug); ?>"><?= esc_html($type->name); ?></li>
                                            <?php endforeach; ?>
                                        </ul>
                                        <input type="hidden" name="type" id="typeInput">
                                    </div>
                                    <button aria-label="Rechercher" class="wp-block-search__button has-icon wp-element-button" type="submit">Rechercher 
                                        <svg class="search-icon" viewBox="0 0 24 24" width="24" height="24">
                                            <path d="M13 5c-3.3 0-6 2.7-6 6 0 1.4.5 2.7 1.3 3.7l-3.8 3.8 1.1 1.1 3.8-3.8c1 .8 2.3 1.3 3.7 1.3 3.3 0 6-2.7 6-6S16.3 5 13 5zm0 10.5c-2.5 0-4.5-2-4.5-4.5s2-4.5 4.5-4.5 4.5 2 4.5 4.5-2 4.5-4.5 4.5z"></path>
                                        </svg>
                                    </button>
                                </div>
                                <div class="related_posts">
                                <?php
                                $current_post_id = get_the_ID();
                                $tags = wp_get_post_tags($current_post_id);

                                if ($tags) {
                                    // S'il y a des tags, on récupère les articles ayant ces tags
                                    $tag_ids = array();

                                    foreach ($tags as $tag) {
                                        $tag_ids[] = $tag->term_id;
                                    }

                                    $args = array(
                                        'tag__in' => $tag_ids,
                                        'post__not_in' => array($current_post_id),
                                        'posts_per_page' => 3,
                                    );
                                } else {
                                    // Sinon, on récupère les 3 derniers articles (hors article courant)
                                    $args = array(
                                        'post__not_in' => array($current_post_id),
                                        'posts_per_page' => 3,
                                    );
                                }

                                $related_posts = new WP_Query($args);

                                if ($related_posts->have_posts()) :
                                    while ($related_posts->have_posts()) : $related_posts->the_post(); ?>
                                        <article itemprop="articleBody">
                                            <figure class="wp-block-post-featured-image">
                                                <a href="<?php the_permalink(); ?>" target="_self" alt="">
                                                    <?php if (has_post_thumbnail()) {
                                                        the_post_thumbnail('medium');
                                                    } ?>
                                                </a>
                                            </figure>
                                            <div class="contentBlock">
                                                <h3 class="entry-title has-text-color has-contrast-color" itemprop="headline">
                                                    <?php the_title(); ?>
                                                </h3>
                                                <p class="has-text-align-right">Lire la suite</p>
                                            </div>
                                            <footer class="entry-footer"></footer>
                                        </article>
                                    <?php endwhile;
                                    wp_reset_postdata();
                                endif;
                                ?>
                                </div>

                            </div>
                        </div>						
					</div>
				</div><!-- .entry-content -->
			</article><!-- #post-<?php the_ID(); ?> -->
			<?php the_post_navigation(
				array(
					'next_text' => '<p class="meta-nav wp-block-button__link has-first-background-color">' . esc_html__( 'Page suivante', 'sarangie' ). '</p>',
					'prev_text' => '<p class="meta-nav wp-block-button__link has-first-background-color">' . esc_html__( 'Page précédente', 'sarangie' ) . '</p>',
				)
			); 
		endwhile; ?>			
	</section>	
</main><!-- #primary -->

<?php get_footer();
