<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package sarangie
 */

get_header(); ?>

<main id="primary" class="site-main" itemscope itemprop="mainEntity" itemtype="http://schema.org/WebPageElement">
<?php if (function_exists('the_breadcrumb')) the_breadcrumb(); ?>
	<section>
		<?php while ( have_posts() ) : the_post(); ?>
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> itemscope itemtype="http://schema.org/Article">
				<div class="entry-content" itemprop="articleBody">
					<div class="wp-block-group alignwide has-global-padding is-layout-constrained" style="margin: 2rem auto;">
						<p class="date"><?php echo get_the_date(); ?></p>
						<h1><?php echo the_title(); ?></h1>
						<figure style="margin-bottom:0;" class="wp-block-post-featured-image">
							<img src="<?php echo the_post_thumbnail_url(); ?>" alt="">
						</figure> 
						<?php the_content(); ?>
					</div>
				</div><!-- .entry-content -->
			</article><!-- #post-<?php the_ID(); ?> -->
			<?php the_post_navigation(
				array(
					'next_text' => '<p class="meta-nav wp-block-button__link has-first-background-color">' . esc_html__( 'Page suivante', 'sarangie' ). '</p>',
					'prev_text' => '<p class="meta-nav wp-block-button__link has-first-background-color">' . esc_html__( 'Page précédente', 'sarangie' ) . '</p>',
				)
			); 
		endwhile; ?>			
	</section>	
</main><!-- #primary -->

<?php get_footer();
