<?php
/**
 * Template Name: Plan de site
 *
 */
get_header();
?>

<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
	<main id="site-main" itemscope itemprop="mainEntity" itemtype="http://schema.org/WebPageElement">
		<section id="primary" role="article" itemscope itemtype="http://schema.org/Article">
			<div id="sitemap" class="entry-content alignwide" itemprop="articleBody">
				<?php if (function_exists('the_breadcrumb')) the_breadcrumb(); ?>

				<h1>Plan du site</h1>		
				<?php the_content(); ?>

				<h2>Pages :</h2>
				<ul>
					<?php wp_list_pages("title_li=&sort_column=menu_order" ); ?>
				</ul>

				<h2>Nos services :</h2>
				<ul>
					<?php $services_query = new WP_Query('showposts=100&orderby=menu_order&post_type=services');
					while ($services_query->have_posts()) : $services_query->the_post(); ?>
						<li><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></li>
					<?php endwhile; ?>
				</ul>
					
				<h2>Actualités :</h2>				
				<ul>
					<?php $actus_query = new WP_Query('showposts=100&orderby=date&post_type=post');
					while ($actus_query->have_posts()) : $actus_query->the_post(); ?>
						<li><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></li>
					<?php endwhile; ?>
				</ul>
			</div><!-- .entry-content -->
		</section>
	</main>
<?php endwhile; endif; 

get_footer(); ?>
