<?php
// Récupérer tous les termes de la taxonomie "type"
$terms = get_terms( array(
    'taxonomy' => 'type',
    'hide_empty' => false,
));
if($terms):?>

<div class="classement alignwide">
    <div class="grid">
        <?php // Commencer la boucle des termes
        foreach ($terms as $term) : ?>
            
            <div class="group-<?php echo $term->slug; ?>">
                <p class="title"><a href="#<?php echo $term->slug; ?>"><?php echo $term->name; ?></a></p>
                <?php // Arguments de la requête pour récupérer les questions associées à ce terme
                $args = array(
                    'post_type' => 'question',
                    'posts_per_page' => -1,
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'type',
                            'field' => 'slug',
                            'terms' => $term->slug,
                        ),
                    ),
                );
                
                // Récupérer les questions avec WP_Query
                $questions_query = new WP_Query($args);

                // Vérifier si des questions existent pour ce terme
                if ($questions_query->have_posts()) {
                    echo "<ul class='questions'>";
                    // Commencer la boucle des questions
                    while ($questions_query->have_posts()) {
                        $questions_query->the_post();
                        $question_text = get_the_title();
                        $answer_text = get_the_content();
                        $question_id = sanitize_title($question_text); // Utilisez la question comme ID (assurez-vous qu'elle est unique)

                        // Afficher la question avec un lien vers l'ancre correspondante
                        echo '<li><a href="#faq-question-'. $question_id . '">' . $question_text . '</a></li>';
                    }
                    echo "</ul>";
                }
                // Réinitialiser la requête
                wp_reset_postdata();?>

            </div>

        <?php endforeach; ?>
    </div>
    <div class="faq">
        <?php foreach ($terms as $term) : ?>            
            <div id="<?php echo $term->slug; ?>" class="wp-block-group alignwide">
                <h3><?php echo $term->name; ?></h3>
                <?php // Arguments de la requête pour récupérer les questions associées à ce terme
                $args = array(
                    'post_type' => 'question',
                    'posts_per_page' => -1,
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'type',
                            'field' => 'slug',
                            'terms' => $term->slug,
                        ),
                    ),
                );
                
                // Récupérer les questions avec WP_Query
                $questions_query = new WP_Query($args);

                // Vérifier si des questions existent pour ce terme
                if ($questions_query->have_posts()) {
                    echo "<div class='schema-faq wp-block-yoast-faq-block full'>";
                    // Commencer la boucle des questions
                    while ($questions_query->have_posts()) {
                        $questions_query->the_post();
                        $question_text = get_the_title();
                        $answer_text = get_the_content();
                        $question_id = sanitize_title($question_text); // Utilisez la question comme ID (assurez-vous qu'elle est unique)

                        // Afficher la question avec un lien vers l'ancre correspondante
                        echo '<div id="faq-question-'. $question_id.'" class="schema-faq-section">';
                            echo '<strong class="schema-faq-question">'.$question_text.'</strong>';
                            echo '<div class="schema-faq-answer">'.$answer_text.'</div>';
                        echo '</div>';
                    }
                    echo "</div>";
                }
                // Réinitialiser la requête
                wp_reset_postdata();?>

            </div>

        <?php endforeach; ?>
    </div>
<?php endif;

// Réinitialiser la requête
wp_reset_postdata(); ?>

</div>
