<?php 
$category_terms = get_terms('categories-biens');
$type_terms = get_terms('types-biens');
$ville_terms = get_terms('villes-biens');
$ref_terms = get_terms('references-biens');
$minBudget = getBudget('min');
$maxBudget = getBudget('max');
$minSurface = getSurface('min');
$maxSurface = getSurface('max');
$biens = get_posts( array(
    'post_type' => 'biens',
    'posts_per_page' => -1,) );
?>
<form class="filters alignfull" id="filtrebiens" method="post">
    <!-- Ajoutez ici les champs de formulaire nécessaires -->
    <div class="wp-group">
        <label for="category">Je souhaite</label>
        <select id="category" name="category">
            <option value="">Sélectionner...</option>
            <?php foreach ($category_terms as $category) : ?>
                <option value="<?php echo $category->term_id; ?>">
                <?php if($category->name == "Location"):
                    echo "Louer";
                else: 
                    echo "Acheter"; 
                endif;?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="wp-group">
        <label for="type">Un / Une</label>
        <select id="type" name="type">
            <option value="">Sélectionner...</option>
            <?php foreach ($type_terms as $type) : ?>
                <option value="<?php echo $type->term_id; ?>"><?php echo $type->name; ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="wp-group">
        <label for="ville">Où ?</label>
        <div class="multiselect">
            <input type="text" class="form-control" id="dropdownToggle" placeholder="Sélectionner...">
            <i class="fa-solid fa-chevron-down"></i>
            <ul class="checkbox-list">
            <?php foreach ($ville_terms as $ville) : ?>
                <li>
                <input type="checkbox" value="<?php echo $ville->term_id; ?>">
                <label for="option1"><?php echo $ville->name; ?></label>
                </li>
            <?php endforeach; ?>
            </ul>
        </div>
    </div>
    <div class="wp-group range flex">
        <label for="budget">Budget</label>
        <div class="rangecontainer">
            <div class="slider-track"></div>
            <input type="range" class="budget" name="budgetmin" min="<?php echo $minBudget; ?>" max="<?php echo $maxBudget; ?>" value="<?php echo $minBudget; ?>" step="10" id="slider1">
            <input type="range" class="budget" name="budgetmax" min="<?php echo $minBudget; ?>" max="<?php echo $maxBudget; ?>" value="<?php echo $maxBudget; ?>" step="10" id="slider2">
        </div>
        <p class="printvalue"><span id="range1"><?php echo number_format($minBudget, 0, ',', ' '); ?></span>€ - <span id="range2"><?php echo number_format($maxBudget, 0, ',', ' '); ?></span>€</p>
    </div>
    <div class="wp-group">
        <label for="reference">Référence</label>
        <select id="reference" name="reference">
            <option value="">Sélectionner...</option>
            <?php foreach ($ref_terms as $ref) : ?>
                <option value="<?php echo $ref->term_id; ?>"><?php echo $ref->name; ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <input class="wp-block-button__link" type="submit" value="Rechercher">
    <div class="wp-group morefilters">
        <div class="wp-group range flex">
            <label for="surface">Surface</label>
            <div class="rangecontainer">
                <div class="slider-track"></div>
                <input type="range" class="surface" name="surfacemin" min="<?php echo $minSurface; ?>" max="<?php echo $maxSurface; ?>" value="<?php echo $minSurface; ?>" step="10" id="slider1">
                <input type="range" class="surface" name="surfacemax" min="<?php echo $minSurface; ?>" max="<?php echo $maxSurface; ?>" value="<?php echo $maxSurface; ?>" step="10" id="slider2">
            </div>
            <p class="printvalue"><span id="range1"><?php echo number_format($minSurface, 0, ',', ' '); ?></span> m2 - <span id="range2"><?php echo number_format($maxSurface, 0, ',', ' '); ?></span> m2</p>
        </div>
        <div class="wp-group flex view">
            <p class="gridview active"><i class="fa-solid fa-grip"></i></p>
            <p class="listview"><i class="fa-solid fa-list"></i></p>
        </div>
        <div class="wp-group">
            <select id='orderby' class="tri-select">
                <option value="default">Trier par</option>
                <option value="title_asc">Titre (A-Z)</option>
                <option value="title_desc">Titre (Z-A)</option>
                <option value="date_desc">Date (plus récent)</option>
                <option value="date_asc">Date (la plus ancienne)</option>
                <option value="price_asc">Prix croissant</option>
                <option value="price_desc">Prix décroissant</option>
            </select>
        </div>
    </div>
</form>
<div style="margin: auto;" id="resultats" class="typeview alignwide grid">
    
</div>
<script>
    </script>