<?php
/**
 * Modal Block Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during backend preview render.
 * @param   int $post_id The post ID the block is rendering content against.
 *          This is either the post ID currently being displayed inside a query loop,
 *          or the post ID of the post hosting this block.
 * @param   array $context The context provided to the block by the post or it's parent block.
 */

$miniature = get_field( 'miniature' );
$video = get_field('videoYTB');
$titre = get_field('titre_interview');
$texte = get_field('texte_interview');
$videoID = getYouTubeVideoID($video);
?> 

<div class="fichemodal">
    <a href="#">
        <img src="<?php echo $miniature; ?>" alt="">
        <div class="wp-block-group has-global-padding is-layout-constrained wp-block-group-is-layout-constrained" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
            <div class="wp-block-group is-vertical is-layout-flex wp-block-group-is-layout-flex" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0">
                <h3><?php echo $titre; ?></h3>
                <p><?php echo $texte; ?></p>
            </div>
            <p class="has-text-align-right">Voir la vidéo</p>
        </div>
    </a>
    <div id="my-modal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <span class="close">&times;</span>
            </div>
            <div class="yt-lite" data-id="<?php echo $videoID; ?>">
                <div class="play-button"></div>
            </div>
        </div>
    </div>
</div>