<?php
// Récupérer le type de post
$post_type = get_field('type_a_afficher');
$args = array(
    'post_type' => $post_type, // Nom du CPT
    'posts_per_page' => -1, // Récupérer tous les établissements
);

// Valeurs global à initialiser
$all_villes = array();
$all_pays = array();
// Créer un tableau pour stocker les données des marqueurs
$markers_data = array();
// Tableau de correspondance pour les noms de mois
$months_fr = array(
    'January' => 'janvier',
    'February' => 'février',
    'March' => 'mars',
    'April' => 'avril',
    'May' => 'mai',
    'June' => 'juin',
    'July' => 'juillet',
    'August' => 'août',
    'September' => 'septembre',
    'October' => 'octobre',
    'November' => 'novembre',
    'December' => 'décembre'
);

// Boucle traditionnel 
$query = new WP_Query($args);
// Vérifier s'il y a des établissements
if ($query->have_posts()) { 
    while ($query->have_posts()) {
        $query->the_post();

        // Récupérer les données nécessaires pour chaque type de poste
        $post_id = get_the_ID();
        $title = get_the_title();
        $titleSlug = slugify($title);
        $pays = get_the_terms($post_id, 'pays');
        $paysName = $pays[0]->name;
        $paysSlug = $pays[0]->slug;

        $lat = get_post_meta($post_id, 'latitude', true); // Changer 'latitude' par le nom du champ contenant la latitude
        $lng = get_post_meta($post_id, 'longitude', true); // Changer 'longitude' par le nom du champ contenant la longitude

        // Récupérer les champs propre aux partenaires
        if($post_type === "partenaire"){

            $prof = get_field('p_prof_nom', $post_id);
            $mail = get_field('p_prof_email', $post_id);
            $permalink = get_field('p_lien', $post_id);
            $tel = get_field('p_telephone', $post_id);
            $ville = get_post_meta($post_id, 'p_ville', true);

            // Date au format initial
            $date_str = get_field('p_date_info', $post_id);
            $date_format_fr = "";
            if ($date_str) {
                // Convertir en objet DateTime
                $date_obj = DateTime::createFromFormat('Ymd', $date_str);
                $today = new DateTime();
                if ($date_obj >= $today) {
                    $dateCode = true;
                } else {
                    $dateCode = false;
                }
                // Formater la date en "jour mois année" en français
                $day = $date_obj->format('j');
                $month_en = $date_obj->format('F');
                $month_fr = $months_fr[$month_en];
                $year = $date_obj->format('Y');

                $date_format_fr = "$day $month_fr $year";
                //var_dump($date_format_fr);
            }

        } // Récupérer les champs propre aux établissements
        else{
            $permalink = get_field('e_site_internet', $post_id);
            $ville = get_post_meta($post_id, 'e_ville', true);

            $typesEtablissement = get_the_terms($post_id, 'type_etablissement');
            $typeName = "";
            $typeSlug = "";
            foreach($typesEtablissement as $typeEtablissement){
                $typeName.= $typeEtablissement->name.", ";
                $typeSlug.= $typeEtablissement->slug.", ";
            }
            $typeName = substr($typeName, 0, -2);
            $typeSlug = substr($typeSlug, 0, -2);
            
        }

        $villeSlug = slugify($ville);
        // Vérifier si l'entrée existe déjà
        if (!isset($all_villes[$villeSlug])) {
            // Si elle n'existe pas, ajouter un tableau vide
            $all_villes[$villeSlug]= $ville;
        }

        // Vérifier si l'entrée existe déjà
        if (!isset($all_pays[$paysSlug])) {
            // Si elle n'existe pas, ajouter un tableau vide
            $all_pays[$paysSlug]= $paysName;
        }

        if($post_type === "partenaire"){
            // Ajouter les données des partenaires au tableau des marqueurs
            $markers_data[] = array(
                'id' => $post_id,
                'title' => $title,
                'titleSlug' => $titleSlug,
                'mail' => $mail,
                'prof' => $prof,
                'permalink' => $permalink,
                'tel' => $tel,
                'telFormatted' => str_replace(' ', '', $tel),
                'date' => $date_format_fr,
                'dateCode' => $dateCode,
                'paysName' => $paysName,
                'paysSlug' => $paysSlug,
                'ville' => $ville,
                'villeSlug' => $villeSlug,
                'lat' => $lat,
                'lng' => $lng,
            );
        }else{
            // Ajouter les données des établissements au tableau des marqueurs
            $markers_data[] = array(
                'id' => $post_id,
                'title' => $title,
                'titleSlug' => $titleSlug,
                'permalink' => $permalink,
                'typeName' => $typeName,
                'typeSlug' => $typeSlug,
                'paysName' => $paysName,
                'paysSlug' => $paysSlug,
                'ville' => $ville,
                'villeSlug' => $villeSlug,
                'lat' => $lat,
                'lng' => $lng,
            );
        }
    }
}
//var_dump($all_villes);
ksort($all_pays);
ksort($all_villes);
wp_reset_postdata();
?>
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js"></script>

<!-- Afficher la carte Leaflet -->
<div id="map" style="height: 600px; width: 1350px; margin: 0 auto;z-index: 1;" class="alignwide"></div>

<script>
    // Initialiser la carte Leaflet
    var map = L.map('map').setView([48.8566, 2.3522], 5); // Coordonnées initiales et niveau de zoom

    // Ajouter un fond de carte OpenStreetMap
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: 'Map data &copy; <a href="https://www.openstreetmap.org/">OpenStreetMap</a> contributors',
        maxZoom: 18,
    }).addTo(map);

    // Ajouter les marqueurs à la carte
    <?php foreach ($markers_data as $marker): ?>
        // Icône personnalisée pour le marqueur
        var customIcon = L.icon({
            iconUrl: '<?php echo get_template_directory_uri(); ?>/assets/images/marker.svg',
            iconSize: [32, 32], // Taille de l'icône
            iconAnchor: [16, 16], // Point d'ancrage de l'icône
            popupAnchor: [0, -20], // Position du popup par rapport à l'icône
            className: 'post-<?php echo $marker["id"]; ?>'
        });
        popupContent = '<p class="title"><?php echo esc_html($marker['title']); ?></p>';
        <?php if ($post_type === "partenaire") : ?>
            <?php if (get_field('p_ville', 'option')) : ?>
                popupContent = '<p class="title"><?php echo esc_html($marker['title']); ?> , <?php echo esc_html($marker['ville']); ?></p>';
            <?php endif; ?>
            <?php if (get_field('p_prof_nom', 'option')) : ?>
                popupContent += '<p><span class="bold">Professeur référent</span><br/><?php echo esc_html($marker['prof']); ?></p>'
                + '<p><a href="mailto:<?php echo esc_attr($marker['mail']); ?>">Envoyer un email</a></p>';
            <?php endif; ?>            
        <?php endif; ?>


        L.marker( [<?php echo $marker['lat']; ?>, <?php echo $marker['lng']; ?>], {icon: customIcon}).addTo(map)
            .bindPopup(popupContent);
    <?php endforeach; ?>
    
</script>
<div class="wp-block-group alignwide filtremap">
    <div class="filtre sidebar">
        <div>
            <input name="nom" type="text" placeholder="Rechercher" value="">
        </div>
        <div>
            <select name="ville">
                <option value="all">Ville</option>
                <?php foreach ($all_villes as $villeSlug => $ville) {
                    if($ville){
                        echo "<option value=\"$villeSlug\">$ville</option>";
                    }                    
                } ?>
            </select>        
        </div>
        <div>
            <select name="pays">
                <option value="all">Pays</option>
                <?php foreach ($all_pays as $paysSlug => $pays) {
                    echo "<option value=\"$paysSlug\">$pays</option>";
                } ?>
            </select>
        </div>
        <div>
            <p class="wp-block-button__link has-base-color has-tertiary-background-color has-text-color has-background has-link-color wp-element-button">Filtrer</p>
        </div>
    </div>
    <div class="grid all_etablissements ">        
        <p class="notfound hidden">Aucun établissement ne correspond à votre recherche.</p>
        <?php foreach($markers_data as $marker) : ?>
            <article class="type-etablissement post-<?php echo $marker['id']; ?>">
                <?php if($post_type === "partenaire"): 
                    echo get_the_post_thumbnail($marker['id']); 
                else : 
                    $pictoEtablissement = get_template_directory_uri()."/assets/images/DD-picto-etablissements.svg";
                    $pictoEtablissement = digitool_get_the_svg($pictoEtablissement);
                    echo $pictoEtablissement;
                endif; ?>
                <p class="title" data-label="<?php echo $marker['titleSlug']; ?>"> <?php echo $marker['title']; ?></p>
                <?php if(get_field('p_ville', 'option')): ?>
                    <p><span class="ville" data-label="<?php echo $marker['villeSlug']; ?>"><?php echo $marker['ville']; if(get_field('p_pays', 'option')){ echo ", ".$marker['paysName']; }?></span></p>
                <?php endif; ?>
                <?php if($post_type === "partenaire"): ?>
                    <?php if(get_field('p_prof_nom', 'option')):
                    if($post_type === "partenaire" && $marker['mail']): ?>
                        <p class="prof">Professeur référent : <a href="mailto:<?php echo $marker['mail']; ?>"><?php echo $marker['prof']; ?></a></p>
                    <?php else: ?>
                        <p class="prof">Professeur référent : <?php echo $marker['prof']; ?></p>
                    <?php endif; endif;?>
                    <?php if(get_field('p_tel', 'option')): ?>
                        <p class="tel"><a href="tel:<?php echo $marker['telFormatted'];?>">T. <?php echo $marker['tel']; ?></a></p>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if(get_field('p_lien', 'option')): ?>
                    <?php if($marker['permalink']){
                        $title_link = get_field('p_lien_title', 'option');
                        echo "<p class='link'><a href=".$marker['permalink']." target='_blank'>".$title_link."</a></p>";
                    } ?>
                <?php endif; ?> 

                <?php if($post_type === "partenaire"): 
                    if($marker['date'] && $marker['dateCode']):                        
                        echo "<p class='reunion'>Prochaine réunion d'information <br/>".$marker['date']."</p>";
                    endif;
                endif; 
                if($marker['paysName']):                        
                    echo "<p class='pays hidden' data-label='".$marker['paysSlug']."'>".$marker['paysName']."</p>";
                endif;?>
            </article>
        <?php endforeach; ?>        
    </div>
</div>
<div class="wp-block-buttons btn-more alignwide is-content-justification-right is-layout-flex wp-container-core-buttons-is-layout-7 wp-block-buttons-is-layout-flex" style="padding-bottom: 2rem;">
    <div class="wp-block-button"><a class="wp-block-button__link has-base-color has-primary-background-color has-text-color has-background has-link-color wp-element-button">En voir plus</a></div>
</div>
